/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.JDBCDisplayUtil;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.store.OnlineBackup;
import org.apache.derbyTesting.functionTests.util.TestUtil;

public class OnlineBackupTest3 {
    private static final String TEST_DATABASE_NAME = "wombat";
    private static final String BACKUP_PATH = "extinout/onlinebackuptest3";

    public static void main(String[] stringArray) throws Throwable {
        OnlineBackupTest3 onlineBackupTest3 = new OnlineBackupTest3();
        ij.getPropertyArg((String[])stringArray);
        try {
            onlineBackupTest3.runTest();
        }
        catch (SQLException sQLException) {
            OnlineBackupTest3.dumpSQLException(sQLException);
        }
    }

    private void runTest() throws Exception {
        this.logMessage("Begin Online Backup Test3");
        Connection connection = ij.startJBMS();
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        statement.execute("create table t1(a int ) ");
        statement.execute("insert into t1 values(1)");
        statement.execute("insert into t1 values(2)");
        statement.execute("create table customer(id int , name varchar(100))");
        statement.execute("insert into customer values(1, 'ABC')");
        statement.execute("insert into customer values(2, 'XYZ')");
        String string = "create procedure addCustomer(id INT, name VARCHAR(100)) MODIFIES SQL DATA external name 'org.apache.derbyTesting.backupRestore.Customer.addCustomer'  language java parameter style java ";
        statement.execute(string);
        String string2 = "create function dv(P1 INT) RETURNS INT NO SQL  external name 'dbytesting.CodeInAJar.doubleMe'  language java parameter style java ";
        statement.execute(string2);
        connection.commit();
        this.logMessage("Initial Setup Complete");
        this.installJarTest();
        this.removeJarTest();
        this.logMessage("End Online Backup Test3");
    }

    void shutdown(String string) {
        try {
            TestUtil.getConnection(string, "shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly");
            }
            OnlineBackupTest3.dumpSQLException(sQLException);
        }
    }

    void logMessage(String string) {
        System.out.println(string);
    }

    private static void dumpSQLException(SQLException sQLException) {
        JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        sQLException.printStackTrace(System.out);
    }

    private int countRows(Connection connection, String string) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT count(*) from " + string);
        resultSet.next();
        int n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return n;
    }

    void installJarTest() throws Exception {
        this.logMessage("Begin Install Jar Test");
        Connection connection = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        Connection connection2 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        connection2.setAutoCommit(false);
        Statement statement2 = connection2.createStatement();
        statement.execute("call sqlj.install_jar('extin/brtestjar.jar', 'math_routines', 0)");
        try {
            statement2.execute("call SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT('extinout/mybackup')");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        }
        OnlineBackup onlineBackup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        Thread thread = new Thread((Runnable)onlineBackup, "BACKUP1");
        thread.start();
        onlineBackup.waitForBackupToBegin();
        this.logMessage("Backup-1 Started");
        Thread.sleep(1000L);
        if (!onlineBackup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged install jar action to commit");
        }
        statement.execute("insert into t1 values(3)");
        statement.execute("insert into t1 values(4)");
        statement.execute("insert into t1 values(5)");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.math_routines') ");
        connection.commit();
        this.logMessage("The transaction that was blocking the backup has ended");
        onlineBackup.waitForBackupToEnd();
        thread.join();
        this.logMessage("Backup-1 Completed");
        statement.execute("create index idx1 on customer(id)");
        statement.execute("insert into t1 values(6)");
        onlineBackup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        thread = new Thread((Runnable)onlineBackup, "BACKUP2");
        thread.start();
        onlineBackup.waitForBackupToBegin();
        this.logMessage("Backup-2 Started");
        Thread.sleep(1000L);
        if (!onlineBackup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged index action to commit");
        }
        AsyncStatementThread asyncStatementThread = new AsyncStatementThread(connection2, "call sqlj.install_jar('extin/obtest_customer.jar', 'customer_app', 0)");
        asyncStatementThread.start();
        this.logMessage("Started obtest_customer.jar addition in seperate thread");
        Thread.sleep(1000L);
        connection.rollback();
        this.logMessage("The transaction that was blocking the backup has ended");
        onlineBackup.waitForBackupToEnd();
        thread.join();
        this.logMessage("Backup-2 Completed");
        asyncStatementThread.join();
        this.logMessage("obtest_customer.jar addition is complete");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.customer_app:APP.math_routines') ");
        connection.commit();
        statement.execute("call addCustomer(3 , 'John')");
        connection.commit();
        this.logMessage("No of rows in table t1: " + this.countRows(connection, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(connection, "customer"));
        connection.commit();
        connection2.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.close();
        this.shutdown(TEST_DATABASE_NAME);
        onlineBackup.restoreFromBackup();
        this.logMessage("Restored From the Backup");
        Connection connection3 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        Statement statement3 = connection3.createStatement();
        this.logMessage("No of rows in table t1: " + this.countRows(connection3, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(connection3, "customer"));
        statement3.execute("select dv(a) from t1");
        try {
            statement3.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.customer_app:APP.math_routines') ");
            statement3.execute("call addCustomer(3 , 'John')");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement3.close();
        connection3.close();
        this.shutdown(TEST_DATABASE_NAME);
        this.logMessage("End Of Install Jar Test.");
    }

    void removeJarTest() throws Exception {
        this.logMessage("Begin Remove Jar Test");
        Connection connection = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        connection.setAutoCommit(false);
        Statement statement = connection.createStatement();
        Connection connection2 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        connection2.setAutoCommit(false);
        Statement statement2 = connection2.createStatement();
        try {
            statement.execute("call sqlj.install_jar('extin/obtest_customer.jar', 'customer_app', 0)");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', '')");
        connection.commit();
        statement.execute("call sqlj.remove_jar('APP.math_routines', 0)");
        try {
            statement2.execute("call SYSCS_UTIL.SYSCS_BACKUP_DATABASE_NOWAIT('extinout/mybackup')");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        }
        OnlineBackup onlineBackup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        Thread thread = new Thread((Runnable)onlineBackup, "BACKUP3");
        thread.start();
        onlineBackup.waitForBackupToBegin();
        this.logMessage("Backup-3 Started");
        Thread.sleep(1000L);
        if (!onlineBackup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged remove jar action to commit");
        }
        statement.execute("insert into t1 values(10)");
        statement.execute("insert into t1 values(11)");
        connection.commit();
        this.logMessage("The transaction that was blocking the backup has ended");
        onlineBackup.waitForBackupToEnd();
        thread.join();
        this.logMessage("Backup-3 Completed");
        statement.execute("create index idx1 on customer(id)");
        statement.execute("insert into t1 values(12)");
        onlineBackup = new OnlineBackup(TEST_DATABASE_NAME, BACKUP_PATH);
        thread = new Thread((Runnable)onlineBackup, "BACKUP4");
        thread.start();
        onlineBackup.waitForBackupToBegin();
        this.logMessage("Backup-4 Started");
        Thread.sleep(1000L);
        if (!onlineBackup.isRunning()) {
            this.logMessage("Backup is not waiting for unlogged index action to commit");
        }
        AsyncStatementThread asyncStatementThread = new AsyncStatementThread(connection2, "call sqlj.remove_jar('APP.customer_app', 0)");
        asyncStatementThread.start();
        this.logMessage("Started obtest_customer.jar remove in seperate thread");
        Thread.sleep(1000L);
        connection.rollback();
        this.logMessage("The transaction that was blocking the backup has ended");
        onlineBackup.waitForBackupToEnd();
        thread.join();
        this.logMessage("Backup-4 Completed");
        asyncStatementThread.join();
        this.logMessage("obtest_customer.jar remove is complete");
        statement.execute("insert into t1 values(13)");
        this.logMessage("No of rows in table t1: " + this.countRows(connection, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(connection, "customer"));
        connection.commit();
        connection2.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.close();
        this.shutdown(TEST_DATABASE_NAME);
        onlineBackup.restoreFromBackup();
        this.logMessage("Restored From the Backup");
        Connection connection3 = TestUtil.getConnection(TEST_DATABASE_NAME, null);
        Statement statement3 = connection3.createStatement();
        this.logMessage("No of rows in table t1: " + this.countRows(connection3, "T1"));
        this.logMessage("No of rows in table customer: " + this.countRows(connection3, "customer"));
        try {
            statement3.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY( 'derby.database.classpath', 'APP.math_routines') ");
        }
        catch (SQLException sQLException) {
            JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
        }
        statement3.close();
        connection3.close();
        this.shutdown(TEST_DATABASE_NAME);
        this.logMessage("End Of Remove Jar Test.");
    }

    class AsyncStatementThread
    extends Thread {
        Connection conn;
        String stmt;

        AsyncStatementThread(Connection connection, String string) {
            this.conn = connection;
            this.stmt = string;
        }

        @Override
        public void run() {
            Statement statement = null;
            try {
                statement = this.conn.createStatement();
                statement.execute(this.stmt);
                statement.close();
                this.conn.commit();
            }
            catch (SQLException sQLException) {
                JDBCDisplayUtil.ShowSQLException((PrintStream)System.out, (SQLException)sQLException);
                sQLException.printStackTrace(System.out);
            }
            statement = null;
        }
    }
}

