/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class UDTPermsTest
extends GeneratedColumnsHelper {
    private static final String TEST_DBO = "TEST_DBO";
    private static final String RUTH = "RUTH";
    private static final String ALICE = "ALICE";
    private static final String FRANK = "FRANK";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE", "RUTH", "FRANK"};

    public UDTPermsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(UDTPermsTest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)cleanDatabaseTestSetup, LEGAL_USERS, "udtPermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecorator(test);
        return test2;
    }

    public void test_001_basicGrant() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        this.goodStatement(connection2, "create type price_ruth_01_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.goodStatement(connection2, "create function makePrice_ruth_01( )\nreturns price_ruth_01_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.goodStatement(connection2, "create table t_ruth_01( a price_ruth_01_a )\n");
        this.goodStatement(connection2, "insert into t_ruth_01( a ) values ( makePrice_ruth_01() )\n");
        this.goodStatement(connection2, "grant select on t_ruth_01 to public\n");
        this.goodStatement(connection2, "grant execute on function makePrice_ruth_01 to public\n");
        this.goodStatement(connection2, "select * from ruth.t_ruth_01\n");
        this.goodStatement(connection2, "values( ruth.makePrice_ruth_01() )\n");
        this.expectExecutionError(connection3, "42504", "create table t_alice_01( a ruth.price_ruth_01_a )\n");
        this.expectExecutionError(connection3, "42504", "create function makePrice_alice_01_a( )\nreturns ruth.price_ruth_01_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.expectExecutionError(connection3, "42504", "create function makePrice_alice_01_b( a ruth.price_ruth_01_a )\nreturns int\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n");
        this.assertResults(connection, "select * from ruth.t_ruth_01", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.assertResults(connection, "values( ruth.makePrice_ruth_01() )\n", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.goodStatement(connection, "create table t_dbo_01( a ruth.price_ruth_01_a )\n");
        this.goodStatement(connection, "insert into t_dbo_01( a ) values ( ruth.makePrice_ruth_01() )\n");
        this.assertResults(connection, "select * from t_dbo_01\n", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.goodStatement(connection, "drop table t_dbo_01\n");
        this.goodStatement(connection2, "grant usage on type price_ruth_01_a to public\n");
        this.assertResults(connection3, "select * from ruth.t_ruth_01", new String[][]{{"Price( USD, 1, XXX )"}}, false);
        this.goodStatement(connection3, "create table t_alice_01( a ruth.price_ruth_01_a )\n");
        this.goodStatement(connection3, "insert into t_alice_01( a ) values ( ruth.makePrice_ruth_01() )\n");
        this.assertResults(connection3, "select * from t_alice_01\n", new String[][]{{"Price( USD, 1, XXX )"}}, false);
    }

    public void test_002_basicRevoke() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(RUTH);
        Connection connection3 = this.openUserConnection(ALICE);
        this.goodStatement(connection2, "create type price_ruth_02_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.expectCompilationError(connection2, "42X01", "revoke usage on type price_ruth_02_a from ruth\n");
        this.expectCompilationError(connection2, "42509", "revoke usage on type price_ruth_02_a from ruth restrict\n");
        String string = "grant usage on type price_ruth_02_a to alice\n";
        String string2 = "revoke usage on type price_ruth_02_a from alice restrict\n";
        String string3 = "create function makePrice_alice_02( )\nreturns ruth.price_ruth_02_a\nlanguage java\nparameter style java\nno sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.Price.makePrice'\n";
        String string4 = "drop function makePrice_alice_02\n";
        String string5 = "X0Y30";
        this.verifyRevokePrivilege(connection2, connection3, string, string2, string3, string4, string5);
        string3 = "create table t_alice_02( a ruth.price_ruth_02_a )\n";
        string4 = "drop table t_alice_02\n";
        string5 = "X0Y29";
        this.verifyRevokePrivilege(connection2, connection3, string, string2, string3, string4, string5);
        string3 = "create view v_alice_02( a ) as select cast (null as ruth.price_ruth_02_a ) from sys.systables\n";
        string4 = "drop view v_alice_02\n";
        string5 = "X0Y23";
        this.verifyRevokePrivilege(connection2, connection3, string, string2, string3, string4, string5);
        this.goodStatement(connection3, "create table t_03_a( a int )\n");
        this.goodStatement(connection3, "create table t_03_b( a int )\n");
        string3 = "create trigger trig_03_a after insert on t_03_a\n  insert into t_03_b( a ) select a from t_03_a where ( cast( null as ruth.price_ruth_02_a ) ) is not null\n";
        string4 = "drop trigger trig_03_a\n";
        string5 = "X0Y25";
        this.verifyRevokePrivilege(connection2, connection3, string, string2, string3, string4, string5);
    }

    public void test_003_dropSchema() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(FRANK);
        this.goodStatement(connection2, "create function f_frank_03( a int ) returns int language java parameter style java no sql external name 'foo.bar.Wibble'\n");
        this.expectExecutionError(connection, "X0Y54", "drop schema frank restrict\n");
        this.goodStatement(connection2, "drop function f_frank_03\n");
        this.goodStatement(connection2, "create type price_frank_03_a external name 'org.apache.derbyTesting.functionTests.tests.lang.Price' language java\n");
        this.expectExecutionError(connection, "X0Y54", "drop schema frank restrict\n");
        this.goodStatement(connection2, "drop type price_frank_03_a restrict\n");
        this.goodStatement(connection, "drop schema frank restrict\n");
    }
}

