/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.optimizer.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.derbyTesting.system.optimizer.StaticValues;
import org.apache.derbyTesting.system.optimizer.utils.TestViews;

public class DataUtils {
    public static void dropObjects(Connection connection, boolean bl) throws SQLException {
        int n;
        Statement statement = null;
        if (bl) {
            System.out.println("Dropping existing Tables and Views...");
        }
        for (n = 0; n < TestViews.dropViews.size(); ++n) {
            try {
                statement = connection.createStatement();
                statement.executeUpdate(TestViews.dropViews.get(n));
                continue;
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equalsIgnoreCase("X0X05")) continue;
                throw sQLException;
            }
        }
        for (n = 1; n <= StaticValues.NUM_OF_TABLES; ++n) {
            try {
                String string = StaticValues.TABLE_NAME + n;
                statement = connection.createStatement();
                statement.execute(StaticValues.DROP_TABLE + string);
                statement.close();
                continue;
            }
            catch (SQLException sQLException) {
                if (sQLException.getSQLState().equalsIgnoreCase("42Y55")) continue;
                throw sQLException;
            }
        }
    }

    public static void createObjects(Connection connection, boolean bl) throws SQLException {
        int n;
        Statement statement = null;
        if (bl) {
            System.out.println("Creating Tables...");
        }
        for (n = 1; n <= StaticValues.NUM_OF_TABLES; ++n) {
            try {
                String string = StaticValues.TABLE_NAME + n;
                if (bl) {
                    System.out.println(" Creating Table - " + string);
                }
                statement = connection.createStatement();
                statement.execute(StaticValues.CREATE_TABLE + string + StaticValues.TABLE_COLS);
                statement.close();
                continue;
            }
            catch (SQLException sQLException) {
                if (!sQLException.getSQLState().equalsIgnoreCase("X0Y32")) {
                    throw sQLException;
                }
                System.out.println("Table " + StaticValues.TABLE_NAME + n + " exists");
            }
        }
        if (bl) {
            System.out.println("Creating Views...");
        }
        for (n = 0; n < TestViews.createViews.size(); ++n) {
            try {
                statement = connection.createStatement();
                statement.executeUpdate(TestViews.createViews.get(n));
                continue;
            }
            catch (SQLException sQLException) {
                System.out.println("SQLState = " + sQLException.getSQLState() + ", " + sQLException);
                System.out.println("View statement ==> " + TestViews.createViews.get(n) + " failed");
            }
        }
    }

    public static void insertData(Connection connection, boolean bl) {
        try {
            String string = "String value for the ";
            String string2 = string + "varchar column ";
            String string3 = string + "bit data column ";
            connection.setAutoCommit(false);
            Statement statement = connection.createStatement();
            ResultSet resultSet = null;
            int n = 0;
            for (int i = 1; i <= StaticValues.NUM_OF_TABLES; ++i) {
                int n2;
                String string4 = StaticValues.TABLE_NAME + i;
                resultSet = statement.executeQuery("SELECT COUNT(*) FROM " + string4);
                while (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                if (n >= StaticValues.NUM_OF_ROWS) {
                    if (!bl) continue;
                    System.out.println(" InsertData.insert_data() => " + n + " exists in table " + string4 + "...");
                    continue;
                }
                if (n > 0) {
                    block16: {
                        block15: {
                            if (bl) {
                                System.out.println("Dropping existing indexes from table: " + string4);
                            }
                            try {
                                statement.executeUpdate("DROP INDEX " + string4 + "_col4_idx");
                            }
                            catch (SQLException sQLException) {
                                if (sQLException.getSQLState().equalsIgnoreCase("42X65")) break block15;
                                throw sQLException;
                            }
                        }
                        try {
                            statement.executeUpdate("DROP INDEX " + string4 + "_col7_idx");
                        }
                        catch (SQLException sQLException) {
                            if (sQLException.getSQLState().equalsIgnoreCase("42X65")) break block16;
                            throw sQLException;
                        }
                    }
                    if (bl) {
                        System.out.println("Rows deleted from " + string4 + "= " + statement.executeUpdate("DELETE FROM " + string4));
                    }
                }
                PreparedStatement preparedStatement = connection.prepareStatement(StaticValues.INSERT_TABLE + string4 + StaticValues.INSERT_VALUES);
                long l = System.currentTimeMillis();
                for (n2 = 1; n2 <= StaticValues.NUM_OF_ROWS; ++n2) {
                    preparedStatement.setInt(1, n2);
                    preparedStatement.setString(2, string2 + "in Table " + StaticValues.TABLE_NAME + i + ": " + n2);
                    preparedStatement.setString(3, string3 + "in Table " + StaticValues.TABLE_NAME + i + ": " + n2);
                    preparedStatement.setString(4, StaticValues.TABLE_NAME + i + "_COL4:" + n2);
                    preparedStatement.setString(5, StaticValues.TABLE_NAME + i + "_COL5:" + n2);
                    preparedStatement.setString(6, StaticValues.TABLE_NAME + i + "_COL6:" + n2);
                    preparedStatement.setString(7, StaticValues.TABLE_NAME + i + "_COL7:" + n2);
                    preparedStatement.setInt(8, n2);
                    preparedStatement.setTimestamp(9, new Timestamp(System.currentTimeMillis()));
                    preparedStatement.executeUpdate();
                    if (n2 % 10000 != 0) continue;
                    connection.commit();
                }
                preparedStatement.close();
                connection.commit();
                if (bl) {
                    System.out.println("Inserted " + (n2 - 1) + " rows into " + string4 + " in " + (System.currentTimeMillis() - l) + " milliseconds");
                }
                connection.setAutoCommit(true);
                if (bl) {
                    System.out.println("Creating indexes for table: " + string4);
                }
                statement.executeUpdate("CREATE INDEX " + string4 + "_col4_idx on " + string4 + "(col4)");
                statement.executeUpdate("CREATE INDEX " + string4 + "_col7_idx on " + string4 + "(col7)");
            }
        }
        catch (Exception exception) {
            System.out.println(" EXCEPTION:" + exception.getMessage());
            System.out.println("Stack Trace :  \n");
            exception.printStackTrace();
            return;
        }
    }
}

