/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.TreeMap;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.RuntimeStatisticsParser;
import org.apache.derbyTesting.junit.SQLUtilities;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InListMultiProbeTest
extends BaseJDBCTestCase {
    private static final String DATA_TABLE = "CHANGES";
    private static final String COLUMN_NAMES = "KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID";
    private static final String DERBY_6045_DATA_TABLE = "VARIABLE_TERM";
    private static final String CREATE_DERBY_6045_DATA_TABLE = "CREATE TABLE VARIABLE_TERM (term_id INTEGER NOT NULL, var_name VARCHAR(1024) NOT NULL, var_type SMALLINT NOT NULL )";
    private static final String DERBY_6045_DATA_TABLE2 = "MT_GAF_TOP_LEVEL_TERM_COUNTS";
    private static final String CREATE_DERBY_6045_DATA_TABLE2 = "CREATE TABLE MT_GAF_TOP_LEVEL_TERM_COUNTS(mt BIGINT NOT NULL, term BIGINT NOT NULL, term_index INTEGER NOT NULL, usage_count BIGINT NOT NULL )";
    private static final String CREATE_DATA_TABLE = "CREATE TABLE CHANGES (ID BIGINT NOT NULL ,KIND VARCHAR(250) NOT NULL ,ITEM_UUID CHAR(23) NOT NULL ,ITEM_TYPE VARCHAR(250) NOT NULL ,BEFORE CHAR(23), AFTER CHAR(23),FOREIGN_KEY_UUID CHAR(23) NOT NULL)";
    private static final String SELECT_ALL = "Select KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID From CHANGES";
    private static final String SELECT_ALL_WHERE_IN = "Select KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID From CHANGES where FOREIGN_KEY_UUID in (";
    private static final String ORDER_BY = ") order by ID";
    private static final String RUNTIME_STATS_ON_QUERY = "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)";
    private static final String RUNTIME_STATS_OFF_QUERY = "CALL SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)";
    private static final String GET_RUNTIME_STATS_QUERY = "VALUES SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()";
    private static char[] uuid_chars = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final int NUM_ROWS = 30000;
    protected String[] allIds;
    protected TreeMap<String, List<DataRow>> foreignIdToRowsMap;
    private static String[] DERBY_3603_Objects = new String[]{"create table d3603_a (a_id integer, c_id integer)", "create table d3603_c (c_id integer not null, primary key(c_id), d_id integer, t_o bigint, t_i bigint)", "insert into d3603_a (a_id, c_id) values (1, 1)", "insert into d3603_a (a_id, c_id) values (2, 2)", "insert into d3603_a (a_id, c_id) values (3, 1)", "insert into d3603_c (c_id, d_id, t_o, t_i) values (1, 1, 1, 1)", "insert into d3603_c (c_id, d_id, t_o, t_i) values (2, 2, 1, 1)", "insert into d3603_c (c_id, d_id, t_o, t_i) values (21, 1, 1, 1)"};

    public InListMultiProbeTest(String string) {
        super(string);
    }

    @Override
    protected void tearDown() throws Exception {
        this.foreignIdToRowsMap = null;
        super.tearDown();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("IN-list MultiProbe Suite");
        baseTestSuite.addTest(TestConfiguration.embeddedSuite(InListMultiProbeTest.class));
        return new CleanDatabaseTestSetup((Test)baseTestSuite){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                int n;
                statement.executeUpdate(InListMultiProbeTest.CREATE_DATA_TABLE);
                Random random = new Random(1L);
                for (n = 30000; n >= 1000; n -= 1000) {
                    InListMultiProbeTest.insertNDataRows(statement.getConnection(), 1000, random);
                }
                if (n > 0) {
                    InListMultiProbeTest.insertNDataRows(statement.getConnection(), n, random);
                }
                String string = "CREATE INDEX CHANGES_NDX1 ON CHANGES(FOREIGN_KEY_UUID, ID)";
                statement.executeUpdate(string);
                string = "ALTER TABLE CHANGES ADD CONSTRAINT CHANGES_PK PRIMARY KEY (ID)";
                statement.executeUpdate(string);
                for (int i = 0; i < DERBY_3603_Objects.length; ++i) {
                    statement.executeUpdate(DERBY_3603_Objects[i]);
                }
            }
        };
    }

    public void testDerby6045DeleteTest() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE2);
        statement.executeUpdate(CREATE_DERBY_6045_DATA_TABLE2);
        statement.executeUpdate("ALTER TABLE MT_GAF_TOP_LEVEL_TERM_COUNTS ADD CONSTRAINT kb_mt_gaf_top_level_term_counts_pk PRIMARY KEY (mt, term, term_index)");
        statement.executeUpdate("CREATE INDEX kb_mt_gaf_top_level_term_counts_mt_index ON MT_GAF_TOP_LEVEL_TERM_COUNTS(mt)");
        statement.executeUpdate("CREATE INDEX kb_mt_gaf_top_level_term_counts_term_index ON MT_GAF_TOP_LEVEL_TERM_COUNTS(term)");
        PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into MT_GAF_TOP_LEVEL_TERM_COUNTS VALUES (?, ?, ?, ?)");
        int n = 10000;
        for (int i = 1; i <= n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.setInt(2, i);
            preparedStatement.setInt(3, i);
            preparedStatement.setInt(4, i);
            preparedStatement.executeUpdate();
        }
        this.deleteRows(false, false);
        this.deleteRows(false, true);
        this.deleteRows(true, false);
        this.deleteRows(true, true);
        this.dropTable(DERBY_6045_DATA_TABLE2);
        preparedStatement.close();
        statement.close();
    }

    void deleteRows(boolean bl, boolean bl2) throws SQLException {
        PreparedStatement preparedStatement;
        Statement statement = this.createStatement();
        if (bl) {
            statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'MT_GAF_TOP_LEVEL_TERM_COUNTS', null)");
        }
        if (bl2) {
            preparedStatement = this.prepareStatement("DELETE FROM MT_GAF_TOP_LEVEL_TERM_COUNTS WHERE (term = ?) ");
            preparedStatement.setInt(1, 1);
            preparedStatement.execute();
        } else {
            statement.execute("DELETE FROM MT_GAF_TOP_LEVEL_TERM_COUNTS WHERE (term = 2) ");
        }
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        InListMultiProbeTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
        if (bl2) {
            preparedStatement = this.prepareStatement("DELETE FROM mt_gaf_top_level_term_counts WHERE (term = ?) OR (mt = ?)");
            preparedStatement.setInt(1, 3);
            preparedStatement.setInt(2, 4);
            preparedStatement.execute();
        } else {
            statement.execute("DELETE FROM mt_gaf_top_level_term_counts WHERE (term = 5) OR (mt = 6)");
        }
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        InListMultiProbeTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
    }

    public void testMultiProbing() throws Exception {
        int n;
        this.readAllRows(this.createStatement());
        ArrayList<QueryStrategy> arrayList = new ArrayList<QueryStrategy>();
        Random random = new Random(2L);
        Connection connection = this.getConnection();
        arrayList.add(new MarkersStrategy(connection, random));
        arrayList.add(new LiteralsStrategy(connection, random));
        arrayList.add(new MixedIdsStrategy(connection, random));
        Statement statement = this.createStatement();
        statement.execute(RUNTIME_STATS_ON_QUERY);
        for (n = 2; n <= 10; n += 2) {
            this.testOneSize(arrayList, n);
        }
        for (n = 20; n <= 100; n += 20) {
            this.testOneSize(arrayList, n);
        }
        for (n = 200; n <= 1000; n += 200) {
            this.testOneSize(arrayList, n);
        }
        arrayList.remove(2);
        arrayList.remove(1);
        for (n = 1250; n <= 2500; n += 250) {
            this.testOneSize(arrayList, n);
        }
        statement.execute(RUNTIME_STATS_OFF_QUERY);
        statement.close();
        connection = null;
    }

    public void testMultipleStartStopPreds() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table ct (i int, c1 char(5), c2 char(10))");
        statement.execute("insert into ct(i) values 1, 2, 3, 4, 5, 6, 7, 8, 9");
        statement.execute("insert into ct(i) values 0, 10, 11, 12, 13, 14, 15");
        statement.execute("insert into ct(i) values 16, 17, 18, 19");
        statement.execute("insert into ct(i) select 7 * i from ct");
        statement.execute("insert into ct(i) select 13 * i from ct");
        statement.execute("update ct set c1 = cast(i as char(25))");
        statement.execute("update ct set c2 = c1 || c1");
        statement.execute("insert into ct values (91, '91', '1234')");
        statement.execute("insert into ct values (91, '91', '212398')");
        statement.execute("create index idx2 on ct (c1, c2)");
        String[][] stringArray = new String[][]{{"1", "1    ", "1    1    "}, {"2", "2    ", "2    2    "}};
        statement.execute(RUNTIME_STATS_ON_QUERY);
        PreparedStatement preparedStatement = this.prepareStatement("select i,c1,c2 from ct where c1 in (?,?) and c2 like '%'");
        preparedStatement.setString(1, "1");
        preparedStatement.setString(2, "2");
        this.assertResultsAndQueryPlan(preparedStatement.executeQuery(), stringArray, statement);
        preparedStatement = this.prepareStatement("select i,c1,c2 from ct where c1 in ('2','1') and c2 like '%'");
        this.assertResultsAndQueryPlan(preparedStatement.executeQuery(), stringArray, statement);
        preparedStatement = this.prepareStatement("select i,c1,c2 from ct where c1 in (?,?) and c2 like ? order by i");
        preparedStatement.setString(1, "1");
        preparedStatement.setString(2, "2");
        preparedStatement.setString(3, "%");
        this.assertResultsAndQueryPlan(preparedStatement.executeQuery(), stringArray, statement);
        preparedStatement = this.prepareStatement("select i,c1,c2 from ct where c1 in (?,?) and c2 like ?");
        preparedStatement.setString(1, "1");
        preparedStatement.setString(2, "2");
        preparedStatement.setString(3, "%");
        this.assertResultsAndQueryPlan(preparedStatement.executeQuery(), stringArray, statement);
        preparedStatement = this.prepareStatement("select i,c1,c2 from ct where c1 in ('2','1') and c2 like ?");
        preparedStatement.setString(1, "%");
        this.assertResultsAndQueryPlan(preparedStatement.executeQuery(), stringArray, statement);
        preparedStatement = this.prepareStatement("select i,c1,c2 from ct where c1 in ('2',?) and c2 like ?");
        preparedStatement.setString(1, "1");
        preparedStatement.setString(2, "%");
        this.assertResultsAndQueryPlan(preparedStatement.executeQuery(), stringArray, statement);
        this.assertResultsAndQueryPlan(statement.executeQuery("select i,c1,c2 from ct where c1 in ('1','2') and c2 like '%' order by i"), stringArray, statement);
        this.assertResultsAndQueryPlan(statement.executeQuery("select i,c1,c2 from ct where c1 in ('1','2') and c2 >= '_' order by i"), null, statement);
        this.assertResultsAndQueryPlan(statement.executeQuery("select i,c1,c2 from ct where c1 in ('14','91') and c2 < '_' order by i"), new String[][]{{"14", "14   ", "14   14   "}, {"14", "14   ", "14   14   "}, {"91", "91   ", "91   91   "}, {"91", "91   ", "91   91   "}, {"91", "91   ", "91   91   "}, {"91", "91   ", "212398    "}, {"91", "91   ", "1234      "}}, statement);
        this.assertResultsAndQueryPlan(statement.executeQuery("select i,c1,c2 from ct where c1 in ('14','91') and c2 < '9' order by i"), new String[][]{{"14", "14   ", "14   14   "}, {"14", "14   ", "14   14   "}, {"91", "91   ", "212398    "}, {"91", "91   ", "1234      "}}, statement);
        this.assertResultsAndQueryPlan(statement.executeQuery("select i,c1,c2 from ct where c1 in ('14','91') and c2 < '9' and c2 > '13' order by i"), new String[][]{{"14", "14   ", "14   14   "}, {"14", "14   ", "14   14   "}, {"91", "91   ", "212398    "}}, statement);
        statement.execute("drop table ct");
        statement.execute("create table mytable (id int primary key)");
        statement.execute("insert into mytable (id) values 0, 1, 2, 3, 4, 5, 6, 7, 8, 9");
        statement.execute("insert into mytable select id + 10 from mytable");
        statement.execute("insert into mytable select id + 20 from mytable");
        statement.execute("insert into mytable select id + 40 from mytable");
        statement.execute("insert into mytable select id + 100 from mytable");
        JDBC.assertDrainResults(statement.executeQuery("select mytable.id from mytable where mytable.id < 100"), 80);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 )"), new String[][]{{"2"}, {"15"}, {"19"}, {"20"}, {"21"}, {"48"}, {"49"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select mytable.id from mytable where mytable.id < 100 and mytable.id in ( 2, 15, 19, 20, 21, 48, 49 )"), new String[][]{{"2"}, {"15"}, {"19"}, {"20"}, {"21"}, {"48"}, {"49"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 ) and mytable.id < 100"), new String[][]{{"2"}, {"15"}, {"19"}, {"20"}, {"21"}, {"48"}, {"49"}});
        JDBC.assertEmpty(statement.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 ) and mytable.id = 100"));
        JDBC.assertUnorderedResultSet(statement.executeQuery("select mytable.id from mytable where mytable.id in ( 2, 15, 19, 20, 21, 48, 49 ) and mytable.id = 21"), new String[][]{{"21"}});
        statement.execute(RUNTIME_STATS_OFF_QUERY);
        statement.execute("drop table mytable");
        preparedStatement.close();
        statement.close();
    }

    public void testProbePredPushedIntoSelectThenReverted() throws Exception {
        Statement statement = this.createStatement();
        statement.execute("create table d3253 (i int, vc varchar(10))");
        statement.execute("insert into d3253 values (1, 'one'), (2, 'two'), (3, 'three'), (1, 'un')");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select x.* from d3253, (select * from d3253) x where d3253.i = x.i and x.vc in ('un', 'trois')"), new String[][]{{"1", "un"}, {"1", "un"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select x.* from d3253, (select * from d3253) x where d3253.i = x.i and x.i in (2, 3)"), new String[][]{{"2", "two"}, {"3", "three"}});
        JDBC.assertEmpty(statement.executeQuery("select x.* from d3253, (select * from d3253) x where d3253.i = x.i and x.vc in ('uno', 'tres')"));
        statement.execute("drop table d3253");
        statement.close();
    }

    public void testInListProbingWithOrderBy() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table CHEESE (CHEESE_CODE VARCHAR(5), CHEESE_NAME VARCHAR(20), CHEESE_COST DECIMAL(7,4))");
        statement.execute("create index cheese_index on CHEESE (CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC)");
        statement.execute("INSERT INTO CHEESE (CHEESE_CODE, CHEESE_NAME, CHEESE_COST) VALUES ('00000', 'GOUDA', 001.1234), ('00000', 'EDAM', 002.1111), ('54321', 'EDAM', 008.5646), ('12345', 'GORGONZOLA', 888.2309), ('AAAAA', 'EDAM', 999.8888), ('54321', 'MUENSTER', 077.9545)");
        String[][] stringArray = new String[][]{{"AAAAA", "EDAM", "999.8888"}, {"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC"), stringArray);
        String[][] stringArray2 = new String[][]{{"00000", "EDAM", "2.1111"}, {"54321", "EDAM", "8.5646"}, {"AAAAA", "EDAM", "999.8888"}};
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC, CHEESE_COST DESC"), stringArray2);
        BitSet bitSet = new BitSet(6);
        bitSet.set(3);
        bitSet.set(4);
        bitSet.set(5);
        Object[][] objectArray = new String[][]{{"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}};
        JDBC.assertPartialResultSet(statement.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC, 6 DESC"), objectArray, bitSet);
        Object[][] objectArray2 = new String[][]{{"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"00000", "EDAM", "2.1111"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}, {"54321", "EDAM", "8.5646"}};
        JDBC.assertPartialResultSet(statement.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 ASC, 5 DESC, 6 DESC"), objectArray2, bitSet);
        PreparedStatement preparedStatement = this.prepareStatement("SELECT * FROM CHEESE WHERE CHEESE_CODE IN (?,?,?) AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC, CHEESE_COST DESC");
        preparedStatement.setString(1, "00000");
        preparedStatement.setString(2, "AAAAA");
        preparedStatement.setString(3, "54321");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray);
        preparedStatement = this.prepareStatement("SELECT * FROM CHEESE WHERE CHEESE_CODE IN (?,?,?) AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC, CHEESE_COST DESC");
        preparedStatement.setString(1, "00000");
        preparedStatement.setString(2, "AAAAA");
        preparedStatement.setString(3, "54321");
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), stringArray2);
        preparedStatement = this.prepareStatement("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND C2.CHEESE_CODE IN (?,?) AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC, 6 DESC");
        preparedStatement.setString(1, "00000");
        preparedStatement.setString(2, "54321");
        JDBC.assertPartialResultSet(preparedStatement.executeQuery(), objectArray, bitSet);
        preparedStatement = this.prepareStatement("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND C2.CHEESE_CODE IN (?,?) AND C1.CHEESE_NAME='EDAM' ORDER BY 4 ASC, 5 ASC, 6 ASC");
        preparedStatement.setString(1, "00000");
        preparedStatement.setString(2, "54321");
        JDBC.assertPartialResultSet(preparedStatement.executeQuery(), objectArray2, bitSet);
        statement.execute("drop index cheese_index");
        statement.execute("create index cheese_index on CHEESE (CHEESE_CODE DESC, CHEESE_NAME DESC)");
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), stringArray);
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='54321' OR CHEESE_CODE='00000' OR CHEESE_CODE='AAAAA') AND CHEESE_NAME='EDAM' ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC"), stringArray2);
        JDBC.assertPartialResultSet(statement.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 DESC, 5 DESC"), objectArray, bitSet);
        JDBC.assertPartialResultSet(statement.executeQuery("SELECT * FROM CHEESE C1, CHEESE C2 WHERE C1.CHEESE_NAME = C2.CHEESE_NAME AND (C2.CHEESE_CODE='00000' OR C2.CHEESE_CODE='54321') AND C1.CHEESE_NAME='EDAM' ORDER BY 4 ASC, 5 DESC"), objectArray2, bitSet);
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_NAME='EDAM' OR CHEESE_NAME='ADAM') ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), new String[][]{{"54321", "EDAM", "8.5646"}, {"00000", "EDAM", "2.1111"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_NAME='EDAM' OR CHEESE_NAME='ADAM') ORDER BY CHEESE_CODE ASC, CHEESE_NAME DESC"), new String[][]{{"00000", "EDAM", "2.1111"}, {"54321", "EDAM", "8.5646"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), new String[][]{{"00000", "GOUDA", "1.1234"}, {"00000", "EDAM", "2.1111"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') AND (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE ASC, CHEESE_NAME ASC"), new String[][]{{"00000", "EDAM", "2.1111"}, {"00000", "GOUDA", "1.1234"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') OR (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE DESC, CHEESE_NAME DESC"), new String[][]{{"AAAAA", "EDAM", "999.8888"}, {"54321", "MUENSTER", "77.9545"}, {"54321", "EDAM", "8.5646"}, {"00000", "GOUDA", "1.1234"}, {"00000", "EDAM", "2.1111"}});
        JDBC.assertFullResultSet(statement.executeQuery("SELECT * FROM CHEESE WHERE (CHEESE_CODE='00000' OR CHEESE_CODE='54321') OR (CHEESE_CODE='AAAAA' OR CHEESE_CODE='00000') ORDER BY CHEESE_CODE ASC, CHEESE_NAME ASC"), new String[][]{{"00000", "EDAM", "2.1111"}, {"00000", "GOUDA", "1.1234"}, {"54321", "EDAM", "8.5646"}, {"54321", "MUENSTER", "77.9545"}, {"AAAAA", "EDAM", "999.8888"}});
        preparedStatement.close();
        statement.execute("drop table cheese");
        statement.close();
    }

    public void testDerby6045WithUpdateStatistics() throws SQLException {
        this.helperDerby6045(10, true, false);
        this.helperDerby6045(24, true, false);
        this.helperDerby6045(10000, true, false);
    }

    public void testDerby6045WithoutUpdateStatistics() throws SQLException {
        this.helperDerby6045(10, false, false);
        this.helperDerby6045(24, false, false);
        this.helperDerby6045(10000, false, false);
    }

    public void testDerby6045WithUpdateStatisticsAndParams() throws SQLException {
        this.helperDerby6045(10, true, true);
        this.helperDerby6045(24, true, true);
        this.helperDerby6045(10000, true, true);
    }

    public void testDerby6045WithoutUpdateStatisticsAndWithParams() throws SQLException {
        this.helperDerby6045(10, false, true);
        this.helperDerby6045(24, false, true);
        this.helperDerby6045(10000, false, true);
    }

    public void helperDerby6045(int n, boolean bl, boolean bl2) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        statement.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        statement.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into VARIABLE_TERM VALUES (?, '?var0', 1)");
        for (int i = 1; i <= n; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.executeUpdate();
        }
        if (bl) {
            statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        }
        this.runThreeQueries(0, bl2);
        this.dropTable(DERBY_6045_DATA_TABLE);
        preparedStatement.close();
        statement.close();
    }

    public void testDerby6045() throws SQLException {
        int n;
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        statement.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        statement.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        PreparedStatement preparedStatement = statement.getConnection().prepareStatement("insert into VARIABLE_TERM VALUES (?, '?var0', 1)");
        for (n = 1; n <= 10; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        this.runThreeQueries(0, false);
        for (n = 11; n <= 25; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        this.runThreeQueries(1, false);
        for (n = 26; n <= 10000; ++n) {
            preparedStatement.setInt(1, n);
            preparedStatement.executeUpdate();
        }
        this.runThreeQueries(2, false);
        statement.close();
    }

    public void testDerby6045InsertAllRowsAdditionalUniqueIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        statement.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        statement.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        statement.executeUpdate("ALTER TABLE  VARIABLE_TERM ADD CONSTRAINT kb_variable_term_variable_name_unique  UNIQUE (var_name, var_type)");
        for (int i = 1; i <= 10000; ++i) {
            statement.executeUpdate("insert into VARIABLE_TERM VALUES (" + i + ", '?var" + i + "'," + (i % 2 == 0 ? 1 : 4) + ")");
        }
        statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        this.runThreeQueries(0, false);
        statement.close();
    }

    public void testDerby6045InsertAllRows() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        this.dropTable(DERBY_6045_DATA_TABLE);
        statement.executeUpdate(CREATE_DERBY_6045_DATA_TABLE);
        statement.executeUpdate("ALTER TABLE VARIABLE_TERM ADD CONSTRAINT kb_variable_term_term_id_pk PRIMARY KEY (term_id)");
        for (int i = 1; i <= 10000; ++i) {
            statement.executeUpdate("insert into VARIABLE_TERM VALUES (" + i + ", '?var" + i + "'," + (i % 2 == 0 ? 1 : 4) + ")");
        }
        statement.execute("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS('APP', 'VARIABLE_TERM', null)");
        this.runThreeQueries(0, false);
        statement.close();
    }

    private void runThreeQueries(int n, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        Statement statement = this.createStatement();
        Object object = "";
        for (int i = 1; i <= n; ++i) {
            object = (String)object + " ";
        }
        if (bl) {
            preparedStatement = this.prepareStatement("SELECT * FROM " + (String)object + "VARIABLE_TERM WHERE TERM_ID = ?");
            preparedStatement.setInt(1, 11);
            JDBC.assertDrainResults(preparedStatement.executeQuery());
        } else {
            statement.executeQuery("SELECT * FROM " + (String)object + "VARIABLE_TERM WHERE TERM_ID = 11");
        }
        RuntimeStatisticsParser runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        InListMultiProbeTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
        if (bl) {
            preparedStatement = this.prepareStatement("SELECT * FROM " + (String)object + "VARIABLE_TERM WHERE (TERM_ID = ?) OR (TERM_ID = ?) OR (TERM_ID = ?)");
            preparedStatement.setInt(1, 11);
            preparedStatement.setInt(2, 21);
            preparedStatement.setInt(3, 31);
            JDBC.assertDrainResults(preparedStatement.executeQuery());
        } else {
            statement.executeQuery("SELECT  *  FROM  " + (String)object + "VARIABLE_TERM WHERE (TERM_ID = 11) OR (TERM_ID =21) OR (TERM_ID = 31)");
        }
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        InListMultiProbeTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
        if (bl) {
            preparedStatement = this.prepareStatement("SELECT * FROM " + (String)object + "VARIABLE_TERM WHERE (TERM_ID IN (?, ?, ?))");
            preparedStatement.setInt(1, 11);
            preparedStatement.setInt(2, 21);
            preparedStatement.setInt(3, 31);
            JDBC.assertDrainResults(preparedStatement.executeQuery());
        } else {
            statement.executeQuery("SELECT  *  FROM " + (String)object + "VARIABLE_TERM WHERE (TERM_ID IN (11, 21, 31))");
        }
        runtimeStatisticsParser = SQLUtilities.getRuntimeStatisticsParser(statement);
        InListMultiProbeTest.assertTrue((boolean)runtimeStatisticsParser.usedIndexScan());
        statement.close();
    }

    public void testDerby3603() throws SQLException {
        Statement statement = this.createStatement();
        JDBC.assertFullResultSet(statement.executeQuery("select count(*) from d3603_a, d3603_c    where d3603_a.a_id <> 2 and d3603_c.c_id in (1, 21)         and d3603_a.c_id = d3603_c.c_id"), new String[][]{{"2"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select d3603_a.a_id from d3603_a, d3603_c    where d3603_a.a_id <> 2 and d3603_c.c_id in (1, 21)         and d3603_a.c_id = d3603_c.c_id"), new String[][]{{"1"}, {"3"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select d3603_a.a_id,d3603_c.d_id        from d3603_a, d3603_c    where d3603_a.a_id <> 2 and d3603_c.c_id in (1, 21)         and d3603_a.c_id = d3603_c.c_id"), new String[][]{{"1", "1"}, {"3", "1"}});
    }

    public void testDerby4376() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table d4376(x int primary key)");
        statement.execute("insert into d4376 values (1), (2), (3)");
        PreparedStatement preparedStatement = this.prepareStatement("select * from d4376 where x in (?, ?)");
        preparedStatement.setNull(1, 4);
        preparedStatement.setInt(2, 1);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), "1");
        statement.execute("drop table d4376");
    }

    public void testDuplicateParameters() throws SQLException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d4378(x int primary key, y int)");
        statement.execute("insert into d4378 values (1,2),(3,4),(5,6),(7,8),(9,10)");
        statement.execute("insert into d4378 select y, x from d4378");
        PreparedStatement preparedStatement = this.prepareStatement("select * from d4378 where x in (?,?,?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.setInt(2, 1);
        preparedStatement.setInt(3, 1);
        JDBC.assertFullResultSet(preparedStatement.executeQuery(), new String[][]{{"1", "2"}});
        this.rollback();
    }

    private static void insertNDataRows(Connection connection, int n, Random random) throws SQLException {
        Object object;
        PreparedStatement preparedStatement = connection.prepareStatement("insert into CHANGES (KIND, ITEM_UUID, ITEM_TYPE, BEFORE, AFTER, FOREIGN_KEY_UUID, ID) VALUES (?, ?, ?, ?, ?, ?, ?)");
        String string = null;
        int n2 = 0;
        while (n-- > 0) {
            if (n2 <= 0) {
                n2 = (int)(1.5 + Math.abs(2.0 * random.nextGaussian()));
                string = InListMultiProbeTest.genUUIDValue(random);
            }
            object = new DataRow(random, string);
            ((DataRow)object).setParameters(preparedStatement);
            preparedStatement.addBatch();
            --n2;
        }
        object = preparedStatement.executeBatch();
        for (int i = 0; i < ((int[])object).length; ++i) {
            if (object[i] == true) continue;
            InListMultiProbeTest.fail((String)"Failed to insert rows into CHANGES");
        }
        preparedStatement.close();
    }

    private void testOneSize(List<QueryStrategy> list, int n) throws SQLException {
        if (n > this.allIds.length) {
            return;
        }
        String string = null;
        Statement statement = this.createStatement();
        for (QueryStrategy queryStrategy : list) {
            int n2 = queryStrategy.testSize(n);
            ResultSet resultSet = statement.executeQuery(GET_RUNTIME_STATS_QUERY);
            if (!this.checkMultiProbeQueryPlan(resultSet, n2)) {
                string = queryStrategy.getName();
                break;
            }
            resultSet.close();
        }
        statement.close();
        if (string != null) {
            InListMultiProbeTest.fail((String)("Execution of '" + string + "' strategy with " + n + " id(s) should have resulted in index multi-probing, but did not."));
        }
    }

    private void readAllRows(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery(SELECT_ALL);
        this.foreignIdToRowsMap = new TreeMap();
        while (resultSet.next()) {
            DataRow dataRow = new DataRow(resultSet);
            List<DataRow> list = this.foreignIdToRowsMap.get(dataRow.foreign_key_uuid);
            if (list == null) {
                list = new ArrayList<DataRow>();
                this.foreignIdToRowsMap.put(dataRow.foreign_key_uuid, list);
            }
            list.add(dataRow);
        }
        resultSet.close();
        statement.close();
        this.allIds = new String[this.foreignIdToRowsMap.size()];
        this.foreignIdToRowsMap.keySet().toArray(this.allIds);
    }

    private static String genUUIDValue(Random random) {
        char[] cArray = new char[23];
        cArray[0] = 95;
        for (int i = 1; i < cArray.length; ++i) {
            int n = random.nextInt(uuid_chars.length);
            cArray[i] = uuid_chars[n];
        }
        return new String(cArray);
    }

    private void assertResultsAndQueryPlan(ResultSet resultSet, String[][] stringArray, Statement statement) throws SQLException {
        int n = 0;
        if (stringArray == null || stringArray.length == 0) {
            JDBC.assertEmpty(resultSet);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray);
            n = stringArray.length;
        }
        ResultSet resultSet2 = statement.executeQuery(GET_RUNTIME_STATS_QUERY);
        if (!this.checkMultiProbeQueryPlan(resultSet2, n)) {
            InListMultiProbeTest.fail((String)"Expected multi-probing index scan but query plan showed something else.");
        }
        resultSet2.close();
    }

    private boolean checkMultiProbeQueryPlan(ResultSet resultSet, int n) throws SQLException {
        if (!resultSet.next()) {
            return false;
        }
        RuntimeStatisticsParser runtimeStatisticsParser = new RuntimeStatisticsParser(resultSet.getString(1));
        return runtimeStatisticsParser.usedIndexRowToBaseRow() && runtimeStatisticsParser.usedIndexScan() && runtimeStatisticsParser.rowsQualifiedEquals(n);
    }

    class MarkersStrategy
    extends QueryStrategy {
        public MarkersStrategy(Connection connection, Random random) {
            super(connection, random);
        }

        @Override
        protected String getName() {
            return "Markers";
        }

        @Override
        protected int fetchDataRows(String[] stringArray) throws SQLException {
            int n;
            StringBuffer stringBuffer = new StringBuffer(InListMultiProbeTest.SELECT_ALL_WHERE_IN);
            stringBuffer.append("?");
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(", ?");
            }
            stringBuffer.append(InListMultiProbeTest.ORDER_BY);
            PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
            for (n = 0; n < stringArray.length; ++n) {
                preparedStatement.setString(n + 1, stringArray[n]);
            }
            n = this.validate(stringArray, preparedStatement.executeQuery());
            preparedStatement.close();
            return n;
        }
    }

    class LiteralsStrategy
    extends QueryStrategy {
        public LiteralsStrategy(Connection connection, Random random) {
            super(connection, random);
        }

        @Override
        protected String getName() {
            return "Literals";
        }

        @Override
        protected int fetchDataRows(String[] stringArray) throws SQLException {
            StringBuffer stringBuffer = new StringBuffer(InListMultiProbeTest.SELECT_ALL_WHERE_IN);
            stringBuffer.append("'");
            stringBuffer.append(stringArray[0]);
            stringBuffer.append("'");
            for (int i = 1; i < stringArray.length; ++i) {
                stringBuffer.append(", '");
                stringBuffer.append(stringArray[i]);
                stringBuffer.append("'");
            }
            stringBuffer.append(InListMultiProbeTest.ORDER_BY);
            PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
            int n = this.validate(stringArray, preparedStatement.executeQuery());
            preparedStatement.close();
            return n;
        }
    }

    class MixedIdsStrategy
    extends QueryStrategy {
        public MixedIdsStrategy(Connection connection, Random random) {
            super(connection, random);
        }

        @Override
        protected String getName() {
            return "MixedIds";
        }

        @Override
        protected int fetchDataRows(String[] stringArray) throws SQLException {
            int n;
            StringBuffer stringBuffer = new StringBuffer(InListMultiProbeTest.SELECT_ALL_WHERE_IN);
            stringBuffer.append("?");
            for (int i = 1; i < stringArray.length; ++i) {
                if (i % 2 == 1) {
                    stringBuffer.append(", '");
                    stringBuffer.append(stringArray[i]);
                    stringBuffer.append("'");
                    continue;
                }
                stringBuffer.append(", ?");
            }
            stringBuffer.append(InListMultiProbeTest.ORDER_BY);
            PreparedStatement preparedStatement = this.conn.prepareStatement(stringBuffer.toString());
            int n2 = 0;
            for (n = 0; n < stringArray.length; ++n) {
                if (n % 2 != 0) continue;
                preparedStatement.setString(++n2, stringArray[n]);
            }
            n = this.validate(stringArray, preparedStatement.executeQuery());
            preparedStatement.close();
            return n;
        }
    }

    private static class DataRow {
        static long nextId = 1L;
        final String kind;
        final String item_uuid;
        final String item_type;
        final String before;
        final String after;
        final String foreign_key_uuid;
        final long id;

        DataRow(Random random, String string) {
            int n = random.nextInt(3);
            switch (n) {
                case 0: {
                    this.kind = "ADD";
                    break;
                }
                case 1: {
                    this.kind = "MOD";
                    break;
                }
                default: {
                    this.kind = "DEL";
                }
            }
            this.item_uuid = InListMultiProbeTest.genUUIDValue(random);
            this.item_type = random.nextBoolean() ? "http://companyA.com/divB/x.y.z/packageC#typeD" : "http://companyE.com/divF/i.j.k/packageG#typeH";
            this.before = InListMultiProbeTest.genUUIDValue(random);
            this.after = InListMultiProbeTest.genUUIDValue(random);
            this.foreign_key_uuid = string;
            this.id = nextId++;
        }

        DataRow(ResultSet resultSet) throws SQLException {
            this.kind = resultSet.getString(1);
            this.item_uuid = resultSet.getString(2);
            this.item_type = resultSet.getString(3);
            this.before = resultSet.getString(4);
            this.after = resultSet.getString(5);
            this.foreign_key_uuid = resultSet.getString(6);
            this.id = resultSet.getLong(7);
        }

        void setParameters(PreparedStatement preparedStatement) throws SQLException {
            preparedStatement.setString(1, this.kind);
            preparedStatement.setString(2, this.item_uuid);
            preparedStatement.setString(3, this.item_type);
            preparedStatement.setString(4, this.before);
            preparedStatement.setString(5, this.after);
            preparedStatement.setString(6, this.foreign_key_uuid);
            preparedStatement.setLong(7, this.id);
        }

        String[] getColumns() {
            return new String[]{this.kind, this.item_uuid, this.item_type, this.before, this.after, this.foreign_key_uuid, Long.toString(this.id)};
        }
    }

    abstract class QueryStrategy {
        private Random random;
        protected Connection conn;
        Comparator<String[]> rowComparator = new Comparator<String[]>(){

            @Override
            public int compare(String[] stringArray, String[] stringArray2) {
                Long l = Long.valueOf(stringArray[6]);
                Long l2 = Long.valueOf(stringArray2[6]);
                return l.compareTo(l2);
            }
        };

        public QueryStrategy(Connection connection, Random random) {
            this.conn = connection;
            this.random = random;
        }

        public final int testSize(int n) throws SQLException {
            HashSet<String> hashSet = new HashSet<String>();
            while (hashSet.size() < n) {
                int n2 = this.random.nextInt(InListMultiProbeTest.this.allIds.length);
                hashSet.add(InListMultiProbeTest.this.allIds[n2]);
            }
            String[] stringArray = new String[n];
            hashSet.toArray(stringArray);
            return this.fetchDataRows(stringArray);
        }

        protected int validate(String[] stringArray, ResultSet resultSet) throws SQLException {
            int n;
            String[][] stringArray2;
            ArrayList<String[]> arrayList = new ArrayList<String[]>(InListMultiProbeTest.this.foreignIdToRowsMap.size());
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray2 = InListMultiProbeTest.this.foreignIdToRowsMap.get(stringArray[i]);
                for (n = stringArray2.size() - 1; n >= 0; --n) {
                    arrayList.add(((DataRow)stringArray2.get(n)).getColumns());
                }
            }
            Collections.sort(arrayList, this.rowComparator);
            Object[] objectArray = arrayList.toArray();
            stringArray2 = new String[objectArray.length][];
            for (n = 0; n < objectArray.length; ++n) {
                stringArray2[n] = (String[])objectArray[n];
            }
            JDBC.assertFullResultSet(resultSet, stringArray2);
            return stringArray2.length;
        }

        protected abstract int fetchDataRows(String[] var1) throws SQLException;

        protected abstract String getName();
    }
}

