/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.derby.iapi.types.HarmonySerialBlob;
import org.apache.derby.iapi.types.HarmonySerialClob;
import org.apache.derbyTesting.functionTests.tests.lang.Price;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;

public class VarargsRoutines {
    public static Integer max(Integer ... integerArray) {
        if (integerArray == null) {
            return null;
        }
        if (integerArray.length == 0) {
            return null;
        }
        int n = Integer.MIN_VALUE;
        for (Integer n2 : integerArray) {
            if (n2 == null) {
                return null;
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    public static String formatMessage(String string, String ... stringArray) {
        return MessageFormat.format(string, stringArray);
    }

    public static String ambiguousTypes(int ... nArray) {
        return "primitive";
    }

    public static String ambiguousTypes(Integer ... integerArray) {
        return "wrapper";
    }

    public static Integer maxInts(int ... nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return null;
        }
        int n = Integer.MIN_VALUE;
        for (int n2 : nArray) {
            n = Math.max(n, n2);
        }
        return n;
    }

    public static String nonVarargsMethod(int n) {
        return "shouldn't be resolved";
    }

    public static String nonVarargsMethod(int[] nArray) {
        return "shouldn't be resolved";
    }

    public static Integer vnvr(int n) {
        return -n;
    }

    public static Integer vnvr(int ... nArray) {
        return VarargsRoutines.maxInts(nArray);
    }

    public static Integer lnv(int ... nArray) {
        return VarargsRoutines.maxInts(nArray);
    }

    public static Integer lnv(int n, int ... nArray) {
        return VarargsRoutines.maxInts(nArray);
    }

    public static Integer lnv(int n, int n2, int ... nArray) {
        return VarargsRoutines.maxInts(nArray);
    }

    public static void inVarargs(String[] stringArray, int ... nArray) {
        String string;
        if (nArray == null) {
            string = null;
        } else if (nArray.length == 0) {
            string = null;
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("RESULT: ");
            for (int n : nArray) {
                stringBuilder.append(" " + Integer.toString(n));
            }
            string = stringBuilder.toString();
        }
        stringArray[0] = string;
    }

    public static void outVarargs(int n, int[] ... nArray) throws Exception {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i][0] = n + i;
        }
    }

    public static void inoutVarargs(int n, int[] ... nArray) throws Exception {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            nArray2[0] = nArray2[0] + n;
        }
    }

    public static String add(String string, int ... nArray) {
        if (nArray == null) {
            return null;
        }
        if (nArray.length == 0) {
            return null;
        }
        int n = 0;
        for (int n2 : nArray) {
            n += n2;
        }
        return "int " + string + " " + n;
    }

    public static String add(String string, long ... lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (long l2 : lArray) {
            l += l2;
        }
        return "long " + string + " " + l;
    }

    public static String add(String string, short ... sArray) {
        if (sArray == null) {
            return null;
        }
        if (sArray.length == 0) {
            return null;
        }
        short s = 0;
        for (short s2 : sArray) {
            s = (short)(s + s2);
        }
        return "short " + string + " " + s;
    }

    public static String add(String string, Blob ... blobArray) throws SQLException {
        if (blobArray == null) {
            return null;
        }
        if (blobArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (Blob blob : blobArray) {
            l += (long)VarargsRoutines.addBytes(blob.getBytes(1L, (int)blob.length()));
        }
        return "blob " + string + " " + l;
    }

    public static String add(String string, boolean ... blArray) throws SQLException {
        if (blArray == null) {
            return null;
        }
        if (blArray.length == 0) {
            return null;
        }
        int n = 0;
        for (boolean bl : blArray) {
            if (!bl) continue;
            ++n;
        }
        return "boolean " + string + " " + n;
    }

    public static String add(String string, String ... stringArray) throws SQLException {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return null;
        }
        Object object = "";
        for (String string2 : stringArray) {
            object = (String)object + string2;
        }
        return "String " + string + " " + (String)object;
    }

    public static String add(String string, byte[] ... byArray) throws SQLException {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return null;
        }
        int n = 0;
        for (byte[] byArray2 : byArray) {
            n += VarargsRoutines.addBytes(byArray2);
        }
        return "byte[] " + string + " " + n;
    }

    public static String add(String string, Clob ... clobArray) throws SQLException {
        if (clobArray == null) {
            return null;
        }
        if (clobArray.length == 0) {
            return null;
        }
        Object object = "";
        for (Clob clob : clobArray) {
            object = (String)object + clob.getSubString(1L, (int)clob.length());
        }
        return "clob " + string + " " + (String)object;
    }

    public static String add(String string, Date ... dateArray) throws SQLException {
        if (dateArray == null) {
            return null;
        }
        if (dateArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (Date date : dateArray) {
            ++l;
        }
        return "date " + string + " " + l;
    }

    public static String add(String string, Time ... timeArray) throws SQLException {
        if (timeArray == null) {
            return null;
        }
        if (timeArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (Time time : timeArray) {
            ++l;
        }
        return "time " + string + " " + l;
    }

    public static String add(String string, Timestamp ... timestampArray) throws SQLException {
        if (timestampArray == null) {
            return null;
        }
        if (timestampArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (Timestamp timestamp : timestampArray) {
            ++l;
        }
        return "timestamp " + string + " " + l;
    }

    public static String add(String string, BigDecimal ... bigDecimalArray) {
        if (bigDecimalArray == null) {
            return null;
        }
        if (bigDecimalArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (BigDecimal bigDecimal : bigDecimalArray) {
            l += bigDecimal.longValue();
        }
        return "bigdecimal " + string + " " + l;
    }

    public static String add(String string, double ... dArray) {
        if (dArray == null) {
            return null;
        }
        if (dArray.length == 0) {
            return null;
        }
        double d = 0.0;
        for (double d2 : dArray) {
            d += d2;
        }
        return "double " + string + " " + d;
    }

    public static String add(String string, float ... fArray) {
        if (fArray == null) {
            return null;
        }
        if (fArray.length == 0) {
            return null;
        }
        float f = 0.0f;
        for (float f2 : fArray) {
            f += f2;
        }
        return "float " + string + " " + f;
    }

    public static String add(String string, Price ... priceArray) throws SQLException {
        if (priceArray == null) {
            return null;
        }
        if (priceArray.length == 0) {
            return null;
        }
        long l = 0L;
        for (Price price : priceArray) {
            ++l;
        }
        return "Price " + string + " " + l;
    }

    private static int addChars(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            n += string.charAt(i);
        }
        return n;
    }

    public static Blob makeBlob(String string) throws SQLException {
        return new HarmonySerialBlob(VarargsRoutines.makeBytes(string));
    }

    public static byte[] makeBytes(String string) throws SQLException {
        int n = string.length();
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[i] = (byte)(string.charAt(i) - 48);
        }
        return byArray;
    }

    public static Clob makeClob(String string) throws SQLException {
        return new HarmonySerialClob(string);
    }

    private static int addBytes(byte[] byArray) {
        int n = 0;
        for (byte by : byArray) {
            n += by;
        }
        return n;
    }

    public static ResultSet oneColumnRows(String ... stringArray) {
        String[][] stringArray2;
        String[] stringArray3 = new String[]{"COL1"};
        if (stringArray == null || stringArray.length == 0) {
            stringArray2 = new String[][]{};
        } else {
            int n = stringArray.length;
            stringArray2 = new String[n][];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = new String[]{stringArray[i]};
            }
        }
        return new StringArrayVTI(stringArray3, stringArray2);
    }

    public static ResultSet stringArrayTable(String string, String ... stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray2 = new String[arrayList.size()];
        arrayList.toArray(stringArray2);
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        for (String string2 : stringArray) {
            ArrayList<String> arrayList3 = new ArrayList<String>();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
            while (stringTokenizer2.hasMoreTokens()) {
                arrayList3.add(stringTokenizer2.nextToken());
            }
            String[] stringArray3 = new String[arrayList3.size()];
            arrayList3.toArray(stringArray3);
            arrayList2.add(stringArray3);
        }
        String[] stringArray4 = new String[arrayList2.size()][];
        arrayList2.toArray(stringArray4);
        return new StringArrayVTI(stringArray2, (String[][])stringArray4);
    }
}

