/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class DecryptDatabaseTest
extends BaseJDBCTestCase {
    private static final String TABLE = "DECRYPTTABLE";
    private static final String BOOTPW = "Thursday";
    private static final String ALREADY_BOOTED = "01J17";
    private static String encryptionAlgorithm;

    public DecryptDatabaseTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        super.setUp();
        try {
            this.connect(false, BOOTPW, null).close();
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("Did you change the boot password?", "XJ004", sQLException);
            this.getConnection();
            this.saveEncryptionAlgorithm();
        }
        TestConfiguration testConfiguration = this.getTestConfiguration();
        testConfiguration.shutdownDatabase();
        try {
            this.connect(false, null, null);
            testConfiguration.shutdownDatabase();
            DecryptDatabaseTest.println("encrypting database (" + encryptionAlgorithm + ")");
            this.connect(false, BOOTPW, "dataEncryption=true;encryptionAlgorithm=" + encryptionAlgorithm);
            testConfiguration.shutdownDatabase();
            this.connect(false, null, null);
            DecryptDatabaseTest.fail((String)"database encryption failed");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XBM06", sQLException);
        }
    }

    private void saveEncryptionAlgorithm() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("values syscs_util.syscs_get_database_property('encryptionAlgorithm')");
        if (resultSet.next()) {
            String string = resultSet.getString(1);
            if (string != null && !string.equals(encryptionAlgorithm)) {
                encryptionAlgorithm = string;
            }
            DecryptDatabaseTest.assertFalse((boolean)resultSet.next());
        }
        resultSet.close();
        statement.close();
    }

    public void testDecryptDatabaseNegative() throws SQLException {
        try {
            this.connect(false, "verywrongpw", null);
            DecryptDatabaseTest.fail((String)"connection succeeded with wrong password");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ040", sQLException);
        }
        try {
            this.connect(false, null, null);
            DecryptDatabaseTest.fail((String)"connection succeeded without password");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XBM06", sQLException);
        }
        try {
            this.connect(true, "verywrongpw", null);
            DecryptDatabaseTest.fail((String)"decryption succeeded with wrong password");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ040", sQLException);
        }
        try {
            this.connect(true, null, null);
            DecryptDatabaseTest.fail((String)"decryption succeeded without password");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XBM06", sQLException);
        }
        try {
            this.connect(true, null, null);
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XBM06", sQLException);
        }
        try {
            this.connect(false, BOOTPW, "decryptDatabase=fred");
            DecryptDatabaseTest.fail((String)"bad decryptDatabase setting not detected");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ05B", sQLException);
        }
        this.connect(false, BOOTPW, null);
    }

    public void testDecryptDatabase() throws SQLException {
        this.populateDatabase(true, 1000);
        this.getTestConfiguration().shutdownDatabase();
        Connection connection = this.connect(true, BOOTPW, null);
        JDBC.assertNoWarnings(connection.getWarnings());
        Statement statement = connection.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("select * from DECRYPTTABLE"), 1000);
        statement.close();
        connection.close();
        this.getTestConfiguration().shutdownDatabase();
        connection = this.connect(false, null, null);
        statement = connection.createStatement();
        JDBC.assertDrainResults(statement.executeQuery("select * from DECRYPTTABLE"), 1000);
        JDBC.assertFullResultSet(statement.executeQuery("select * from DECRYPTTABLE where id <= 6 order by id ASC"), new String[][]{{"1"}, {"2"}, {"3"}, {"4"}, {"5"}, {"6"}});
        statement.close();
        connection.close();
    }

    public void testDecryptOnBootedDatabase() throws SQLException {
        this.getConnection();
        DecryptDatabaseTest.println("Test warning 01J17");
        this.vetChangeWarning(this.connect(false, BOOTPW, "dataEncryption=true"));
        this.vetChangeWarning(this.connect(false, BOOTPW, "newBootPassword=foo"));
        this.vetChangeWarning(this.connect(false, BOOTPW, "newEncryptionKey=foo"));
        this.vetChangeWarning(this.connect(false, BOOTPW, "decryptDatabase=true"));
        this.connect(true, BOOTPW, null).close();
        this.getTestConfiguration().shutdownDatabase();
        try {
            this.connect(false, null, null);
            DecryptDatabaseTest.fail((String)"decrypted already booted database");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XBM06", sQLException);
        }
    }

    private void vetChangeWarning(Connection connection) throws SQLException {
        DecryptDatabaseTest.assertWarning(connection, ALREADY_BOOTED);
        connection.close();
    }

    public void testDecryptUnEncryptedDatabase() throws SQLException {
        Connection connection = this.connect(true, BOOTPW, null);
        JDBC.assertNoWarnings(connection.getWarnings());
        connection.close();
        this.getTestConfiguration().shutdownDatabase();
        connection = this.connect(true, null, null);
        connection.close();
    }

    public void testConflictingConnectionAttributes() throws SQLException {
        try {
            this.connect(true, BOOTPW, "newBootPassword=MondayMilk");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (newBootPassword)");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ048", sQLException);
        }
        try {
            this.connect(true, BOOTPW, "newEncryptionKey=6162636465666768");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (newEncryptionKey)");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ048", sQLException);
        }
        try {
            this.connect(true, BOOTPW, "createFrom=./nonexistdb");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (createFrom)");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ081", sQLException);
        }
        try {
            this.connect(true, BOOTPW, "restoreFrom=./nonexistdb");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (restoreFrom)");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ081", sQLException);
        }
        try {
            this.connect(true, BOOTPW, "rollForwardRecoveryFrom=./nonexistdb");
            DecryptDatabaseTest.fail((String)"connected with conflicting attrs (rollForwardRecoveryFrom)");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ081", sQLException);
        }
        this.connect(true, BOOTPW, null);
        this.getTestConfiguration().shutdownDatabase();
        try {
            this.connect(true, BOOTPW, "dataEncryption=true");
            DecryptDatabaseTest.fail((String)"connected with conflicting attributes (dataEncryption)");
        }
        catch (SQLException sQLException) {
            DecryptDatabaseTest.assertSQLState("XJ048", sQLException);
        }
    }

    private Connection connect(boolean bl, String string, String string2) throws SQLException {
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.clearStringBeanProperty(dataSource, "connectionAttributes");
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            stringBuffer.append("decryptDatabase=true").append(';');
        }
        if (string != null) {
            stringBuffer.append("bootPassword=").append(string).append(';');
        }
        if (string2 != null) {
            stringBuffer.append(string2).append(';');
        }
        if (stringBuffer.length() > 0) {
            JDBCDataSource.setBeanProperty(dataSource, "connectionAttributes", stringBuffer.toString());
        }
        DecryptDatabaseTest.println("connectionAttributes: " + (stringBuffer.length() == 0 ? "<empty>" : stringBuffer.toString()));
        return dataSource.getConnection();
    }

    private void populateDatabase(boolean bl, int n) throws SQLException {
        Statement statement;
        this.setAutoCommit(false);
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        ResultSet resultSet = databaseMetaData.getTables(null, null, TABLE, null);
        boolean bl2 = resultSet.next();
        DecryptDatabaseTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        if (bl) {
            statement = this.createStatement();
            if (bl2) {
                DecryptDatabaseTest.println("deleting rows from table DECRYPTTABLE");
                statement.executeUpdate("delete from DECRYPTTABLE");
                DecryptDatabaseTest.println("resetting identity column");
                statement.executeUpdate("ALTER TABLE DECRYPTTABLE ALTER COLUMN id RESTART WITH 1");
            } else {
                DecryptDatabaseTest.println("creating table DECRYPTTABLE");
                statement.executeUpdate("create table DECRYPTTABLE (id int generated always as identity)");
            }
        }
        DecryptDatabaseTest.println("populating database");
        statement = this.prepareStatement("insert into DECRYPTTABLE values (DEFAULT)");
        for (int i = 0; i < n; ++i) {
            statement.executeUpdate();
        }
        this.commit();
        this.setAutoCommit(true);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("DecryptDatabaseTest suite");
        baseTestSuite.addTest(DecryptDatabaseTest.wrapTest());
        baseTestSuite.addTest(DecryptDatabaseTest.wrapTest("AES/OFB/NoPadding"));
        return baseTestSuite;
    }

    private static Test wrapTest() {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(DecryptDatabaseTest.class), BOOTPW);
    }

    private static Test wrapTest(String string) {
        return Decorator.encryptedDatabaseBpw(TestConfiguration.embeddedSuite(DecryptDatabaseTest.class), string, BOOTPW);
    }
}

