/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.jdbc;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Vector;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.EnginePreparedStatement;
import org.apache.derby.iapi.services.loader.GeneratedClass;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ParameterValueSet;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RawToBinaryFormatStream;
import org.apache.derby.iapi.types.ReaderToUTF8Stream;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.VariableSizeDataValue;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedParameterSetMetaData;
import org.apache.derby.impl.jdbc.EmbedResultSet;
import org.apache.derby.impl.jdbc.EmbedResultSetMetaData;
import org.apache.derby.impl.jdbc.EmbedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class EmbedPreparedStatement
extends EmbedStatement
implements EnginePreparedStatement {
    protected ResultSetMetaData rMetaData;
    private String gcDuringGetMetaData;
    protected org.apache.derby.iapi.sql.PreparedStatement preparedStatement;
    private Activation activation;
    private Boolean usePreTenFiveHdrFormat;
    private BrokeredConnectionControl bcc = null;

    public EmbedPreparedStatement(EmbedConnection conn, String sql, boolean forMetaData, int resultSetType, int resultSetConcurrency, int resultSetHoldability, int autoGeneratedKeys, int[] columnIndexes, String[] columnNames) throws SQLException {
        super(conn, forMetaData, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.isPoolable = true;
        if (sql == null) {
            throw EmbedPreparedStatement.newSQLException("XJ067.S", new Object[0]);
        }
        this.SQLText = sql;
        try {
            this.preparedStatement = this.lcc.prepareInternalStatement(this.lcc.getDefaultSchema(), sql, resultSetConcurrency == 1007, forMetaData);
            this.addWarning(this.preparedStatement.getCompileTimeWarnings());
            this.activation = this.preparedStatement.getActivation(this.lcc, resultSetType == 1004);
            this.checkRequiresCallableStatement(this.activation);
            if (autoGeneratedKeys == 1) {
                this.activation.setAutoGeneratedKeysResultsetInfo(columnIndexes, columnNames);
            }
            InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
    }

    @Override
    protected void finalize() throws Throwable {
        super.finalize();
        if (this.activation != null) {
            this.activation.markUnused();
        }
    }

    @Override
    public final boolean execute(String sql) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "execute(String)");
    }

    @Override
    public final boolean execute(String sql, int autoGenKeys) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "execute(String, int)");
    }

    @Override
    public final boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "execute(String, int[])");
    }

    @Override
    public final boolean execute(String sql, String[] columnNames) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "execute(String, String[])");
    }

    @Override
    public final ResultSet executeQuery(String sql) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "executeQuery(String)");
    }

    @Override
    public final int executeUpdate(String sql) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "executeUpdate(String)");
    }

    @Override
    public final int executeUpdate(String sql, int autoGenKeys) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "executeUpdate(String, int)");
    }

    @Override
    public final int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "executeUpdate(String, int[])");
    }

    @Override
    public final int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "executeUpdate(String, String[])");
    }

    @Override
    public final void addBatch(String sql) throws SQLException {
        throw EmbedPreparedStatement.newSQLException("XJ016.S", "addBatch(String)");
    }

    @Override
    void closeActions() throws SQLException {
        if (this.bcc != null) {
            PreparedStatement ps_app = (PreparedStatement)((Object)this.applicationStatement);
            this.bcc.onStatementClose(ps_app);
        }
        this.preparedStatement = null;
        try {
            this.setupContextStack();
        }
        catch (SQLException se) {
            return;
        }
        try {
            this.activation.close();
            this.activation = null;
            InterruptStatus.restoreIntrFlagIfSeen();
        }
        catch (Throwable t) {
            throw this.handleException(t);
        }
        finally {
            this.restoreContextStack();
        }
    }

    @Override
    public final ResultSet executeQuery() throws SQLException {
        try {
            this.executeStatement(this.activation, true, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        if (this.results == null) {
            SanityManager.THROWASSERT("no results returned on executeQuery()");
        }
        return this.results;
    }

    @Override
    public final int executeUpdate() throws SQLException {
        return (int)this.executeLargeUpdate();
    }

    @Override
    public final long executeLargeUpdate() throws SQLException {
        try {
            this.executeStatement(this.activation, false, true);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        return this.updateCount;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        Util.checkForSupportedDataType(sqlType);
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isJDBCTypeEquivalent(jdbcTypeId, sqlType)) {
            throw this.dataTypeConversion(parameterIndex, Util.typeName(sqlType));
        }
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setToNull();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setBigDecimal(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.setDate(parameterIndex, x, null);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.setTime(parameterIndex, x, null);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.setTimestamp(parameterIndex, x, null);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkAsciiStreamConditions(parameterIndex);
        InputStreamReader r = null;
        if (x != null) {
            try {
                r = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.setCharacterStreamInternal(parameterIndex, r, false, length);
    }

    @Override
    public final void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setAsciiStream(parameterIndex, x, (long)length);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        throw Util.notImplemented("setUnicodeStream");
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkCharacterStreamConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, false, length);
    }

    @Override
    public final void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.setCharacterStream(parameterIndex, reader, (long)length);
    }

    private final void checkCharacterStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isCharacterStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.Reader");
        }
    }

    private final void checkAsciiStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isAsciiStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.InputStream(ASCII)");
        }
    }

    private void setCharacterStreamInternal(int parameterIndex, Reader reader, boolean lengthLess, long length) throws SQLException {
        if (!lengthLess && length < 0L) {
            throw EmbedPreparedStatement.newSQLException("XJ025.S", new Object[0]);
        }
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (reader == null) {
            this.setNull(parameterIndex, jdbcTypeId);
            return;
        }
        if (!lengthLess && length > Integer.MAX_VALUE) {
            throw EmbedPreparedStatement.newSQLException("22003", this.getParameterSQLType(parameterIndex));
        }
        try {
            ReaderToUTF8Stream utfIn;
            StringDataValue dvd = (StringDataValue)this.getParms().getParameter(parameterIndex - 1);
            dvd.setStreamHeaderFormat(this.usePreTenFiveHdrFormat());
            DataTypeDescriptor[] dtd = this.preparedStatement.getParameterTypes();
            int colWidth = dtd[parameterIndex - 1].getMaximumWidth();
            int usableLength = -1;
            if (!lengthLess) {
                usableLength = (int)length;
                int truncationLength = 0;
                if (jdbcTypeId == 2005 && usableLength > colWidth) {
                    truncationLength = usableLength - colWidth;
                    usableLength = colWidth;
                }
                utfIn = new ReaderToUTF8Stream(reader, usableLength, truncationLength, this.getParameterSQLType(parameterIndex), dvd.getStreamHeaderGenerator());
            } else {
                utfIn = new ReaderToUTF8Stream(reader, colWidth, this.getParameterSQLType(parameterIndex), dvd.getStreamHeaderGenerator());
            }
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(utfIn, usableLength);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    private Boolean usePreTenFiveHdrFormat() throws StandardException {
        if (this.usePreTenFiveHdrFormat == null) {
            this.usePreTenFiveHdrFormat = !this.lcc.getDataDictionary().checkVersion(170, null);
        }
        return this.usePreTenFiveHdrFormat;
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkBinaryStreamConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, x, true, -1L);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.checkBinaryStreamConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, x, false, length);
    }

    @Override
    public final void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.setBinaryStream(parameterIndex, x, (long)length);
    }

    private void setBinaryStreamInternal(int parameterIndex, InputStream x, boolean lengthLess, long length) throws SQLException {
        if (!lengthLess && length < 0L) {
            throw EmbedPreparedStatement.newSQLException("XJ025.S", new Object[0]);
        }
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, jdbcTypeId);
            return;
        }
        if (!lengthLess && length > Integer.MAX_VALUE) {
            throw EmbedPreparedStatement.newSQLException("22003", this.getParameterMetaData().getParameterTypeName(parameterIndex));
        }
        try {
            RawToBinaryFormatStream rawStream;
            if (lengthLess) {
                length = -1L;
                DataTypeDescriptor[] dtd = this.preparedStatement.getParameterTypes();
                rawStream = new RawToBinaryFormatStream(x, dtd[parameterIndex - 1].getMaximumWidth(), dtd[parameterIndex - 1].getTypeName());
            } else {
                rawStream = new RawToBinaryFormatStream(x, (int)length);
            }
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(rawStream, (int)length);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    private final void checkBinaryStreamConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        int jdbcTypeId = this.getParameterJDBCType(parameterIndex);
        if (!DataTypeDescriptor.isBinaryStreamAssignable(jdbcTypeId)) {
            throw this.dataTypeConversion(parameterIndex, "java.io.InputStream");
        }
    }

    @Override
    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this.setNull(paramIndex, sqlType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        this.checkStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            if (this.batchStatements == null) {
                this.batchStatements = new Vector();
            }
            this.batchStatements.add(this.getParms().getClone());
            this.clearParameters();
        }
    }

    @Override
    boolean executeBatchElement(Object batchElement) throws SQLException, StandardException {
        ParameterValueSet temp = (ParameterValueSet)batchElement;
        int numberOfParameters = temp.getParameterCount();
        for (int j = 0; j < numberOfParameters; ++j) {
            temp.getParameter(j).setInto(this, j + 1);
        }
        return super.executeStatement(this.activation, false, true);
    }

    @Override
    public void clearParameters() throws SQLException {
        this.checkStatus();
        ParameterValueSet pvs = this.getParms();
        if (pvs != null) {
            pvs.clearParameters();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkExecStatus();
        Object object = this.getConnectionSynchronization();
        synchronized (object) {
            ExecPreparedStatement execp = (ExecPreparedStatement)this.preparedStatement;
            this.setupContextStack();
            try {
                GeneratedClass currAc = null;
                ResultDescription resd = null;
                ExecPreparedStatement execPreparedStatement = execp;
                synchronized (execPreparedStatement) {
                    while (true) {
                        if (!execp.upToDate()) {
                            execp.rePrepare(this.lcc);
                            continue;
                        }
                        currAc = execp.getActivationClass();
                        resd = execp.getResultDescription();
                        if (currAc != null) break;
                    }
                }
                if (this.gcDuringGetMetaData == null || !this.gcDuringGetMetaData.equals(currAc.getName())) {
                    this.rMetaData = null;
                    this.gcDuringGetMetaData = currAc.getName();
                }
                if (this.rMetaData == null && resd != null) {
                    String statementType = resd.getStatementType();
                    this.rMetaData = statementType.equals("INSERT") || statementType.equals("UPDATE") || statementType.equals("DELETE") ? null : this.newEmbedResultSetMetaData(resd);
                }
                InterruptStatus.restoreIntrFlagIfSeen(this.lcc);
            }
            catch (Throwable t) {
                throw this.handleException(t);
            }
            finally {
                this.restoreContextStack();
            }
        }
        return this.rMetaData;
    }

    @Override
    public final void setRef(int i, Ref x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setArray(int i, Array x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        if (x == null) {
            this.setNull(parameterIndex, targetSqlType);
            return;
        }
        Util.checkForSupportedDataType(targetSqlType);
        int paramJDBCType = this.getParameterJDBCType(parameterIndex);
        if (paramJDBCType != 2000 && !DataTypeDescriptor.isJDBCTypeEquivalent(paramJDBCType, targetSqlType)) {
            throw this.dataTypeConversion(parameterIndex, Util.typeName(targetSqlType));
        }
        this.setObject(parameterIndex, x);
        if (paramJDBCType == 3 || paramJDBCType == 2) {
            this.setScale(parameterIndex, scale);
        }
    }

    @Override
    public final void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.setObject(parameterIndex, x, targetSqlType, 0);
    }

    @Override
    public final void setObject(int parameterIndex, Object x) throws SQLException {
        this.checkStatus();
        int colType = this.getParameterJDBCType(parameterIndex);
        if (x == null) {
            this.setNull(parameterIndex, colType);
            return;
        }
        if (colType == 2000) {
            try {
                this.getParms().setParameterAsObject(parameterIndex - 1, x);
                return;
            }
            catch (Throwable t) {
                throw EmbedResultSet.noStateChangeException(t);
            }
        }
        if (x instanceof String) {
            this.setString(parameterIndex, (String)x);
            return;
        }
        if (x instanceof Boolean) {
            this.setBoolean(parameterIndex, (Boolean)x);
            return;
        }
        if (x instanceof Byte) {
            this.setByte(parameterIndex, (Byte)x);
            return;
        }
        if (x instanceof Short) {
            this.setShort(parameterIndex, (Short)x);
            return;
        }
        if (x instanceof Integer) {
            this.setInt(parameterIndex, (Integer)x);
            return;
        }
        if (x instanceof Long) {
            this.setLong(parameterIndex, (Long)x);
            return;
        }
        if (x instanceof Float) {
            this.setFloat(parameterIndex, ((Float)x).floatValue());
            return;
        }
        if (x instanceof Double) {
            this.setDouble(parameterIndex, (Double)x);
            return;
        }
        if (x instanceof byte[]) {
            this.setBytes(parameterIndex, (byte[])x);
            return;
        }
        if (x instanceof Date) {
            this.setDate(parameterIndex, (Date)x);
            return;
        }
        if (x instanceof Time) {
            this.setTime(parameterIndex, (Time)x);
            return;
        }
        if (x instanceof Timestamp) {
            this.setTimestamp(parameterIndex, (Timestamp)x);
            return;
        }
        if (x instanceof Blob) {
            this.setBlob(parameterIndex, (Blob)x);
            return;
        }
        if (x instanceof Clob) {
            this.setClob(parameterIndex, (Clob)x);
            return;
        }
        if (x instanceof java.util.Date) {
            this.setTimestamp(parameterIndex, new Timestamp(((java.util.Date)x).getTime()));
            return;
        }
        if (x instanceof Calendar) {
            this.setTimestamp(parameterIndex, new Timestamp(((Calendar)x).getTime().getTime()));
            return;
        }
        if (x instanceof BigDecimal) {
            this.setBigDecimal(parameterIndex, (BigDecimal)x);
            return;
        }
        if (x instanceof BigInteger) {
            this.setBigDecimal(parameterIndex, new BigDecimal((BigInteger)x));
            return;
        }
        throw this.dataTypeConversion(parameterIndex, x.getClass().getName());
    }

    @Override
    public final boolean execute() throws SQLException {
        boolean ret = false;
        try {
            ret = this.executeStatement(this.activation, false, false);
        }
        catch (SQLException sqle) {
            this.checkStatementValidity(sqle);
        }
        return ret;
    }

    @Override
    public final void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (Throwable t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.checkStatus();
        try {
            this.getParms().getParameterForSet(parameterIndex - 1).setValue(x, cal);
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public void setBlob(int i, Blob x) throws SQLException {
        this.checkBlobConditions(i);
        if (x == null) {
            this.setNull(i, 2004);
        } else {
            long streamLength = x.length();
            this.setBinaryStreamInternal(i, x.getBinaryStream(), false, streamLength);
        }
    }

    private final void checkClobConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(parameterIndex) != 2005) {
            throw this.dataTypeConversion(parameterIndex, "java.sql.Clob");
        }
    }

    @Override
    public void setClob(int i, Clob x) throws SQLException {
        this.checkClobConditions(i);
        if (x == null) {
            this.setNull(i, 2005);
        } else {
            long streamLength = x.length();
            this.setCharacterStreamInternal(i, x.getCharacterStream(), false, streamLength);
        }
    }

    public final ParameterValueSet getParms() {
        return this.activation.getParameterValueSet();
    }

    protected int getParameterJDBCType(int parameterIndex) throws SQLException {
        try {
            DataTypeDescriptor dtd = this.preparedStatement.getParameterType(parameterIndex - 1);
            return dtd == null ? 1111 : dtd.getTypeId().getJDBCTypeId();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    protected final String getParameterSQLType(int parameterIndex) throws SQLException {
        try {
            DataTypeDescriptor dtd = this.preparedStatement.getParameterType(parameterIndex - 1);
            return dtd == null ? null : dtd.getTypeName();
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    private void setScale(int parameterIndex, int scale) throws SQLException {
        this.checkStatus();
        if (scale < 0) {
            throw EmbedPreparedStatement.newSQLException("XJ044.S", scale);
        }
        try {
            ParameterValueSet pvs = this.getParms();
            DataValueDescriptor value = pvs.getParameter(parameterIndex - 1);
            int origvaluelen = value.getLength();
            ((VariableSizeDataValue)((Object)value)).setWidth(-1, scale, false);
            if (value.getLength() < origvaluelen) {
                this.activation.addWarning(StandardException.newWarning("01505", value.getString()));
            }
        }
        catch (StandardException t) {
            throw EmbedResultSet.noStateChangeException(t);
        }
    }

    @Override
    public final void setURL(int parameterIndex, URL x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final ParameterMetaData getParameterMetaData() throws SQLException {
        this.checkStatus();
        return new EmbedParameterSetMetaData(this.getParms(), this.preparedStatement.getParameterTypes());
    }

    protected EmbedResultSetMetaData newEmbedResultSetMetaData(ResultDescription resultDesc) {
        return this.factory.newEmbedResultSetMetaData(resultDesc.getColumnInfo());
    }

    public String toString() {
        if (this.activation != null) {
            return this.activation.getPreparedStatement().getObjectName();
        }
        return super.toString();
    }

    public void transferParameters(EmbedPreparedStatement newStatement) throws SQLException {
        try {
            newStatement.activation.setParameters(this.getParms(), this.preparedStatement.getParameterTypes());
        }
        catch (StandardException se) {
            throw EmbedResultSet.noStateChangeException(se);
        }
    }

    @Override
    boolean executeStatement(Activation a, boolean executeQuery, boolean executeUpdate) throws SQLException {
        this.checkExecStatus();
        this.checkIfInMiddleOfBatch();
        this.clearResultSets();
        return super.executeStatement(a, executeQuery, executeUpdate);
    }

    final SQLException dataTypeConversion(int column, String sourceType) throws SQLException {
        return EmbedPreparedStatement.newSQLException("22005", this.getParameterMetaData().getParameterTypeName(column), sourceType);
    }

    public void setBrokeredConnectionControl(BrokeredConnectionControl control) {
        this.bcc = control;
    }

    private void checkStatementValidity(SQLException sqle) throws SQLException {
        if (this.bcc != null && this.isClosed()) {
            this.bcc.onStatementErrorOccurred((PreparedStatement)((Object)this.applicationStatement), sqle);
        }
        throw sqle;
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.checkAsciiStreamConditions(parameterIndex);
        InputStreamReader asciiStream = null;
        if (x != null) {
            try {
                asciiStream = new InputStreamReader(x, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException uee) {
                throw new SQLException(uee.getMessage());
            }
        }
        this.setCharacterStreamInternal(parameterIndex, asciiStream, true, -1L);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.checkCharacterStreamConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, true, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.checkClobConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, true, -1L);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.checkClobConditions(parameterIndex);
        this.setCharacterStreamInternal(parameterIndex, reader, false, length);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.checkBlobConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, inputStream, true, -1L);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.checkBlobConditions(parameterIndex);
        this.setBinaryStreamInternal(parameterIndex, inputStream, false, length);
    }

    private final void checkBlobConditions(int parameterIndex) throws SQLException {
        this.checkStatus();
        if (this.getParameterJDBCType(parameterIndex) != 2004) {
            throw this.dataTypeConversion(parameterIndex, "java.sql.Blob");
        }
    }

    @Override
    public final void setRowId(int parameterIndex, RowId x) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNString(int index, String value) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNCharacterStream(int index, Reader value, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(int parameterIndex, Reader reader) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(int index, NClob value) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        throw Util.notImplemented();
    }

    @Override
    public final long getVersionCounter() throws SQLException {
        return this.preparedStatement.getVersionCounter();
    }
}

