/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecRowBuilder;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromSubquery;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

class ResultColumnList
extends QueryTreeNodeVector<ResultColumn> {
    protected boolean indexRow;
    protected long conglomerateId;
    int orderBySelect = 0;
    protected boolean forUpdate;
    private boolean countMismatchAllowed;
    private int initialListSize = 0;

    ResultColumnList(ContextManager cm) {
        super(ResultColumn.class, cm);
    }

    void addResultColumn(ResultColumn resultColumn) {
        resultColumn.setVirtualColumnId(this.size() + 1);
        this.addElement(resultColumn);
    }

    void appendResultColumns(ResultColumnList resultColumns, boolean destructiveCopy) {
        int oldSize = this.size();
        int newID = oldSize + 1;
        for (ResultColumn rc : resultColumns) {
            rc.setVirtualColumnId(newID);
            ++newID;
        }
        if (destructiveCopy) {
            this.destructiveAppend(resultColumns);
        } else {
            this.nondestructiveAppend(resultColumns);
        }
    }

    ResultColumn getResultColumn(int position) {
        ResultColumn rc;
        if (position <= this.size() && (rc = (ResultColumn)this.elementAt(position - 1)).getColumnPosition() == position) {
            return rc;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc2 = (ResultColumn)this.elementAt(index);
            if (rc2.getColumnPosition() != position) continue;
            return rc2;
        }
        return null;
    }

    ResultColumn getResultColumn(int colNum, ResultSetNode rsn, int[] whichRC) throws StandardException {
        if (colNum == -1) {
            return null;
        }
        int[] crColNum = new int[]{-1};
        for (int index = this.size() - 1; index >= 0; --index) {
            ColumnReference colRef;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference) || rsn != (colRef = (ColumnReference)rc.getExpression()).getSourceResultSet(crColNum) || crColNum[0] != colNum) continue;
            whichRC[0] = index + 1;
            return rc;
        }
        return null;
    }

    ResultColumn getOrderByColumn(int position) {
        if (position == 0) {
            return null;
        }
        return this.getResultColumn(position);
    }

    ResultColumn getResultColumn(String columnName) {
        return this.getResultColumn(columnName, true);
    }

    ResultColumn getResultColumn(String columnName, boolean markIfReferenced) {
        for (ResultColumn resultColumn : this) {
            if (!columnName.equals(resultColumn.getName())) continue;
            if (markIfReferenced) {
                resultColumn.setReferenced();
            }
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getResultColumn(int tableNumber, int columnNumber, String columnName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn;
            ResultColumn rc = resultColumn = (ResultColumn)this.elementAt(index);
            while (rc != null) {
                ValueNode exp = rc.getExpression();
                if (exp instanceof VirtualColumnNode) {
                    VirtualColumnNode vcn = (VirtualColumnNode)exp;
                    ResultSetNode rsn = vcn.getSourceResultSet();
                    if (rsn instanceof FromTable) {
                        FromTable ft = (FromTable)rsn;
                        if (ft.getTableNumber() == tableNumber) {
                            ColumnDescriptor cd = rc.getTableColumnDescriptor();
                            SanityManager.ASSERT(cd != null || ft instanceof FromSubquery);
                            if (cd != null && cd.getPosition() == columnNumber || vcn.getSourceColumn().getColumnPosition() == columnNumber) {
                                if (columnName.equals(vcn.getSourceColumn().getName())) {
                                    resultColumn.setReferenced();
                                    return resultColumn;
                                }
                                SanityManager.ASSERT(false, "wrong (tn,cn) for column " + columnName + " found: this pair points to " + vcn.getSourceColumn().getName());
                                return null;
                            }
                            rc = vcn.getSourceColumn();
                            continue;
                        }
                        rc = vcn.getSourceColumn();
                        continue;
                    }
                    rc = null;
                    continue;
                }
                if (exp instanceof ColumnReference) {
                    ColumnReference cr = (ColumnReference)exp;
                    if (cr.getTableNumber() == tableNumber && cr.getColumnNumber() == columnNumber) {
                        resultColumn.setReferenced();
                        return resultColumn;
                    }
                    rc = null;
                    continue;
                }
                SanityManager.ASSERT(exp instanceof BaseColumnNode, "expected BaseColumnNode, found: " + exp.getClass());
                rc = null;
            }
        }
        return null;
    }

    ResultColumn getResultColumn(String columnsTableName, String columnName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (columnsTableName != null && (resultColumn.getTableName() == null || !columnsTableName.equals(resultColumn.getTableName())) || !columnName.equals(resultColumn.getName())) continue;
            resultColumn.setReferenced();
            return resultColumn;
        }
        return null;
    }

    ResultColumn getAtMostOneResultColumn(ColumnReference cr, String exposedTableName, boolean considerGeneratedColumns) throws StandardException {
        ResultColumn retRC = null;
        String columnName = cr.getColumnName();
        for (ResultColumn resultColumn : this) {
            if (!columnName.equals(resultColumn.getName()) || resultColumn.isGenerated() && !considerGeneratedColumns) continue;
            if (retRC != null) {
                throw StandardException.newException("42Y34", columnName, exposedTableName);
            }
            resultColumn.setReferenced();
            retRC = resultColumn;
        }
        return retRC;
    }

    boolean columnsAreUpdatable() {
        for (ResultColumn rc : this) {
            if (!rc.isUpdatable()) continue;
            return true;
        }
        return false;
    }

    ResultColumn getOrderByColumnToBind(String columnName, TableName tableName, int tableNumber, OrderByColumn obc) throws StandardException {
        int size = this.size();
        ResultColumn retVal = null;
        for (int index = 0; index < size; ++index) {
            boolean columnNameMatches;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (tableName != null) {
                ColumnReference cr;
                ValueNode rcExpr = resultColumn.getExpression();
                if (!(rcExpr instanceof ColumnReference) || !tableName.equals((cr = (ColumnReference)rcExpr).getQualifiedTableName()) && tableNumber != cr.getTableNumber()) continue;
                columnNameMatches = columnName.equals(resultColumn.getSourceColumnName());
            } else {
                columnNameMatches = resultColumn.columnNameMatches(columnName);
            }
            if (!columnNameMatches) continue;
            if (retVal == null) {
                retVal = resultColumn;
                continue;
            }
            if (!retVal.isEquivalent(resultColumn)) {
                throw StandardException.newException("42X79", columnName);
            }
            if (index < size - this.orderBySelect) continue;
            this.removeElement(resultColumn);
            this.decOrderBySelect();
            obc.clearAddedColumnOffset();
            this.collapseVirtualColumnIdGap(resultColumn.getColumnPosition());
            break;
        }
        return retVal;
    }

    private void collapseVirtualColumnIdGap(int gap) {
        for (ResultColumn rc : this) {
            rc.collapseVirtualColumnIdGap(gap);
        }
    }

    ResultColumn findResultColumnForOrderBy(String columnName, TableName tableName) throws StandardException {
        int size = this.size();
        ResultColumn retVal = null;
        for (int index = 0; index < size; ++index) {
            boolean columnNameMatches;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (tableName != null) {
                ColumnReference cr;
                ValueNode rcExpr = resultColumn.getExpression();
                if (rcExpr == null || !(rcExpr instanceof ColumnReference) || !tableName.equals((cr = (ColumnReference)rcExpr).getQualifiedTableName())) continue;
                columnNameMatches = columnName.equals(resultColumn.getSourceColumnName());
            } else {
                columnNameMatches = resultColumn.columnNameMatches(columnName);
            }
            if (!columnNameMatches) continue;
            if (retVal == null) {
                retVal = resultColumn;
                continue;
            }
            if (!retVal.isEquivalent(resultColumn)) {
                throw StandardException.newException("42X79", columnName);
            }
            if (index < size - this.orderBySelect) continue;
            SanityManager.THROWASSERT("Unexpectedly found ORDER BY column '" + columnName + "' pulled up at position " + index);
        }
        return retVal;
    }

    void copyResultColumnNames(ResultColumnList nameList) {
        if (!this.countMismatchAllowed && this.visibleSize() != nameList.visibleSize()) {
            SanityManager.THROWASSERT("The size of the 2 lists is expected to be the same. visibleSize() = " + this.visibleSize() + ", nameList.visibleSize() = " + nameList.visibleSize());
        }
        int size = this.countMismatchAllowed ? nameList.visibleSize() : this.visibleSize();
        for (int index = 0; index < size; ++index) {
            ResultColumn thisResultColumn = (ResultColumn)this.elementAt(index);
            ResultColumn nameListResultColumn = (ResultColumn)nameList.elementAt(index);
            thisResultColumn.setName(nameListResultColumn.getName());
            thisResultColumn.setNameGenerated(nameListResultColumn.isNameGenerated());
        }
    }

    void bindExpressions(FromList fromList, SubqueryList subqueryList, List<AggregateNode> aggregates) throws StandardException {
        this.expandAllsAndNameColumns(fromList);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vn = (ResultColumn)this.elementAt(index);
            vn = vn.bindExpression(fromList, subqueryList, (List)aggregates);
            this.setElementAt(vn, index);
        }
    }

    void bindResultColumnsToExpressions() throws StandardException {
        for (ResultColumn rc : this) {
            rc.bindResultColumnToExpression();
        }
    }

    void bindResultColumnsByName(TableDescriptor targetTableDescriptor) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).bindResultColumnByName(targetTableDescriptor, index + 1);
        }
    }

    FormatableBitSet bindResultColumnsByName(TableDescriptor targetTableDescriptor, DMLStatementNode statement) throws StandardException {
        int size = this.size();
        FormatableBitSet columnBitSet = new FormatableBitSet(targetTableDescriptor.getNumberOfColumns());
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.bindResultColumnByName(targetTableDescriptor, index + 1);
            int colIdx = rc.getColumnPosition() - 1;
            SanityManager.ASSERT(colIdx >= 0 && colIdx < targetTableDescriptor.getNumberOfColumns(), "Invalid column position found for " + rc.getName());
            if (statement != null && columnBitSet.isSet(colIdx)) {
                String colName = rc.getName();
                if (statement instanceof UpdateNode) {
                    throw StandardException.newException("42X16", colName);
                }
                throw StandardException.newException("42X13", colName);
            }
            columnBitSet.set(colIdx);
        }
        return columnBitSet;
    }

    void bindResultColumnsByName(ResultColumnList fullRCL, FromVTI targetVTI, DMLStatementNode statement) throws StandardException {
        int size = this.size();
        HashSet<String> seenNames = new HashSet<String>(size + 2, 0.999f);
        for (int index = 0; index < size; ++index) {
            boolean alreadySeen;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            String colName = rc.getName();
            boolean bl = alreadySeen = !seenNames.add(colName);
            if (alreadySeen) {
                SanityManager.ASSERT(statement instanceof UpdateNode || statement instanceof InsertNode, "statement is expected to be instanceof UpdateNode or InsertNode");
                if (statement instanceof UpdateNode) {
                    throw StandardException.newException("42X16", colName);
                }
                throw StandardException.newException("42X13", colName);
            }
            ResultColumn matchRC = fullRCL.getResultColumn(null, rc.getName());
            if (matchRC == null) {
                throw StandardException.newException("42X14", rc.getName(), targetVTI.getMethodCall().getJavaClassName());
            }
            ColumnDescriptor cd = new ColumnDescriptor(rc.getName(), matchRC.getVirtualColumnId(), matchRC.getType(), null, null, null, null, 0L, 0L, false);
            rc.setColumnDescriptor(null, cd);
            rc.setVirtualColumnId(index + 1);
        }
    }

    void bindResultColumnsByPosition(TableDescriptor targetTableDescriptor) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).bindResultColumnByPosition(targetTableDescriptor, index + 1);
        }
    }

    void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            this.setElementAt(resultColumn.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList), index);
        }
    }

    void checkStorableExpressions(ResultColumnList toStore) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn otherRC = (ResultColumn)toStore.elementAt(index);
            ((ResultColumn)this.elementAt(index)).checkStorableExpression(otherRC);
        }
    }

    int[] getStreamStorableColIds(int heapColCount) throws StandardException {
        int ssCount = 0;
        boolean[] isSS = new boolean[heapColCount];
        for (ResultColumn rc : this) {
            if (!rc.getTypeId().streamStorable()) continue;
            ColumnDescriptor cd = rc.getTableColumnDescriptor();
            isSS[cd.getPosition() - 1] = true;
        }
        for (int ix = 0; ix < isSS.length; ++ix) {
            if (!isSS[ix]) continue;
            ++ssCount;
        }
        if (ssCount == 0) {
            return null;
        }
        int[] result = new int[ssCount];
        int resultOffset = 0;
        for (int heapOffset = 0; heapOffset < isSS.length; ++heapOffset) {
            if (!isSS[heapOffset]) continue;
            result[resultOffset++] = heapOffset;
        }
        return result;
    }

    void checkStorableExpressions() throws StandardException {
        for (ResultColumn rc : this) {
            rc.checkStorableExpression();
        }
    }

    @Override
    void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCore(acb, mb, false);
    }

    void generateNulls(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCore(acb, mb, true);
    }

    void generateCore(ExpressionClassBuilder acb, MethodBuilder mb, boolean genNulls) throws StandardException {
        MethodBuilder userExprFun = acb.newUserExprFun();
        this.generateEvaluatedRow(acb, userExprFun, genNulls, false);
        acb.pushMethodReference(mb, userExprFun);
    }

    void generateEvaluatedRow(ExpressionClassBuilder acb, MethodBuilder userExprFun, boolean genNulls, boolean forMatchingClause) throws StandardException {
        LocalField field = acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(acb, field, "getValueRow", "org.apache.derby.iapi.sql.execute.ExecRow", this.size());
        int size = this.size();
        MethodBuilder cb = acb.getConstructor();
        for (int index = 0; index < size; ++index) {
            ValueNode expr;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!genNulls) {
                ValueNode sourceExpr = rc.getExpression();
                if (sourceExpr instanceof VirtualColumnNode && !((VirtualColumnNode)sourceExpr).getCorrelated()) continue;
                if (rc.getJoinResultSet() != null) {
                    ResultColumnList jnRCL = rc.getJoinResultSet().getResultColumns();
                    int joinResultSetNumber = rc.getJoinResultSet().getResultSetNumber();
                    int virtualColumnIdRightTable = -1;
                    int virtualColumnIdLeftTable = -1;
                    for (ResultColumn joinColumn : jnRCL) {
                        if (!joinColumn.getName().equals(rc.getUnderlyingOrAliasName())) continue;
                        if (joinColumn.isRightOuterJoinUsingClause()) {
                            virtualColumnIdRightTable = joinColumn.getVirtualColumnId();
                            continue;
                        }
                        virtualColumnIdLeftTable = joinColumn.getVirtualColumnId();
                    }
                    userExprFun.getField(field);
                    userExprFun.push(index + 1);
                    String resultTypeName = this.getTypeCompiler(DataTypeDescriptor.getBuiltInDataTypeDescriptor(16).getTypeId()).interfaceName();
                    String receiverType = "org.apache.derby.iapi.types.DataValueDescriptor";
                    acb.pushColumnReference(userExprFun, joinResultSetNumber, virtualColumnIdLeftTable);
                    userExprFun.cast(rc.getTypeCompiler().interfaceName());
                    userExprFun.cast(receiverType);
                    userExprFun.callMethod((short)185, null, "isNullOp", resultTypeName, 0);
                    userExprFun.cast("org.apache.derby.iapi.types.BooleanDataValue");
                    userExprFun.push(true);
                    userExprFun.callMethod((short)185, null, "equals", "boolean", 1);
                    userExprFun.conditionalIf();
                    acb.pushColumnReference(userExprFun, joinResultSetNumber, virtualColumnIdRightTable);
                    userExprFun.cast(rc.getTypeCompiler().interfaceName());
                    userExprFun.startElseCode();
                    acb.pushColumnReference(userExprFun, joinResultSetNumber, virtualColumnIdLeftTable);
                    userExprFun.cast(rc.getTypeCompiler().interfaceName());
                    userExprFun.completeConditional();
                    userExprFun.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                    userExprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                    continue;
                }
                if (!forMatchingClause && sourceExpr instanceof ColumnReference && !((ColumnReference)sourceExpr).getCorrelated()) continue;
            }
            if (index + 1 != rc.getVirtualColumnId()) {
                SanityManager.THROWASSERT("VirtualColumnId (" + rc.getVirtualColumnId() + ") does not agree with position within Vector (" + (index + 1) + ")");
            }
            if (rc.hasGenerationClause() && (expr = rc.getExpression()) != null && !(expr instanceof VirtualColumnNode)) continue;
            if (!genNulls && rc.getExpression() instanceof ConstantNode && !((ConstantNode)rc.getExpression()).isNull() && !cb.statementNumHitLimit(1)) {
                cb.getField(field);
                cb.push(index + 1);
                rc.generateExpression(acb, cb);
                cb.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                cb.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            userExprFun.getField(field);
            userExprFun.push(index + 1);
            boolean needDVDCast = true;
            if (rc.isAutoincrementGenerated()) {
                userExprFun.pushThis();
                userExprFun.push(rc.getColumnPosition());
                userExprFun.push(rc.getTableColumnDescriptor().getAutoincInc());
                userExprFun.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getSetAutoincrementValue", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
                needDVDCast = false;
            } else if (genNulls || rc.getExpression() instanceof ConstantNode && ((ConstantNode)rc.getExpression()).isNull()) {
                userExprFun.getField(field);
                userExprFun.push(index + 1);
                userExprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                acb.generateNullWithExpress(userExprFun, rc.getTypeCompiler(), rc.getTypeServices().getCollationType());
            } else {
                rc.generateExpression(acb, userExprFun);
            }
            if (needDVDCast) {
                userExprFun.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            userExprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        }
        userExprFun.getField(field);
        userExprFun.methodReturn();
        userExprFun.complete();
    }

    public ExecRow buildEmptyRow() throws StandardException {
        int columnCount = this.size();
        ExecRow row = this.getExecutionFactory().getValueRow(columnCount);
        int position = 1;
        for (ResultColumn rc : this) {
            DataTypeDescriptor dataType = rc.getTypeServices();
            DataValueDescriptor dataValue = dataType.getNull();
            row.setColumn(position++, dataValue);
        }
        return row;
    }

    public ExecRow buildEmptyIndexRow(TableDescriptor td, ConglomerateDescriptor cd, StoreCostController scc, DataDictionary dd) throws StandardException {
        if (!cd.isIndex()) {
            SanityManager.THROWASSERT("ConglomerateDescriptor expected to be for index: " + cd);
        }
        int[] baseCols = cd.getIndexDescriptor().baseColumnPositions();
        ExecRow row = this.getExecutionFactory().getValueRow(baseCols.length + 1);
        for (int i = 0; i < baseCols.length; ++i) {
            ColumnDescriptor coldes = td.getColumnDescriptor(baseCols[i]);
            DataTypeDescriptor dataType = coldes.getType();
            DataValueDescriptor dataValue = dataType.getNull();
            row.setColumn(i + 1, dataValue);
        }
        RowLocation rlTemplate = scc.newRowLocationTemplate();
        row.setColumn(baseCols.length + 1, rlTemplate);
        return row;
    }

    ExecRowBuilder buildRowTemplate(FormatableBitSet referencedCols, boolean skipPropagatedCols) throws StandardException {
        int columns = referencedCols == null ? this.size() : referencedCols.getNumBitsSet();
        ExecRowBuilder builder = new ExecRowBuilder(columns, this.indexRow);
        int colNum = referencedCols == null ? 0 : referencedCols.anySetBit();
        for (ResultColumn rc : this) {
            ValueNode sourceExpr = rc.getExpression();
            if (sourceExpr instanceof CurrentRowLocationNode) {
                builder.setColumn(colNum + 1, this.newRowLocationTemplate());
            } else {
                if (skipPropagatedCols && sourceExpr instanceof VirtualColumnNode) continue;
                builder.setColumn(colNum + 1, rc.getType());
            }
            if (referencedCols == null) {
                ++colNum;
                continue;
            }
            colNum = referencedCols.anySetBit(colNum);
        }
        return builder;
    }

    ExecRowBuilder buildRowTemplate() throws StandardException {
        return this.buildRowTemplate(null, false);
    }

    private void genCreateRow(ExpressionClassBuilder acb, LocalField field, String rowAllocatorMethod, String rowAllocatorType, int numCols) throws StandardException {
        MethodBuilder cb = acb.getConstructor();
        acb.pushGetExecutionFactoryExpression(cb);
        cb.push(numCols);
        cb.callMethod((short)185, null, rowAllocatorMethod, rowAllocatorType, 1);
        cb.setField(field);
        cb.statementNumHitLimit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocation newRowLocationTemplate() throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        int isolationLevel = dd.getCacheMode() == 1 ? 2 : 0;
        try (ConglomerateController cc = lcc.getTransactionCompile().openConglomerate(this.conglomerateId, false, 0, 6, isolationLevel);){
            RowLocation rowLocation = cc.newRowLocationTemplate();
            return rowLocation;
        }
    }

    ResultColumnDescriptor[] makeResultDescriptors() {
        ResultColumnDescriptor[] colDescs = new ResultColumnDescriptor[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            colDescs[index] = this.getExecutionFactory().getResultColumnDescriptor((ResultColumnDescriptor)this.elementAt(index));
        }
        return colDescs;
    }

    void expandAllsAndNameColumns(FromList fromList) throws StandardException {
        boolean expanded = false;
        for (int index = 0; index < this.size(); ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc instanceof AllResultColumn) {
                TableName fullTableName;
                expanded = true;
                TableName temp = rc.getTableNameObject();
                if (temp != null) {
                    String sName = temp.getSchemaName();
                    String tName = temp.getTableName();
                    fullTableName = this.makeTableName(sName, tName);
                } else {
                    fullTableName = null;
                }
                ResultColumnList allExpansion = fromList.expandAll(fullTableName);
                allExpansion.nameAllResultColumns();
                this.removeElementAt(index);
                for (int inner = 0; inner < allExpansion.size(); ++inner) {
                    this.insertElementAt((ResultColumn)allExpansion.elementAt(inner), index + inner);
                }
                index += allExpansion.size() - 1;
                this.markInitialSize();
                continue;
            }
            rc.guaranteeColumnName();
        }
        if (expanded) {
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                ((ResultColumn)this.elementAt(index)).setVirtualColumnId(index + 1);
            }
        }
    }

    void nameAllResultColumns() throws StandardException {
        for (ResultColumn rc : this) {
            rc.guaranteeColumnName();
        }
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        for (ResultColumn resultColumn : this) {
            if (resultColumn.isGenerated() || resultColumn.columnTypeAndLengthMatch()) continue;
            return false;
        }
        return true;
    }

    boolean columnTypesAndLengthsMatch(ResultColumnList otherRCL) throws StandardException {
        boolean retval = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            ResultColumn otherResultColumn = (ResultColumn)otherRCL.elementAt(index);
            if (resultColumn.isGenerated() || otherResultColumn.isGenerated() || resultColumn.columnTypeAndLengthMatch(otherResultColumn)) continue;
            retval = false;
        }
        return retval;
    }

    boolean nopProjection(ResultColumnList childRCL) {
        if (this.size() != childRCL.size()) {
            return false;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn referencedColumn;
            ResultColumn thisColumn = (ResultColumn)this.elementAt(index);
            if (thisColumn.getExpression() instanceof VirtualColumnNode) {
                referencedColumn = ((VirtualColumnNode)thisColumn.getExpression()).getSourceColumn();
            } else if (thisColumn.getExpression() instanceof ColumnReference) {
                referencedColumn = ((ColumnReference)thisColumn.getExpression()).getSource();
            } else {
                return false;
            }
            ResultColumn childColumn = (ResultColumn)childRCL.elementAt(index);
            if (referencedColumn == childColumn) continue;
            return false;
        }
        return true;
    }

    ResultColumnList copyListAndObjects() throws StandardException {
        ResultColumnList newList = new ResultColumnList(this.getContextManager());
        for (ResultColumn origResultColumn : this) {
            newList.addResultColumn(origResultColumn.cloneMe());
        }
        newList.copyOrderBySelect(this);
        return newList;
    }

    void removeOrderByColumns() {
        int idx = this.size() - 1;
        int i = 0;
        while (i < this.orderBySelect) {
            this.removeElementAt(idx);
            ++i;
            --idx;
        }
        this.orderBySelect = 0;
    }

    void genVirtualColumnNodes(ResultSetNode sourceResultSet, ResultColumnList sourceResultColumnList) throws StandardException {
        this.genVirtualColumnNodes(sourceResultSet, sourceResultColumnList, true);
    }

    void genVirtualColumnNodes(ResultSetNode sourceResultSet, ResultColumnList sourceResultColumnList, boolean markReferenced) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            resultColumn.setExpression(new VirtualColumnNode(sourceResultSet, (ResultColumn)sourceResultColumnList.elementAt(index), index + 1, this.getContextManager()));
            if (!markReferenced) continue;
            resultColumn.setReferenced();
        }
    }

    void adjustVirtualColumnIds(int adjust) {
        for (ResultColumn resultColumn : this) {
            resultColumn.adjustVirtualColumnId(adjust);
            if (!(resultColumn.getExpression() instanceof VirtualColumnNode)) {
                SanityManager.THROWASSERT("resultColumn.getExpression() is expected to be instanceof VirtualColumnNode not " + resultColumn.getExpression().getClass().getName());
            }
            ((VirtualColumnNode)resultColumn.getExpression()).columnId += adjust;
        }
    }

    void doProjection() throws StandardException {
        int numDeleted = 0;
        ResultColumnList deletedRCL = new ResultColumnList(this.getContextManager());
        for (ResultColumn resultColumn : this) {
            if (!resultColumn.isReferenced() && resultColumn.getExpression() instanceof VirtualColumnNode && !((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn().isReferenced()) {
                deletedRCL.addElement(resultColumn);
                ++numDeleted;
                continue;
            }
            if (numDeleted >= 1) {
                resultColumn.adjustVirtualColumnId(-numDeleted);
            }
            resultColumn.setReferenced();
        }
        for (int index = 0; index < deletedRCL.size(); ++index) {
            this.removeElement((ResultColumn)deletedRCL.elementAt(index));
        }
    }

    String verifyUniqueNames(boolean errForGenCols) throws StandardException {
        HashSet<String> seenNames = new HashSet<String>(this.size() + 2, 0.999f);
        for (ResultColumn rc : this) {
            if (errForGenCols && rc.isNameGenerated()) {
                throw StandardException.newException("42908", new Object[0]);
            }
            String colName = rc.getName();
            boolean alreadySeen = !seenNames.add(colName);
            if (!alreadySeen) continue;
            return colName;
        }
        return null;
    }

    void propagateDCLInfo(ResultColumnList derivedRCL, String tableName) throws StandardException {
        if (derivedRCL.size() != this.size() && !derivedRCL.getCountMismatchAllowed() && this.visibleSize() != derivedRCL.visibleSize()) {
            throw StandardException.newException("42X32", tableName);
        }
        String duplicateColName = derivedRCL.verifyUniqueNames(false);
        if (duplicateColName != null) {
            throw StandardException.newException("42X33", duplicateColName);
        }
        this.copyResultColumnNames(derivedRCL);
    }

    void rejectParameters() throws StandardException {
        for (ResultColumn rc : this) {
            rc.rejectParameter();
        }
    }

    void rejectXMLValues() throws StandardException {
        int sz = this.size();
        for (int i = 1; i <= sz; ++i) {
            ResultColumn rc;
            if (i > this.initialListSize || (rc = this.getResultColumn(i)) == null || rc.getType() == null || !rc.getType().getTypeId().isXMLTypeId()) continue;
            throw StandardException.newException("42Z71", new Object[0]);
        }
    }

    void setResultSetNumber(int resultSetNumber) {
        for (ResultColumn rc : this) {
            rc.setResultSetNumber(resultSetNumber);
        }
    }

    void setRedundant() {
        for (ResultColumn rc : this) {
            rc.setRedundant();
        }
    }

    void checkColumnUpdateability(ExecPreparedStatement cursorStmt, String cursorName) throws StandardException {
        for (ResultColumn resultColumn : this) {
            if (!resultColumn.updated() || cursorStmt.isUpdateColumn(resultColumn.getName())) continue;
            throw StandardException.newException("42X31", resultColumn.getName(), cursorName);
        }
    }

    void setUnionResultExpression(ResultColumnList otherRCL, int tableNumber, int level, String operatorName) throws StandardException {
        if (this.visibleSize() != otherRCL.visibleSize()) {
            SanityManager.THROWASSERT("visibleSize() = (" + this.visibleSize() + ") is expected to equal otherRCL.visibleSize (" + otherRCL.visibleSize() + ")");
        }
        SanityManager.ASSERT(this.size() == this.visibleSize(), "size() and visibleSize() should be equal");
        TableName dummyTN = new TableName(null, null, this.getContextManager());
        int size = this.visibleSize();
        for (int index = 0; index < size; ++index) {
            TypeId otherTypeId;
            TypeId thisTypeId;
            ResultColumn thisRC = (ResultColumn)this.elementAt(index);
            ResultColumn otherRC = (ResultColumn)otherRCL.elementAt(index);
            ValueNode thisExpr = thisRC.getExpression();
            ValueNode otherExpr = otherRC.getExpression();
            if (!otherRC.isAutoincrementGenerated() && thisRC.isAutoincrementGenerated()) {
                thisRC.resetAutoincrementGenerated();
            }
            if ((thisTypeId = thisExpr.getTypeId()) == null || (otherTypeId = otherExpr.getTypeId()) == null) continue;
            ClassFactory cf = this.getClassFactory();
            if (!this.unionCompatible(thisExpr, otherExpr)) {
                throw StandardException.newException("42X61", thisTypeId.getSQLTypeName(), otherTypeId.getSQLTypeName(), operatorName);
            }
            DataTypeDescriptor resultType = thisExpr.getTypeServices().getDominantType(otherExpr.getTypeServices(), cf);
            ColumnReference newCR = new ColumnReference(thisRC.getName(), dummyTN, this.getContextManager());
            newCR.setType(resultType);
            if (thisExpr instanceof ColumnReference) {
                newCR.copyFields((ColumnReference)thisExpr);
            } else {
                newCR.setNestingLevel(level);
                newCR.setSourceLevel(level);
            }
            newCR.setTableNumber(tableNumber);
            thisRC.setExpression(newCR);
            thisRC.setType(thisRC.getTypeServices().getDominantType(otherRC.getTypeServices(), cf));
            if (thisRC.getName() == null || thisRC.isNameGenerated() || otherRC.getName() == null) continue;
            if (otherRC.isNameGenerated()) {
                thisRC.setName(otherRC.getName());
                thisRC.setNameGenerated(true);
                continue;
            }
            if (thisRC.getName().equals(otherRC.getName())) continue;
            thisRC.setName(null);
            thisRC.guaranteeColumnName();
            thisRC.setNameGenerated(true);
        }
    }

    private boolean unionCompatible(ValueNode left, ValueNode right) throws StandardException {
        TypeId leftTypeId = left.getTypeId();
        TypeId rightTypeId = right.getTypeId();
        ClassFactory cf = this.getClassFactory();
        if (!left.getTypeCompiler().storable(rightTypeId, cf) && !right.getTypeCompiler().storable(leftTypeId, cf)) {
            return false;
        }
        return leftTypeId.isBooleanTypeId() == rightTypeId.isBooleanTypeId();
    }

    boolean isExactTypeAndLengthMatch(ResultColumnList otherRCL) throws StandardException {
        SanityManager.ASSERT(this.visibleSize() == otherRCL.visibleSize(), "visibleSize() should match");
        SanityManager.ASSERT(this.size() == this.visibleSize(), "size() and visibleSize() should match");
        int size = this.visibleSize();
        for (int index = 0; index < size; ++index) {
            ResultColumn thisRC = (ResultColumn)this.elementAt(index);
            ResultColumn otherRC = (ResultColumn)otherRCL.elementAt(index);
            if (thisRC.getTypeServices().isExactTypeAndLengthMatch(otherRC.getTypeServices())) continue;
            return false;
        }
        return true;
    }

    public boolean updateOverlaps(int[] columns) {
        for (ResultColumn rc : this) {
            if (!rc.updated()) continue;
            int column = rc.getColumnPosition();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] != column) continue;
                return true;
            }
        }
        return false;
    }

    ResultColumn[] getSortedByPosition() {
        int size = this.size();
        Object[] result = new ResultColumn[size];
        for (int index = 0; index < size; ++index) {
            result[index] = (ResultColumn)this.elementAt(index);
        }
        Arrays.sort(result);
        return result;
    }

    public int[] sortMe() {
        ResultColumn[] sortedResultColumns = this.getSortedByPosition();
        int[] sortedColumnIds = new int[sortedResultColumns.length];
        for (int ix = 0; ix < sortedResultColumns.length; ++ix) {
            sortedColumnIds[ix] = sortedResultColumns[ix].getColumnPosition();
        }
        return sortedColumnIds;
    }

    ResultColumnList expandToAll(TableDescriptor td, TableName tableName) throws StandardException {
        ResultColumnList retval = new ResultColumnList(this.getContextManager());
        ResultColumn[] originalRCS = this.getSortedByPosition();
        int posn = 0;
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ResultColumn rc;
            ColumnDescriptor cd = cdl.elementAt(index);
            if (posn < originalRCS.length && cd.getPosition() == originalRCS[posn].getColumnPosition()) {
                rc = originalRCS[posn];
                ++posn;
            } else {
                rc = this.makeColumnReferenceFromName(tableName, cd.getColumnName());
                rc.bindResultColumnByPosition(td, cd.getPosition());
            }
            retval.addResultColumn(rc);
        }
        SanityManager.ASSERT(posn == originalRCS.length, "ResultColumns in original list not added to expanded ResultColumnList");
        return retval;
    }

    void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        if (bindingRCL == null) {
            throw StandardException.newException("42X07", new Object[0]);
        }
        SanityManager.ASSERT(bindingRCL.size() >= this.size(), "More columns in result column list than in base table");
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn bindingRC = (ResultColumn)bindingRCL.elementAt(index);
            ResultColumn thisRC = (ResultColumn)this.elementAt(index);
            thisRC.typeUntypedNullExpression(bindingRC);
        }
    }

    void markUpdated() {
        for (ResultColumn rc : this) {
            rc.markUpdated();
        }
    }

    void markUpdatableByCursor() {
        for (ResultColumn rc : this) {
            if (rc.getSourceTableName() == null || rc.getExpression() == null || !rc.getExpression().getColumnName().equals(rc.getName())) continue;
            rc.markUpdatableByCursor();
        }
    }

    String verifyCreateConstraintColumnList(TableElementList tel) {
        for (ResultColumn rc : this) {
            String colName = rc.getName();
            if (tel.containsColumnName(colName)) continue;
            return colName;
        }
        return null;
    }

    void exportNames(String[] columnNames) {
        if (this.size() != columnNames.length) {
            SanityManager.THROWASSERT("size() (" + this.size() + ") is expected to equal columnNames.length (" + columnNames.length + ")");
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            columnNames[index] = ((ResultColumn)this.elementAt(index)).getName();
        }
    }

    ResultColumn findParentResultColumn(ResultColumn childRC) {
        ResultColumn parentRC = null;
        for (ResultColumn rc : this) {
            VirtualColumnNode vcn;
            if (rc.getExpression() instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)rc.getExpression();
                if (cr.getSource() != childRC) continue;
                parentRC = rc;
                break;
            }
            if (!(rc.getExpression() instanceof VirtualColumnNode) || (vcn = (VirtualColumnNode)rc.getExpression()).getSourceColumn() != childRC) continue;
            parentRC = rc;
            break;
        }
        return parentRC;
    }

    void markUpdated(ResultColumnList updateColumns) {
        for (ResultColumn updateColumn : updateColumns) {
            ResultColumn resultColumn = this.getResultColumn(updateColumn.getName());
            if (resultColumn == null) continue;
            resultColumn.markUpdated();
        }
    }

    void markColumnsInSelectListUpdatableByCursor(List<String> updateColumns) {
        this.commonCodeForUpdatableByCursor(updateColumns, true);
    }

    private void commonCodeForUpdatableByCursor(List<String> updateColumns, boolean dealingWithSelectResultColumnList) {
        if (updateColumns == null || updateColumns.isEmpty()) {
            this.markUpdatableByCursor();
        } else {
            int ucSize = updateColumns.size();
            for (int index = 0; index < ucSize; ++index) {
                String columnName = updateColumns.get(index);
                ResultColumn resultColumn = this.getResultColumn(columnName);
                if (resultColumn == null && !dealingWithSelectResultColumnList) {
                    SanityManager.THROWASSERT("No result column found with name " + columnName);
                }
                if (resultColumn == null && dealingWithSelectResultColumnList) continue;
                resultColumn.markUpdatableByCursor();
            }
        }
    }

    void markUpdatableByCursor(List<String> updateColumns) {
        this.commonCodeForUpdatableByCursor(updateColumns, false);
    }

    boolean updatableByCursor(int columnPosition) {
        return this.getResultColumn(columnPosition).updatableByCursor();
    }

    boolean isCloneable() {
        boolean retcode = true;
        for (ResultColumn rc : this) {
            if (rc.getExpression().isCloneable()) continue;
            retcode = false;
            break;
        }
        return retcode;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
        for (ResultColumn rc : this) {
            if (rc.getExpression() == null) continue;
            rc.setExpression(rc.getExpression().remapColumnReferencesToExpressions());
        }
    }

    void setIndexRow(long cid, boolean forUpdate) {
        this.indexRow = true;
        this.conglomerateId = cid;
        this.forUpdate = forUpdate;
    }

    boolean hasConsistentTypeInfo() throws StandardException {
        boolean isConsistent = true;
        for (ResultColumn rc : this) {
            ValueNode expr = rc.getExpression();
            DataTypeDescriptor rcDTS = rc.getTypeServices();
            DataTypeDescriptor exDTS = expr.getTypeServices();
            if (rcDTS == null || exDTS == null) {
                isConsistent = false;
                break;
            }
            if (rcDTS.getClass().getName() == exDTS.getClass().getName()) continue;
            isConsistent = false;
            break;
        }
        return isConsistent;
    }

    boolean containsAllResultColumn() {
        boolean containsAllResultColumn = false;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (!(this.elementAt(index) instanceof AllResultColumn)) continue;
            containsAllResultColumn = true;
            break;
        }
        return containsAllResultColumn;
    }

    int countReferencedColumns() {
        int numReferenced = 0;
        for (ResultColumn rc : this) {
            if (!rc.isReferenced()) continue;
            ++numReferenced;
        }
        return numReferenced;
    }

    void recordColumnReferences(int[] idArray, int basis) {
        int currArrayElement = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            idArray[currArrayElement++] = index + basis;
        }
    }

    int getPosition(String name, int basis) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!name.equals(rc.getName())) continue;
            return index + basis;
        }
        return -1;
    }

    void recordColumnReferences(boolean[] colArray1, JBitSet[] tableColMap, int tableNumber) {
        for (ResultColumn rc : this) {
            if (!(rc.getExpression() instanceof ColumnReference)) continue;
            int columnNumber = ((ColumnReference)rc.getExpression()).getColumnNumber();
            colArray1[columnNumber] = true;
            tableColMap[tableNumber].set(columnNumber);
        }
    }

    int allTopCRsFromSameTable() {
        int tableNumber = -1;
        for (ResultColumn rc : this) {
            ValueNode vn = rc.getExpression();
            if (!(vn instanceof ColumnReference)) continue;
            ColumnReference cr = (ColumnReference)vn;
            if (tableNumber == -1) {
                tableNumber = cr.getTableNumber();
                continue;
            }
            if (tableNumber == cr.getTableNumber()) continue;
            return -1;
        }
        return tableNumber;
    }

    void clearColumnReferences() {
        for (ResultColumn rc : this) {
            if (!rc.isReferenced()) continue;
            rc.setUnreferenced();
        }
    }

    void copyReferencedColumnsToNewList(ResultColumnList targetList) {
        for (ResultColumn rc : this) {
            if (!rc.isReferenced()) continue;
            targetList.addElement(rc);
        }
    }

    void copyColumnsToNewList(ResultColumnList targetList, FormatableBitSet copyList) {
        for (ResultColumn rc : this) {
            if (!copyList.isSet(rc.getColumnPosition())) continue;
            targetList.addElement(rc);
        }
    }

    FormatableBitSet getColumnReferenceMap() {
        FormatableBitSet colMap = new FormatableBitSet(this.size());
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            colMap.set(index);
        }
        return colMap;
    }

    void pullVirtualIsReferenced() {
        for (ResultColumn rc : this) {
            rc.pullVirtualIsReferenced();
        }
    }

    void clearTableNames() {
        for (ResultColumn rc : this) {
            rc.clearTableName();
        }
    }

    protected void setCountMismatchAllowed(boolean allowed) {
        this.countMismatchAllowed = allowed;
    }

    protected boolean getCountMismatchAllowed() {
        return this.countMismatchAllowed;
    }

    int getTotalColumnSize() {
        int colSize = 0;
        for (ResultColumn rc : this) {
            colSize += rc.getMaximumColumnSize();
        }
        return colSize;
    }

    void createListFromResultSetMetaData(ResultSetMetaData rsmd, TableName tableName, String javaClassName) throws StandardException {
        try {
            int numColumns = rsmd.getColumnCount();
            if (numColumns <= 0) {
                throw StandardException.newException("42X57", javaClassName, String.valueOf(numColumns));
            }
            for (int index = 1; index <= numColumns; ++index) {
                boolean nullableResult = rsmd.isNullable(index) != 0;
                int jdbcColumnType = rsmd.getColumnType(index);
                TypeId cti = switch (jdbcColumnType) {
                    case 1111, 2000 -> TypeId.getUserDefinedTypeId(rsmd.getColumnTypeName(index));
                    default -> TypeId.getBuiltInTypeId(jdbcColumnType);
                };
                if (cti == null) {
                    throw StandardException.newException("42Y23", Integer.toString(index));
                }
                int maxWidth = cti.variableLength() ? rsmd.getColumnDisplaySize(index) : (jdbcColumnType == -1 || jdbcColumnType == -4 ? Integer.MAX_VALUE : 0);
                int precision = cti.isDecimalTypeId() ? rsmd.getPrecision(index) : 0;
                int scale = cti.isDecimalTypeId() ? rsmd.getScale(index) : 0;
                DataTypeDescriptor dts = new DataTypeDescriptor(cti, precision, scale, nullableResult, maxWidth);
                this.addColumn(tableName, rsmd.getColumnName(index), dts);
            }
        }
        catch (Throwable t) {
            if (t instanceof StandardException) {
                throw (StandardException)t;
            }
            throw StandardException.unexpectedUserException(t);
        }
    }

    public ResultColumn addColumn(TableName tableName, String columnName, DataTypeDescriptor dts) throws StandardException {
        BaseColumnNode bcn = new BaseColumnNode(columnName, tableName, dts, this.getContextManager());
        ResultColumn rc = new ResultColumn(columnName, (ValueNode)bcn, this.getContextManager());
        rc.setType(dts);
        this.addResultColumn(rc);
        return rc;
    }

    void addRCForRID() throws StandardException {
        CurrentRowLocationNode rowLocationNode = new CurrentRowLocationNode(this.getContextManager());
        ResultColumn rowLocationColumn = new ResultColumn("", (ValueNode)rowLocationNode, this.getContextManager());
        rowLocationColumn.markGenerated();
        this.addResultColumn(rowLocationColumn);
    }

    void markAllUnreferenced() throws StandardException {
        for (ResultColumn rc : this) {
            rc.setUnreferenced();
        }
    }

    boolean allExpressionsAreColumns(ResultSetNode sourceRS) {
        for (ResultColumn rc : this) {
            ColumnReference cr;
            VirtualColumnNode vcn;
            if (rc.isRightOuterJoinUsingClause()) {
                return false;
            }
            ValueNode expr = rc.getExpression();
            if (!(expr instanceof VirtualColumnNode) && !(expr instanceof ColumnReference)) {
                return false;
            }
            if (expr instanceof VirtualColumnNode && (vcn = (VirtualColumnNode)expr).getSourceResultSet() != sourceRS) {
                vcn.setCorrelated();
                return false;
            }
            if (!(expr instanceof ColumnReference) || !(cr = (ColumnReference)expr).getCorrelated()) continue;
            return false;
        }
        return true;
    }

    ColumnMapping mapSourceColumns() {
        int[] mapArray = new int[this.size()];
        boolean[] cloneMap = new boolean[this.size()];
        HashMap<Integer, Integer> seenMap = new HashMap<Integer, Integer>();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (resultColumn.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode vcn = (VirtualColumnNode)resultColumn.getExpression();
                if (vcn.getCorrelated()) {
                    mapArray[index] = -1;
                    continue;
                }
                rc = vcn.getSourceColumn();
                ResultColumnList.updateArrays(mapArray, cloneMap, seenMap, rc, index);
                continue;
            }
            if (resultColumn.isRightOuterJoinUsingClause()) {
                mapArray[index] = -1;
                continue;
            }
            if (resultColumn.getExpression() instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)resultColumn.getExpression();
                if (cr.getCorrelated()) {
                    mapArray[index] = -1;
                    continue;
                }
                rc = cr.getSource();
                ResultColumnList.updateArrays(mapArray, cloneMap, seenMap, rc, index);
                continue;
            }
            mapArray[index] = -1;
        }
        ColumnMapping result = new ColumnMapping(mapArray, cloneMap);
        return result;
    }

    void setNullability(boolean nullability) throws StandardException {
        for (ResultColumn rc : this) {
            rc.setNullability(nullability);
        }
    }

    FormatableBitSet getReferencedFormatableBitSet(boolean positionedUpdate, boolean always, boolean onlyBCNs) {
        int index;
        int colsAdded = 0;
        int size = this.size();
        FormatableBitSet newReferencedCols = new FormatableBitSet(size);
        if (positionedUpdate) {
            if (always) {
                for (int index2 = 0; index2 < size; ++index2) {
                    newReferencedCols.set(index2);
                }
                return newReferencedCols;
            }
            return null;
        }
        for (index = 0; index < size; ++index) {
            ResultColumn oldCol = (ResultColumn)this.elementAt(index);
            if (!oldCol.isReferenced()) continue;
            if (onlyBCNs && !(oldCol.getExpression() instanceof BaseColumnNode)) {
                boolean skipable;
                boolean bl = skipable = !(oldCol.getExpression() instanceof BaseColumnNode) && !(oldCol.getExpression() instanceof CurrentRowLocationNode);
                if (skipable) continue;
            }
            newReferencedCols.set(index);
            ++colsAdded;
        }
        if (colsAdded != index || always) {
            return newReferencedCols;
        }
        return null;
    }

    ResultColumnList compactColumns(boolean positionedUpdate, boolean always) throws StandardException {
        int index;
        int colsAdded = 0;
        if (positionedUpdate) {
            return this;
        }
        ResultColumnList newCols = new ResultColumnList(this.getContextManager());
        int size = this.size();
        for (index = 0; index < size; ++index) {
            ResultColumn oldCol = (ResultColumn)this.elementAt(index);
            if (!oldCol.isReferenced()) continue;
            newCols.addResultColumn(oldCol);
            ++colsAdded;
        }
        if (colsAdded != index || always) {
            return newCols;
        }
        return this;
    }

    void removeJoinColumns(ResultColumnList joinColumns) {
        for (ResultColumn joinRC : joinColumns) {
            String columnName = joinRC.getName();
            SanityManager.ASSERT(columnName != null, "columnName should be non-null");
            ResultColumn rightRC = this.getResultColumn(columnName);
            if (rightRC == null) continue;
            this.removeElement(rightRC);
        }
    }

    ResultColumnList getJoinColumns(ResultColumnList joinColumns) throws StandardException {
        ResultColumnList newRCL = new ResultColumnList(this.getContextManager());
        for (ResultColumn joinRC : joinColumns) {
            String columnName = joinRC.getName();
            SanityManager.ASSERT(columnName != null, "columnName should be non-null");
            ResultColumn xferRC = this.getResultColumn(columnName);
            if (xferRC == null) {
                throw StandardException.newException("42X04", columnName);
            }
            newRCL.addElement(xferRC);
        }
        return newRCL;
    }

    void resetVirtualColumnIds() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).setVirtualColumnId(index + 1);
        }
    }

    boolean reusableResult() {
        for (ResultColumn rc : this) {
            if (rc.getExpression() instanceof ConstantNode || rc.getExpression() instanceof AggregateNode) continue;
            return false;
        }
        return true;
    }

    int[] getColumnPositions(TableDescriptor td) throws StandardException {
        int size = this.size();
        int[] myPositions = new int[size];
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            String columnName = resultColumn.getName();
            ColumnDescriptor cd = td.getColumnDescriptor(columnName);
            if (cd == null) {
                throw StandardException.newException("42X14", columnName, td.getQualifiedName());
            }
            myPositions[index] = cd.getPosition();
        }
        return myPositions;
    }

    String[] getColumnNames() {
        String[] strings = new String[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            strings[index] = resultColumn.getName();
        }
        return strings;
    }

    void replaceOrForbidDefaults(TableDescriptor ttd, ResultColumnList tcl, boolean allowDefaults) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            DefaultInfoImpl defaultInfo;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isDefaultColumn()) continue;
            if (!allowDefaults) {
                throw StandardException.newException("42Y85", new Object[0]);
            }
            ColumnDescriptor cd = null;
            if (tcl == null) {
                cd = ttd.getColumnDescriptor(index + 1);
            } else if (index < tcl.size()) {
                ResultColumn trc = (ResultColumn)tcl.elementAt(index);
                cd = ttd.getColumnDescriptor(trc.getName());
            }
            if (cd == null) {
                throw StandardException.newException("42X06", ttd.getQualifiedName());
            }
            if (cd.isAutoincrement()) {
                rc.setAutoincrementGenerated();
            }
            if ((defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo()) != null && !defaultInfo.isGeneratedColumn()) {
                this.setDefault(rc, cd, defaultInfo);
            } else {
                rc.setExpression(new UntypedNullConstantNode(this.getContextManager()));
                rc.setWasDefaultColumn(true);
            }
            rc.setDefaultColumn(false);
        }
    }

    void setDefault(ResultColumn rc, ColumnDescriptor cd, DefaultInfoImpl defaultInfo) throws StandardException {
        DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(this.getDataDictionary());
        this.getCompilerContext().createDependency(defaultDescriptor);
        rc.setExpression(DefaultNode.parseDefault(defaultInfo.getDefaultText(), this.getLanguageConnectionContext(), this.getCompilerContext()));
    }

    void checkForInvalidDefaults() throws StandardException {
        for (ResultColumn rc : this) {
            if (rc.isAutoincrementGenerated() || !rc.isDefaultColumn()) continue;
            throw StandardException.newException("42Y85", new Object[0]);
        }
    }

    void verifyAllOrderable() throws StandardException {
        for (ResultColumn rc : this) {
            rc.verifyOrderable();
        }
    }

    public void populate(TableDescriptor table, int[] columnIDs) throws StandardException {
        if (columnIDs == null) {
            return;
        }
        for (int columnPosition : columnIDs) {
            String columnName = table.getColumnDescriptor(columnPosition).getColumnName();
            ResultColumn rc = this.makeColumnFromName(columnName);
            this.addResultColumn(rc);
        }
    }

    private ResultColumn makeColumnFromName(String columnName) throws StandardException {
        return new ResultColumn(columnName, null, this.getContextManager());
    }

    private ResultColumn makeColumnReferenceFromName(TableName tableName, String columnName) throws StandardException {
        ContextManager cm = this.getContextManager();
        ResultColumn rc = new ResultColumn(columnName, (ValueNode)new ColumnReference(columnName, tableName, cm), cm);
        return rc;
    }

    void forbidOverrides(ResultColumnList sourceRSRCL) throws StandardException {
        this.forbidOverrides(sourceRSRCL, false);
    }

    void forbidOverrides(ResultColumnList sourceRSRCL, boolean defaultsWereReplaced) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            ResultColumn sourceRC = sourceRSRCL == null ? null : (ResultColumn)sourceRSRCL.elementAt(index);
            ColumnDescriptor cd = rc.getTableColumnDescriptor();
            if (cd != null && cd.hasGenerationClause()) {
                if (!(defaultsWereReplaced || sourceRC == null || sourceRC.hasGenerationClause() || sourceRC.wasDefaultColumn())) {
                    throw StandardException.newException("42XA3", rc.getName());
                }
                if (sourceRC != null) {
                    sourceRC.setColumnDescriptor(cd.getTableDescriptor(), cd);
                }
            }
            if (cd == null || !cd.isAutoincrement()) continue;
            if (sourceRC != null && sourceRC.isAutoincrementGenerated() || cd.isAutoincAlways() && defaultsWereReplaced) {
                sourceRC.setColumnDescriptor(cd.getTableDescriptor(), cd);
                continue;
            }
            if (!cd.isAutoincAlways()) continue;
            throw StandardException.newException("42Z23", rc.getName());
        }
    }

    void incOrderBySelect() {
        ++this.orderBySelect;
    }

    private void decOrderBySelect() {
        --this.orderBySelect;
    }

    int getOrderBySelect() {
        return this.orderBySelect;
    }

    public void copyOrderBySelect(ResultColumnList src) {
        this.orderBySelect = src.orderBySelect;
    }

    protected void markInitialSize() {
        this.initialListSize = this.size();
    }

    private int numGeneratedColumns() {
        int numGenerated = 0;
        int sz = this.size();
        boolean inVisibleRange = false;
        for (int i = sz - 1; i >= 0; --i) {
            ResultColumn rc = (ResultColumn)this.elementAt(i);
            if (rc.isGenerated()) {
                if (inVisibleRange) {
                    SanityManager.THROWASSERT("Encountered generated column in expected visible range at rcl[" + i + "]");
                }
                ++numGenerated;
                continue;
            }
            inVisibleRange = true;
        }
        return numGenerated;
    }

    int numGeneratedColumnsForGroupBy() {
        int numGenerated = 0;
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            ResultColumn rc = (ResultColumn)this.elementAt(i);
            if (!rc.isGenerated() || !rc.isGroupingColumn()) continue;
            ++numGenerated;
        }
        return numGenerated;
    }

    void removeGeneratedGroupingColumns() {
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            ResultColumn rc = (ResultColumn)this.elementAt(i);
            if (!rc.isGenerated() || !rc.isGroupingColumn()) continue;
            this.removeElementAt(i);
        }
    }

    int visibleSize() {
        return this.size() - this.orderBySelect - this.numGeneratedColumns();
    }

    @Override
    public String toString() {
        return "indexRow: " + this.indexRow + "\norderBySelect: " + this.orderBySelect + "\n" + (String)(this.indexRow ? "conglomerateId: " + this.conglomerateId + "\n" : "") + super.toString();
    }

    private static boolean streamableType(ResultColumn rc) {
        DataTypeDescriptor dtd = rc.getType();
        TypeId s = TypeId.getBuiltInTypeId(dtd.getTypeName());
        if (s != null) {
            return s.streamStorable();
        }
        return false;
    }

    private static void updateArrays(int[] mapArray, boolean[] cloneMap, Map<Integer, Integer> seenMap, ResultColumn rc, int index) {
        int vcId;
        mapArray[index] = vcId = rc.getVirtualColumnId();
        if (ResultColumnList.streamableType(rc)) {
            Integer seenIndex = seenMap.get(vcId);
            if (seenIndex != null) {
                cloneMap[index] = true;
            } else {
                seenMap.put(vcId, index);
            }
        }
    }

    static class ColumnMapping {
        final int[] mapArray;
        final boolean[] cloneMap;

        private ColumnMapping(int[] mapArray, boolean[] cloneMap) {
            this.mapArray = mapArray;
            this.cloneMap = cloneMap;
        }
    }
}

