/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.UserDefinedTypeIdImpl;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BaseTypeCompiler;

public class UserDefinedTypeCompiler
extends BaseTypeCompiler {
    @Override
    public boolean convertible(TypeId otherType, boolean forDataTypeFunction) {
        if (this.getTypeId().getBaseTypeId().isAnsiUDT()) {
            if (!otherType.getBaseTypeId().isAnsiUDT()) {
                return false;
            }
            UserDefinedTypeIdImpl thisTypeID = (UserDefinedTypeIdImpl)this.getTypeId().getBaseTypeId();
            UserDefinedTypeIdImpl thatTypeID = (UserDefinedTypeIdImpl)otherType.getBaseTypeId();
            return thisTypeID.getSQLTypeName().equals(thatTypeID.getSQLTypeName());
        }
        return true;
    }

    @Override
    public boolean compatible(TypeId otherType) {
        return this.convertible(otherType, false);
    }

    @Override
    public boolean storable(TypeId otherType, ClassFactory cf) {
        if (!otherType.isUserDefinedTypeId()) {
            return false;
        }
        UserDefinedTypeIdImpl thisTypeID = (UserDefinedTypeIdImpl)this.getTypeId().getBaseTypeId();
        UserDefinedTypeIdImpl thatTypeID = (UserDefinedTypeIdImpl)otherType.getBaseTypeId();
        if (thisTypeID.isAnsiUDT() != thatTypeID.isAnsiUDT()) {
            return false;
        }
        if (thisTypeID.isAnsiUDT()) {
            return thisTypeID.getSQLTypeName().equals(thatTypeID.getSQLTypeName());
        }
        return cf.getClassInspector().assignableTo(otherType.getCorrespondingJavaTypeName(), this.getTypeId().getCorrespondingJavaTypeName());
    }

    @Override
    public String interfaceName() {
        return "org.apache.derby.iapi.types.UserDataValue";
    }

    @Override
    public String getCorrespondingPrimitiveTypeName() {
        return this.getTypeId().getCorrespondingJavaTypeName();
    }

    @Override
    public int getCastToCharWidth(DataTypeDescriptor dts) {
        return -1;
    }

    @Override
    String nullMethodName() {
        return "getNullObject";
    }

    @Override
    public void generateDataValue(MethodBuilder mb, int collationType, LocalField field) {
        mb.upCast("java.lang.Object");
        super.generateDataValue(mb, collationType, field);
    }
}

