/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.sql.Timestamp;
import java.util.Vector;
import org.apache.derby.iapi.sql.execute.ResultSetStatistics;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.shared.common.i18n.MessageService;
import org.apache.derby.shared.common.util.ArrayUtil;

public final class RunTimeStatisticsImpl
implements RunTimeStatistics {
    public String statementText;
    public String statementName;
    public String spsName;
    public long parseTime;
    public long bindTime;
    public long optimizeTime;
    public long generateTime;
    public long compileTime;
    public long executeTime;
    public Timestamp beginCompilationTimestamp;
    public Timestamp endCompilationTimestamp;
    public Timestamp beginExecutionTimestamp;
    public Timestamp endExecutionTimestamp;
    public ResultSetStatistics topResultSetStatistics;
    public ResultSetStatistics[] subqueryTrackingArray;

    public RunTimeStatisticsImpl(String spsName, String statementName, String statementText, long compileTime, long parseTime, long bindTime, long optimizeTime, long generateTime, long executeTime, Timestamp beginCompilationTimestamp, Timestamp endCompilationTimestamp, Timestamp beginExecutionTimestamp, Timestamp endExecutionTimestamp, ResultSetStatistics[] subqueryTrackingArray, ResultSetStatistics topResultSetStatistics) {
        this.spsName = spsName;
        this.statementName = statementName;
        this.statementText = statementText;
        this.compileTime = compileTime;
        this.parseTime = parseTime;
        this.bindTime = bindTime;
        this.optimizeTime = optimizeTime;
        this.generateTime = generateTime;
        this.executeTime = executeTime;
        this.beginCompilationTimestamp = DataTypeUtilities.clone(beginCompilationTimestamp);
        this.endCompilationTimestamp = DataTypeUtilities.clone(endCompilationTimestamp);
        this.beginExecutionTimestamp = DataTypeUtilities.clone(beginExecutionTimestamp);
        this.endExecutionTimestamp = DataTypeUtilities.clone(endExecutionTimestamp);
        this.subqueryTrackingArray = ArrayUtil.copy(subqueryTrackingArray);
        this.topResultSetStatistics = topResultSetStatistics;
    }

    @Override
    public long getCompileTimeInMillis() {
        return this.compileTime;
    }

    @Override
    public long getParseTimeInMillis() {
        return this.parseTime;
    }

    @Override
    public long getBindTimeInMillis() {
        return this.bindTime;
    }

    @Override
    public long getOptimizeTimeInMillis() {
        return this.optimizeTime;
    }

    @Override
    public long getGenerateTimeInMillis() {
        return this.generateTime;
    }

    @Override
    public long getExecuteTimeInMillis() {
        return this.executeTime;
    }

    @Override
    public Timestamp getBeginCompilationTimestamp() {
        return DataTypeUtilities.clone(this.beginCompilationTimestamp);
    }

    @Override
    public Timestamp getEndCompilationTimestamp() {
        return DataTypeUtilities.clone(this.endCompilationTimestamp);
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return DataTypeUtilities.clone(this.beginExecutionTimestamp);
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return DataTypeUtilities.clone(this.endExecutionTimestamp);
    }

    @Override
    public String getStatementName() {
        return this.statementName;
    }

    @Override
    public String getSPSName() {
        return this.spsName;
    }

    @Override
    public String getStatementText() {
        return this.statementText;
    }

    @Override
    public double getEstimatedRowCount() {
        if (this.topResultSetStatistics == null) {
            return 0.0;
        }
        return this.topResultSetStatistics.getEstimatedRowCount();
    }

    @Override
    public String getStatementExecutionPlanText() {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        Object subqueryInfo = "";
        if (this.subqueryTrackingArray != null) {
            boolean foundAttached = false;
            for (int index = 0; index < this.subqueryTrackingArray.length; ++index) {
                if (this.subqueryTrackingArray[index] == null) continue;
                if (!foundAttached) {
                    subqueryInfo = MessageService.getTextMessage("43Y21.U", new Object[0]) + ":\n";
                    foundAttached = true;
                }
                subqueryInfo = (String)subqueryInfo + this.subqueryTrackingArray[index].getStatementExecutionPlanText(1);
            }
        }
        return (String)subqueryInfo + this.topResultSetStatistics.getStatementExecutionPlanText(0);
    }

    @Override
    public String getScanStatisticsText() {
        return this.topResultSetStatistics == null ? (String)null : this.topResultSetStatistics.getScanStatisticsText(null, 0);
    }

    @Override
    public String getScanStatisticsText(String tableName) {
        if (this.topResultSetStatistics == null) {
            return null;
        }
        String s = this.topResultSetStatistics.getScanStatisticsText(tableName, 0);
        return s.equals("") ? null : s;
    }

    public String toString() {
        String spstext = this.spsName != null ? "Stored Prepared Statement Name: \n\t" + this.spsName + "\n" : "";
        return spstext + MessageService.getTextMessage("43Y22.U", new Object[0]) + ": \n\t" + this.statementName + "\n" + MessageService.getTextMessage("43Y23.U", new Object[0]) + ": \n\t" + this.statementText + "\n" + MessageService.getTextMessage("43Y24.U", new Object[0]) + ": " + this.parseTime + "\n" + MessageService.getTextMessage("43Y25.U", new Object[0]) + ": " + this.bindTime + "\n" + MessageService.getTextMessage("43Y26.U", new Object[0]) + ": " + this.optimizeTime + "\n" + MessageService.getTextMessage("43Y27.U", new Object[0]) + ": " + this.generateTime + "\n" + MessageService.getTextMessage("43Y28.U", new Object[0]) + ": " + this.compileTime + "\n" + MessageService.getTextMessage("43Y29.U", new Object[0]) + ": " + this.executeTime + "\n" + MessageService.getTextMessage("43Y30.U", new Object[0]) + " : " + this.beginCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y31.U", new Object[0]) + " : " + this.endCompilationTimestamp + "\n" + MessageService.getTextMessage("43Y32.U", new Object[0]) + " : " + this.beginExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y33.U", new Object[0]) + " : " + this.endExecutionTimestamp + "\n" + MessageService.getTextMessage("43Y44.U", new Object[0]) + ": \n" + this.getStatementExecutionPlanText();
    }

    public Vector<ResultSetStatistics> getChildren() {
        Vector<ResultSetStatistics> children = new Vector<ResultSetStatistics>();
        children.addElement(this.topResultSetStatistics);
        return children;
    }

    @Override
    public void acceptFromTopResultSet(XPLAINVisitor v) {
        if (this.topResultSetStatistics != null) {
            this.topResultSetStatistics.accept(v);
        }
    }
}

