/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class ProcessStreamDrainer
implements Runnable {
    protected ByteArrayOutputStream data = new ByteArrayOutputStream();
    protected InputStream in;
    protected FileOutputStream fos;
    protected BufferedOutputStream bos;
    protected boolean finished;
    protected IOException ioe;

    public ProcessStreamDrainer(InputStream in, File tmpOutFile) throws IOException, InterruptedException {
        this.in = in;
        this.fos = new FileOutputStream(tmpOutFile);
        this.bos = new BufferedOutputStream(this.fos, 4096);
        Thread myThread = new Thread((Runnable)this, this.getClass().getName());
        myThread.setPriority(1);
        myThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void run() {
        if (this.in == null) {
            System.out.println("The inputstream is null");
            System.exit(1);
        }
        try {
            int valid;
            byte[] ca = new byte[4096];
            while ((valid = this.in.read(ca, 0, ca.length)) != -1) {
                this.bos.write(ca, 0, valid);
                this.bos.flush();
            }
            this.bos.flush();
        }
        catch (IOException ioe) {
            System.out.println(ioe);
        }
        ProcessStreamDrainer processStreamDrainer = this;
        synchronized (processStreamDrainer) {
            this.finished = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Wait() throws IOException {
        ProcessStreamDrainer processStreamDrainer = this;
        synchronized (processStreamDrainer) {
            try {
                while (!this.finished) {
                    this.wait();
                }
            }
            catch (InterruptedException ie) {
                System.out.println("Interrupted: " + ie.toString());
            }
        }
        this.bos.close();
    }
}

