/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.management;

import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.derbyTesting.functionTests.tests.management.JMXConnectionGetter;

class RemoteConnectionGetter
implements JMXConnectionGetter {
    static final ThreadLocal<Map<MBeanServerConnection, JMXConnector>> connections = new ThreadLocal();
    private final JMXServiceURL url;

    RemoteConnectionGetter(JMXServiceURL url) {
        this.url = url;
    }

    @Override
    public MBeanServerConnection getMBeanServerConnection(String user, String password) throws Exception {
        HashMap<String, String[]> env = new HashMap<String, String[]>();
        if (user != null) {
            String[] credentials = new String[]{user, password};
            env.put("jmx.remote.credentials", credentials);
        }
        JMXConnector jmxc = JMXConnectorFactory.connect(this.url, env);
        MBeanServerConnection jmxConn = jmxc.getMBeanServerConnection();
        Map<MBeanServerConnection, JMXConnector> conns = connections.get();
        if (conns == null) {
            conns = new HashMap<MBeanServerConnection, JMXConnector>();
            connections.set(conns);
        }
        conns.put(jmxConn, jmxc);
        return jmxConn;
    }

    @Override
    public void close(MBeanServerConnection jmxConnection) throws Exception {
        Map<MBeanServerConnection, JMXConnector> conns = connections.get();
        JMXConnector jmxc = conns.remove(jmxConnection);
        jmxc.close();
    }
}

