/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Formatters;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SpaceTableTest
extends BaseJDBCTestCase {
    public SpaceTableTest(String name) {
        super(name);
    }

    public static Test suite() {
        Test suite = TestConfiguration.embeddedSuite(SpaceTableTest.class);
        return new CleanDatabaseTestSetup(suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = this.getConnection();
                conn.setAutoCommit(false);
                String createWaitForPostCommit = "CREATE PROCEDURE WAIT_FOR_POST_COMMIT() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA";
                s.executeUpdate(createWaitForPostCommit);
                conn.commit();
                conn.setAutoCommit(true);
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        this.dropTable("IDELETEU");
        this.dropTable("PLATYPUS");
        this.dropTable("\"platypus2\"");
        this.dropFooTables(stmt);
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        this.commit();
        super.tearDown();
    }

    public void testIDeleteu() throws SQLException, InterruptedException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        stmt.executeUpdate("create table ideleteu (a varchar(2000), b varchar(2000))");
        String insertString = "insert into ideleteu values ('" + Formatters.padString("rrrrrrrrrr", 2000) + "', '" + Formatters.padString("ssssssssssssssss", 2000) + "')";
        for (int i = 0; i < 5; ++i) {
            stmt.executeUpdate(insertString);
        }
        this.assertSpaceTableOK("IDELETEU", new String[][]{{"IDELETEU", "0", "6", "0", "4096", "0"}}, false);
        stmt.executeUpdate("delete from ideleteu");
        this.commit();
        stmt.execute("call WAIT_FOR_POST_COMMIT()");
        this.assertSpaceTableOK("IDELETEU", new String[][]{{"IDELETEU", "0", "1", "5", "4096", "20480"}}, true);
        stmt.executeUpdate("drop table ideleteu");
        this.commit();
    }

    public void testPlatypi() throws SQLException, InterruptedException {
        int i;
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        JDBC.assertEmpty(this.doSpaceTableSelect("PLATYPUS"));
        stmt.executeUpdate("create table platypus (a varchar(1000), b varchar(3500), c varchar(400), d varchar(100))");
        stmt.executeUpdate("create index kookaburra on platypus (a)");
        stmt.executeUpdate("create index echidna on platypus (c)");
        stmt.executeUpdate("create index wallaby on platypus (a,c,d)");
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "1", "0", "4096", "0"}, {"KOOKABURRA", "1", "1", "0", "4096", "0"}, {"PLATYPUS", "0", "1", "0", "4096", "0"}, {"WALLABY", "1", "1", "0", "4096", "0"}}, false);
        String insertString = "insert into platypus values ('" + Formatters.padString("wwwwwww", 1000) + "', '" + Formatters.padString("xxx", 3500) + "', '" + Formatters.padString("yy", 400) + "', '" + Formatters.padString("zzz", 100) + "')";
        for (i = 0; i < 6; ++i) {
            stmt.executeUpdate(insertString);
        }
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "1", "0", "4096", "0"}, {"KOOKABURRA", "1", "4", "0", "4096", "0"}, {"PLATYPUS", "0", "13", "0", "4096", "0"}, {"WALLABY", "1", "8", "0", "4096", "0"}}, false);
        for (i = 0; i < 4; ++i) {
            stmt.executeUpdate(insertString);
        }
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "3", "0", "4096", "0"}, {"KOOKABURRA", "1", "8", "0", "4096", "0"}, {"PLATYPUS", "0", "21", "0", "4096", "0"}, {"WALLABY", "1", "16", "0", "4096", "0"}}, false);
        stmt.executeUpdate("delete from platypus");
        stmt.execute("call WAIT_FOR_POST_COMMIT()");
        this.assertSpaceTableOK("PLATYPUS", new String[][]{{"ECHIDNA", "1", "1", "2", "4096", "8192"}, {"KOOKABURRA", "1", "1", "7", "4096", "28672"}, {"PLATYPUS", "0", "1", "20", "4096", "81920"}, {"WALLABY", "1", "15", "1", "4096", "4096"}}, true);
        stmt.executeUpdate("create table \"platypus2\" (a varchar(10), b varchar(1500), c varchar(400), d varchar(100))");
        insertString = "insert into \"platypus2\" values ('" + Formatters.padString("wwwwwww", 10) + "', '" + Formatters.padString("xxx", 1500) + "', '" + Formatters.padString("yy", 400) + "', '" + Formatters.padString("zzz", 100) + "')";
        for (i = 0; i < 6; ++i) {
            stmt.executeUpdate(insertString);
        }
        stmt.executeUpdate("create index kookaburra2 on \"platypus2\" (a)");
        stmt.executeUpdate("create index echidna2 on \"platypus2\" (c)");
        stmt.executeUpdate("create index wallaby2 on \"platypus2\" (a,c,d)");
        this.assertSpaceTableOK("platypus2", new String[][]{{"ECHIDNA2", "1", "1", "0", "4096", "0"}, {"KOOKABURRA2", "1", "1", "0", "4096", "0"}, {"WALLABY2", "1", "1", "0", "4096", "0"}, {"platypus2", "0", "6", "0", "4096", "0"}}, false);
        ResultSet rs = stmt.executeQuery("select conglomeratename, isindex, numallocatedpages, numfreepages, pagesize, estimspacesaving from SYS.SYSSCHEMAS s, SYS.SYSTABLES t, new org.apache.derby.diag.SpaceTable(SCHEMANAME,TABLENAME) v where s.SCHEMAID = t.SCHEMAID and s.SCHEMANAME = 'APP' order by conglomeratename");
        JDBC.assertFullResultSet(rs, new String[][]{{"ECHIDNA", "1", "1", "2", "4096", "8192"}, {"ECHIDNA2", "1", "1", "0", "4096", "0"}, {"KOOKABURRA", "1", "1", "7", "4096", "28672"}, {"KOOKABURRA2", "1", "1", "0", "4096", "0"}, {"PLATYPUS", "0", "1", "20", "4096", "81920"}, {"WALLABY", "1", "15", "1", "4096", "4096"}, {"WALLABY2", "1", "1", "0", "4096", "0"}, {"platypus2", "0", "6", "0", "4096", "0"}});
        stmt.executeUpdate("drop table platypus");
        stmt.executeUpdate("drop table \"platypus2\"");
    }

    public void testReservedSpace() throws SQLException, InterruptedException {
        Statement stmt = this.createStatement();
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        this.setAutoCommit(false);
        stmt.executeUpdate("create table foo_int (a int)");
        stmt.executeUpdate("create table foo_char (a char(100))");
        stmt.executeUpdate("create table foo_varchar (a varchar(32000))");
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        stmt.executeUpdate("create table foo_longvarchar (a long varchar)");
        stmt.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        stmt.executeUpdate("create table foo_bit (a char(100) for bit data)");
        stmt.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "4096"}, {"FOO_CHAR", "4096"}, {"FOO_INT", "4096"}, {"FOO_LONGVARBINARY", "32768"}, {"FOO_LONGVARCHAR", "32768"}, {"FOO_VARBINARY", "4096"}, {"FOO_VARCHAR", "4096"}});
        this.dropFooTables(stmt);
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.ReservedSpace', '65')");
        stmt.executeUpdate("create table foo_int (a int)");
        stmt.executeUpdate("create table foo_char (a char(100))");
        stmt.executeUpdate("create table foo_varchar (a varchar(32000))");
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        stmt.executeUpdate("create table foo_longvarchar (a long varchar)");
        stmt.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        stmt.executeUpdate("create table foo_bit (a char(100) for bit data)");
        stmt.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.ReservedSpace', NULL)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "4096"}, {"FOO_CHAR", "4096"}, {"FOO_INT", "4096"}, {"FOO_LONGVARBINARY", "32768"}, {"FOO_LONGVARCHAR", "32768"}, {"FOO_VARBINARY", "4096"}, {"FOO_VARCHAR", "4096"}});
        this.dropFooTables(stmt);
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '8192')");
        stmt.executeUpdate("create table foo_int (a int)");
        stmt.executeUpdate("create table foo_char (a char(100))");
        stmt.executeUpdate("create table foo_varchar (a varchar(32000))");
        stmt.executeUpdate("create table foo_longvarchar (a long varchar)");
        stmt.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        stmt.executeUpdate("create table foo_bit (a char(100) for bit data)");
        stmt.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "8192"}, {"FOO_CHAR", "8192"}, {"FOO_INT", "8192"}, {"FOO_LONGVARBINARY", "8192"}, {"FOO_LONGVARCHAR", "8192"}, {"FOO_VARBINARY", "8192"}, {"FOO_VARCHAR", "8192"}});
        this.dropFooTables(stmt);
        stmt.execute("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        this.commit();
        stmt.executeUpdate("create table foo_int (a int)");
        stmt.executeUpdate("create table foo_char (a char(100))");
        stmt.executeUpdate("create table foo_varchar (a varchar(32000))");
        stmt.executeUpdate("create table foo_longvarchar (a long varchar)");
        stmt.executeUpdate("create table foo_longvarbinary (a long varchar for bit data)");
        stmt.executeUpdate("create table foo_bit (a char(100) for bit data)");
        stmt.executeUpdate("create table foo_varbinary (a varchar(1000) for bit data)");
        JDBC.assertFullResultSet(this.doSpaceTableSelect2(), new String[][]{{"FOO_BIT", "4096"}, {"FOO_CHAR", "4096"}, {"FOO_INT", "4096"}, {"FOO_LONGVARBINARY", "4096"}, {"FOO_LONGVARCHAR", "4096"}, {"FOO_VARBINARY", "4096"}, {"FOO_VARCHAR", "4096"}});
        this.commit();
        this.dropFooTables(stmt);
        this.commit();
    }

    private ResultSet doSpaceTableSelect(String tableName) throws SQLException {
        ResultSet rs = null;
        String stmt_str = "select conglomeratename, isindex, numallocatedpages, numfreepages, pagesize, estimspacesaving from new org.apache.derby.diag.SpaceTable('" + tableName + "') t order by conglomeratename";
        PreparedStatement space_stmt = this.prepareStatement(stmt_str);
        rs = space_stmt.executeQuery();
        return rs;
    }

    private ResultSet doSpaceTableSelect2() throws SQLException {
        ResultSet rs = null;
        String stmt_str = "select v.conglomeratename, pagesize from SYS.SYSSCHEMAS s, SYS.SYSTABLES t, new org.apache.derby.diag.SpaceTable(schemaname, tablename) v where s.schemaid=t.schemaid and conglomeratename in ('FOO_INT', 'FOO_VARCHAR', 'FOO_CHAR', 'FOO_LONGVARCHAR','FOO_VARBINARY', 'FOO_LONGVARBINARY', 'FOO_BIT') order by 1";
        PreparedStatement space_stmt = this.prepareStatement(stmt_str);
        rs = space_stmt.executeQuery();
        return rs;
    }

    private void assertSpaceTableOK(String tableName, String[][] expRS, boolean trytwice) throws SQLException, InterruptedException {
        ResultSet rs = this.doSpaceTableSelect(tableName);
        try {
            JDBC.assertFullResultSet(rs, expRS);
        }
        catch (AssertionFailedError e) {
            if (trytwice) {
                this.assertSpaceTableOK(tableName, expRS, false);
            }
            throw e;
        }
    }

    public void dropFooTables(Statement stmt) throws SQLException {
        this.dropTable("FOO_INT");
        this.dropTable("FOO_CHAR");
        this.dropTable("FOO_VARCHAR");
        this.dropTable("FOO_LONGVARCHAR");
        this.dropTable("FOO_LONGVARBINARY");
        this.dropTable("FOO_BIT");
        this.dropTable("FOO_VARBINARY");
    }
}

