/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.perf.basic.jdbc.BaseLoad100TestSetup;

public class HeapScan
extends JDBCPerfTestCase {
    PreparedStatement select = null;
    private PreparedStatement selectWithPred;
    protected static String tableName = "SCANTEST";
    protected static int rowcount = 10000;
    private boolean binaryData;

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("HeapScanTests");
        suite.addTest(HeapScan.baseSuite("HeapScan:CHAR", false));
        suite.addTest(HeapScan.baseSuite("HeapScan:BINARY", true));
        return suite;
    }

    private static Test baseSuite(String name, boolean binaryData) {
        int iterations = 700;
        int repeats = 4;
        BaseTestSuite heapScan = new BaseTestSuite(name);
        heapScan.addTest((Test)new HeapScan("Scan100", binaryData, iterations, repeats));
        heapScan.addTest((Test)new HeapScan("Scan100GetData", binaryData, iterations, repeats));
        heapScan.addTest((Test)new HeapScan("Scan100WithPredicate", binaryData, iterations, repeats));
        return new BaseLoad100TestSetup((Test)heapScan, rowcount, tableName, binaryData);
    }

    public HeapScan(String name, int iterations, int repeats) {
        this(name, false, iterations, repeats);
    }

    public HeapScan(String name, boolean binaryData, int iterations, int repeats) {
        super(name, iterations, repeats);
        this.binaryData = binaryData;
    }

    public void setUp() throws Exception {
        this.select = this.prepareStatement("SELECT * FROM " + tableName);
        this.selectWithPred = this.prepareStatement("SELECT * FROM " + tableName + " WHERE c6=? OR c7=? OR c8=? OR c9=?");
        Object predicate = "abcdef";
        if (this.binaryData) {
            predicate = ((String)predicate).getBytes("US-ASCII");
        }
        for (int i = 1; i <= 4; ++i) {
            this.selectWithPred.setObject(i, predicate);
        }
    }

    @Override
    public void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public void Scan100() throws Exception {
        ResultSet rs = this.select.executeQuery();
        int actualCount = 0;
        while (rs.next()) {
            ++actualCount;
        }
        HeapScan.assertEquals((int)actualCount, (int)rowcount);
        rs.close();
        this.commit();
    }

    public void Scan100GetData() throws Exception {
        ResultSet rs = this.select.executeQuery();
        int actualCount = 0;
        while (rs.next()) {
            int i1 = rs.getInt(1);
            int i2 = rs.getInt(2);
            int i3 = rs.getInt(3);
            int i4 = rs.getInt(4);
            int i5 = rs.getInt(5);
            Object c6 = rs.getObject(6);
            Object c7 = rs.getObject(7);
            Object c8 = rs.getObject(8);
            Object c9 = rs.getObject(9);
            ++actualCount;
        }
        HeapScan.assertEquals((int)actualCount, (int)rowcount);
        rs.close();
        this.commit();
    }

    public void Scan100WithPredicate() throws SQLException {
        ResultSet rs = this.selectWithPred.executeQuery();
        HeapScan.assertFalse((String)"should be empty", (boolean)rs.next());
        rs.close();
        this.commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.select = null;
        this.selectWithPred = null;
        super.tearDown();
    }
}

