/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_Recovery
extends T_Generic {
    private static final String testService = "RecoveryTest";
    static final String REC_001 = "McLaren";
    static final String REC_002 = "Ferrari";
    static final String REC_003 = "Benetton";
    static final String REC_004 = "Prost";
    static final String REC_005 = "Tyrell";
    static final String REC_006 = "Derby, Natscape, Goatscape, the popular names";
    static final String REC_UNDO = "Lotus";
    static final String REC_NULL = "NULL";
    static final String SP1 = "savepoint1";
    static final String SP2 = "savepoint2";
    static final FormatableBitSet BS_COL_0 = new FormatableBitSet(1);
    private RandomAccessFile filein = null;
    private RandomAccessFile fileout = null;
    private boolean setupRecovery;
    private boolean testRecovery;
    private static final String infoPath = "extinout/T_Recovery.info";
    private static final String SETUP_RECOVERY = "SetupRecovery";
    private static final String TEST_RECOVERY = "TestRecovery";
    private static final String RECOVERY_TESTPATH = "RecoveryTestPath";
    RawStoreFactory factory;
    LockFactory lf;
    ContextService contextService;
    UUIDFactory uuidfactory;
    T_Util t_util;

    public T_Recovery() {
        BS_COL_0.set(0);
    }

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    private void getConfig() {
        String param = PropertyUtil.getSystemProperty((String)SETUP_RECOVERY);
        this.setupRecovery = Boolean.valueOf(param);
        param = PropertyUtil.getSystemProperty((String)TEST_RECOVERY);
        this.testRecovery = Boolean.valueOf(param);
    }

    @Override
    public void runTests() throws T_Fail {
        this.getConfig();
        if (!(this.setupRecovery ^ this.testRecovery)) {
            throw T_Fail.testFailMsg("One & only one of the SetupRecovery and TestRecovery properties must be set");
        }
        try {
            this.uuidfactory = T_Recovery.getMonitor().getUUIDFactory();
            if (this.uuidfactory == null) {
                throw T_Fail.testFailMsg("UUIDFactory.MODULE not found");
            }
            this.startParams = T_Util.setEncryptionParam(this.startParams);
            this.contextService = T_Recovery.getContextService();
            if (this.testRecovery) {
                if (!T_Recovery.startPersistentService(testService, this.startParams)) {
                    throw T_Fail.testFailMsg("Monitor didn't know how to restart service: RecoveryTest");
                }
                this.factory = (RawStoreFactory)T_Recovery.findService(this.getModuleToTestProtocolName(), testService);
            } else {
                if (this.startParams == null) {
                    this.startParams = new Properties();
                }
                this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
                this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
                this.startParams.put("derby.storage.keepTransactionLog", "true");
                this.factory = (RawStoreFactory)T_Recovery.createPersistentService(this.getModuleToTestProtocolName(), testService, this.startParams);
            }
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (this.factory == null) {
            throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
        }
        this.lf = this.factory.getLockFactory();
        if (this.lf == null) {
            throw T_Fail.testFailMsg("LockFactory.MODULE not found");
        }
        this.t_util = new T_Util(this.factory, this.lf, this.contextService);
        try {
            if (this.setupRecovery) {
                this.S001();
                this.S002();
                this.S003();
                this.S004();
                this.S005();
                this.S006();
                this.S007();
                this.S008();
                this.S009();
                this.S010();
                this.S011();
                this.S012();
                this.S020();
                this.S022();
                this.S100();
                this.S101();
                this.S200();
                this.S201();
                this.S202();
                this.S203();
                this.S204();
                this.S300();
                this.S301();
                this.S302();
                this.S303();
                this.S304();
            }
            if (this.testRecovery || this.setupRecovery) {
                this.R001();
                this.R002();
                this.R003();
                this.R004();
                this.R005();
                this.R006();
                this.R007();
                this.R008();
                this.R009();
                this.R010();
                this.R011();
                this.R012();
                this.R020();
                this.R022();
                this.R100();
                this.R101();
                this.R302();
                if (this.testRecovery) {
                    this.R200();
                    this.R201();
                    this.R202();
                    this.R203();
                    this.R204();
                    this.R300();
                    this.R301();
                    this.R303();
                    this.R304();
                    this.R999();
                }
            }
            if (this.setupRecovery) {
                this.S999();
            }
            if (this.fileout != null) {
                this.fileout.close();
                this.fileout = null;
            }
            if (this.filein != null) {
                this.filein.close();
                this.filein = null;
            }
        }
        catch (Throwable t) {
            SanityManager.showTrace((Throwable)t);
            System.out.println("caught exception t " + t);
            t.printStackTrace();
            System.exit(0);
        }
    }

    private long find(long inkey) throws T_Fail {
        try {
            if (this.filein == null) {
                File infoFile = new File(infoPath);
                if (infoFile.exists()) {
                    try {
                        this.filein = new RandomAccessFile(infoFile, "r");
                    }
                    catch (IOException ioe) {
                        System.out.println("Cannot write to temporary file extinout/T_Recovery.info.  Please make sure it is correct, if not, please set the property RecoveryTestPath=<where temp files should go>");
                        throw T_Fail.exceptionFail(ioe);
                    }
                } else {
                    return -1L;
                }
            }
            this.filein.seek(0L);
            while (true) {
                long key;
                if ((key = this.filein.readLong()) == inkey) {
                    long value = this.filein.readLong();
                    return value;
                }
                this.filein.readLong();
            }
        }
        catch (IOException ioe) {
            return -1L;
        }
    }

    private long key(int test, int param) {
        long i = test;
        return (i << 32) + (long)param;
    }

    private void register(long key, long value) throws T_Fail {
        try {
            if (this.fileout == null) {
                File ifdir;
                File infofile = new File(infoPath);
                if (infofile.exists()) {
                    infofile.delete();
                }
                if (!(ifdir = new File("extinout")).exists()) {
                    ifdir.mkdirs();
                }
                this.fileout = new RandomAccessFile(infoPath, "rw");
            }
            this.fileout.writeLong(key);
            this.fileout.writeLong(value);
        }
        catch (IOException ioe) {
            T_Fail.exceptionFail(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S001() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
            page.unlatch();
            c.close();
            this.register(this.key(1, 1), cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.REPORT("setup S001: " + cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R001() throws T_Fail, StandardException {
        long cid = this.find(this.key(1, 1));
        if (cid < 0L) {
            this.REPORT("R001 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFieldCount(page, 0, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R001: containerId " + cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S002() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        try {
            RecordHandle r4;
            RecordHandle r3;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
            RecordHandle r2 = T_Util.t_insertAtSlot(page, 1, row2);
            RecordHandle recordHandle = r2 == null ? r2 : (r3 = T_Util.t_insertAtSlot(page, 2, row3));
            RecordHandle recordHandle2 = r3 == null ? r3 : (r4 = T_Util.t_insertAtSlot(page, 3, row4));
            RecordHandle r5 = r4 == null ? r4 : T_Util.t_insertAtSlot(page, 4, row5);
            this.REPORT("setup S002: containerId " + cid + " recordCount " + page.recordCount());
            this.register(this.key(2, 1), cid);
            this.register(this.key(2, 2), page.recordCount());
            page.unlatch();
            c.close();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R002() throws T_Fail, StandardException {
        long cid = this.find(this.key(2, 1));
        if (cid < 0L) {
            this.REPORT("R002 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(2, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, recordCount);
            switch (recordCount) {
                case 5: {
                    T_Util.t_checkFetchBySlot(page, 4, REC_005, false, false);
                }
                case 4: {
                    T_Util.t_checkFetchBySlot(page, 3, REC_004, false, false);
                }
                case 3: {
                    T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
                }
                case 2: {
                    T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
                }
                case 1: {
                    T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
                }
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R002: containerId " + cid + " recordCount " + recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S003() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
            T_Util.t_checkFetch(page, r1, row1);
            T_RawStoreRow upd1 = new T_RawStoreRow(3);
            upd1.setColumn(0, (String)null);
            upd1.setColumn(1, REC_003);
            upd1.setColumn(2, REC_004);
            r1 = page.updateAtSlot(0, (Object[])upd1.getRow(), (FormatableBitSet)null);
            T_RawStoreRow row2 = new T_RawStoreRow(3);
            row2.setColumn(0, REC_001);
            row2.setColumn(1, REC_002);
            row2.setColumn(2, REC_003);
            T_RawStoreRow upd2 = new T_RawStoreRow(REC_005);
            RecordHandle r2 = T_Util.t_insertAtSlot(page, 1, row2);
            if (r2 != null) {
                r2 = page.updateAtSlot(1, (Object[])upd2.getRow(), (FormatableBitSet)null);
            }
            T_Util.t_checkFetch(page, r1, upd1);
            SQLChar column = new SQLChar();
            T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, true, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, true, REC_003);
            T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, true, REC_004);
            if (r2 != null) {
                T_Util.t_checkFetch(page, r2, upd2);
                T_Util.t_checkFetchColFromSlot(page, 1, 0, (DataValueDescriptor)column, true, REC_005);
            }
            this.REPORT("setup S003: containerId " + cid + " recordCount " + page.recordCount());
            this.register(this.key(3, 1), cid);
            this.register(this.key(3, 2), page.recordCount());
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R003() throws T_Fail, StandardException {
        long cid = this.find(this.key(3, 1));
        if (cid < 0L) {
            this.REPORT("R003 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(3, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, recordCount);
            T_Util.t_checkFieldCount(page, 0, 3);
            SQLChar column = new SQLChar();
            T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_003);
            T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, false, REC_004);
            if (recordCount == 2) {
                T_Util.t_checkFieldCount(page, 1, 1);
                T_Util.t_checkFetchColFromSlot(page, 1, 0, (DataValueDescriptor)column, false, REC_005);
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R003: containerId " + cid + " recordCount " + recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S004() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            Page page;
            long cid;
            block7: {
                block6: {
                    cid = this.t_util.t_addContainer(t, 0L);
                    this.t_util.t_commit(t);
                    ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
                    page = this.t_util.t_getPage(c, 1L);
                    T_RawStoreRow row = new T_RawStoreRow(5);
                    row.setColumn(0, (String)null);
                    row.setColumn(1, REC_004);
                    row.setColumn(2, (String)null);
                    row.setColumn(3, REC_005);
                    row.setColumn(4, REC_005);
                    RecordHandle rh = T_Util.t_insert(page, row);
                    SQLChar col0 = new SQLChar((String)null);
                    SQLChar col1 = new SQLChar(REC_001);
                    SQLChar col2 = new SQLChar(REC_002);
                    SQLChar col3 = new SQLChar((String)null);
                    if (page.updateFieldAtSlot(0, 0, (Object)col0, null) == null) break block6;
                    if (page.updateFieldAtSlot(0, 1, (Object)col1, null) == null) break block6;
                    if (page.updateFieldAtSlot(0, 2, (Object)col2, null) == null) break block6;
                    if (page.updateFieldAtSlot(0, 3, (Object)col3, null) != null) break block7;
                }
                throw T_Fail.testFailMsg("Failed to update field");
            }
            page.unlatch();
            this.REPORT("setup S004: containerId " + cid);
            this.register(this.key(4, 1), cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R004() throws T_Fail, StandardException {
        long cid = this.find(this.key(4, 1));
        if (cid < 0L) {
            this.REPORT("R004 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            SQLChar column = new SQLChar();
            T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_001);
            T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, false, REC_002);
            T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column, false, null);
            T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column, false, REC_005);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R004: containerId " + cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S005() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            RecordHandle r5;
            RecordHandle r4;
            RecordHandle r3;
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            long numPurged = 0L;
            RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
            page.purgeAtSlot(0, 1, true);
            ++numPurged;
            RecordHandle r2 = T_Util.t_insertAtSlot(page, 0, row2);
            if (r2 != null) {
                page.deleteAtSlot(0, true, null);
            }
            RecordHandle recordHandle = r2 == null ? r2 : (r3 = T_Util.t_insertAtSlot(page, 1, row3));
            if (r3 != null) {
                page.deleteAtSlot(1, true, null);
            }
            RecordHandle recordHandle2 = r3 == null ? r3 : (r4 = T_Util.t_insertAtSlot(page, 2, row4));
            RecordHandle recordHandle3 = r4 == null ? r4 : (r5 = T_Util.t_insertAtSlot(page, 3, row5));
            if (r5 != null) {
                page.purgeAtSlot(1, 2, true);
                numPurged += 2L;
            }
            this.REPORT("setup S005: containerId " + cid + " recordCount " + page.recordCount() + " numPurges " + numPurged);
            this.register(this.key(5, 1), cid);
            this.register(this.key(5, 2), page.recordCount());
            this.register(this.key(5, 3), numPurged);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R005() throws T_Fail, StandardException {
        long cid = this.find(this.key(5, 1));
        if (cid < 0L) {
            this.REPORT("R005 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(5, 2));
        int numPurged = (int)this.find(this.key(5, 3));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, 1);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            if (numPurged == 1) {
                switch (recordCount) {
                    case 3: {
                        T_Util.t_checkFetchBySlot(page, 2, REC_004, false, false);
                    }
                    case 2: {
                        T_Util.t_checkFetchBySlot(page, 1, REC_003, true, false);
                    }
                    case 1: {
                        T_Util.t_checkFetchBySlot(page, 0, REC_002, true, false);
                    }
                }
            } else {
                switch (recordCount) {
                    case 2: {
                        T_Util.t_checkFetchBySlot(page, 1, REC_005, false, false);
                    }
                    case 1: {
                        T_Util.t_checkFetchBySlot(page, 0, REC_002, true, false);
                        if (page.isDeletedAtSlot(0)) break;
                        throw T_Fail.testFailMsg("record should be deleted");
                    }
                }
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R005: containerId " + cid + " recordCount " + recordCount + " numPurges " + numPurged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S006() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_insertAtSlot(page, 0, row1);
            long page1_Id = page.getPageNumber();
            page.unlatch();
            page = this.t_util.t_addPage(c);
            T_Util.t_insertAtSlot(page, 0, row2);
            long page2_Id = page.getPageNumber();
            page.unlatch();
            page = this.t_util.t_addPage(c);
            T_Util.t_insertAtSlot(page, 0, row3);
            long page3_Id = page.getPageNumber();
            page.unlatch();
            if (page1_Id == page2_Id || page1_Id == page3_Id || page2_Id == page3_Id) {
                throw T_Fail.testFailMsg("not getting new pages");
            }
            this.REPORT("setup S006: containerId " + cid);
            this.register(this.key(6, 1), cid);
            this.register(this.key(6, 2), page1_Id);
            this.register(this.key(6, 3), page2_Id);
            this.register(this.key(6, 4), page3_Id);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R006() throws T_Fail, StandardException {
        long cid = this.find(this.key(6, 1));
        if (cid < 0L) {
            this.REPORT("R006 not run");
            return;
        }
        long page1_Id = this.find(this.key(6, 2));
        long page2_Id = this.find(this.key(6, 3));
        long page3_Id = this.find(this.key(6, 4));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            if (page1_Id != 1L) {
                throw T_Fail.testFailMsg("first page != container first page");
            }
            Page page = this.t_util.t_getPage(c, page1_Id);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            page.unlatch();
            page = this.t_util.t_getPage(c, page2_Id);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_002, false, false);
            page.unlatch();
            page = this.t_util.t_getPage(c, page3_Id);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_003, false, false);
            page.unlatch();
            page = this.t_util.t_getLastPage(c);
            T_Util.t_checkPageNumber(page, page3_Id);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R006: containerId " + cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S007() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page1 = this.t_util.t_getPage(c, 1L);
            long p1 = page1.getPageNumber();
            Page page2 = this.t_util.t_addPage(c);
            long p2 = page2.getPageNumber();
            Page page3 = this.t_util.t_addPage(c);
            long p3 = page3.getPageNumber();
            this.t_util.t_removePage(c, page2);
            this.t_util.t_removePage(c, page3);
            this.t_util.t_removePage(c, page1);
            if (page1.isLatched()) {
                throw T_Fail.testFailMsg("page is still latched after remove");
            }
            if (page2.isLatched()) {
                throw T_Fail.testFailMsg("page is still latched after remove");
            }
            if (page3.isLatched()) {
                throw T_Fail.testFailMsg("page is still latched after remove");
            }
            this.register(this.key(7, 0), cid);
            this.register(this.key(7, 1), p1);
            this.register(this.key(7, 2), p2);
            this.register(this.key(7, 3), p3);
            this.REPORT("setup S007: containerId " + cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R007() throws T_Fail, StandardException {
        long cid = this.find(this.key(7, 0));
        if (cid < 0L) {
            this.REPORT("R007 not run");
            return;
        }
        long p1 = this.find(this.key(7, 1));
        long p2 = this.find(this.key(7, 2));
        long p3 = this.find(this.key(7, 3));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page p = c.getPage(p1);
            if (p != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + p1);
            }
            p = c.getPage(p2);
            if (p != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + p2);
            }
            p = c.getPage(p3);
            if (p != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + p3);
            }
            p = c.getPage(p3 + 1L);
            if (p != null) {
                throw T_Fail.testFailMsg("got a non-existant page " + p3 + "100");
            }
            p = c.getFirstPage();
            if (p != null) {
                throw T_Fail.testFailMsg("got a non-existant first page ");
            }
            p = this.t_util.t_getLastPage(c);
            if (p != null) {
                throw T_Fail.testFailMsg("got a non-existant last page ");
            }
            this.PASS("R007: containerId " + cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S008() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page1 = this.t_util.t_getPage(c, 1L);
            long p1 = page1.getPageNumber();
            Page page2 = this.t_util.t_addPage(c);
            long p2 = page2.getPageNumber();
            Page page3 = this.t_util.t_addPage(c);
            long p3 = page3.getPageNumber();
            Page page4 = this.t_util.t_addPage(c);
            long p4 = page4.getPageNumber();
            Page page5 = this.t_util.t_addPage(c);
            long p5 = page5.getPageNumber();
            this.t_util.t_removePage(c, page1);
            this.t_util.t_removePage(c, page3);
            this.t_util.t_removePage(c, page5);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page3 = this.t_util.t_getPage(c, p2);
            page1 = this.t_util.t_getPage(c, p4);
            this.t_util.t_removePage(c, page2);
            this.t_util.t_removePage(c, page4);
            this.register(this.key(8, 0), cid);
            this.register(this.key(8, 1), p1);
            this.register(this.key(8, 2), p2);
            this.register(this.key(8, 3), p3);
            this.register(this.key(8, 4), p4);
            this.register(this.key(8, 5), p5);
            this.REPORT("setup S008: containerId " + cid);
        }
        finally {
            this.t_util.t_abort(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R008() throws T_Fail, StandardException {
        long cid = this.find(this.key(8, 0));
        if (cid < 0L) {
            this.REPORT("R008 not run");
            return;
        }
        long p1 = this.find(this.key(8, 1));
        long p2 = this.find(this.key(8, 2));
        long p3 = this.find(this.key(8, 3));
        long p4 = this.find(this.key(8, 4));
        long p5 = this.find(this.key(8, 5));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page p = c.getPage(p1);
            if (p != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + p1);
            }
            p = this.t_util.t_getPage(c, p2);
            p.unlatch();
            p = c.getPage(p3);
            if (p != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + p3);
            }
            p = this.t_util.t_getPage(c, p4);
            p.unlatch();
            p = c.getPage(p5);
            if (p != null) {
                throw T_Fail.testFailMsg("got a deallcated page " + p5);
            }
            p = c.getPage(p5 + 1L);
            if (p != null) {
                throw T_Fail.testFailMsg("got a non-existant page " + p5 + "1");
            }
            p = c.getFirstPage();
            if (p == null || p.getPageNumber() != p2) {
                throw T_Fail.testFailMsg("get first page failed");
            }
            p.unlatch();
            p = c.getNextPage(p2);
            if (p == null || p.getPageNumber() != p4) {
                throw T_Fail.testFailMsg("get next page failed");
            }
            p.unlatch();
            p = c.getNextPage(p4);
            if (p != null) {
                p.unlatch();
                throw T_Fail.testFailMsg("get next page failed to terminate");
            }
            p = this.t_util.t_getLastPage(c);
            if (p == null || p.getPageNumber() != p4) {
                throw T_Fail.testFailMsg("getLastPage failed");
            }
            p.unlatch();
            this.PASS("R008: containerId " + cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S009() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            int i2;
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            int numpages = 10;
            Page[] origpage = new Page[numpages];
            int[] origrid = new int[numpages];
            long[] origpnum = new long[numpages];
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            for (i2 = 0; i2 < numpages; ++i2) {
                origpage[i2] = i2 == 0 ? this.t_util.t_getPage(c, 1L) : this.t_util.t_addPage(c);
                origrid[i2] = T_Util.t_insert(origpage[i2], row1).getId();
                origpnum[i2] = origpage[i2].getPageNumber();
                this.t_util.t_removePage(c, origpage[i2]);
            }
            this.t_util.t_commit(t);
            for (i2 = 0; i2 < numpages - 1; ++i2) {
                for (int j = i2 + 1; j < numpages; ++j) {
                    if (origpnum[i2] != origpnum[j]) continue;
                    throw T_Fail.testFailMsg("page reused before transaction is committed");
                }
            }
            this.register(this.key(9, 0), cid);
            this.register(this.key(9, 1), numpages);
            for (i2 = 0; i2 < numpages; ++i2) {
                this.register(this.key(9, i2 + 10), origpnum[i2]);
                this.register(this.key(9, i2 + numpages + 10), origrid[i2]);
            }
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page[] newpage = new Page[numpages];
            int[] newrid = new int[numpages];
            long[] newpnum = new long[numpages];
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            for (int i3 = 0; i3 < numpages; ++i3) {
                newpage[i3] = this.t_util.t_addPage(c);
                newpnum[i3] = newpage[i3].getPageNumber();
                newrid[i3] = T_Util.t_insert(newpage[i3], row2).getId();
            }
            int reuse = 0;
            block8: for (i = 0; i < numpages; ++i) {
                for (int j = 0; j < numpages; ++j) {
                    if (origpnum[i] != newpnum[j]) continue;
                    ++reuse;
                    if (origrid[i] != newrid[j]) continue block8;
                    throw T_Fail.testFailMsg("resued page rid is not preserved");
                }
            }
            for (i = 0; i < numpages; ++i) {
                this.register(this.key(9, i + 100), newpnum[i]);
                this.register(this.key(9, i + numpages + 100), newrid[i]);
            }
            this.REPORT("setup S009: containerId " + cid + " of " + numpages + " original pages," + reuse + " pages were reused.");
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R009() throws T_Fail, StandardException {
        long cid = this.find(this.key(9, 0));
        if (cid < 0L) {
            this.REPORT("R009 not run");
            return;
        }
        int numpages = (int)this.find(this.key(9, 1));
        int[] newrid = new int[numpages];
        long[] newpnum = new long[numpages];
        Page[] newpage = new Page[numpages];
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            for (int i = 0; i < numpages; ++i) {
                newrid[i] = (int)this.find(this.key(9, i + numpages + 100));
                newpnum[i] = this.find(this.key(9, i + 100));
                newpage[i] = this.t_util.t_getPage(c, newpnum[i]);
                T_Util.t_checkRecordCount(newpage[i], 1, 1);
                RecordHandle rh = T_Util.t_checkFetchFirst(newpage[i], REC_002);
                if (rh.getId() == newrid[i]) continue;
                throw T_Fail.testFailMsg("recordId not match");
            }
            this.REPORT("R009: containerId " + cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S010() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            int numpages = 10;
            Page[] page = new Page[numpages];
            long[] pnum = new long[numpages];
            RecordHandle[] recordHandles = new RecordHandle[numpages];
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            for (int i2 = 0; i2 < numpages; ++i2) {
                page[i2] = i2 == 0 ? this.t_util.t_getPage(c, 1L) : this.t_util.t_addPage(c);
                pnum[i2] = page[i2].getPageNumber();
                if (i2 < 2 || i2 == numpages - 1) {
                    T_Util.t_checkEmptyPage(page[i2]);
                    this.t_util.t_removePage(c, page[i2]);
                    continue;
                }
                recordHandles[i2] = T_Util.t_insert(page[i2], row1);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page p = c.getFirstPage();
            if (p.getPageNumber() != pnum[2]) {
                throw T_Fail.testFailMsg("first page expected to be page " + pnum[2] + ", got " + p.getPageNumber() + " instead");
            }
            p.unlatch();
            p = this.t_util.t_getLastPage(c);
            if (p.getPageNumber() != pnum[numpages - 2]) {
                throw T_Fail.testFailMsg("last page expected to be page " + pnum[numpages - 2] + ", got " + p.getPageNumber() + " instead");
            }
            p.unlatch();
            T_RawStoreRow big = new T_RawStoreRow(String.valueOf(new char[1500]));
            this.REPORT("start reusing pages hopefully");
            for (i = 2; i < numpages - 1; ++i) {
                T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
                p = this.t_util.t_getPage(c, pnum[i]);
                while (p.spaceForInsert((Object[])row2.getRow(), (FormatableBitSet)null, 100)) {
                    T_Util.t_insert(p, row2);
                }
                RecordHandle rh = p.fetchFromSlot((RecordHandle)null, 0, (Object[])row2.getRow(), (FetchDescriptor)null, true);
                int slot = p.getSlotNumber(rh);
                p.updateAtSlot(slot, (Object[])big.getRow(), null);
                p.unlatch();
            }
            this.register(this.key(10, 1), cid);
            this.register(this.key(10, 2), numpages);
            for (i = 0; i < numpages; ++i) {
                this.register(this.key(10, 10 + i), pnum[i]);
            }
            this.REPORT("setup S010");
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R010() throws T_Fail, StandardException {
        long cid = this.find(this.key(10, 1));
        if (cid < 0L) {
            this.REPORT("R010 not run");
            return;
        }
        int numpages = (int)this.find(this.key(10, 2));
        long[] pnum = new long[numpages];
        for (int i = 0; i < numpages; ++i) {
            pnum[i] = this.find(this.key(10, 10 + i));
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page p = c.getPage(pnum[0]);
            if (p.recordCount() == 0) {
                p.unlatch();
                throw T_Fail.testFailMsg("first page failed to get any overflow records");
            }
            p.unlatch();
            p = c.getPage(pnum[1]);
            if (p.recordCount() == 0) {
                p.unlatch();
                throw T_Fail.testFailMsg("second page failed to get any overflow records");
            }
            p.unlatch();
            p = c.getPage(pnum[numpages - 1]);
            if (p.recordCount() == 0) {
                p.unlatch();
                throw T_Fail.testFailMsg("last page failed to get any overflow records");
            }
            p.unlatch();
            p = c.getFirstPage();
            if (p.getPageNumber() != pnum[2]) {
                throw T_Fail.testFailMsg("first page expected to be page " + pnum[2] + ", got " + p.getPageNumber() + " instead");
            }
            long pageNum = p.getPageNumber();
            this.t_util.t_checkStringLengthFetch(p, 0, 1500);
            p.unlatch();
            int i = 3;
            while ((p = c.getNextPage(pageNum)) != null) {
                pageNum = p.getPageNumber();
                if (pageNum != pnum[i]) {
                    throw T_Fail.testFailMsg("expect page " + pnum[i] + " get page " + pageNum);
                }
                this.t_util.t_checkStringLengthFetch(p, 0, 1500);
                p.unlatch();
                ++i;
            }
            if (i != numpages - 1) {
                throw T_Fail.testFailMsg("expect last head page to be " + (numpages - 2) + " got " + i + " page instead");
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R010");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S011() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        int iterations = 10000;
        try {
            long cid = this.t_util.t_addContainer(t, 0L, 4096);
            this.t_util.t_commit(t);
            T_RawStoreRow row = new T_RawStoreRow(REC_001);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page p = this.t_util.t_getPage(c, 1L);
            T_Util.t_insert(p, row);
            p.unlatch();
            long pnum = 1L;
            long lastPageNum = -1L;
            for (int i = 1; i <= iterations; ++i) {
                p = this.t_util.t_addPage(c);
                if (p.getPageNumber() != pnum + 1L) {
                    this.REPORT("S011: skipping " + (pnum + 1L) + " going to " + p.getPageNumber());
                }
                pnum = p.getPageNumber();
                T_Util.t_insert(p, row);
                if (i == iterations) {
                    lastPageNum = p.getPageNumber();
                    this.REPORT("S011: Last page number is " + lastPageNum);
                }
                p.unlatch();
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            p = c.getFirstPage();
            if (p == null || p.getPageNumber() != 1L) {
                throw T_Fail.testFailMsg("first page not where it is expected");
            }
            p.unlatch();
            p = this.t_util.t_getLastPage(c);
            if (p == null || p.getPageNumber() != lastPageNum) {
                throw T_Fail.testFailMsg("last page not where it is expected");
            }
            p.unlatch();
            this.register(this.key(11, 1), cid);
            this.register(this.key(11, 2), lastPageNum);
            this.register(this.key(11, 3), iterations);
            this.REPORT("setup S011, container id = " + cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R011() throws T_Fail, StandardException {
        long cid = this.find(this.key(11, 1));
        if (cid < 0L) {
            this.REPORT("R011 not run");
            return;
        }
        this.REPORT("R011 container id = " + cid);
        long expectedLastPageNum = this.find(this.key(11, 2));
        int iterations = (int)this.find(this.key(11, 3));
        Transaction t = this.t_util.t_startTransaction();
        try {
            long pageNum;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page p = c.getFirstPage();
            if (p == null || p.getPageNumber() != 1L) {
                throw T_Fail.testFailMsg("first page not where it is expected");
            }
            p.unlatch();
            long pnum = pageNum = 1L;
            int pcount = 1;
            while ((p = c.getNextPage(pageNum)) != null) {
                T_Util.t_checkFetchFirst(p, REC_001);
                pageNum = p.getPageNumber();
                if (pageNum != pnum + 1L) {
                    this.REPORT("R011: skipping " + (pnum + 1L) + " going to " + pageNum);
                }
                pnum = pageNum;
                ++pcount;
                p.unlatch();
            }
            if (pcount != iterations + 1) {
                throw T_Fail.testFailMsg("expect to see " + (iterations + 1) + " pages, got: " + pcount + " last page number is " + pageNum);
            }
            p = this.t_util.t_getLastPage(c);
            if (p.getPageNumber() != expectedLastPageNum) {
                throw T_Fail.testFailMsg("expect last page num to be " + expectedLastPageNum + " , instead got " + p.getPageNumber());
            }
            this.REPORT("Last page pagenumber is " + p.getPageNumber() + ", it is the last page of " + (iterations + 1) + " user pages");
            p.unlatch();
            this.PASS("R011");
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S012() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096);
        this.t_util.t_commit(t);
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            if (c.getEstimatedPageCount(0) != 1L) {
                throw T_Fail.testFailMsg("Expect 2 user page, got " + c.getEstimatedPageCount(0));
            }
            Page p = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row = new T_RawStoreRow(REC_001);
            T_Util.t_insert(p, row);
            p.unlatch();
            for (int i = 2; i <= 30; ++i) {
                p = this.t_util.t_addPage(c);
                T_Util.t_insert(p, row);
                p.unlatch();
            }
            this.register(this.key(12, 1), cid);
            this.REPORT("Setup S012");
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R012() throws T_Fail, StandardException {
        long cid = this.find(this.key(12, 1));
        if (cid < 0L) {
            this.REPORT("R012 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            if (c.getEstimatedPageCount(0) != 30L) {
                throw T_Fail.testFailMsg("expect 30 pages, got " + c.getEstimatedPageCount(0));
            }
            this.PASS("R012");
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S020() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
        try {
            long cid1 = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c1 = this.t_util.t_openContainer(t, 0L, cid1, true);
            Page page = this.t_util.t_getPage(c1, 1L);
            T_Util.t_insertAtSlot(page, 0, row1);
            page.unlatch();
            long cid2 = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c2 = this.t_util.t_openContainer(t, 0L, cid2, true);
            long cid3 = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c3 = this.t_util.t_openContainer(t, 0L, cid3, true);
            page = this.t_util.t_getPage(c2, 1L);
            page.unlatch();
            page = this.t_util.t_addPage(c2);
            T_Util.t_insertAtSlot(page, 0, row2);
            long pageId = page.getPageNumber();
            page.unlatch();
            page = this.t_util.t_getPage(c3, 1L);
            T_Util.t_insertAtSlot(page, 0, row3);
            page.unlatch();
            this.REPORT("setup S020: container1 " + cid1 + " container2 " + cid2 + " container3 " + cid3 + " page " + pageId);
            this.register(this.key(20, 1), cid1);
            this.register(this.key(20, 2), cid2);
            this.register(this.key(20, 3), cid3);
            this.register(this.key(20, 4), pageId);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R020() throws T_Fail, StandardException {
        long cid1 = this.find(this.key(20, 1));
        if (cid1 < 0L) {
            this.REPORT("R020 not run");
            return;
        }
        long cid2 = this.find(this.key(20, 2));
        long cid3 = this.find(this.key(20, 3));
        long pageId = this.find(this.key(20, 4));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid1, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            page.unlatch();
            c = this.t_util.t_openContainer(t, 0L, cid2, false);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = this.t_util.t_getPage(c, pageId);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_002, false, false);
            page.unlatch();
            c = this.t_util.t_openContainer(t, 0L, cid3, false);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_003, false, false);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R020 container1 " + cid1 + " container2 " + cid2 + " container3 " + cid3 + " page " + pageId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S022() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            this.t_util.t_openContainer(t, 0L, cid, true);
            this.t_util.t_dropContainer(t, 0L, cid);
            this.t_util.t_abort(t);
            this.t_util.t_openContainer(t, 0L, cid, true);
            this.REPORT("rollback of drop container tested");
            t.dropContainer(new ContainerKey(0L, cid));
            t.commit();
            this.REPORT("setup S022: containerId " + cid);
            this.register(this.key(22, 1), cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R022() throws T_Fail, StandardException {
        long cid = this.find(this.key(22, 1));
        if (cid < 0L) {
            this.REPORT("R022 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerKey id = new ContainerKey(0L, cid);
            ContainerHandle c1 = t.openContainer(id, 8);
            if (c1 != null) {
                throw T_Fail.testFailMsg("dropped container should fail to open");
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R022 : containerId " + cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S100() throws T_Fail, StandardException {
        T_TWC t1 = this.t_util.t_startTransactionWithContext();
        T_TWC t2 = this.t_util.t_startTransactionWithContext();
        try {
            long cid10 = this.t_util.t_addContainer(t1, 0L);
            long cid11 = this.t_util.t_addContainer(t1, 0L);
            this.t_util.t_commit(t1);
            long cid20 = this.t_util.t_addContainer(t2, 0L);
            long cid21 = this.t_util.t_addContainer(t2, 0L);
            this.t_util.t_commit(t2);
            ContainerHandle c10 = this.t_util.t_openContainer(t1, 0L, cid10, true);
            ContainerHandle c11 = this.t_util.t_openContainer(t1, 0L, cid11, true);
            ContainerHandle c20 = this.t_util.t_openContainer(t2, 0L, cid20, true);
            ContainerHandle c21 = this.t_util.t_openContainer(t2, 0L, cid21, true);
            t1.switchTransactionContext();
            Page p10 = this.t_util.t_getPage(c10, 1L);
            Page p11 = this.t_util.t_getPage(c11, 1L);
            t1.resetContext();
            t2.switchTransactionContext();
            Page p20 = this.t_util.t_getPage(c20, 1L);
            Page p21 = this.t_util.t_getPage(c21, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(3);
            row1.setColumn(0, REC_001);
            row1.setColumn(1, REC_002);
            row1.setColumn(2, (String)null);
            T_RawStoreRow row2 = new T_RawStoreRow(2);
            row2.setColumn(0, REC_003);
            row2.setColumn(1, REC_004);
            T_RawStoreRow rowP = new T_RawStoreRow(1);
            rowP.setColumn(0, REC_005);
            t2.resetContext();
            t1.switchTransactionContext();
            RecordHandle r10 = T_Util.t_insertAtSlot(p10, 0, row1);
            RecordHandle r11 = T_Util.t_insertAtSlot(p11, 0, row1);
            t1.resetContext();
            t2.switchTransactionContext();
            RecordHandle r20 = T_Util.t_insertAtSlot(p20, 0, row1);
            RecordHandle r21 = T_Util.t_insertAtSlot(p21, 0, row1);
            t2.resetContext();
            t1.switchTransactionContext();
            int slot10 = p10.getSlotNumber(r10);
            p10.updateAtSlot(slot10, (Object[])row2.getRow(), null);
            int slot11 = p11.getSlotNumber(r11);
            p11.updateAtSlot(slot11, (Object[])row2.getRow(), null);
            t1.resetContext();
            t2.switchTransactionContext();
            int slot20 = p20.getSlotNumber(r20);
            p20.updateAtSlot(slot20, (Object[])row2.getRow(), null);
            int slot21 = p21.getSlotNumber(r21);
            p21.updateAtSlot(slot21, (Object[])row2.getRow(), null);
            t2.resetContext();
            t1.switchTransactionContext();
            slot10 = p10.getSlotNumber(r10);
            p10.updateAtSlot(slot10, (Object[])rowP.getRow(), BS_COL_0);
            slot11 = p11.getSlotNumber(r11);
            p11.updateAtSlot(slot11, (Object[])rowP.getRow(), BS_COL_0);
            p10.unlatch();
            p11.unlatch();
            t1.resetContext();
            t2.switchTransactionContext();
            slot20 = p20.getSlotNumber(r20);
            p20.updateAtSlot(slot20, (Object[])rowP.getRow(), BS_COL_0);
            slot21 = p21.getSlotNumber(r21);
            p21.updateAtSlot(slot21, (Object[])rowP.getRow(), BS_COL_0);
            p21.deleteAtSlot(slot21, true, null);
            p20.unlatch();
            p21.unlatch();
            t2.resetContext();
            this.REPORT("setup S100: container1 " + cid10 + " container2 " + cid11 + " container3 " + cid20 + " container4 " + cid21);
            this.register(this.key(100, 1), cid10);
            this.register(this.key(100, 2), cid11);
            this.register(this.key(100, 3), cid20);
            this.register(this.key(100, 4), cid21);
        }
        finally {
            this.t_util.t_commit(t1);
            this.t_util.t_close(t1);
            this.t_util.t_commit(t2);
            this.t_util.t_close(t2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R100() throws T_Fail, StandardException {
        long[] cid = new long[4];
        cid[0] = this.find(this.key(100, 1));
        if (cid[0] < 0L) {
            this.REPORT("R100 not run");
            return;
        }
        cid[1] = this.find(this.key(100, 2));
        cid[2] = this.find(this.key(100, 3));
        cid[3] = this.find(this.key(100, 4));
        Transaction t = this.t_util.t_startTransaction();
        try {
            for (int i = 0; i < 4; ++i) {
                ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid[i], false);
                Page page = this.t_util.t_getPage(c, 1L);
                if (i == 3) {
                    T_Util.t_checkRecordCount(page, 1, 0);
                } else {
                    T_Util.t_checkRecordCount(page, 1, 1);
                }
                T_Util.t_checkFieldCount(page, 0, 2);
                SQLChar column = new SQLChar();
                T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, REC_005);
                T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_004);
                page.unlatch();
            }
            this.PASS("R100 passed: container1 " + cid[0] + " container2 " + cid[1] + " container3 " + cid[2] + " container4 " + cid[3]);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S101() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            RecordHandle r0 = T_Util.t_insertAtSlot(page, 0, row1);
            if (T_Util.t_insertAtSlot(page, 1, row2) == null) {
                return;
            }
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            t.setSavePoint(SP1, null);
            if (T_Util.t_insertAtSlot(page, 2, row3) == null) {
                return;
            }
            page.purgeAtSlot(1, 1, true);
            if (T_Util.t_insertAtSlot(page, 1, row4) == null) {
                return;
            }
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            t.setSavePoint(SP2, null);
            int slot0 = page.getSlotNumber(r0);
            page.updateAtSlot(slot0, (Object[])row5.getRow(), null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            page.unlatch();
            t.rollbackToSavePoint(SP2, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            slot0 = page.getSlotNumber(r0);
            page.updateAtSlot(slot0, (Object[])row5.getRow(), null);
            page.deleteAtSlot(0, true, (LogicalUndo)null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            page.deleteAtSlot(2, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 0);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, true, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, true, false);
            page.unlatch();
            t.rollbackToSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 4, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 3, REC_003, true, false);
            if (page.spaceForInsert()) {
                T_Util.t_insertAtSlot(page, 3, row5);
            }
            this.REPORT("setup S101: containerId " + cid + " recordCount " + page.recordCount());
            this.register(this.key(101, 1), cid);
            this.register(this.key(101, 2), page.recordCount());
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R101() throws T_Fail, StandardException {
        long cid = this.find(this.key(101, 1));
        if (cid < 0L) {
            this.REPORT("R101 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(101, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, recordCount - 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, false);
            if (recordCount == 5) {
                T_Util.t_checkFetchBySlot(page, 3, REC_005, false, false);
                T_Util.t_checkFetchBySlot(page, 4, REC_003, true, false);
            } else {
                T_Util.t_checkFetchBySlot(page, 3, REC_003, true, false);
            }
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R101: containerId " + cid + " recordCount " + recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S200() throws T_Fail, StandardException {
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        Page page = null;
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            ctx.switchTransactionContext();
            page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            int rowcount = 0;
            while (page.spaceForInsert()) {
                if (T_Util.t_insertAtSlot(page, 0, row1) == null) continue;
                ++rowcount;
            }
            T_Util.t_checkRecordCount(page, rowcount, rowcount);
            for (int i = 0; i < rowcount; ++i) {
                T_Util.t_checkFetchBySlot(page, i, REC_001, false, false);
            }
            this.REPORT("setup S200: containerId " + cid + " recordCount " + rowcount);
            this.register(this.key(200, 1), cid);
            this.register(this.key(200, 2), rowcount);
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            ctx.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R200() throws T_Fail, StandardException {
        long cid = this.find(this.key(200, 1));
        if (cid < 0L) {
            this.REPORT("R200 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(200, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, 0);
            for (int i = 0; i < recordCount; ++i) {
                T_Util.t_checkFetchBySlot(page, i, REC_001, true, false);
            }
            page.unlatch();
            this.PASS("R200: containerId " + cid + " recordCount " + recordCount);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S201() throws T_Fail, StandardException {
        T_TWC t1 = this.t_util.t_startTransactionWithContext();
        T_TWC t2 = this.t_util.t_startTransactionWithContext();
        Page p21 = null;
        Page p20 = null;
        Page p11 = null;
        Page p10 = null;
        try {
            long cid10 = this.t_util.t_addContainer(t1, 0L);
            long cid11 = this.t_util.t_addContainer(t1, 0L);
            long cid20 = this.t_util.t_addContainer(t2, 0L);
            long cid21 = this.t_util.t_addContainer(t2, 0L);
            this.t_util.t_commit(t1);
            this.t_util.t_commit(t2);
            ContainerHandle c10 = this.t_util.t_openContainer(t1, 0L, cid10, true);
            ContainerHandle c11 = this.t_util.t_openContainer(t1, 0L, cid11, true);
            ContainerHandle c20 = this.t_util.t_openContainer(t2, 0L, cid20, true);
            ContainerHandle c21 = this.t_util.t_openContainer(t2, 0L, cid21, true);
            t1.switchTransactionContext();
            p10 = this.t_util.t_getPage(c10, 1L);
            p11 = this.t_util.t_getPage(c11, 1L);
            t1.resetContext();
            t2.switchTransactionContext();
            p20 = this.t_util.t_getPage(c20, 1L);
            p21 = this.t_util.t_getPage(c21, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(3);
            row1.setColumn(0, REC_001);
            row1.setColumn(1, REC_002);
            row1.setColumn(2, (String)null);
            T_RawStoreRow row2 = new T_RawStoreRow(2);
            row2.setColumn(0, REC_003);
            row2.setColumn(1, REC_004);
            T_RawStoreRow rowP = new T_RawStoreRow(1);
            rowP.setColumn(0, REC_005);
            t2.resetContext();
            t1.switchTransactionContext();
            RecordHandle r10 = T_Util.t_insertAtSlot(p10, 0, row1);
            RecordHandle r11 = T_Util.t_insertAtSlot(p11, 0, row1);
            t1.resetContext();
            t2.switchTransactionContext();
            RecordHandle r20 = T_Util.t_insertAtSlot(p20, 0, row1);
            RecordHandle r21 = T_Util.t_insertAtSlot(p21, 0, row1);
            t2.resetContext();
            t1.switchTransactionContext();
            int slot10 = p10.getSlotNumber(r10);
            p10.updateAtSlot(slot10, (Object[])row2.getRow(), null);
            int slot11 = p11.getSlotNumber(r11);
            p11.updateAtSlot(slot11, (Object[])row2.getRow(), null);
            t1.resetContext();
            t2.switchTransactionContext();
            int slot20 = p20.getSlotNumber(r20);
            p20.updateAtSlot(slot20, (Object[])row2.getRow(), null);
            int slot21 = p21.getSlotNumber(r21);
            p21.updateAtSlot(slot21, (Object[])row2.getRow(), null);
            t2.resetContext();
            t1.switchTransactionContext();
            slot10 = p10.getSlotNumber(r10);
            p10.updateAtSlot(slot10, (Object[])rowP.getRow(), BS_COL_0);
            slot11 = p11.getSlotNumber(r11);
            p11.updateAtSlot(slot11, (Object[])rowP.getRow(), BS_COL_0);
            t1.resetContext();
            t2.switchTransactionContext();
            slot20 = p20.getSlotNumber(r20);
            p20.updateAtSlot(slot20, (Object[])rowP.getRow(), BS_COL_0);
            slot21 = p21.getSlotNumber(r21);
            p21.updateAtSlot(slot21, (Object[])rowP.getRow(), BS_COL_0);
            p21.deleteAtSlot(slot21, true, null);
            t2.resetContext();
            this.REPORT("setup S201: container1 " + cid10 + " container2 " + cid11 + " container3 " + cid20 + " container4 " + cid21);
            this.register(this.key(201, 1), cid10);
            this.register(this.key(201, 2), cid11);
            this.register(this.key(201, 3), cid20);
            this.register(this.key(201, 4), cid21);
        }
        finally {
            if (p10 != null && p10.isLatched()) {
                p10.unlatch();
            }
            if (p11 != null && p11.isLatched()) {
                p11.unlatch();
            }
            if (p20 != null && p20.isLatched()) {
                p20.unlatch();
            }
            if (p21 != null && p21.isLatched()) {
                p21.unlatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R201() throws T_Fail, StandardException {
        long[] cid = new long[4];
        cid[0] = this.find(this.key(201, 1));
        if (cid[0] < 0L) {
            this.REPORT("R201 not run");
            return;
        }
        cid[1] = this.find(this.key(201, 2));
        cid[2] = this.find(this.key(201, 3));
        cid[3] = this.find(this.key(201, 4));
        Transaction t = this.t_util.t_startTransaction();
        try {
            for (int i = 0; i < 4; ++i) {
                ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid[i], false);
                Page page = this.t_util.t_getPage(c, 1L);
                T_Util.t_checkRecordCount(page, 1, 0);
                SQLChar column = new SQLChar();
                T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, REC_001);
                T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_002);
                T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, false, null);
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R201 passed:  container1 " + cid[0] + " container2 " + cid[1] + " container3 " + cid[2] + " container4 " + cid[3]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S202() throws T_Fail, StandardException {
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        Page page = null;
        ctx.switchTransactionContext();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            RecordHandle r0 = T_Util.t_insertAtSlot(page, 0, row1);
            if (T_Util.t_insertAtSlot(page, 1, row2) == null) {
                page.unlatch();
                this.t_util.t_abort(t);
                t.close();
                return;
            }
            t.setSavePoint(SP1, null);
            int slot0 = page.getSlotNumber(r0);
            page.updateAtSlot(slot0, (Object[])row5.getRow(), null);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            page.unlatch();
            t.rollbackToSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            if (T_Util.t_insertAtSlot(page, 2, row3) == null) {
                page.unlatch();
                this.t_util.t_abort(t);
                t.close();
                return;
            }
            page.purgeAtSlot(1, 1, true);
            if (T_Util.t_insertAtSlot(page, 1, row4) == null) {
                page.unlatch();
                this.t_util.t_abort(t);
                t.close();
                return;
            }
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            t.setSavePoint(SP2, null);
            slot0 = page.getSlotNumber(r0);
            page.updateAtSlot(slot0, (Object[])row5.getRow(), null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            page.unlatch();
            t.rollbackToSavePoint(SP2, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, false, false);
            slot0 = page.getSlotNumber(r0);
            page.updateAtSlot(slot0, (Object[])row5.getRow(), null);
            page.deleteAtSlot(0, true, (LogicalUndo)null);
            page.deleteAtSlot(1, true, (LogicalUndo)null);
            page.deleteAtSlot(2, true, (LogicalUndo)null);
            T_Util.t_checkRecordCount(page, 3, 0);
            T_Util.t_checkFetchBySlot(page, 0, REC_005, true, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_003, true, false);
            page.unlatch();
            t.rollbackToSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 4, 2);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, false);
            T_Util.t_checkFetchBySlot(page, 3, REC_003, true, false);
            if (page.spaceForInsert()) {
                T_Util.t_insertAtSlot(page, 3, row5);
            }
            this.REPORT("setup S202: containerId " + cid + " recordCount " + page.recordCount());
            this.register(this.key(202, 1), cid);
            this.register(this.key(202, 2), page.recordCount());
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            ctx.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R202() throws T_Fail, StandardException {
        long cid = this.find(this.key(202, 1));
        if (cid < 0L) {
            this.REPORT("R202 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(202, 2));
        Transaction t = this.t_util.t_startTransaction();
        Page page = null;
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, 0);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, true, true);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, true, true);
            T_Util.t_checkFetchBySlot(page, 2, REC_004, true, true);
            if (recordCount == 5) {
                T_Util.t_checkFetchBySlot(page, 3, REC_005, true, true);
                T_Util.t_checkFetchBySlot(page, 4, REC_003, true, true);
            } else {
                T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
            }
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R202: containerId " + cid + " recordCount " + recordCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S203() throws T_Fail, StandardException {
        int j;
        int i;
        int numtrans = 5;
        int numpages = 2;
        T_TWC[] t = new T_TWC[numtrans];
        for (i = 0; i < numtrans; ++i) {
            t[i] = this.t_util.t_startTransactionWithContext();
        }
        Page[][] page = null;
        try {
            long[] cid = new long[numtrans];
            ContainerHandle[] c = new ContainerHandle[numtrans];
            for (i = 0; i < numtrans; ++i) {
                cid[i] = this.t_util.t_addContainer(t[i], 0L);
                this.t_util.t_commit(t[i]);
                c[i] = this.t_util.t_openContainer(t[i], 0L, cid[i], true);
            }
            page = new Page[numtrans][numpages];
            long[][] pagenum = new long[numtrans][numpages];
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    t[i].switchTransactionContext();
                    page[i][j] = this.t_util.t_addPage(c[i]);
                    pagenum[i][j] = page[i][j].getPageNumber();
                    t[i].resetContext();
                }
            }
            RecordHandle[][] rh = new RecordHandle[numtrans][numpages];
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    t[i].switchTransactionContext();
                    rh[i][j] = T_Util.t_insert(page[i][j], row1);
                    t[i].resetContext();
                }
            }
            t[0].switchTransactionContext();
            t[0].setSavePoint(SP1, null);
            t[0].resetContext();
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    t[i].switchTransactionContext();
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row2.getRow(), null);
                    t[i].resetContext();
                }
            }
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                t[i].setSavePoint(SP1, null);
                t[i].resetContext();
            }
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row3.getRow(), null);
                }
            }
            for (i = 0; i < numtrans; ++i) {
                t[i].setSavePoint(SP2, null);
            }
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row4.getRow(), null);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                page[0][j].unlatch();
            }
            t[0].rollbackToSavePoint(SP1, null);
            for (j = 0; j < numpages; ++j) {
                page[0][j] = this.t_util.t_getPage(c[0], pagenum[0][j]);
            }
            t[0].resetContext();
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    T_Util.t_checkFetch(page[i][j], rh[i][j], REC_004);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[0][j], rh[0][j], REC_001);
            }
            t[0].resetContext();
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row5.getRow(), null);
                }
                t[i].resetContext();
            }
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    page[i][j].unlatch();
                }
                t[i].rollbackToSavePoint(SP2, null);
                for (j = 0; j < numpages; ++j) {
                    page[i][j] = this.t_util.t_getPage(c[i], pagenum[i][j]);
                }
                t[i].resetContext();
            }
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    T_Util.t_checkFetch(page[i][j], rh[i][j], REC_003);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[0][j], rh[0][j], REC_005);
            }
            t[0].resetContext();
            T_RawStoreRow row6 = new T_RawStoreRow(REC_006);
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    int slot = page[i][j].getSlotNumber(rh[i][j]);
                    page[i][j].updateAtSlot(slot, (Object[])row6.getRow(), null);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                page[0][j].unlatch();
            }
            t[0].rollbackToSavePoint(SP1, null);
            for (j = 0; j < numpages; ++j) {
                page[0][j] = this.t_util.t_getPage(c[0], pagenum[0][j]);
            }
            t[0].resetContext();
            for (i = 1; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    T_Util.t_checkFetch(page[i][j], rh[i][j], REC_006);
                    T_Util.t_checkRecordCount(page[i][j], 1, 1);
                }
                t[i].resetContext();
            }
            t[0].switchTransactionContext();
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkFetch(page[0][j], rh[0][j], REC_001);
                T_Util.t_checkRecordCount(page[0][j], 1, 1);
            }
            t[0].resetContext();
            for (i = 0; i < numtrans; ++i) {
                t[i].switchTransactionContext();
                for (j = 0; j < numpages; ++j) {
                    page[i][j].unlatch();
                }
                t[i].resetContext();
            }
            this.t_util.t_abort(t[1]);
            this.t_util.t_commit(t[2]);
            this.t_util.t_commit(t[4]);
            c[1] = this.t_util.t_openContainer(t[1], 0L, cid[1], false);
            c[2] = this.t_util.t_openContainer(t[2], 0L, cid[2], false);
            c[4] = this.t_util.t_openContainer(t[4], 0L, cid[4], false);
            for (j = 0; j < numpages; ++j) {
                t[0].switchTransactionContext();
                this.t_util.t_checkFetch(c[0], rh[0][j], REC_001);
                t[0].resetContext();
                t[1].switchTransactionContext();
                page[1][j] = this.t_util.t_getPage(c[1], pagenum[1][j]);
                T_Util.t_checkRecordCount(page[1][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[1][j], 0, REC_001, true, false);
                page[1][j].unlatch();
                t[1].resetContext();
                t[2].switchTransactionContext();
                this.t_util.t_checkFetch(c[2], rh[2][j], REC_006);
                t[2].resetContext();
                t[3].switchTransactionContext();
                this.t_util.t_checkFetch(c[3], rh[3][j], REC_006);
                t[3].resetContext();
                t[4].switchTransactionContext();
                this.t_util.t_checkFetch(c[4], rh[4][j], REC_006);
                t[4].resetContext();
            }
            this.REPORT("setup S203: numtrans " + numtrans + " numpages " + numpages);
            for (i = 0; i < numtrans; ++i) {
                String str = "container " + i + ":" + cid[i] + " pages: ";
                this.register(this.key(203, i + 10), cid[i]);
                for (j = 0; j < numpages; ++j) {
                    str = str + pagenum[i][j] + " ";
                    this.register(this.key(203, (i + 1) * 1000 + j), pagenum[i][j]);
                }
                this.REPORT("\t" + str);
            }
            this.register(this.key(203, 1), numtrans);
            this.register(this.key(203, 2), numpages);
        }
        finally {
            for (i = 0; i < numtrans; ++i) {
                for (j = 0; j < numpages; ++j) {
                    if (page == null || page[i][j] == null || !page[i][j].isLatched()) continue;
                    page[i][j].unlatch();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R203() throws T_Fail, StandardException {
        int numtrans = (int)this.find(this.key(203, 1));
        int numpages = (int)this.find(this.key(203, 2));
        if (numtrans < 5 || numpages < 1) {
            this.REPORT("R203 not run");
            return;
        }
        this.REPORT("R203 started, numtrans " + numtrans + " numpages " + numpages);
        Transaction t = this.t_util.t_startTransaction();
        try {
            int j;
            int i;
            long[] cid = new long[numtrans];
            ContainerHandle[] c = new ContainerHandle[numtrans];
            long[][] pagenum = new long[numtrans][numpages];
            Page[][] page = new Page[numtrans][numpages];
            for (i = 0; i < numtrans; ++i) {
                cid[i] = this.find(this.key(203, i + 10));
                c[i] = this.t_util.t_openContainer(t, 0L, cid[i], true);
                for (j = 0; j < numpages; ++j) {
                    pagenum[i][j] = this.find(this.key(203, (i + 1) * 1000 + j));
                    if (i == 0 && j == numpages - 1) {
                        SanityManager.DEBUG_SET((String)"TEST_BAD_CHECKSUM");
                        Page p = null;
                        try {
                            p = c[i].getPage(pagenum[i][j]);
                        }
                        catch (StandardException se) {
                            if (se.getMessageId().equals("XSDFD.S")) {
                                this.REPORT("bad checksum tested");
                            }
                            throw se;
                        }
                        SanityManager.DEBUG_CLEAR((String)"TEST_BAD_CHECKSUM");
                        if (p != null) {
                            throw T_Fail.testFailMsg("failed to generate expected error with bad checksum");
                        }
                    }
                    page[i][j] = this.t_util.t_getPage(c[i], pagenum[i][j]);
                }
            }
            for (j = 0; j < numpages; ++j) {
                T_Util.t_checkRecordCount(page[0][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[0][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[1][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[1][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[2][j], 1, 1);
                T_Util.t_checkFetchBySlot(page[2][j], 0, REC_006, false, true);
                T_Util.t_checkRecordCount(page[3][j], 1, 0);
                T_Util.t_checkFetchBySlot(page[3][j], 0, REC_001, true, true);
                T_Util.t_checkRecordCount(page[4][j], 1, 1);
                T_Util.t_checkFetchBySlot(page[4][j], 0, REC_006, false, true);
            }
            for (i = 0; i < numtrans; ++i) {
                String str = "container " + i + ":" + cid[i] + " pages: ";
                for (j = 0; j < numpages; ++j) {
                    str = str + pagenum[i][j] + " ";
                }
                this.REPORT("\t" + str);
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R203: numtrans " + numtrans + " numpages " + numpages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S204() throws T_Fail, StandardException {
        T_TWC ut1 = this.t_util.t_startTransactionWithContext();
        T_TWC ut2 = this.t_util.t_startTransactionWithContext();
        Page p30 = null;
        Page p21 = null;
        Page p20 = null;
        Page p11 = null;
        Page p10 = null;
        try {
            long cid10 = this.t_util.t_addContainer(ut1, 0L);
            long cid11 = this.t_util.t_addContainer(ut1, 0L);
            this.t_util.t_commit(ut1);
            long cid20 = this.t_util.t_addContainer(ut2, 0L);
            long cid21 = this.t_util.t_addContainer(ut2, 0L);
            this.t_util.t_commit(ut2);
            T_RawStoreRow row = new T_RawStoreRow(REC_001);
            ut1.switchTransactionContext();
            ContainerHandle c10 = this.t_util.t_openContainer(ut1, 0L, cid10, true);
            p10 = this.t_util.t_addPage(c10);
            RecordHandle r10 = T_Util.t_insert(p10, row);
            Transaction it1 = this.t_util.t_startInternalTransaction();
            ContainerHandle c11 = this.t_util.t_openContainer(it1, 0L, cid11, true);
            p11 = this.t_util.t_addPage(c11);
            RecordHandle r11 = T_Util.t_insert(p11, row);
            ut1.resetContext();
            ut2.switchTransactionContext();
            ContainerHandle c20 = this.t_util.t_openContainer(ut2, 0L, cid20, true);
            p20 = this.t_util.t_addPage(c20);
            RecordHandle r20 = T_Util.t_insert(p20, row);
            Transaction it2 = this.t_util.t_startInternalTransaction();
            ContainerHandle c21 = this.t_util.t_openContainer(it2, 0L, cid21, true);
            p21 = this.t_util.t_addPage(c21);
            RecordHandle r21 = T_Util.t_insert(p21, row);
            ut2.resetContext();
            ut1.switchTransactionContext();
            it1.commit();
            T_Util.t_checkFetch(p11, r11, REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            RecordHandle r12 = T_Util.t_insert(p11, row2);
            T_Util.t_checkFetch(p11, r12, REC_002);
            ut1.resetContext();
            ut2.switchTransactionContext();
            it2.abort();
            c21 = this.t_util.t_openContainer(it2, 0L, cid21, true);
            p21 = this.t_util.t_getLastPage(c21);
            RecordHandle r22 = T_Util.t_insert(p21, row2);
            ut2.resetContext();
            T_TWC ut3 = this.t_util.t_startTransactionWithContext();
            long cid30 = this.t_util.t_addContainer(ut3, 0L);
            this.t_util.t_commit(ut3);
            ContainerHandle c30 = this.t_util.t_openContainer(ut3, 0L, cid30, true);
            ut3.switchTransactionContext();
            p30 = this.t_util.t_addPage(c30);
            RecordHandle r30 = T_Util.t_insert(p30, row);
            ut3.resetContext();
            this.register(this.key(204, 10), cid10);
            this.register(this.key(204, 11), cid11);
            this.register(this.key(204, 20), cid20);
            this.register(this.key(204, 21), cid21);
            this.register(this.key(204, 30), cid30);
            this.REPORT("setup S204: cid10 " + cid10 + ", cid11 " + cid11 + ", cid20 " + cid20 + ", cid21 " + cid21 + ", cid30 " + cid30);
        }
        finally {
            if (p10 != null && p10.isLatched()) {
                p10.unlatch();
            }
            if (p11 != null && p11.isLatched()) {
                p11.unlatch();
            }
            if (p20 != null && p20.isLatched()) {
                p20.unlatch();
            }
            if (p21 != null && p21.isLatched()) {
                p21.unlatch();
            }
            if (p30 != null && p30.isLatched()) {
                p30.unlatch();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R204() throws T_Fail, StandardException {
        long cid10 = this.find(this.key(204, 10));
        if (cid10 < 0L) {
            this.REPORT("R204 not run");
            return;
        }
        long cid11 = this.find(this.key(204, 11));
        long cid20 = this.find(this.key(204, 20));
        long cid21 = this.find(this.key(204, 21));
        long cid30 = this.find(this.key(204, 30));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid10, false);
            Page p = this.t_util.t_getLastPage(c);
            T_Util.t_checkRecordCount(p, 1, 0);
            p.unlatch();
            c = this.t_util.t_openContainer(t, 0L, cid11, false);
            p = this.t_util.t_getLastPage(c);
            T_Util.t_checkRecordCount(p, 2, 1);
            p.unlatch();
            c = this.t_util.t_openContainer(t, 0L, cid20, false);
            p = this.t_util.t_getLastPage(c);
            T_Util.t_checkRecordCount(p, 1, 0);
            p.unlatch();
            c = this.t_util.t_openContainer(t, 0L, cid21, false);
            p = this.t_util.t_getLastPage(c);
            T_Util.t_checkRecordCount(p, 2, 0);
            p.unlatch();
            c = this.t_util.t_openContainer(t, 0L, cid30, false);
            p = this.t_util.t_getLastPage(c);
            T_Util.t_checkRecordCount(p, 1, 0);
            p.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R204 passed: cid10 " + cid10 + ", cid11 " + cid11 + ", cid20 " + cid20 + ", cid21 " + cid21 + ", cid30 " + cid30);
    }

    protected void S300() throws T_Fail, StandardException {
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            this.t_util.t_openContainer(t, 0L, cid, true);
            this.t_util.t_dropContainer(t, 0L, cid);
            this.REPORT("setup S300: containerId " + cid);
            this.register(this.key(300, 1), cid);
        }
        catch (StandardException se) {
            this.t_util.t_abort(t);
            t.close();
            throw se;
        }
        catch (T_Fail tf) {
            this.t_util.t_abort(t);
            t.close();
            throw tf;
        }
    }

    protected void R300() throws T_Fail, StandardException {
        long cid = this.find(this.key(300, 1));
        if (cid < 0L) {
            this.REPORT("R300 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        this.t_util.t_openContainer(t, 0L, cid, true);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("R300 : containerId " + cid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S301() throws T_Fail, StandardException {
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        Page page = null;
        ctx.switchTransactionContext();
        try {
            long cid1 = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c1 = this.t_util.t_openContainer(t, 0L, cid1, true);
            page = this.t_util.t_addPage(c1);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            RecordHandle r1 = T_Util.t_insert(page, row1);
            t.abort();
            ContainerKey id1 = new ContainerKey(0L, cid1);
            c1 = t.openContainer(id1, 8);
            if (c1 != null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            LockingPolicy nolock = t.newLockingPolicy(0, 0, false);
            RawContainerHandle stub = ((RawTransaction)t).openDroppedContainer(new ContainerKey(0L, cid1), nolock);
            if (stub != null && stub.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
            long cid2 = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c2 = this.t_util.t_openContainer(t, 0L, cid2, true);
            page = this.t_util.t_addPage(c2);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            RecordHandle r2 = T_Util.t_insert(page, row2);
            this.REPORT("setup S301: cid1 " + cid1 + " cid2 " + cid2);
            this.register(this.key(301, 1), cid1);
            this.register(this.key(301, 2), cid2);
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            ctx.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R301() throws T_Fail, StandardException {
        long cid1 = this.find(this.key(301, 1));
        if (cid1 < 0L) {
            this.REPORT("R301 not run");
            return;
        }
        long cid2 = this.find(this.key(301, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            LockingPolicy nolock = t.newLockingPolicy(0, 0, false);
            ContainerKey id1 = new ContainerKey(0L, cid1);
            ContainerHandle c = t.openContainer(id1, 8);
            if (c != null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            RawContainerHandle stub = ((RawTransaction)t).openDroppedContainer(id1, nolock);
            if (stub != null && stub.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
            ContainerKey id2 = new ContainerKey(0L, cid2);
            c = t.openContainer(id2, 8);
            if (c != null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            stub = ((RawTransaction)t).openDroppedContainer(id2, nolock);
            if (stub != null && stub.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R301 : cid1 " + cid1 + " cid2 " + cid2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S302() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        try {
            RecordHandle r5;
            RecordHandle r4;
            RecordHandle r3;
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            long numPurged = 0L;
            RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
            RecordHandle r2 = T_Util.t_insertAtSlot(page, 1, row2);
            RecordHandle recordHandle = r2 == null ? r2 : (r3 = T_Util.t_insertAtSlot(page, 2, row3));
            RecordHandle recordHandle2 = r3 == null ? r3 : (r4 = T_Util.t_insertAtSlot(page, 3, row4));
            RecordHandle recordHandle3 = r4 == null ? r4 : (r5 = T_Util.t_insertAtSlot(page, 4, row5));
            if (r5 != null) {
                int slot = page.getSlotNumber(r5);
                page.deleteAtSlot(slot, true, null);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            page.purgeAtSlot(0, 1, false);
            page.purgeAtSlot(0, 3, false);
            this.t_util.t_abort(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            page.purgeAtSlot(0, 1, false);
            ++numPurged;
            if (r5 != null) {
                page.purgeAtSlot(0, 2, false);
                numPurged += 2L;
            }
            this.REPORT("setup S302: containerId " + cid + " recordCount " + page.recordCount() + " numPurges " + numPurged);
            this.register(this.key(302, 1), cid);
            this.register(this.key(302, 2), page.recordCount());
            this.register(this.key(302, 3), numPurged);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R302() throws T_Fail, StandardException {
        long cid = this.find(this.key(302, 1));
        if (cid < 0L) {
            this.REPORT("R302 not run");
            return;
        }
        int recordCount = (int)this.find(this.key(302, 2));
        int numPurged = (int)this.find(this.key(302, 3));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, false);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, recordCount, 1);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
            T_Util.t_checkFetchBySlot(page, 1, REC_005, true, false);
            if (!page.isDeletedAtSlot(1)) {
                throw T_Fail.testFailMsg("record should be deleted");
            }
            T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, false);
            page.unlatch();
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R302: containerId " + cid + " recordCount " + recordCount + " numPurges " + numPurged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S303() throws StandardException, T_Fail {
        this.REPORT("START S303");
        long segment = 0L;
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        ctx.switchTransactionContext();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(1);
            r1.setColumn(0, 5000, REC_001);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            T_RawStoreRow r2 = new T_RawStoreRow(6);
            r2.setColumn(0, 1600, REC_001);
            r2.setColumn(1, 4000, REC_002);
            r2.setColumn(2, 1600, REC_001);
            r2.setColumn(3, 4000, REC_002);
            r2.setColumn(4, 1600, REC_001);
            r2.setColumn(5, 4000, REC_002);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, r2);
            RecordHandle rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.REPORT("S303 - Nextpage is " + nextPageNumber);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, false);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_abort(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            int rh1slotnumber = page.getSlotNumber(rh1);
            int rh2slotnumber = page.getSlotNumber(rh2);
            page.purgeAtSlot(0, 2, false);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.REPORT("S303 - Purged Slots" + rh1slotnumber + "," + rh2slotnumber);
            this.register(this.key(303, 1), cid);
            this.register(this.key(303, 2), rh1slotnumber);
            this.register(this.key(303, 3), rh2slotnumber);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            ctx.resetContext();
        }
        this.PASS("S303");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R303() throws T_Fail, StandardException {
        long cid = this.find(this.key(303, 1));
        if (cid < 0L) {
            this.REPORT("R303 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            int r1slot = (int)this.find(this.key(303, 2));
            int r2slot = (int)this.find(this.key(303, 3));
            T_RawStoreRow r1 = new T_RawStoreRow(1);
            r1.setColumn(0, 5000, REC_001);
            T_RawStoreRow r2_wnl = new T_RawStoreRow(6);
            r2_wnl.setColumn(0, 4, REC_NULL);
            r2_wnl.setColumn(1, 4000, REC_002);
            r2_wnl.setColumn(2, 1600, REC_001);
            r2_wnl.setColumn(3, 4000, REC_002);
            r2_wnl.setColumn(4, 1600, REC_001);
            r2_wnl.setColumn(5, 4000, REC_002);
            RecordHandle rh1 = page.getRecordHandleAtSlot(r1slot);
            T_Util.t_checkFetch(page, rh1, r1);
            RecordHandle rh2 = page.getRecordHandleAtSlot(r2slot);
            T_Util.t_checkFetch(page, rh2, r2_wnl);
            page.purgeAtSlot(0, 2, false);
            page.unlatch();
            page = null;
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R303");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S304() throws StandardException, T_Fail {
        long segment = 0L;
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        ctx.switchTransactionContext();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(100);
            for (int i = 0; i < 100; ++i) {
                r1.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, false);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.register(this.key(304, 1), cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            ctx.resetContext();
        }
        this.PASS("S304");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R304() throws T_Fail, StandardException {
        long cid = this.find(this.key(304, 1));
        if (cid < 0L) {
            this.REPORT("R304 not run");
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            int i;
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            T_RawStoreRow r1_wnl = new T_RawStoreRow(100);
            for (i = 0; i < 18; ++i) {
                r1_wnl.setColumn(i, 4, REC_NULL);
            }
            for (i = 18; i < 100; ++i) {
                r1_wnl.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle rh1 = page.getRecordHandleAtSlot(0);
            T_Util.t_checkFetch(page, rh1, r1_wnl);
            page.purgeAtSlot(0, 1, false);
            page.unlatch();
            page = null;
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R304");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void S999() throws T_Fail, StandardException {
        T_TWC ctx = this.t_util.t_startTransactionWithContext();
        Transaction t = ctx.tran;
        ctx.switchTransactionContext();
        SanityManager.DEBUG_SET((String)"TEST_LOG_SWITCH_LOG");
        this.factory.checkpoint();
        Page page = null;
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, row1);
            this.t_util.t_commit(t);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 1, row2);
            if (rh2 == null) {
                this.REPORT("S999 not run, page cannot accomodate 2 rows");
                return;
            }
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetch(page, rh1, REC_001);
            T_Util.t_checkFetch(page, rh2, REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            SanityManager.DEBUG_SET((String)"TEST_LOG_INCOMPLETE_LOG_WRITE");
            RecordHandle rh3 = T_Util.t_insert(page, row3);
            if (rh3 == null) {
                this.REPORT("S999 not run, page cannot accomodate 3 rows");
                return;
            }
            T_Util.t_checkRecordCount(page, 3, 3);
            T_Util.t_checkFetch(page, rh3, REC_003);
            this.REPORT("setup S999: cid1 " + cid + " page " + page.getPageNumber());
            this.register(this.key(999, 1), cid);
            this.register(this.key(999, 2), page.getPageNumber());
        }
        finally {
            SanityManager.DEBUG_CLEAR((String)"TEST_LOG_SWITCH_LOG");
            SanityManager.DEBUG_CLEAR((String)"TEST_LOG_INCOMPLETE_LOG_WRITE");
            ctx.resetContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void R999() throws StandardException, T_Fail {
        long cid = this.find(this.key(999, 1));
        if (cid < 0L) {
            this.REPORT("R999 not run");
            return;
        }
        long pageid = this.find(this.key(999, 2));
        Transaction t = this.t_util.t_startTransaction();
        try {
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_getPage(c, pageid);
            T_Util.t_checkRecordCount(page, 2, 1);
            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
            T_Util.t_checkFetchBySlot(page, 1, REC_002, true, false);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("R999: cid " + cid + " page " + pageid);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object findService(String factoryInterface, String serviceName) {
        return Monitor.findService((String)factoryInterface, (String)serviceName);
    }

    private static boolean startPersistentService(String serviceName, Properties properties) throws StandardException {
        return Monitor.startPersistentService((String)serviceName, (Properties)properties);
    }

    private static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)factoryInterface, (String)serviceName, (Properties)properties);
    }
}

