/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.Lob;
import org.apache.derby.client.am.SqlException;

abstract class UpdateSensitiveLOBLocatorInputStream
extends InputStream {
    private BufferedInputStream is = null;
    protected ClientConnection con = null;
    private Lob lob = null;
    private long updateCount;
    protected long currentPos;
    protected long length;

    protected UpdateSensitiveLOBLocatorInputStream(ClientConnection con, Lob lob, InputStream is) throws SqlException {
        lob.checkForLocatorValidity();
        this.is = new BufferedInputStream(is);
        this.currentPos = 1L;
        this.con = con;
        this.lob = lob;
        this.updateCount = lob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveLOBLocatorInputStream(ClientConnection con, Lob lob, InputStream is, long pos, long len) throws SqlException {
        this(con, lob, is);
        this.currentPos = pos;
        this.length = len;
    }

    @Override
    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int ret = this.is.read();
        if (ret == -1) {
            return ret;
        }
        ++this.currentPos;
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int ret = this.is.read(b, off, len);
        if (ret == -1) {
            return ret;
        }
        this.currentPos += (long)ret;
        return ret;
    }

    @Override
    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long newUpdateCount = this.lob.getUpdateCount();
        if (this.updateCount != newUpdateCount) {
            try {
                this.is = new BufferedInputStream(this.reCreateStream());
            }
            catch (SqlException sqle) {
                IOException ioe = new IOException();
                ioe.initCause(sqle);
                throw ioe;
            }
            this.updateCount = newUpdateCount;
        }
    }

    protected abstract InputStream reCreateStream() throws SqlException;
}

