/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Enumeration;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementEventsTest
extends BaseJDBCTestCase {
    private boolean xa;
    private boolean callable;
    private Statement closedStatement;
    private int closedCount;
    private Statement errorStatement;
    private int errorCount;
    private PooledConnection pooledConnection;
    private Connection connection;

    public StatementEventsTest(String string) {
        super(string);
    }

    private void setXA(boolean bl) {
        this.xa = bl;
    }

    private void setCallable(boolean bl) {
        this.callable = bl;
    }

    public String getName() {
        return super.getName() + (this.xa ? "_xa" : "_pooled") + (this.callable ? "_callable" : "_prepared");
    }

    public void setUp() throws SQLException {
        Object object;
        if (this.xa) {
            object = J2EEDataSource.getXADataSource();
            J2EEDataSource.setBeanProperty(object, "createDatabase", "create");
            this.pooledConnection = object.getXAConnection();
        } else {
            object = J2EEDataSource.getConnectionPoolDataSource();
            J2EEDataSource.setBeanProperty(object, "createDatabase", "create");
            this.pooledConnection = object.getPooledConnection();
        }
        object = new StatementEventListener(){

            @Override
            public void statementClosed(StatementEvent statementEvent) {
                StatementEventsTest.this.closedStatement = statementEvent.getStatement();
                ++StatementEventsTest.this.closedCount;
            }

            @Override
            public void statementErrorOccurred(StatementEvent statementEvent) {
                StatementEventsTest.this.errorStatement = statementEvent.getStatement();
                ++StatementEventsTest.this.errorCount;
            }
        };
        this.pooledConnection.addStatementEventListener((StatementEventListener)object);
        this.connection = this.pooledConnection.getConnection();
    }

    @Override
    protected void tearDown() throws Exception {
        this.connection.close();
        this.pooledConnection.close();
        this.connection = null;
        this.pooledConnection = null;
        this.closedStatement = null;
        this.errorStatement = null;
        super.tearDown();
    }

    private static Test baseSuite(String string) {
        boolean[] blArray;
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        for (boolean bl : blArray = new boolean[]{true, false}) {
            for (boolean bl2 : blArray) {
                baseTestSuite.addTest((Test)new Suite(bl, bl2));
            }
        }
        return baseTestSuite;
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("StatementEventsTest suite");
        baseTestSuite.addTest(StatementEventsTest.baseSuite("StatementEventsTest:embedded"));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(StatementEventsTest.baseSuite("StatementEventsTest:client")));
        return baseTestSuite;
    }

    private PreparedStatement prepare(String string) throws SQLException {
        if (this.callable) {
            return this.connection.prepareCall(string);
        }
        return this.connection.prepareStatement(string);
    }

    public void testCloseEvent() throws SQLException {
        PreparedStatement preparedStatement = this.prepare("VALUES (1)");
        preparedStatement.close();
        StatementEventsTest.assertSame((String)"Close event raised on wrong statement.", (Object)preparedStatement, (Object)this.closedStatement);
        StatementEventsTest.assertEquals((String)"Incorrect close count.", (int)1, (int)this.closedCount);
    }

    public void testAddNullListener() throws SQLException {
        this.pooledConnection.addStatementEventListener(null);
        PreparedStatement preparedStatement = this.prepare("VALUES (1)");
        preparedStatement.close();
        StatementEventsTest.assertEquals((int)1, (int)this.closedCount);
        StatementEventsTest.assertEquals((int)0, (int)this.errorCount);
        preparedStatement = this.prepare("VALUES (1)");
        this.connection.close();
        try {
            preparedStatement.execute();
            StatementEventsTest.fail((String)"Execute should fail on closed connection");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            StatementEventsTest.assertSQLState("08003", sQLNonTransientConnectionException);
        }
        StatementEventsTest.assertEquals((int)1, (int)this.errorCount);
    }

    public void testRemoveNullListener() throws SQLException {
        this.pooledConnection.removeStatementEventListener(null);
    }

    public void testDoubleAddListener() throws SQLException {
        SimpleListener simpleListener = new SimpleListener();
        this.pooledConnection.addStatementEventListener(simpleListener);
        this.pooledConnection.addStatementEventListener(simpleListener);
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((int)2, (int)simpleListener.getCloseCount());
        StatementEventsTest.assertEquals((int)0, (int)simpleListener.getErrorCount());
        simpleListener.resetCounts();
        PreparedStatement preparedStatement = this.prepare("VALUES (1)");
        this.connection.close();
        StatementEventsTest.assertStatementError("08003", preparedStatement);
        StatementEventsTest.assertEquals((int)2, (int)simpleListener.getErrorCount());
        StatementEventsTest.assertEquals((int)(StatementEventsTest.usingDerbyNetClient() ? 2 : 0), (int)simpleListener.getCloseCount());
    }

    public void testCloseEventOnClosedConnection() throws SQLException {
        PreparedStatement preparedStatement = this.prepare("VALUES (1)");
        this.connection.close();
        if (StatementEventsTest.usingDerbyNetClient()) {
            StatementEventsTest.assertSame((String)"Close event raised on wrong statement.", (Object)preparedStatement, (Object)this.closedStatement);
            StatementEventsTest.assertEquals((String)"Incorrect close count.", (int)1, (int)this.closedCount);
        } else if (StatementEventsTest.usingEmbedded()) {
            StatementEventsTest.assertNull((String)"Didn't expect close event.", (Object)this.closedStatement);
            StatementEventsTest.assertEquals((String)"Incorrect close count.", (int)0, (int)this.closedCount);
        } else {
            StatementEventsTest.fail((String)"Unknown framework.");
        }
    }

    public void testErrorEventOnClosedConnection() throws SQLException {
        PreparedStatement preparedStatement = this.prepare("VALUES (1)");
        this.connection.close();
        try {
            preparedStatement.execute();
            StatementEventsTest.fail((String)"No exception thrown.");
        }
        catch (SQLException sQLException) {
            StatementEventsTest.assertSQLState("Unexpected SQL state.", "08003", sQLException);
            StatementEventsTest.assertSame((String)"Error event raised on wrong statement.", (Object)preparedStatement, (Object)this.errorStatement);
            StatementEventsTest.assertEquals((String)"Incorrect error count.", (int)1, (int)this.errorCount);
        }
    }

    public void testRemoveListenerFromListener() throws SQLException {
        Object object;
        int n;
        final int[] nArray = new int[2];
        for (n = 0; n < 5; ++n) {
            object = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent statementEvent) {
                    StatementEventsTest.this.pooledConnection.removeStatementEventListener(this);
                    nArray[0] = nArray[0] + 1;
                }

                @Override
                public void statementErrorOccurred(StatementEvent statementEvent) {
                }
            };
            this.pooledConnection.addStatementEventListener((StatementEventListener)object);
            StatementEventListener statementEventListener = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent statementEvent) {
                }

                @Override
                public void statementErrorOccurred(StatementEvent statementEvent) {
                    StatementEventsTest.this.pooledConnection.removeStatementEventListener(this);
                    nArray[1] = nArray[1] + 1;
                }
            };
            this.pooledConnection.addStatementEventListener(statementEventListener);
        }
        for (n = 0; n < 2; ++n) {
            this.prepare("VALUES (1)").close();
            StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)5, (int)nArray[0]);
            StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)0, (int)nArray[1]);
        }
        Arrays.fill(nArray, 0);
        for (n = 0; n < 2; ++n) {
            object = this.prepare("VALUES (1)");
            this.connection.close();
            try {
                object.execute();
                StatementEventsTest.fail((String)"Execute on closed connection should fail");
            }
            catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
                StatementEventsTest.assertSQLState("08003", sQLNonTransientConnectionException);
            }
            StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)0, (int)nArray[0]);
            StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)5, (int)nArray[1]);
            this.connection = this.pooledConnection.getConnection();
        }
        StatementEventsTest.assertEquals((String)"Incorrect error count", (int)2, (int)this.errorCount);
        if (StatementEventsTest.usingEmbedded()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)2, (int)this.closedCount);
        } else if (StatementEventsTest.usingDerbyNetClient()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)4, (int)this.closedCount);
        } else {
            StatementEventsTest.fail((String)"unknown framework");
        }
    }

    public void testAddListenerFromListener() throws SQLException {
        final int[] nArray = new int[4];
        for (int i = 0; i < 5; ++i) {
            StatementEventListener statementEventListener = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent statementEvent) {
                    nArray[0] = nArray[0] + 1;
                    StatementEventsTest.this.pooledConnection.addStatementEventListener(new StatementEventListener(){

                        @Override
                        public void statementClosed(StatementEvent statementEvent) {
                            nArray[2] = nArray[2] + 1;
                        }

                        @Override
                        public void statementErrorOccurred(StatementEvent statementEvent) {
                            nArray[2] = nArray[2] + 1;
                        }
                    });
                }

                @Override
                public void statementErrorOccurred(StatementEvent statementEvent) {
                }
            };
            this.pooledConnection.addStatementEventListener(statementEventListener);
            StatementEventListener statementEventListener2 = new StatementEventListener(){

                @Override
                public void statementClosed(StatementEvent statementEvent) {
                }

                @Override
                public void statementErrorOccurred(StatementEvent statementEvent) {
                    nArray[1] = nArray[1] + 1;
                    StatementEventsTest.this.pooledConnection.addStatementEventListener(new StatementEventListener(){

                        @Override
                        public void statementClosed(StatementEvent statementEvent) {
                            nArray[3] = nArray[3] + 1;
                        }

                        @Override
                        public void statementErrorOccurred(StatementEvent statementEvent) {
                            nArray[3] = nArray[3] + 1;
                        }
                    });
                }
            };
            this.pooledConnection.addStatementEventListener(statementEventListener2);
        }
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)5, (int)nArray[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)0, (int)nArray[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)0, (int)nArray[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)0, (int)nArray[3]);
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)10, (int)nArray[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)0, (int)nArray[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)5, (int)nArray[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)0, (int)nArray[3]);
        PreparedStatement preparedStatement = this.prepare("VALUES (1)");
        this.connection.close();
        Arrays.fill(nArray, 0);
        try {
            preparedStatement.execute();
            StatementEventsTest.fail((String)"Execute on closed connection should fail");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            StatementEventsTest.assertSQLState("08003", sQLNonTransientConnectionException);
        }
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)0, (int)nArray[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)5, (int)nArray[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)(StatementEventsTest.usingEmbedded() ? 10 : 15), (int)nArray[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)0, (int)nArray[3]);
        Arrays.fill(nArray, 0);
        try {
            preparedStatement.execute();
            StatementEventsTest.fail((String)"Execute on closed connection should fail");
        }
        catch (SQLNonTransientConnectionException sQLNonTransientConnectionException) {
            StatementEventsTest.assertSQLState("08003", sQLNonTransientConnectionException);
        }
        StatementEventsTest.assertEquals((String)"unexpected number of close events", (int)0, (int)nArray[0]);
        StatementEventsTest.assertEquals((String)"unexpected number of error events", (int)5, (int)nArray[1]);
        StatementEventsTest.assertEquals((String)"unexpected number of added close listeners triggered", (int)(StatementEventsTest.usingEmbedded() ? 10 : 15), (int)nArray[2]);
        StatementEventsTest.assertEquals((String)"unexpected number of added error listeners triggered", (int)5, (int)nArray[3]);
        StatementEventsTest.assertEquals((String)"Incorrect error count", (int)2, (int)this.errorCount);
        if (StatementEventsTest.usingEmbedded()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)2, (int)this.closedCount);
        } else if (StatementEventsTest.usingDerbyNetClient()) {
            StatementEventsTest.assertEquals((String)"Incorrect close count", (int)3, (int)this.closedCount);
        } else {
            StatementEventsTest.fail((String)"unknown framework");
        }
    }

    public void testAddRemoveListenerOnClosedObject() throws SQLException {
        SimpleListener simpleListener = new SimpleListener();
        this.pooledConnection.addStatementEventListener(simpleListener);
        this.pooledConnection.close();
        this.pooledConnection.removeStatementEventListener(simpleListener);
        this.pooledConnection.addStatementEventListener(new SimpleListener());
    }

    public void testRemoveListenerNotAddedFirst() throws SQLException {
        this.pooledConnection.removeStatementEventListener(new SimpleListener());
        this.prepare("VALUES (1)").close();
        StatementEventsTest.assertEquals((int)1, (int)this.closedCount);
        StatementEventsTest.assertEquals((int)0, (int)this.errorCount);
    }

    private static class Suite
    extends BaseTestSuite {
        private Suite(boolean bl, boolean bl2) {
            super(StatementEventsTest.class);
            Enumeration enumeration = this.tests();
            while (enumeration.hasMoreElements()) {
                StatementEventsTest statementEventsTest = (StatementEventsTest)((Object)enumeration.nextElement());
                statementEventsTest.setXA(bl);
                statementEventsTest.setCallable(bl2);
            }
        }
    }

    private static class SimpleListener
    implements StatementEventListener {
        private int closeCount;
        private int errorCount;

        private SimpleListener() {
        }

        @Override
        public void statementClosed(StatementEvent statementEvent) {
            ++this.closeCount;
        }

        @Override
        public void statementErrorOccurred(StatementEvent statementEvent) {
            ++this.errorCount;
        }

        private int getCloseCount() {
            return this.closeCount;
        }

        private int getErrorCount() {
            return this.errorCount;
        }

        private void resetCounts() {
            this.closeCount = 0;
            this.errorCount = 0;
        }
    }
}

