/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.db;

import java.sql.SQLException;
import org.apache.derby.iapi.security.Securable;
import org.apache.derby.iapi.security.SecurityUtil;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.conn.ConnectionUtil;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GenericScanController;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;

public class ConsistencyChecker {
    private ConsistencyChecker() {
    }

    public static boolean checkTable(String string, String string2) throws SQLException {
        long l = -1L;
        RowLocation rowLocation = null;
        RowLocation rowLocation2 = null;
        GenericScanController genericScanController = null;
        int n = 0;
        ConglomerateController conglomerateController = null;
        ConglomerateController conglomerateController2 = null;
        LanguageConnectionContext languageConnectionContext = ConnectionUtil.getCurrentLCC();
        TransactionController transactionController = languageConnectionContext.getTransactionExecute();
        try {
            DataValueDescriptor[] dataValueDescriptorArray;
            ConstraintDescriptor constraintDescriptor;
            SecurityUtil.authorize(Securable.CHECK_TABLE);
            DataDictionary dataDictionary = languageConnectionContext.getDataDictionary();
            DataValueFactory dataValueFactory = languageConnectionContext.getDataValueFactory();
            ExecutionFactory executionFactory = languageConnectionContext.getLanguageConnectionFactory().getExecutionFactory();
            SchemaDescriptor schemaDescriptor = dataDictionary.getSchemaDescriptor(string, transactionController, true);
            TableDescriptor tableDescriptor = dataDictionary.getTableDescriptor(string2, schemaDescriptor, transactionController);
            if (tableDescriptor == null) {
                throw StandardException.newException("42X05", string + "." + string2);
            }
            if (tableDescriptor.getTableType() == 2) {
                boolean bl = true;
                return bl;
            }
            conglomerateController = transactionController.openConglomerate(tableDescriptor.getHeapConglomerateId(), false, 0, 7, 5);
            conglomerateController.checkConsistency();
            ConglomerateDescriptor conglomerateDescriptor = tableDescriptor.getConglomerateDescriptor(tableDescriptor.getHeapConglomerateId());
            ExecRow execRow = executionFactory.getValueRow(tableDescriptor.getNumberOfColumns());
            ColumnDescriptorList columnDescriptorList = tableDescriptor.getColumnDescriptorList();
            int n2 = columnDescriptorList.size();
            for (int i = 0; i < n2; ++i) {
                ColumnDescriptor columnDescriptor = columnDescriptorList.elementAt(i);
                execRow.setColumn(columnDescriptor.getPosition(), columnDescriptor.getType().getNull());
            }
            ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
            for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
                DataValueDescriptor[] dataValueDescriptorArray2;
                int n3;
                ConglomerateDescriptor conglomerateDescriptor2 = conglomerateDescriptorArray[i];
                if (!conglomerateDescriptor2.isIndex()) continue;
                conglomerateController2 = transactionController.openConglomerate(conglomerateDescriptor2.getConglomerateNumber(), false, 0, 7, 5);
                conglomerateController2.checkConsistency();
                conglomerateController2.close();
                conglomerateController2 = null;
                if (conglomerateDescriptor2.isConstraint() && (constraintDescriptor = dataDictionary.getConstraintDescriptor(tableDescriptor, conglomerateDescriptor2.getUUID())) == null) {
                    throw StandardException.newException("42X94", "CONSTRAINT for INDEX", conglomerateDescriptor2.getConglomerateName());
                }
                if (l < 0L) {
                    genericScanController = transactionController.openScan(conglomerateDescriptor.getConglomerateNumber(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 0, null, null, 0);
                    rowLocation = genericScanController.newRowLocationTemplate();
                    rowLocation2 = genericScanController.newRowLocationTemplate();
                    l = 0L;
                    while (genericScanController.next()) {
                        ++l;
                    }
                    genericScanController.close();
                    genericScanController = null;
                }
                int[] nArray = conglomerateDescriptor2.getIndexDescriptor().baseColumnPositions();
                n = nArray.length;
                FormatableBitSet formatableBitSet = new FormatableBitSet();
                for (n3 = 0; n3 < n; ++n3) {
                    formatableBitSet.grow(nArray[n3]);
                    formatableBitSet.set(nArray[n3] - 1);
                }
                ExecRow execRow2 = executionFactory.getValueRow(n + 1);
                for (n3 = 0; n3 < n; ++n3) {
                    dataValueDescriptorArray2 = tableDescriptor.getColumnDescriptor(nArray[n3]);
                    execRow2.setColumn(n3 + 1, dataValueDescriptorArray2.getType().getNull());
                }
                execRow2.setColumn(n + 1, rowLocation);
                genericScanController = transactionController.openScan(conglomerateDescriptor2.getConglomerateNumber(), false, 0, 7, 5, null, null, 0, null, null, 0);
                dataValueDescriptorArray = new DataValueDescriptor[n];
                dataValueDescriptorArray2 = execRow.getRowArray();
                for (int j = 0; j < n; ++j) {
                    dataValueDescriptorArray[j] = dataValueDescriptorArray2[nArray[j] - 1];
                }
                long l2 = 0L;
                while (genericScanController.fetchNext(execRow2.getRowArray())) {
                    RowLocation rowLocation3 = (RowLocation)execRow2.getColumn(n + 1);
                    boolean bl = conglomerateController.fetch(rowLocation3, dataValueDescriptorArray2, formatableBitSet);
                    if (!bl) {
                        String string3 = conglomerateDescriptor2.getConglomerateName();
                        throw StandardException.newException("X0X62.S", string + "." + string2, string3, rowLocation3.toString(), execRow2.toString());
                    }
                    for (int j = 0; j < n; ++j) {
                        DataValueDescriptor dataValueDescriptor;
                        DataValueDescriptor dataValueDescriptor2 = execRow2.getColumn(j + 1);
                        if (dataValueDescriptor2.compare(dataValueDescriptor = dataValueDescriptorArray[j]) == 0) continue;
                        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[j]);
                        throw StandardException.newException("X0X61.S", conglomerateDescriptor2.getConglomerateName(), tableDescriptor.getSchemaName(), tableDescriptor.getName(), rowLocation3.toString(), columnDescriptor.getColumnName(), dataValueDescriptor2.toString(), dataValueDescriptor.toString(), execRow2.toString());
                    }
                    ++l2;
                }
                genericScanController.close();
                genericScanController = null;
                if (l2 == l) continue;
                throw StandardException.newException("X0Y55.S", conglomerateDescriptor2.getConglomerateName(), tableDescriptor.getSchemaName(), tableDescriptor.getName(), Long.toString(l2), Long.toString(l));
            }
            ConstraintDescriptorList constraintDescriptorList = dataDictionary.getConstraintDescriptors(tableDescriptor);
            for (int i = 0; i < constraintDescriptorList.size(); ++i) {
                constraintDescriptor = constraintDescriptorList.elementAt(i);
                if (!constraintDescriptor.hasBackingIndex() || (dataValueDescriptorArray = tableDescriptor.getConglomerateDescriptor(constraintDescriptor.getConglomerateId())) != null) continue;
                throw StandardException.newException("42X94", "INDEX for CONSTRAINT", constraintDescriptor.getConstraintName());
            }
        }
        catch (StandardException standardException) {
            throw PublicAPI.wrapStandardException(standardException);
        }
        finally {
            try {
                if (conglomerateController != null) {
                    conglomerateController.close();
                    conglomerateController = null;
                }
                if (conglomerateController2 != null) {
                    conglomerateController2.close();
                    conglomerateController2 = null;
                }
                if (genericScanController != null) {
                    genericScanController.close();
                    genericScanController = null;
                }
            }
            catch (StandardException standardException) {
                throw PublicAPI.wrapStandardException(standardException);
            }
        }
        return true;
    }
}

