/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURBaseTest;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.SURDataModelSetup;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConcurrencyTest
extends SURBaseTest {
    public ConcurrencyTest(String string) {
        super(string);
    }

    public void setUp() throws Exception {
        SURDataModelSetup.createDataModel(SURDataModelSetup.SURDataModel.MODEL_WITH_PK, this.getConnection());
        this.commit();
    }

    @Override
    public void tearDown() throws Exception {
        this.rollback();
        this.dropTable("T1");
        this.commit();
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testUpdateLockDownGrade1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        while (resultSet.next()) {
        }
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement(1003, 1008);
        ResultSet resultSet2 = statement2.executeQuery("select * from t1 for update");
        try {
            resultSet2.next();
        }
        catch (SQLException sQLException) {
            ConcurrencyTest.assertEquals((String)"Unexpected SQL state", (String)"40XL1", (String)sQLException.getSQLState());
            return;
        }
        finally {
            connection.rollback();
        }
        ConcurrencyTest.assertTrue((String)"Expected Derby to hold updatelocks in RR mode", (boolean)false);
        statement2.close();
        connection.close();
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAquireUpdateLock1() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
        }
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement(1003, 1008);
        ResultSet resultSet2 = statement2.executeQuery("select * from t1 for update");
        try {
            resultSet2.next();
        }
        finally {
            connection.rollback();
        }
        statement2.close();
        connection.close();
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLocks1() throws SQLException {
        Statement statement = this.createStatement(1003, 1007);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForward(resultSet);
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement(1003, 1007);
        try {
            ResultSet resultSet2 = statement2.executeQuery("select * from t1");
            this.scrollForward(resultSet2);
        }
        finally {
            resultSet.close();
            connection.rollback();
            connection.close();
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedLocks2() throws SQLException {
        Statement statement = this.createStatement();
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForward(resultSet);
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement();
        try {
            ResultSet resultSet2 = statement2.executeQuery("select * from t1");
            this.scrollForward(resultSet2);
        }
        finally {
            resultSet.close();
            connection.rollback();
            connection.close();
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedAndUpdateLocks1() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        this.scrollForward(resultSet);
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement(1003, 1007);
        try {
            ResultSet resultSet2 = statement2.executeQuery("select * from t1");
            this.scrollForward(resultSet2);
        }
        finally {
            resultSet.close();
            connection.rollback();
            connection.close();
        }
        statement.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSharedAndUpdateLocks2() throws SQLException {
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        this.scrollForward(resultSet);
        Connection connection = this.openDefaultConnection();
        Statement statement2 = connection.createStatement(1003, 1007);
        try {
            ResultSet resultSet2 = statement2.executeQuery("select * from t1");
            this.scrollForward(resultSet2);
        }
        finally {
            resultSet.close();
            connection.rollback();
            connection.close();
        }
        statement.close();
    }

    public void testUpdatePurgedTuple1() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        int n = resultSet.getInt(1);
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        int n2 = n;
        while (resultSet.next()) {
            n2 = resultSet.getInt(1);
            ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from t1 where id=? or id=?");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            ConcurrencyTest.assertEquals((String)"Expected two records to be deleted", (int)2, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T2: Deleted records with id=" + n + " and id=" + n2);
            connection.commit();
            ConcurrencyTest.println("T2: commit");
            preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
            preparedStatement.setString(1, "APP");
            preparedStatement.setString(2, "T1");
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 0);
            preparedStatement.setInt(5, 0);
            ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
            ConcurrencyTest.println("T3: purges deleted records");
            preparedStatement.executeUpdate();
            connection.commit();
            ConcurrencyTest.println("T3: commit");
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        resultSet.first();
        ConcurrencyTest.println("T1: Read first Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        resultSet.last();
        ConcurrencyTest.println("T1: Read last Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        resultSet = statement.executeQuery("select * from t1");
        ConcurrencyTest.println("T3: select * from table");
        while (resultSet.next()) {
            ConcurrencyTest.println("T3: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
        statement.close();
    }

    public void testUpdatePurgedTuple2() throws SQLException {
        PreparedStatement preparedStatement;
        this.getConnection().setTransactionIsolation(2);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        int n = resultSet.getInt(1);
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        try {
            preparedStatement = connection.prepareStatement("delete from t1 where id=?");
            preparedStatement.setInt(1, n);
            ConcurrencyTest.assertEquals((String)"Expected one record to be deleted", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T2: Deleted record with id=" + n);
            connection.commit();
            ConcurrencyTest.println("T2: commit");
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        resultSet.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        preparedStatement = this.prepareStatement("update T1 set a=? where current of " + resultSet.getCursorName());
        preparedStatement.setInt(1, 3);
        int n2 = preparedStatement.executeUpdate();
        ConcurrencyTest.println("T1: update table, set a=3 where current of " + resultSet.getCursorName());
        ConcurrencyTest.println("T1: commit");
        this.commit();
        resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
            ConcurrencyTest.println("T3: Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
    }

    public void testUpdatePurgedTuple3() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        int n = resultSet.getInt(1);
        ConcurrencyTest.println("T1: read tuple with key " + n);
        resultSet.next();
        ConcurrencyTest.println("T1: read next tuple");
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from t1 where id=?");
            preparedStatement.setInt(1, n);
            ConcurrencyTest.assertEquals((String)"Expected one record to be deleted", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T2: Deleted record with id=" + n);
            connection.commit();
            ConcurrencyTest.println("T2: commit");
            preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
            preparedStatement.setString(1, "APP");
            preparedStatement.setString(2, "T1");
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 0);
            preparedStatement.setInt(5, 0);
            ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
            ConcurrencyTest.println("T3: purges deleted records");
            preparedStatement.executeUpdate();
            connection.commit();
            preparedStatement = connection.prepareStatement("insert into t1 values(?,?,?,?,?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, -1);
            preparedStatement.setInt(3, -1);
            preparedStatement.setString(4, "UPDATED TUPLE");
            preparedStatement.setString(5, "UPDATED CLOB");
            ConcurrencyTest.assertEquals((String)"Expected one record to be inserted", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T4: Inserted record (" + n + ",-1,-1)");
            connection.commit();
            ConcurrencyTest.println("T4: commit");
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        ConcurrencyTest.println("T1: read previous tuple");
        resultSet.previous();
        ConcurrencyTest.println("T1: id=" + resultSet.getInt(1));
        resultSet.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updated column 2, to value=3");
        ConcurrencyTest.println("T1: commit");
        this.commit();
        resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
            ConcurrencyTest.println("T5: Read Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
    }

    public void testUpdatePurgedTuple4() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        int n = resultSet.getInt(1);
        int n2 = resultSet.getInt(2);
        int n3 = resultSet.getInt(3);
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("delete from t1 where id=?");
            preparedStatement.setInt(1, n);
            ConcurrencyTest.assertEquals((String)"Expected one record to be deleted", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T2: Deleted record with id=" + n);
            connection.commit();
            ConcurrencyTest.println("T2: commit");
            preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
            preparedStatement.setString(1, "APP");
            preparedStatement.setString(2, "T1");
            preparedStatement.setInt(3, 1);
            preparedStatement.setInt(4, 0);
            preparedStatement.setInt(5, 0);
            ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
            ConcurrencyTest.println("T3: purges deleted records");
            preparedStatement.executeUpdate();
            connection.commit();
            ConcurrencyTest.println("T3: commit");
            preparedStatement = connection.prepareStatement("insert into t1 values(?,?,?,?,?)");
            preparedStatement.setInt(1, n);
            preparedStatement.setInt(2, n2);
            preparedStatement.setInt(3, n3);
            preparedStatement.setString(4, "UPDATE TUPLE " + n);
            preparedStatement.setString(5, "UPDATED CLOB " + n);
            ConcurrencyTest.assertEquals((String)"Expected one record to be inserted", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T4: Inserted record (" + n + "," + n2 + "," + n3 + ")");
            connection.commit();
            ConcurrencyTest.println("T4: commit");
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        resultSet.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        ConcurrencyTest.println("T1: id=" + resultSet.getInt(1));
        resultSet.updateInt(2, 3);
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updated column 2, to value=3");
        ConcurrencyTest.println("T1: commit");
        this.commit();
        resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
            ConcurrencyTest.println("T4: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
    }

    public void testUpdateModifiedTuple1() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        int n = resultSet.getInt(1);
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update t1 set b=? where id=?");
            preparedStatement.setInt(1, 999);
            preparedStatement.setInt(2, n);
            ConcurrencyTest.assertEquals((String)"Expected one record to be updated", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T2: Updated b=999 where id=" + n);
            connection.commit();
            ConcurrencyTest.println("T2: commit");
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        resultSet.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.updateInt(2, 3);
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updated column 2, to value=3");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
            ConcurrencyTest.println("T3: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
    }

    public void testUpdateModifiedTuple2() throws SQLException {
        this.getConnection().setTransactionIsolation(2);
        Statement statement = this.createStatement(1004, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        int n = resultSet.getInt(1);
        resultSet.next();
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("update t1 set b=? where id=?");
            preparedStatement.setInt(1, 999);
            preparedStatement.setInt(2, n);
            ConcurrencyTest.assertEquals((String)"Expected one record to be updated", (int)1, (int)preparedStatement.executeUpdate());
            ConcurrencyTest.println("T2: Updated b=999 where id=" + n);
            connection.commit();
            ConcurrencyTest.println("T2: commit");
        }
        catch (SQLException sQLException) {
            connection.rollback();
            throw sQLException;
        }
        resultSet.previous();
        ConcurrencyTest.println("T1: Read previous Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.updateInt(3, 9999);
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updated column 3, to value=9999");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        resultSet = statement.executeQuery("select * from t1");
        while (resultSet.next()) {
            ConcurrencyTest.println("T3: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
    }

    public void testTableIntentLock1() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement statement = this.createStatement(1004, 1008);
        ConcurrencyTest.println("T1: select * from t1");
        ResultSet resultSet = statement.executeQuery("select * from t1 for update");
        while (resultSet.next()) {
            ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        PreparedStatement preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(?, ?, ?)");
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "T1");
        preparedStatement.setInt(3, 0);
        ConcurrencyTest.println("T2: call SYSCS_UTIL.SYSCS_COMPRESS_TABLE(APP, T1, 0)");
        try {
            preparedStatement.executeUpdate();
            ConcurrencyTest.fail((String)"Expected T2 to hang");
        }
        catch (SQLException sQLException) {
            ConcurrencyTest.println("T2: Got exception:" + sQLException.getMessage());
            ConcurrencyTest.assertSQLState("38000", sQLException);
        }
        preparedStatement.close();
        connection.rollback();
        connection.close();
        statement.close();
    }

    public void testUpdateLockInReadUncommitted() throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement statement = this.createStatement(1003, 1008);
        ResultSet resultSet = statement.executeQuery("select * from t1");
        resultSet.next();
        int n = resultSet.getInt(1);
        ConcurrencyTest.println("T1: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(2);
        PreparedStatement preparedStatement = connection.prepareStatement("delete from t1 where id=?");
        preparedStatement.setInt(1, n);
        try {
            preparedStatement.executeUpdate();
            ConcurrencyTest.fail((String)("expected record with id=" + n + " to be locked"));
        }
        catch (SQLException sQLException) {
            ConcurrencyTest.assertSQLState("40XL1", sQLException);
        }
        preparedStatement.close();
        connection.rollback();
        connection.close();
        statement.close();
    }

    public void testDefragmentDuringScan() throws SQLException {
        this.testCompressDuringScan(true, false);
    }

    public void testTruncateDuringScan() throws SQLException {
        this.testCompressDuringScan(false, true);
    }

    private void testCompressDuringScan(boolean bl, boolean bl2) throws SQLException {
        this.getConnection().setTransactionIsolation(1);
        Statement statement = this.createStatement();
        int n = statement.executeUpdate("delete from T1 where id>0 and id<" + (this.recordCount - 1));
        int n2 = this.recordCount - 2;
        ConcurrencyTest.println("T1: delete records");
        ConcurrencyTest.assertEquals((String)"Invalid number of records deleted", (int)n2, (int)n);
        statement.close();
        this.commit();
        ConcurrencyTest.println("T1: commit");
        Statement statement2 = this.createStatement(1004, 1008);
        ResultSet resultSet = statement2.executeQuery("select * from t1");
        resultSet.next();
        int n3 = resultSet.getInt(1);
        ConcurrencyTest.println("T2: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        int n4 = n3;
        while (resultSet.next()) {
            n4 = resultSet.getInt(1);
            ConcurrencyTest.println("T2: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        Connection connection = this.openDefaultConnection();
        connection.setTransactionIsolation(1);
        PreparedStatement preparedStatement = connection.prepareStatement("call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE(?,?,?,?,?)");
        preparedStatement.setString(1, "APP");
        preparedStatement.setString(2, "T1");
        preparedStatement.setInt(3, 0);
        int n5 = bl ? 1 : 0;
        int n6 = bl2 ? 1 : 0;
        preparedStatement.setInt(4, n5);
        preparedStatement.setInt(5, n6);
        ConcurrencyTest.println("T3: call SYSCS_UTIL.SYSCS_INPLACE_COMPRESS_TABLE");
        ConcurrencyTest.println("T3: defragmenting rows");
        try {
            preparedStatement.executeUpdate();
            connection.commit();
            ConcurrencyTest.println("T3: commit");
            ConcurrencyTest.fail((String)"Expected T3 to hang waiting for Table lock");
        }
        catch (SQLException sQLException) {
            ConcurrencyTest.println("T3: got expected exception");
            connection.rollback();
        }
        preparedStatement.close();
        resultSet.first();
        ConcurrencyTest.println("T1: Read first Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        resultSet.last();
        ConcurrencyTest.println("T1: Read last Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        resultSet.updateInt(2, 3);
        ConcurrencyTest.println("T1: updateInt(2, 3);");
        resultSet.updateRow();
        ConcurrencyTest.println("T1: updateRow()");
        this.commit();
        ConcurrencyTest.println("T1: commit");
        resultSet = statement2.executeQuery("select * from t1");
        ConcurrencyTest.println("T4: select * from table");
        while (resultSet.next()) {
            ConcurrencyTest.println("T4: Read next Tuple:(" + resultSet.getInt(1) + "," + resultSet.getInt(2) + "," + resultSet.getInt(3) + ")");
        }
        connection.close();
        statement2.close();
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ConcurrencyTest");
        baseTestSuite.addTest(ConcurrencyTest.baseSuite("ConcurrencyTest:embedded", true));
        baseTestSuite.addTest(TestConfiguration.clientServerDecorator(ConcurrencyTest.baseSuite("ConcurrencyTest:client", false)));
        return DatabasePropertyTestSetup.setLockTimeouts((Test)baseTestSuite, -1, 4);
    }

    private static Test baseSuite(String string, boolean bl) {
        BaseTestSuite baseTestSuite = new BaseTestSuite(string);
        baseTestSuite.addTest((Test)new ConcurrencyTest("testSharedLocks2"));
        if (JDBC.vmSupportsJDBC3() || JDBC.vmSupportsJSR169()) {
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdateLockDownGrade1"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testAquireUpdateLock1"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testSharedLocks1"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testSharedAndUpdateLocks1"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testSharedAndUpdateLocks2"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple2"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple3"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple4"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdateModifiedTuple1"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdateModifiedTuple2"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testTableIntentLock1"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdateLockInReadUncommitted"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testDefragmentDuringScan"));
            baseTestSuite.addTest((Test)new ConcurrencyTest("testTruncateDuringScan"));
            if (bl) {
                baseTestSuite.addTest((Test)new ConcurrencyTest("testUpdatePurgedTuple1"));
            }
        }
        return baseTestSuite;
    }
}

