/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.init;

import java.io.PrintWriter;
import java.net.InetAddress;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.system.nstest.NsTest;

public class NWServerThread
extends Thread {
    InetAddress inetaddr = null;
    String address = "localhost";
    int port = 1900;

    public NWServerThread(String string, int n) throws Exception {
        if (string != null && !string.equals("")) {
            this.address = string;
        }
        if (n > 0) {
            this.port = n;
        }
        try {
            this.inetaddr = InetAddress.getByName(string);
        }
        catch (Exception exception) {
            NsTest.logger.println("Invalid host address passed, cannot start server");
            if (NsTest.justCountErrors()) {
                NsTest.printException(NWServerThread.class.getName(), exception);
            } else {
                exception.printStackTrace(NsTest.logger);
            }
            throw exception;
        }
    }

    @Override
    public void run() {
        try {
            NetworkServerControl networkServerControl = new NetworkServerControl(this.inetaddr, this.port);
            networkServerControl.start(new PrintWriter(NsTest.logger));
            NsTest.logger.println("===> Derby Network Server on " + this.address + ":" + this.port + " <===");
        }
        catch (Exception exception) {
            if (NsTest.justCountErrors()) {
                NsTest.printException(NWServerThread.class.getName(), exception);
            }
            exception.printStackTrace(NsTest.logger);
        }
    }
}

