/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.load;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.derbyTesting.system.oe.load.SimpleInsert;

public class ThreadInsert
extends SimpleInsert
implements Runnable {
    private final ThreadInsert master;
    private SQLException loadExceptions;
    private int threadCount;
    private DataSource ds;
    private short nextWarehouse = 1;

    public ThreadInsert(DataSource dataSource) {
        this.master = this;
        this.ds = dataSource;
    }

    private ThreadInsert(ThreadInsert threadInsert) {
        this.master = threadInsert;
    }

    @Override
    public void setupLoad(Connection connection, short s) throws SQLException {
        super.setupLoad(connection, s);
        int n = Runtime.getRuntime().availableProcessors();
        this.setThreadCount(n);
    }

    @Override
    public void setThreadCount(int n) {
        if (this.scale == 1) {
            this.threadCount = 1;
            return;
        }
        if (this.scale < n) {
            this.threadCount = this.scale;
            return;
        }
        this.threadCount = n;
    }

    @Override
    public void populateAllTables() throws Exception {
        if (this.threadCount == 1) {
            super.populateAllTables();
        } else {
            this.threadPopulate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void threadPopulate() throws SQLException, InterruptedException {
        int n;
        Thread[] threadArray = new Thread[this.threadCount - 1];
        for (n = 1; n < this.threadCount; ++n) {
            Thread thread;
            Connection connection = this.ds.getConnection();
            ThreadInsert threadInsert = new ThreadInsert(this);
            threadInsert.setSeed(this.seed * (long)n / 17L);
            threadInsert.setupConnection(connection, this.scale);
            threadInsert.setRandomGenerator();
            threadArray[n - 1] = thread = new Thread((Runnable)threadInsert, "OELoader:" + n);
            thread.start();
        }
        this.itemTable(1, 100000);
        this.run();
        for (n = 0; n < threadArray.length; ++n) {
            threadArray[n].join();
        }
        ThreadInsert threadInsert = this;
        synchronized (threadInsert) {
            if (this.loadExceptions != null) {
                throw this.loadExceptions;
            }
        }
    }

    synchronized short getNextWarehouse() {
        short s = this.nextWarehouse;
        this.nextWarehouse = (short)(s + 1);
        short s2 = s;
        if (s2 > this.scale) {
            return -1;
        }
        return s2;
    }

    synchronized void addException(SQLException sQLException) {
        if (this.loadExceptions == null) {
            this.loadExceptions = sQLException;
        } else {
            SQLException sQLException2;
            SQLException sQLException3 = this.loadExceptions;
            while ((sQLException2 = sQLException3.getNextException()) != null) {
                sQLException3 = sQLException2;
            }
            sQLException3.setNextException(sQLException);
        }
    }

    @Override
    public void run() {
        short s;
        while ((s = this.master.getNextWarehouse()) != -1) {
            try {
                this.populateForOneWarehouse(s);
            }
            catch (SQLException sQLException) {
                this.master.addException(sQLException);
                break;
            }
        }
    }
}

