/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class executeUpdate {
    public static void main(String[] args) {
        try {
            System.out.println("executeUpdate Test Starts");
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            if (conn == null) {
                System.out.println("conn didn't work");
                return;
            }
            Statement stmt = conn.createStatement();
            int rowCount = stmt.executeUpdate("create table exup(a int)");
            if (rowCount != 0) {
                System.out.println("FAIL - non zero return count on create table");
            } else {
                System.out.println("PASS - create table");
            }
            rowCount = stmt.executeUpdate("insert into exup values(1)");
            if (rowCount != 1) {
                System.out.println("FAIL - expected row count 1, got " + rowCount);
            } else {
                System.out.println("PASS - insert 1 row");
            }
            rowCount = stmt.executeUpdate("insert into exup values(2),(3),(4)");
            if (rowCount != 3) {
                System.out.println("FAIL - expected row count 3, got " + rowCount);
            } else {
                System.out.println("PASS - insert 3 rows");
            }
            System.out.println("Rows in table should be 1,2,3,4");
            ResultSet rs = stmt.executeQuery("select * from exup");
            int i = 1;
            boolean fail = false;
            while (rs.next()) {
                int val = rs.getInt(1);
                if (i++ == val) continue;
                System.out.println("FAIL - expecting " + i + " got " + val);
                fail = true;
            }
            if (i != 5) {
                System.out.println("FAIL - too many rows in table");
            } else if (!fail) {
                System.out.println("PASS - correct rows in table");
            }
            rs.close();
            rowCount = stmt.executeUpdate("drop table exup");
            if (rowCount != 0) {
                System.out.println("FAIL - non zero return count on drop table");
            } else {
                System.out.println("PASS - drop table");
            }
            stmt.close();
            System.out.println("executeUpdate Test ends");
            conn.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

