/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.jdbcapi.BLOBDataModelSetup;
import org.apache.derbyTesting.functionTests.util.TestInputStream;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.functionTests.util.streams.ReadOnceByteArrayInputStream;
import org.apache.derbyTesting.functionTests.util.streams.StringReaderWithLength;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;

public final class BLOBTest
extends BaseJDBCTestCase {
    public BLOBTest(String name) {
        super(name);
    }

    public void testUpdateBlobFromScrollableResultSetUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        rs.last();
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, newSize);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(newVal, newSize, rs.getBlob(3));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        while (rs.next()) {
            BLOBTest.println("Next");
            int val = rs.getInt(1);
            if (val != 11) continue;
            break;
        }
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, newSize);
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromScrollableResultSetUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        rs.last();
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithPositionedUpdate(rs, newVal, newSize);
        rs.relative(0);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(newVal, newSize, rs.getBlob(3));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT * from " + BLOBDataModelSetup.getBlobTableName());
        while (rs.next()) {
            BLOBTest.println("Next");
            int val = rs.getInt(1);
            if (val != 11) continue;
            break;
        }
        int newVal = rs.getInt(1) + 11;
        int newSize = rs.getInt(2) / 2;
        this.testUpdateBlobWithPositionedUpdate(rs, newVal, newSize);
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromScrollableResultSetWithProjectUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data,val,length from " + BLOBDataModelSetup.getBlobTableName());
        BLOBTest.println("Last");
        rs.last();
        int newVal = rs.getInt(2) + 11;
        int newSize = rs.getInt(3) / 2;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, newSize);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(newVal, newSize, rs.getBlob(1));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetWithProjectUsingResultSetMethods() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data,val,length from " + BLOBDataModelSetup.getBlobTableName());
        while (rs.next()) {
            BLOBTest.println("Next");
            int val = rs.getInt("VAL");
            if (val != 11) continue;
            break;
        }
        int newVal = rs.getInt("VAL") + 11;
        int newSize = 0x2000000;
        this.testUpdateBlobWithResultSetMethods(rs, newVal, 0x2000000);
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromScrollableResultSetWithProjectUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1004, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data from " + BLOBDataModelSetup.getBlobTableName() + " WHERE val= 11");
        BLOBTest.println("Last");
        rs.last();
        int newVal = 22;
        int newSize = 0x2000000;
        this.testUpdateBlobWithPositionedUpdate(rs, 22, 0x2000000);
        rs.relative(0);
        BLOBTest.println("Verify updated blob using result set");
        this.verifyBlob(22, 0x2000000, rs.getBlob("DATA"));
        rs.close();
        stmt.close();
    }

    public void testUpdateBlobFromForwardOnlyResultSetWithProjectUsingPositionedUpdates() throws SQLException, IOException {
        Statement stmt = this.createStatement(1003, 1008);
        ResultSet rs = stmt.executeQuery("SELECT data from " + BLOBDataModelSetup.getBlobTableName() + " WHERE val = 11");
        rs.next();
        int newVal = 22;
        int newSize = 0x2000000;
        this.testUpdateBlobWithPositionedUpdate(rs, 22, 0x2000000);
        rs.close();
        stmt.close();
    }

    private void testUpdateBlobWithResultSetMethods(ResultSet rs, int newVal, int newSize) throws SQLException, IOException {
        int val = rs.getInt("VAL");
        int size = rs.getInt("LENGTH");
        BLOBTest.println("VerifyBlob");
        this.verifyBlob(val, size, rs.getBlob("DATA"));
        BLOBTest.println("UpdateBlob");
        TestInputStream newStream = new TestInputStream(newSize, newVal);
        rs.updateInt("VAL", newVal);
        rs.updateInt("LENGTH", newSize);
        rs.updateBinaryStream("DATA", (InputStream)newStream, newSize);
        rs.updateRow();
        BLOBTest.println("Verify updated blob with another query");
        this.verifyNewValueInTable(newVal, newSize);
    }

    private void testUpdateBlobWithPositionedUpdate(ResultSet rs, int newVal, int newSize) throws SQLException, IOException {
        PreparedStatement preparedStatement = this.prepareStatement("UPDATE " + BLOBDataModelSetup.getBlobTableName() + " SET val=?, length = ?, data = ? WHERE CURRENT OF " + rs.getCursorName());
        BLOBTest.println("UpdateBlob");
        TestInputStream newStream = new TestInputStream(newSize, newVal);
        preparedStatement.setInt(1, newVal);
        preparedStatement.setInt(2, newSize);
        preparedStatement.setBinaryStream(3, (InputStream)newStream, newSize);
        preparedStatement.executeUpdate();
        BLOBTest.println("Verify updated blob with another query");
        this.verifyNewValueInTable(newVal, newSize);
    }

    public void testBlobCastInValuesClause() throws IOException, SQLException {
        int length = 38912;
        PreparedStatement ps = this.prepareStatement("values cast(? as blob)");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(38912L), 38912);
        ResultSet rs = ps.executeQuery();
        BLOBTest.assertTrue((boolean)rs.next());
        Blob b = rs.getBlob(1);
        BLOBTest.assertEquals((long)38912L, (long)b.length());
        BLOBTest.assertEquals((int)100, (int)b.getBytes(32741L, 100).length);
        BLOBTest.assertEquals((int)1029, (int)b.getBytes(19456L, 1029).length);
        BLOBTest.assertEquals(new LoopingAlphabetStream(38912L), b.getBinaryStream());
        BLOBTest.assertEquals((long)-1L, (long)b.position(new byte[]{97, 65}, 1L));
        BLOBTest.assertEquals((long)38912L, (long)b.length());
        BLOBTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testDerby4477_3645_3646_Repro() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V BLOB(590473235) )");
        PreparedStatement ps = this.prepareStatement("INSERT INTO T_MAIN(V) VALUES (?)");
        byte[] bytes = new byte[35000];
        for (int i = 0; i < 35000; ++i) {
            bytes[i] = (byte)i;
        }
        ps.setBytes(1, bytes);
        ps.executeUpdate();
        ps.close();
        s.executeUpdate("CREATE TABLE T_COPY ( V1 BLOB(2M), V2 BLOB(2M))");
        s.executeUpdate("INSERT INTO T_COPY SELECT  V, V FROM T_MAIN");
        ResultSet rs = s.executeQuery("SELECT * FROM T_COPY");
        rs.next();
        String v1 = rs.getString(1);
        String v2 = rs.getString(2);
        BLOBTest.assertEquals((int)v1.length(), (int)v2.length());
        for (int i = 0; i < v1.length(); ++i) {
            BLOBTest.assertEquals((char)v1.charAt(i), (char)v2.charAt(i));
        }
        rs = s.executeQuery("SELECT V from T_MAIN");
        rs.next();
        String v3 = rs.getString(1);
        BLOBTest.assertEquals((int)v1.length(), (int)v3.length());
        for (int i = 0; i < v1.length(); ++i) {
            BLOBTest.assertEquals((char)v1.charAt(i), (char)v3.charAt(i));
        }
        rs = s.executeQuery("SELECT 'I', V, ID, V from T_MAIN");
        rs.next();
        InputStream s1 = rs.getBinaryStream(2);
        for (int i = 0; i < 35000; ++i) {
            BLOBTest.assertEquals((byte)((byte)i), (byte)((byte)s1.read()));
        }
        BLOBTest.assertEquals((int)-1, (int)s1.read());
        s1.close();
        InputStream s2 = rs.getBinaryStream(4);
        for (int i = 0; i < 35000; ++i) {
            BLOBTest.assertEquals((byte)((byte)i), (byte)((byte)s2.read()));
        }
        BLOBTest.assertEquals((int)-1, (int)s2.read());
        s2.close();
        rs.close();
        this.rollback();
    }

    public void testDerby4477_2349_Repro() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V BLOB(590473235) )");
        s.executeUpdate("CREATE TABLE T_ACTION_ROW(ID INT, A CHAR(1), V1 BLOB(590473235), V2 BLOB(590473235) )");
        s.executeUpdate("CREATE TABLE T_ACTION_STATEMENT(ID INT, A CHAR(1), V1 BLOB(590473235), V2 BLOB(590473235) )");
        s.executeUpdate("CREATE TRIGGER AIR AFTER INSERT ON T_MAIN     REFERENCING NEW AS N FOR EACH ROW     INSERT INTO T_ACTION_ROW(A, V1, ID, V2)         VALUES ('I', N.V, N.ID, N.V)");
        s.executeUpdate("CREATE TRIGGER AIS AFTER INSERT ON T_MAIN     REFERENCING NEW_TABLE AS N FOR EACH STATEMENT     INSERT INTO T_ACTION_STATEMENT(A, V1, ID, V2)         SELECT 'I', V, ID, V FROM N");
        s.executeUpdate("INSERT INTO T_MAIN(V) VALUES NULL");
        s.close();
        this.actionTypesCompareMainToAction(1);
        int jdbcType = 2004;
        int precision = 590473235;
        Random r = new Random();
        String ins1 = "INSERT INTO T_MAIN(V) VALUES (?)";
        String ins3 = "INSERT INTO T_MAIN(V) VALUES (?), (?), (?)";
        PreparedStatement ps = this.prepareStatement(ins1);
        BLOBTest.setRandomValue(r, ps, 1, jdbcType, precision);
        ps.executeUpdate();
        ps.close();
        this.actionTypesCompareMainToAction(2);
        ps = this.prepareStatement(ins3);
        BLOBTest.setRandomValue(r, ps, 1, jdbcType, precision);
        BLOBTest.setRandomValue(r, ps, 2, jdbcType, precision);
        BLOBTest.setRandomValue(r, ps, 3, jdbcType, precision);
        ps.executeUpdate();
        ps.close();
        this.actionTypesCompareMainToAction(5);
        this.rollback();
    }

    public void testDerby2992_Repro() throws IOException, SQLException {
        this.setAutoCommit(true);
        String TBL = "D2992BLOB";
        this.getConnection().setTransactionIsolation(1);
        Statement stmt = this.createStatement();
        this.dropTable("D2992BLOB");
        stmt.executeUpdate("create table D2992BLOB (b blob)");
        stmt.close();
        PreparedStatement ps = this.prepareStatement("insert into D2992BLOB values (?)");
        int length = 0x4100000;
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(length), length);
        ps.executeUpdate();
        ps.close();
        stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select B from D2992BLOB");
        BLOBTest.assertTrue((boolean)rs.next());
        InputStream is = rs.getBinaryStream(1);
        int i = is.read();
        BLOBTest.assertTrue((i != -1 ? 1 : 0) != 0);
        Connection secondCon = this.openUserConnection("APP");
        Statement secondStmt = secondCon.createStatement();
        BLOBTest.assertEquals((int)1, (int)secondStmt.executeUpdate("delete from D2992BLOB"));
        secondCon.close();
        byte[] buf = new byte[4096];
        try {
            while (is.read(buf) != -1) {
            }
            BLOBTest.fail((String)"The read should have failed, value has been deleted");
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
    }

    public static void setRandomValue(Random r, PreparedStatement ps, int column, int jdbcType, int precision) throws SQLException, IOException {
        Object val = BLOBTest.getRandomValue(r, jdbcType, precision);
        if (val instanceof StringReaderWithLength) {
            StringReaderWithLength rd = (StringReaderWithLength)val;
            ps.setCharacterStream(column, (Reader)rd, rd.getLength());
        } else if (val instanceof InputStream) {
            InputStream in = (InputStream)val;
            ps.setBinaryStream(column, in, in.available());
        } else {
            ps.setObject(column, val, jdbcType);
        }
    }

    public static Object getRandomValue(Random r, int jdbcType, int precision) throws IOException {
        switch (jdbcType) {
            case 2004: {
                if (precision > 262144) {
                    precision = 262144;
                }
                return new ReadOnceByteArrayInputStream(BLOBTest.randomBinary(r, r.nextInt(precision)));
            }
        }
        BLOBTest.fail((String)("unexpected JDBC Type " + jdbcType));
        return null;
    }

    private static byte[] randomBinary(Random r, int len) {
        byte[] bb = new byte[len];
        for (int i = 0; i < bb.length; ++i) {
            bb[i] = (byte)r.nextInt();
        }
        return bb;
    }

    private void actionTypesCompareMainToAction(int actionCount) throws SQLException, IOException {
        Statement s1 = this.createStatement();
        Statement s2 = this.createStatement();
        String sqlMain = "SELECT ID, V, V FROM T_MAIN ORDER BY 1";
        String sqlActionRow = "SELECT ID, V1, V2 FROM T_ACTION_ROW ORDER BY 1";
        String sqlActionStatement = "SELECT ID, V1, V2 FROM T_ACTION_STATEMENT ORDER BY 1";
        ResultSet rsMain = s1.executeQuery(sqlMain);
        ResultSet rsAction = s2.executeQuery(sqlActionRow);
        JDBC.assertSameContents(rsMain, rsAction);
        rsMain = s1.executeQuery(sqlMain);
        rsAction = s2.executeQuery(sqlActionStatement);
        JDBC.assertSameContents(rsMain, rsAction);
        this.assertTableRowCount("T_ACTION_ROW", actionCount);
        this.assertTableRowCount("T_ACTION_STATEMENT", actionCount);
        s1.close();
        s2.close();
    }

    public void testDerby1511() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table derby1511(b blob)");
        PreparedStatement insert = this.prepareStatement("insert into derby1511(b) values (?)");
        int rows = 20;
        int length = 40000;
        for (int i = 0; i < rows; ++i) {
            insert.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(length), length);
            insert.executeUpdate();
        }
        this.commit();
        ResultSet rs = s.executeQuery("select b from derby1511");
        for (int i = 0; i < rows; ++i) {
            BLOBTest.assertTrue((String)"Too few rows", (boolean)rs.next());
            BLOBTest.assertEquals(new LoopingAlphabetStream(length), rs.getBinaryStream(1));
            this.commit();
        }
        BLOBTest.assertFalse((String)"Too many rows", (boolean)rs.next());
        rs.close();
    }

    private void verifyNewValueInTable(int newVal, int newSize) throws IOException, SQLException {
        BLOBTest.println("Verify new value in table: " + newVal);
        Statement stmt = this.createStatement(1003, 1007);
        ResultSet rs = stmt.executeQuery("SELECT * FROM " + BLOBDataModelSetup.getBlobTableName() + " WHERE val = " + newVal);
        BLOBTest.println("Query executed, calling next");
        boolean foundVal = false;
        while (rs.next()) {
            BLOBTest.println("Next called, verifying row");
            BLOBTest.assertEquals((String)"Unexpected value in val column", (int)newVal, (int)rs.getInt(1));
            this.verifyBlob(newVal, newSize, rs.getBlob(3));
            foundVal = true;
        }
        BLOBTest.assertTrue((String)("No column with value= " + newVal + " found "), (boolean)foundVal);
        rs.close();
        stmt.close();
    }

    private void verifyBlob(int expectedVal, int expectedSize, Blob blob) throws IOException, SQLException {
        InputStream stream = blob.getBinaryStream();
        int blobSize = 0;
        int val = stream.read();
        while (val != -1) {
            ++blobSize;
            if (expectedVal != val) {
                BLOBTest.assertEquals((String)("Unexpected value in stream at position " + blobSize), (int)expectedVal, (int)val);
            }
            val = stream.read();
        }
        stream.close();
        BLOBTest.assertEquals((String)"Unexpected size of stream ", (int)expectedSize, (int)blobSize);
    }

    public static Test suite() {
        BaseTestSuite mainSuite = new BaseTestSuite(BLOBTest.class, "BLOBTest");
        return new BLOBDataModelSetup((Test)mainSuite);
    }

    public final void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
    }
}

