/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.InputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobUpdatableStreamTest
extends BaseJDBCTestCase {
    public BlobUpdatableStreamTest(String name) {
        super(name);
    }

    public void testUpdatableBlob() throws Exception {
        this.getConnection().setAutoCommit(false);
        PreparedStatement ps = this.prepareStatement("insert into testblob values (?)");
        ps.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(0x100000L), 0x100000);
        ps.executeUpdate();
        ps.close();
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from testblob");
        rs.next();
        Blob blob = rs.getBlob(1);
        InputStream is = blob.getBinaryStream();
        long l = is.skip(20L);
        blob.truncate(l);
        int ret = is.read();
        BlobUpdatableStreamTest.assertEquals((String)"stream update failed", (int)-1, (int)ret);
        byte[] buffer = new byte[1024];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)(i % 255);
        }
        blob.setBytes(blob.length() + 1L, buffer);
        byte[] buff = new byte[1024];
        int toRead = 1024;
        while (toRead != 0) {
            long read = is.read(buff, 1024 - toRead, toRead);
            if (read < 0L) {
                BlobUpdatableStreamTest.fail((String)"couldn't retrieve updated value");
            }
            toRead = (int)((long)toRead - read);
        }
        for (int i = 0; i < buffer.length; ++i) {
            BlobUpdatableStreamTest.assertEquals((String)"value retrieved is not same as updated value", (byte)buffer[i], (byte)buff[i]);
        }
        blob = null;
        rs.close();
        stmt.close();
        this.commit();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(BlobUpdatableStreamTest.class);
    }

    public void setUp() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("create table testblob (data blob)");
        stmt.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("drop table testblob");
        stmt.close();
        this.commit();
        super.tearDown();
    }
}

