/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class LargeDataLocksTest
extends BaseJDBCTestCase {
    public LargeDataLocksTest(String name) {
        super(name);
    }

    public void testGetCharacterStream() throws SQLException, IOException {
        int numChars = 0;
        Statement stmt = this.createStatement();
        String sql = "SELECT bc from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        Reader characterStream = rs.getCharacterStream(1);
        int read = characterStream.read();
        while (read != -1) {
            read = characterStream.read();
            ++numChars;
        }
        LargeDataLocksTest.assertEquals((int)38000, (int)numChars);
        rs.close();
        this.assertLockCount(0);
        this.commit();
    }

    public void testGetBytes() throws SQLException {
        Statement stmt = this.createStatement();
        String sql = "SELECT bincol from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        byte[] value = rs.getBytes(1);
        LargeDataLocksTest.assertEquals((int)38000, (int)value.length);
        rs.close();
        this.assertLockCount(0);
        this.commit();
    }

    public void testGetBinaryStream() throws SQLException, IOException {
        int numBytes = 0;
        this.getConnection().setAutoCommit(false);
        Statement stmt = this.createStatement();
        String sql = "SELECT bincol from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        InputStream stream = rs.getBinaryStream(1);
        int read = stream.read();
        while (read != -1) {
            read = stream.read();
            ++numBytes;
        }
        LargeDataLocksTest.assertEquals((int)38000, (int)numBytes);
        rs.close();
        this.assertLockCount(0);
        this.commit();
    }

    public void testGetString() throws SQLException, IOException {
        Statement stmt = this.createStatement();
        String sql = "SELECT bc from t1";
        ResultSet rs = stmt.executeQuery(sql);
        rs.next();
        String value = rs.getString(1);
        LargeDataLocksTest.assertEquals((int)38000, (int)value.length());
        rs.close();
        this.assertLockCount(0);
        this.commit();
    }

    private void assertLockCount(int expected) throws SQLException {
        Connection conn = this.openDefaultConnection();
        Statement stmt = conn.createStatement();
        stmt.execute("call wait_for_post_commit()");
        ResultSet rs = stmt.executeQuery("select * from syscs_diag.lock_table");
        ResultSetMetaData meta = rs.getMetaData();
        StringBuffer msg = new StringBuffer("Unexpected lock count. Contents of lock table:\n");
        int count = 0;
        while (rs.next()) {
            msg.append(count + 1).append(": ");
            for (int col = 1; col <= meta.getColumnCount(); ++col) {
                String name = meta.getColumnName(col);
                Object val = rs.getObject(col);
                msg.append(name).append('=').append(val).append(' ');
            }
            msg.append('\n');
            ++count;
        }
        rs.close();
        stmt.close();
        conn.close();
        LargeDataLocksTest.assertEquals((String)msg.toString(), (int)expected, (int)count);
    }

    public static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(LargeDataLocksTest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                Connection conn = this.getConnection();
                conn.setAutoCommit(false);
                PreparedStatement ps = null;
                String sql = "CREATE TABLE t1 (bc CLOB(1M), bincol BLOB(1M), datalen int)";
                s.executeUpdate(sql);
                sql = "INSERT into t1 values(?,?,?)";
                ps = conn.prepareStatement(sql);
                ps.setCharacterStream(1, (Reader)new StringReader(Utilities.repeatChar("a", 38000)), 38000);
                try {
                    ps.setBytes(2, Utilities.repeatChar("a", 38000).getBytes("US-ASCII"));
                }
                catch (UnsupportedEncodingException ue) {
                    BaseTestCase.fail(ue.getMessage(), ue);
                }
                ps.setInt(3, 38000);
                ps.executeUpdate();
                ps.close();
                s.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
                conn.commit();
            }
        };
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("LargeDataLocksTest");
        suite.addTest(LargeDataLocksTest.baseSuite("LargeDataLocksTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(LargeDataLocksTest.baseSuite("LargeDataLocksTest:client")));
        return suite;
    }
}

