/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.Barrier;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class IndexSplitDeadlockTest
extends BaseJDBCTestCase {
    private List<AsyncThread> threads = new ArrayList<AsyncThread>();

    public IndexSplitDeadlockTest(String name) {
        super(name);
    }

    public static Test suite() {
        Object test = TestConfiguration.embeddedSuite(IndexSplitDeadlockTest.class);
        test = DatabasePropertyTestSetup.singleProperty(test, "derby.locks.deadlockTrace", "true");
        test = new CleanDatabaseTestSetup((Test)test);
        return test;
    }

    @Override
    protected void tearDown() throws Exception {
        this.rollback();
        for (AsyncThread thread : this.threads) {
            thread.waitFor();
        }
        this.threads = null;
        this.setAutoCommit(false);
        JDBC.dropSchema(this.getConnection().getMetaData(), "APP");
        super.tearDown();
    }

    public void testBTreeMaxScan_fetchMaxRowFromBeginning() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table max_scan(x int)");
        s.executeUpdate("create index idx on max_scan(x)");
        PreparedStatement ins = this.prepareStatement("insert into max_scan values ?");
        for (int i = 0; i < 500; ++i) {
            ins.setInt(1, i * 2);
            ins.executeUpdate();
        }
        this.commit();
        s.executeUpdate("delete from max_scan where x > 50");
        this.obstruct("update max_scan set x = x where x = 10", 2000L);
        Thread.sleep(1000L);
        JDBC.assertSingleValueResultSet(s.executeQuery("select max(x) from max_scan --DERBY-PROPERTIES index=IDX"), "50");
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterSplit() throws SQLException {
        int i;
        Statement s = this.createStatement();
        s.executeUpdate("create table t (x int)");
        s.executeUpdate("create index idx on t(x)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i2 = 0; i2 < 400; ++i2) {
            ins.setInt(1, i2);
            ins.executeUpdate();
        }
        ResultSet rs = s.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i3 = 0; i3 < 30; ++i3) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i3, (int)rs.getInt(1));
        }
        Connection c2 = this.openDefaultConnection();
        Statement s2 = c2.createStatement();
        for (i = 0; i < 300; ++i) {
            s2.executeUpdate("insert into t values -1");
        }
        s2.close();
        c2.close();
        for (i = 30; i < 400; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeScanAfterCommitAndSplit() throws SQLException {
        int i;
        this.setAutoCommit(false);
        Statement s1 = this.createStatement();
        s1.executeUpdate("create table t (x int)");
        s1.executeUpdate("create index idx on t(x)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i2 = 0; i2 < 1000; ++i2) {
            ins.setInt(1, i2);
            ins.executeUpdate();
        }
        this.commit();
        IndexSplitDeadlockTest.assertEquals((String)"This test must use a holdable cursor", (int)1, (int)s1.getResultSetHoldability());
        ResultSet rs = s1.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i3 = 0; i3 < 500; ++i3) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i3, (int)rs.getInt(1));
        }
        this.commit();
        Statement s2 = this.createStatement();
        for (i = 0; i < 300; ++i) {
            s2.executeUpdate("insert into t values 498");
        }
        for (i = 500; i < 1000; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeScanAfterCompress() throws Exception {
        this.setAutoCommit(false);
        Statement s1 = this.createStatement();
        s1.executeUpdate("create table t (x int)");
        s1.executeUpdate("create index idx on t(x)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 1000; ++i) {
            ins.setInt(1, i);
            ins.executeUpdate();
        }
        this.commit();
        IndexSplitDeadlockTest.assertEquals((String)"This test must use a holdable cursor", (int)1, (int)s1.getResultSetHoldability());
        ResultSet rs = s1.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 500; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
        }
        this.commit();
        Statement s2 = this.createStatement();
        s2.executeUpdate("delete from t");
        this.commit();
        Thread.sleep(1000L);
        s2.execute("call syscs_util.syscs_inplace_compress_table('APP','T',1,1,1)");
        this.commit();
        int expected = 500;
        while (rs.next()) {
            IndexSplitDeadlockTest.assertTrue((expected < 1000 ? 1 : 0) != 0);
            IndexSplitDeadlockTest.assertEquals((int)expected, (int)rs.getInt(1));
            ++expected;
        }
        rs.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_unique() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table t (x int, constraint c primary key(x))");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            ins.setInt(1, i);
            ins.executeUpdate();
        }
        this.commit();
        this.obstruct("delete from t where x = 100", 2000L);
        Thread.sleep(1000L);
        ResultSet rs = s.executeQuery("select * from t --DERBY-PROPERTIES constraint=C");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_unique_split() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table t (x int, constraint c primary key(x))");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            ins.setInt(1, i);
            ins.executeUpdate();
        }
        this.commit();
        final Barrier barrier = new Barrier(2);
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection conn) throws Exception {
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                s.executeUpdate("update t set x = x where x = 40");
                s.close();
                barrier.await();
                Thread.sleep(1000L);
                PreparedStatement ps = conn.prepareStatement("insert into t values ?");
                for (int i = -1; i > -300; --i) {
                    ps.setInt(1, i);
                    ps.executeUpdate();
                }
                ps.close();
                conn.commit();
            }
        });
        ResultSet rs = s.executeQuery("select * from t --DERBY-PROPERTIES constraint=C");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
            if (i != 0) continue;
            barrier.await();
        }
        IndexSplitDeadlockTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_nonUnique() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table t (x int)");
        s.executeUpdate("create index idx on t(x)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            ins.setInt(1, i);
            ins.executeUpdate();
        }
        this.commit();
        this.obstruct("delete from t where x = 100", 2000L);
        Thread.sleep(1000L);
        ResultSet rs = s.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
        }
        IndexSplitDeadlockTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testBTreeForwardScan_fetchRows_resumeAfterWait_nonUnique_split() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.executeUpdate("create table t (x int)");
        s.executeUpdate("create index idx on t(x)");
        PreparedStatement ins = this.prepareStatement("insert into t values ?");
        for (int i = 0; i < 300; ++i) {
            ins.setInt(1, i);
            ins.executeUpdate();
        }
        this.commit();
        final Barrier barrier = new Barrier(2);
        new AsyncThread(new AsyncTask(){

            @Override
            public void doWork(Connection conn) throws Exception {
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                s.executeUpdate("update t set x = x where x = 40");
                barrier.await();
                Thread.sleep(1000L);
                for (int i = 0; i < 300; ++i) {
                    s.executeUpdate("insert into t values -1");
                }
                s.close();
                conn.commit();
            }
        });
        ResultSet rs = s.executeQuery("select * from t --DERBY-PROPERTIES index=IDX");
        for (int i = 0; i < 300; ++i) {
            IndexSplitDeadlockTest.assertTrue((boolean)rs.next());
            IndexSplitDeadlockTest.assertEquals((int)i, (int)rs.getInt(1));
            if (i != 0) continue;
            barrier.await();
        }
        IndexSplitDeadlockTest.assertFalse((boolean)rs.next());
        rs.close();
    }

    public void testMultipleLastKeyWaitsInMaxScan() throws Exception {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("create table max_scan(x int, y int)");
        s.execute("create index idx on max_scan(x)");
        s.execute("insert into max_scan(x) values 1,2,3");
        this.commit();
        new AsyncThread(new AsyncTask(this){

            @Override
            public void doWork(Connection conn) throws Exception {
                int i;
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                s.execute("update max_scan set y = x where x = 3");
                s.close();
                Thread.sleep(2000L);
                PreparedStatement ps = conn.prepareStatement("insert into max_scan(x) values 4");
                for (i = 0; i < 300; ++i) {
                    ps.execute();
                }
                conn.commit();
                for (i = 0; i < 300; ++i) {
                    ps.execute();
                }
                Thread.sleep(500L);
                conn.commit();
                ps.close();
            }
        });
        int totalWait = 0;
        do {
            Thread.sleep(500L);
        } while (this.numlocks() < 2 && (totalWait += 500) < 60000);
        JDBC.assertSingleValueResultSet(s.executeQuery("select max(x) from max_scan --DERBY-PROPERTIES index=IDX"), "4");
    }

    private int numlocks() throws SQLException {
        Statement s = this.createStatement();
        ResultSet rs = s.executeQuery("SELECT count(*) from syscs_diag.lock_table");
        rs.next();
        int num = rs.getInt(1);
        rs.close();
        return num;
    }

    public void testMultiplePrevKeyWaitsInForwardScan() throws Exception {
        this.setAutoCommit(false);
        this.getConnection().setTransactionIsolation(8);
        Statement s = this.createStatement();
        s.execute("create table fw_scan(x int)");
        s.execute("create index idx on fw_scan(x)");
        s.execute("insert into fw_scan(x) values 100,200,300");
        this.commit();
        new AsyncThread(new AsyncTask(this){

            @Override
            public void doWork(Connection conn) throws Exception {
                int i;
                conn.setAutoCommit(false);
                PreparedStatement ps = conn.prepareStatement("insert into fw_scan values 1");
                ps.execute();
                Thread.sleep(2000L);
                for (i = 0; i < 300; ++i) {
                    ps.execute();
                }
                conn.commit();
                for (i = 0; i < 300; ++i) {
                    ps.execute();
                }
                Thread.sleep(500L);
                conn.rollback();
                ps.close();
            }
        });
        Thread.sleep(1000L);
        JDBC.assertSingleValueResultSet(s.executeQuery("select x from fw_scan --DERBY-PROPERTIES index=IDX\nwhere x >= 100 and x < 200"), "100");
    }

    private void obstruct(final String sql, final long blockMillis) {
        AsyncTask task = new AsyncTask(){

            @Override
            public void doWork(Connection conn) throws Exception {
                conn.setAutoCommit(false);
                Statement s = conn.createStatement();
                s.execute(sql);
                s.close();
                Thread.sleep(blockMillis);
            }
        };
        new AsyncThread(task);
    }

    private class AsyncThread
    implements Runnable {
        private final Thread thread = new Thread(this);
        private final AsyncTask task;
        private Exception error;

        public AsyncThread(AsyncTask task) {
            this.task = task;
            this.thread.start();
            IndexSplitDeadlockTest.this.threads.add(this);
        }

        @Override
        public void run() {
            try {
                Connection conn = IndexSplitDeadlockTest.this.openDefaultConnection();
                try {
                    this.task.doWork(conn);
                }
                finally {
                    JDBC.cleanup(conn);
                }
            }
            catch (Exception e) {
                this.error = e;
            }
        }

        void waitFor() throws Exception {
            this.thread.join();
            if (this.error != null) {
                throw this.error;
            }
        }
    }

    private static interface AsyncTask {
        public void doWork(Connection var1) throws Exception;
    }
}

