/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.DataSource;
import junit.framework.Assert;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class JDBCDataSource {
    public static DataSource getDataSource() {
        return JDBCDataSource.getDataSource(TestConfiguration.getCurrent(), null);
    }

    public static DataSource getDataSource(String dbName) {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "databaseName", dbName);
        return ds;
    }

    public static DataSource getDataSourceLogical(String logicalDatabasename) {
        DataSource ds = JDBCDataSource.getDataSource();
        TestConfiguration current = TestConfiguration.getCurrent();
        String physicalName = current.getPhysicalDatabaseName(logicalDatabasename);
        JDBCDataSource.setBeanProperty(ds, "databaseName", physicalName);
        return ds;
    }

    static DataSource getDataSource(TestConfiguration config, HashMap beanProperties) {
        return (DataSource)JDBCDataSource.getDataSource(config, beanProperties, config.getJDBCClient().getDataSourceClassName());
    }

    static Object getDataSource(TestConfiguration config, HashMap beanProperties, String dsClassName) {
        if (beanProperties == null) {
            beanProperties = JDBCDataSource.getDataSourceProperties(config);
        }
        return JDBCDataSource.getDataSourceObject(dsClassName, beanProperties);
    }

    static HashMap<String, Object> getDataSourceProperties(TestConfiguration config) {
        HashMap<String, Object> beanProperties = new HashMap<String, Object>();
        if (!config.getJDBCClient().isEmbedded()) {
            beanProperties.put("serverName", config.getHostName());
            beanProperties.put("portNumber", config.getPort());
        }
        beanProperties.put("databaseName", config.getDefaultDatabaseName());
        beanProperties.put("user", config.getUserName());
        beanProperties.put("password", config.getUserPassword());
        String attributes = config.getConnectionAttributesString();
        if (attributes != null) {
            beanProperties.put("connectionAttributes", attributes);
        }
        return beanProperties;
    }

    static DataSource getDataSourceObject(String classname, HashMap beanProperties) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> clazz;
            DataSource ds = null;
            if (contextLoader != null) {
                try {
                    clazz = Class.forName(classname, true, contextLoader);
                    ds = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception clazz2) {
                    // empty catch block
                }
            }
            if (ds == null) {
                clazz = Class.forName(classname);
                ds = (DataSource)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            for (String property : beanProperties.keySet()) {
                Object value = beanProperties.get(property);
                JDBCDataSource.setBeanProperty(ds, property, value);
            }
            if (!BaseTestCase.isJ9Platform() && !BaseTestCase.isCVM()) {
                ds.setLoginTimeout(TestConfiguration.getCurrent().getLoginTimeout());
            }
            return ds;
        }
        catch (Exception e) {
            BaseTestCase.printStackTrace(e);
            BaseTestCase.fail("unexpected error: " + e.getMessage(), e);
            return null;
        }
    }

    public static void setBeanProperty(Object ds, String property, Object value) {
        String setterName = JDBCDataSource.getSetterName(property);
        Class<Object> clazz = value.getClass();
        if (Integer.class.equals(clazz)) {
            clazz = Integer.TYPE;
        } else if (Boolean.class.equals(clazz)) {
            clazz = Boolean.TYPE;
        } else if (Short.class.equals(clazz)) {
            clazz = Short.TYPE;
        }
        try {
            Method setter = ds.getClass().getMethod(setterName, clazz);
            setter.invoke(ds, value);
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    public static Object getBeanProperty(Object ds, String property) throws Exception {
        String getterName = JDBCDataSource.getGetterName(property);
        Method getter = ds.getClass().getMethod(getterName, new Class[0]);
        return getter.invoke(ds, new Object[0]);
    }

    public static void clearStringBeanProperty(Object ds, String property) {
        String setterName = JDBCDataSource.getSetterName(property);
        try {
            Method setter = ds.getClass().getMethod(setterName, String.class);
            setter.invoke(ds, new Object[]{null});
        }
        catch (Exception e) {
            Assert.fail((String)e.getMessage());
        }
    }

    private static String getSetterName(String attribute) {
        return "set" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    private static String getGetterName(String attribute) {
        return "get" + Character.toUpperCase(attribute.charAt(0)) + attribute.substring(1);
    }

    public static void shutdownDatabase(DataSource ds) {
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection();
            Assert.fail((String)"Database failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Database shutdown", "08006", e);
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "shutdownDatabase");
        }
    }

    public static void shutEngine(DataSource ds) throws SQLException {
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(ds, "databaseName", "");
        try {
            ds.getConnection();
            Assert.fail((String)"Engine failed to shut down");
        }
        catch (SQLException e) {
            BaseJDBCTestCase.assertSQLState("Engine shutdown", "XJ015", e);
        }
        finally {
            JDBCDataSource.clearStringBeanProperty(ds, "shutdownDatabase");
        }
    }
}

