/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.utils;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Random;
import org.apache.derbyTesting.system.nstest.NsTest;

public class DbUtil {
    private String threadName = "";
    public static final int TCHAR = 0;
    public static final int TDATE = 1;
    public static final int TDECIMAL = 2;
    public static final int TDECIMALNN = 3;
    public static final int TDOUBLE = 4;
    public static final int TFLOAT = 5;
    public static final int TINT = 6;
    public static final int TLONGINT = 7;
    public static final int TNUMERICLARGE = 8;
    public static final int TREAL = 9;
    public static final int TSMALLINT = 10;
    public static final int TTIME = 11;
    public static final int TTIMESTAMP = 12;
    public static final int TVARCHAR = 13;
    public static final int NUMTYPES = 14;
    public static String[] colnames = new String[]{"t_char", "t_date", "t_decimal", "t_decimal_nn", "t_double", "t_float", "t_int", "t_longint", "t_numeric_large", "t_real", "t_smallint", "t_time", "t_timestamp", "t_varchar"};

    public DbUtil(String thName) {
        this.threadName = thName;
    }

    public int add_one_row(Connection conn, String thread_id) throws Exception {
        PreparedStatement ps = null;
        int rowsAdded = 0;
        try {
            int ind;
            ps = conn.prepareStatement(" insert into nstesttab (id, t_char, t_date, t_decimal, t_decimal_nn, t_double,  t_float, t_int, t_longint, t_numeric_large, t_real, t_smallint, t_time, t_timestamp, t_varchar,t_clob,t_blob,sequenceColumn) values ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,cast('00000000000000000000000000000000031' as clob(1K)),cast(X'000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000031' as blob(10K)), next value for nstesttab_seq)");
            Random rand = new Random();
            int id_ind = ind = rand.nextInt();
            Date dt = new Date(1L);
            Time tt = new Time(1L);
            Timestamp ts = new Timestamp(1L);
            String cs = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
            ps.setInt(1, ind);
            int i1 = Math.abs(ind % 100);
            String cs2 = cs.substring(i1, 99) + cs.substring(0, i1);
            int i2 = i1 < 89 ? i1 + 10 : i1;
            ps.setString(2, cs2.substring(0, i2));
            dt.setTime(Math.abs(rand.nextLong() / 150000L));
            ps.setDate(3, dt);
            double t_dec = rand.nextDouble() * Math.pow(10.0, Math.abs(rand.nextInt() % 6));
            ps.setDouble(4, t_dec);
            double t_dec_nn = rand.nextDouble();
            ps.setDouble(5, t_dec_nn);
            double t_doub = rand.nextDouble() * Math.pow(10.0, Math.abs(rand.nextInt() % 300));
            ps.setDouble(6, t_doub);
            float t_flt = rand.nextFloat() * (float)Math.pow(10.0, Math.abs(rand.nextInt() % 30));
            ps.setFloat(7, t_flt);
            int t_intval = rand.nextInt();
            ps.setInt(8, t_intval);
            long t_longval = rand.nextLong();
            ps.setLong(9, t_longval);
            double t_num_lrg = rand.nextDouble() * Math.pow(10.0, Math.abs(rand.nextInt() % 20));
            ps.setDouble(10, t_num_lrg);
            float t_fltval = rand.nextFloat() * (float)Math.pow(10.0, Math.abs(rand.nextInt() % 7));
            ps.setFloat(11, t_fltval);
            int t_smlint = rand.nextInt() % 32768;
            ps.setInt(12, t_smlint);
            tt.setTime(Math.abs(rand.nextInt()));
            ps.setTime(13, tt);
            ts.setTime(Math.abs(rand.nextLong() / 50000L));
            ps.setTimestamp(14, ts);
            ps.setString(15, cs.substring(Math.abs(rand.nextInt() % 100)));
            try {
                rowsAdded = ps.executeUpdate();
            }
            catch (SQLException sqe) {
                if (NsTest.justCountErrors()) {
                    NsTest.addError(sqe);
                }
                if (sqe.getSQLState().equalsIgnoreCase("40XL1")) {
                    NsTest.logger.println("LOCK TIMEOUT obtained during insert - add_one_row() " + sqe.getSQLState());
                }
                if (sqe.getSQLState().equalsIgnoreCase("23505")) {
                    NsTest.logger.println("prevented duplicate row - add_one_row(): " + sqe.getSQLState() + "; " + sqe.getMessage());
                }
                throw sqe;
            }
            if (rowsAdded == 1) {
                NsTest.logger.println(thread_id + " inserted 1 row with id " + id_ind);
            } else {
                NsTest.logger.println("FAIL: " + thread_id + " inserted " + rowsAdded + "rows");
            }
        }
        catch (Exception e) {
            NsTest.logger.println("Exception when preparing or executing insert prepared stmt");
            this.printException("executing/preparing insert stmt in dbUtil", e);
            e.printStackTrace(NsTest.logger);
        }
        return rowsAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update_one_row(Connection conn, String thread_id) throws Exception {
        PreparedStatement ps2 = null;
        String column = null;
        int ind = 0;
        Random rand = new Random();
        int rowsUpdated = 0;
        conn.setTransactionIsolation(2);
        long skey = this.pick_one(conn, thread_id);
        if (skey == 0L) {
            NsTest.logger.println(thread_id + " could not find a row to update or there was an error.");
            return rowsUpdated;
        }
        ind = Math.abs(rand.nextInt());
        column = colnames[ind % 14];
        try {
            ps2 = conn.prepareStatement(" update nstesttab set " + column + " = ?  where serialkey = " + skey);
        }
        catch (Exception e) {
            this.printException("closing update prepared stmt in dbUtil.update_one_row() ", e);
            return rowsUpdated;
        }
        String ds2 = null;
        String cs = "asdf qwerqwer 12341234 ZXCVZXCVZXCV !@#$!@#$ asdfasdf 1 q a z asdf ASDF qwerasdfzxcvasdfqwer1234asd#";
        double d = 0.0;
        float f = 0.0f;
        int type = ind % 14;
        switch (type) {
            case 0: {
                ds2 = cs.substring(Math.abs(rand.nextInt() % 100));
                ps2.setString(1, ds2);
                break;
            }
            case 1: {
                Date dt = new Date(1L);
                dt.setTime(Math.abs(rand.nextLong() / 150000L));
                dt.setTime(Math.abs(rand.nextLong() / 150000L));
                ps2.setDate(1, dt);
                ds2 = dt.toString();
                break;
            }
            case 2: {
                d = rand.nextDouble() * Math.pow(10.0, Math.abs(rand.nextInt() % 6));
                ps2.setDouble(1, d);
                ds2 = String.valueOf(d);
                break;
            }
            case 3: {
                d = rand.nextDouble();
                ps2.setDouble(1, d);
                ds2 = String.valueOf(d);
                break;
            }
            case 4: {
                d = rand.nextDouble() * Math.pow(10.0, rand.nextInt() % 300);
                ps2.setDouble(1, d);
                ds2 = String.valueOf(d);
                break;
            }
            case 5: {
                f = rand.nextFloat() * (float)Math.pow(10.0, rand.nextInt() % 30);
                ps2.setFloat(1, f);
                ds2 = String.valueOf(f);
                break;
            }
            case 6: {
                int i = rand.nextInt();
                ds2 = String.valueOf(i);
                ps2.setInt(1, i);
                break;
            }
            case 7: {
                long l = rand.nextLong();
                ds2 = String.valueOf(l);
                ps2.setLong(1, l);
                break;
            }
            case 8: {
                d = rand.nextDouble() * Math.pow(10.0, rand.nextInt() % 20);
                ps2.setDouble(1, d);
                ds2 = String.valueOf(d);
                break;
            }
            case 9: {
                f = rand.nextFloat() * (float)Math.pow(10.0, rand.nextInt() % 7);
                ps2.setFloat(1, f);
                ds2 = String.valueOf(f);
                break;
            }
            case 10: {
                int i = rand.nextInt() % 32768;
                short si = (short)i;
                ps2.setShort(1, si);
                ds2 = String.valueOf(si);
                break;
            }
            case 11: {
                Time tt = new Time(1L);
                tt.setTime(Math.abs(rand.nextInt()));
                ps2.setTime(1, tt);
                ds2 = tt.toString();
                break;
            }
            case 12: {
                Timestamp ts = new Timestamp(1L);
                ts.setTime(Math.abs(rand.nextLong() / 50000L));
                ps2.setTimestamp(1, ts);
                ds2 = ts.toString();
                break;
            }
            case 13: {
                ds2 = cs.substring(Math.abs(rand.nextInt() % 100));
                ps2.setString(1, ds2);
            }
        }
        try {
            rowsUpdated = ps2.executeUpdate();
        }
        catch (SQLException sqe) {
            NsTest.logger.println(sqe.getSQLState() + " " + sqe.getErrorCode() + " " + sqe.getMessage());
            if (NsTest.justCountErrors()) {
                NsTest.printException(DbUtil.class.getName(), sqe);
            } else {
                sqe.printStackTrace(NsTest.logger);
            }
        }
        catch (Exception e) {
            this.printException("Error in update_one_row()", e);
            e.printStackTrace(NsTest.logger);
        }
        finally {
            conn.setTransactionIsolation(1);
        }
        if (rowsUpdated > 0) {
            NsTest.logger.println(thread_id + " updated " + rowsUpdated + " row with serialkey " + skey + " *** SUCCESS *** ");
        } else {
            NsTest.logger.println(thread_id + " update failed, no such row exists");
        }
        return rowsUpdated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete_one_row(Connection conn, String thread_id) throws Exception {
        PreparedStatement ps = null;
        int rowsDeleted = 0;
        conn.setTransactionIsolation(2);
        try {
            ps = conn.prepareStatement(" delete from nstesttab where serialkey = ?");
        }
        catch (Exception e) {
            NsTest.logger.println("Unexpected error preparing the statement in delete_one()");
            this.printException("delete_one_row prepare ", e);
            return rowsDeleted;
        }
        long skey = this.pick_one(conn, thread_id);
        if (skey == 0L) {
            NsTest.logger.println(thread_id + " could not find a row to delete or there was an error.");
            return rowsDeleted;
        }
        try {
            ps.setLong(1, skey);
            rowsDeleted = ps.executeUpdate();
        }
        catch (Exception e) {
            NsTest.logger.println("Error in delete_one(): either with setLong() or executeUpdate");
            this.printException("failure to execute delete stmt", e);
        }
        finally {
            conn.setTransactionIsolation(1);
        }
        if (rowsDeleted > 0) {
            NsTest.logger.println(thread_id + " deleted row with serialkey " + skey + " *** SUCCESS *** ");
        } else {
            NsTest.logger.println(thread_id + " delete for serialkey " + skey + " failed, no such row exists.");
        }
        return rowsDeleted;
    }

    public long pick_one(Connection conn, String thread_id) throws Exception {
        Random rand = new Random();
        long minVal = NsTest.NUM_UNTOUCHED_ROWS + 1;
        long maxVal = NsTest.numInserts;
        long rowToReturn = minVal + (long)(rand.nextDouble() * (double)(maxVal - minVal));
        return rowToReturn;
    }

    public synchronized void printException(String where, Exception e) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(e);
            return;
        }
        NsTest.logger.println(e.toString());
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (se.getSQLState().equals("40001")) {
                NsTest.logger.println(this.getThreadName() + " dbUtil --> deadlocked detected");
            }
            if (se.getSQLState().equals("40XL1")) {
                NsTest.logger.println(this.getThreadName() + " dbUtil --> lock timeout exception");
            }
            if (se.getSQLState().equals("23500")) {
                NsTest.logger.println(this.getThreadName() + " dbUtil --> duplicate key violation");
            }
            if (se.getNextException() != null) {
                String m = se.getNextException().getSQLState();
                NsTest.logger.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
                NsTest.logger.println(this.getThreadName() + " dbUtil ---> Details of exception: " + se.toString() + " " + se.getErrorCode());
            }
        }
        if (e.getMessage() == null) {
            NsTest.logger.println(this.getThreadName() + " dbUtil --> NULL error message detected");
            NsTest.logger.println(this.getThreadName() + " dbUtil --> Here is the NULL exection - " + e.toString());
            NsTest.logger.println(this.getThreadName() + " dbUtil --> Stack trace of the NULL exception - ");
            if (NsTest.justCountErrors()) {
                NsTest.printException(DbUtil.class.getName(), e);
            } else {
                e.printStackTrace(NsTest.logger);
            }
        }
        NsTest.logger.println(this.getThreadName() + " dbUtil ----> During " + where + ", exception thrown was : " + e.toString());
    }

    public String getThreadName() {
        return this.threadName;
    }
}

