/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.optimizer;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.derbyTesting.system.optimizer.StaticValues;
import org.apache.derbyTesting.system.optimizer.query.GenericQuery;
import org.apache.derbyTesting.system.optimizer.query.QueryList;
import org.apache.derbyTesting.system.optimizer.utils.DataUtils;
import org.apache.derbyTesting.system.optimizer.utils.TestViews;

public class RunOptimizerTest {
    public static void main(String[] args) {
        Connection conn = null;
        String driverClass = StaticValues.embedClass;
        String jdbcurl = StaticValues.embedURL;
        boolean reset = false;
        boolean verbose = false;
        try {
            int i;
            File dir;
            String mode = System.getProperty("derby.optimizertest.mode");
            if (mode != null) {
                if (mode.equalsIgnoreCase("client")) {
                    driverClass = StaticValues.clientClass;
                    jdbcurl = StaticValues.clientURL;
                } else {
                    driverClass = StaticValues.embedClass;
                    jdbcurl = StaticValues.embedURL;
                }
            }
            if (!(dir = new File("testdb")).exists()) {
                reset = true;
            }
            System.out.println("Running test with url " + jdbcurl);
            if (args.length > 0) {
                for (i = 0; i < args.length; ++i) {
                    if (args[i].equalsIgnoreCase("-reset")) {
                        reset = true;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-qlist")) {
                        QueryList.queryListOnly = true;
                        continue;
                    }
                    if (args[i].equalsIgnoreCase("-verbose")) {
                        verbose = true;
                        continue;
                    }
                    RunOptimizerTest.printUsage();
                    return;
                }
            }
            Class.forName(driverClass);
            if (reset) {
                System.out.println("Initializing db ...");
                conn = DriverManager.getConnection(jdbcurl);
                TestViews.init();
                DataUtils.dropObjects(conn, verbose);
                DataUtils.createObjects(conn, verbose);
            } else {
                System.out.println("Use existing db ...");
                conn = DriverManager.getConnection(jdbcurl);
            }
            DataUtils.insertData(conn, verbose);
            QueryList.init(conn);
            if (verbose) {
                System.out.println(" List of query scenarios to run: " + QueryList.getQList().size());
            }
            System.out.println("Starting tests ...");
            for (i = 0; i < QueryList.getQList().size(); ++i) {
                if (verbose) {
                    System.out.println("\n______________________________________________________________________\n");
                }
                GenericQuery gq = QueryList.getQList().get(i);
                if (verbose) {
                    System.out.println("*** Running query: " + gq.getDescription() + " ***");
                }
                conn = null;
                conn = DriverManager.getConnection(jdbcurl);
                gq.setConnection(conn);
                gq.executeQueries(false, verbose);
                conn.close();
                conn = null;
                conn = DriverManager.getConnection(jdbcurl);
                gq.setConnection(conn);
                gq.executeQueries(true, verbose);
            }
        }
        catch (ClassNotFoundException cne) {
            System.out.println("Class not found Exception: " + cne.getMessage());
        }
        catch (SQLException sqe) {
            System.out.println("SQL Exception :" + String.valueOf(sqe));
            sqe.printStackTrace();
        }
        catch (Exception e) {
            System.out.println("Unexpected Exception " + String.valueOf(e));
            e.printStackTrace();
        }
        RunOptimizerTest.printResults();
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("\njava org.apache.derbyTesting.system.optimizer.RunOptimizerTest -reset|-qlist\n");
        System.out.println("-reset = Reset the database and begin run");
        System.out.println("-qlist = Run only test queries from the 'query.list' file provided");
        System.out.println("\nNo arguments will run all the default test queries available in this test case.\n");
    }

    private static void printResults() {
        System.out.println("\n\n========================= R E S U L T S =========================\n");
        for (int i = 0; i < QueryList.getQList().size(); ++i) {
            System.out.println("\n________________________________________________________________________________________________");
            GenericQuery gq = QueryList.getQList().get(i);
            if (gq.getPrepStmtRunResults().size() == 0) {
                System.out.println("Queries didn't run");
                System.exit(0);
                continue;
            }
            System.out.println("Timings for Query type: " + gq.getDescription() + "\n");
            System.out.println("QueryName\tUsing PreparedStatment\tUsing Statement\tRows Expected");
            System.out.println("------------------------------------------------------------------------------");
            System.out.println("Query size: " + gq.getQueries().size());
            for (int k = 0; k < gq.getQueries().size(); ++k) {
                String queryName = "QUERY # " + (k + 1);
                String[] prepStmtTimes = gq.getPrepStmtRunResults().get(k);
                String[] stmtTimes = gq.getStmtRunResults().get(k);
                for (int j = 0; j < StaticValues.ITER; ++j) {
                    System.out.println(queryName + "\t" + prepStmtTimes[j] + "\t\t" + stmtTimes[j] + "\t" + gq.getRowsExpected(k));
                }
                System.out.println("*************************************************************************");
            }
            System.out.println("\n________________________________________________________________________________________________");
        }
    }
}

