/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.io.FormatableLongHolder;
import org.apache.derby.shared.common.sanity.SanityManager;

public class FormatableHashtable
extends Hashtable<Object, Object>
implements Formatable {
    @Override
    public Object put(Object key, Object value) {
        if (value == null) {
            return this.remove(key);
        }
        if (!(value instanceof FormatableIntHolder) && !(value instanceof FormatableLongHolder) && (!(value instanceof Serializable) || value instanceof Formatable || value instanceof String) || !value.getClass().isArray()) {
            // empty if block
        }
        return super.put(key, value);
    }

    public void putInt(Object key, int value) {
        super.put(key, new FormatableIntHolder(value));
    }

    public int getInt(Object key) {
        return ((FormatableIntHolder)this.get(key)).getInt();
    }

    public void putLong(Object key, long value) {
        super.put(key, new FormatableLongHolder(value));
    }

    public long getLong(Object key) {
        return ((FormatableLongHolder)this.get(key)).getLong();
    }

    public void putBoolean(Object key, boolean value) {
        this.putInt(key, value ? 1 : 0);
    }

    public boolean getBoolean(Object key) {
        return this.getInt(key) != 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            out.writeObject(key);
            out.writeObject(this.get(key));
            Object value = this.get(key);
            if (!(value instanceof Formatable[])) continue;
            SanityManager.THROWASSERT("you should be using FormatableArrayHolder rather than writing out an array of Formatables, otherwise you will get bad behavior for null Storables.  Your class is a " + value.getClass().getName());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        for (int size = in.readInt(); size > 0; --size) {
            super.put(in.readObject(), in.readObject());
        }
    }

    @Override
    public int getTypeFormatId() {
        return 313;
    }
}

