/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LockTableTest
extends BaseJDBCTestCase {
    public LockTableTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.setProperty("derby.storage.rowLocking", "false");
        properties.setProperty("derby.locks.waitTimeout", "7");
        properties.setProperty("derby.locks.deadlockTimeout", "5");
        Object object = TestConfiguration.embeddedSuite(LockTableTest.class);
        object = new DatabasePropertyTestSetup((Test)object, properties, true);
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                Connection connection = this.getConnection();
                connection.setAutoCommit(false);
                statement.executeUpdate("create schema u1");
                statement.executeUpdate("create schema u2");
                connection.commit();
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        try (Statement statement = this.createStatement();){
            statement = this.createStatement();
            statement.executeUpdate("drop table u1.t1");
            statement.executeUpdate("drop schema u1 restrict");
            statement.executeUpdate("drop schema u2 restrict");
        }
        super.tearDown();
    }

    private Connection setConnection(String string) throws SQLException {
        Connection connection = this.openUserConnection(string);
        connection.setAutoCommit(false);
        return connection;
    }

    private void setupTable(Statement statement) throws SQLException {
        statement.executeUpdate("create table t1(c1 int)");
        statement.executeUpdate("insert into t1 values 1");
    }

    public static String getSelectLocksString() {
        String string = "select cast(username as char(8)) as username, cast(t.type as char(15)) as trantype, cast(l.type as char(8)) as type, cast(lockcount as char(3)) as cnt, mode, cast(tablename as char(12)) as tabname, cast(lockname as char(10)) as lockname, state, status from syscs_diag.lock_table l right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' order by tabname, type desc, mode, cnt, lockname";
        return string;
    }

    public void testSystemTable() throws SQLException {
        Statement statement = this.createStatement();
        LockTableTest.assertStatementError("42X62", statement, "lock table sys.systables in share mode");
        statement.close();
    }

    public void testTXvsTXLocks() throws SQLException {
        Connection connection = this.setConnection("U1");
        Statement statement = connection.createStatement();
        Connection connection2 = this.setConnection("U2");
        Statement statement2 = connection2.createStatement();
        this.setupTable(statement);
        connection.commit();
        statement.executeUpdate("lock table u1.t1 in exclusive mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, statement2, "lock table u1.t1 in exclusive mode");
        ResultSet resultSet = statement.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "X", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        statement.executeUpdate("insert into t1 values 2");
        resultSet = statement.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        LockTableTest.assertStatementError("40XL1", statement2, "insert into u1.t1 values 9");
        resultSet = statement.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        resultSet = statement.executeQuery("select count(*) from u1.t1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        resultSet.close();
        connection.commit();
        statement.executeUpdate("drop table U1.t1");
        connection.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.rollback();
        connection2.close();
    }

    public void testTXvsTSLocks() throws SQLException {
        Connection connection = this.setConnection("U1");
        Statement statement = connection.createStatement();
        Connection connection2 = this.setConnection("U2");
        Statement statement2 = connection2.createStatement();
        this.setupTable(statement);
        connection.commit();
        statement.executeUpdate("lock table t1 in exclusive mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, statement2, "lock table u1.t1 in share mode");
        ResultSet resultSet = statement.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "X", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        statement.executeUpdate("insert into t1 values 3");
        resultSet = statement.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        statement.executeUpdate("drop table U1.t1");
        connection.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.rollback();
        connection2.close();
    }

    public void testTSvsTXLocks() throws SQLException {
        Connection connection = this.setConnection("U1");
        Statement statement = connection.createStatement();
        Connection connection2 = this.setConnection("U2");
        Statement statement2 = connection2.createStatement();
        this.setupTable(statement);
        connection.commit();
        statement.executeUpdate("lock table t1 in share mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, statement2, "lock table u1.t1 in exclusive mode");
        ResultSet resultSet = statement.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        statement.executeUpdate("insert into t1 values 4");
        resultSet = statement.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(resultSet, "2");
        statement.executeUpdate("drop table U1.t1");
        connection.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.rollback();
        connection2.close();
    }

    public void testTSvsTSLocks() throws SQLException {
        Connection connection = this.setConnection("U1");
        Statement statement = connection.createStatement();
        Connection connection2 = this.setConnection("U2");
        Statement statement2 = connection2.createStatement();
        this.setupTable(statement);
        connection.commit();
        statement.executeUpdate("lock table t1 in share mode");
        LockTableTest.assertUpdateCount(statement2, 0, "lock table u1.t1 in share mode");
        ResultSet resultSet = statement.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"U2", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}, {"U1", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        LockTableTest.assertStatementError("40XL1", statement, "insert into t1 values 5");
        resultSet = statement.executeQuery("select count(*) from t1");
        JDBC.assertSingleValueResultSet(resultSet, "1");
        connection2.rollback();
        connection.rollback();
        statement.executeUpdate("drop table U1.t1");
        connection.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.close();
    }

    public void testWithRolledBack() throws SQLException {
        Connection connection = this.setConnection("U1");
        Statement statement = connection.createStatement();
        Connection connection2 = this.setConnection("U2");
        Statement statement2 = connection2.createStatement();
        this.setupTable(statement);
        connection.commit();
        statement.executeUpdate("create table t2(c1 int)");
        connection.commit();
        statement.executeUpdate("lock table t1 in share mode");
        statement2.executeUpdate("lock table u1.t2 in share mode");
        LockTableTest.assertStatementError(new String[]{"X0X02", "40XL1"}, statement2, "lock table u1.t1 in exclusive mode");
        ResultSet resultSet = statement.executeQuery(LockTableTest.getSelectLocksString());
        JDBC.assertFullResultSet(resultSet, new String[][]{{"U1", "UserTransaction", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}, {"U2", "UserTransaction", "TABLE", "1", "S", "T2", "Tablelock", "GRANT", "ACTIVE"}});
        connection2.rollback();
        connection.rollback();
        statement.executeUpdate("drop table U1.t2");
        statement.executeUpdate("drop table U1.t1");
        connection.commit();
        statement.close();
        statement2.close();
        connection.close();
        connection2.close();
    }
}

