/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.source;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.source.FileSourceSaxHandlerFactory;
import org.apache.torque.generator.configuration.source.JdbcMetadataSourceSaxHandlerFactory;
import org.apache.torque.generator.configuration.source.SourceSaxHandlerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSaxHandlerFactories {
    private static Log log = LogFactory.getLog(SourceSaxHandlerFactories.class);
    private Map<String, SourceSaxHandlerFactory> factories = new HashMap<String, SourceSaxHandlerFactory>();

    public SourceSaxHandlerFactories() {
        try {
            this.register(new FileSourceSaxHandlerFactory());
            this.register(new JdbcMetadataSourceSaxHandlerFactory());
        }
        catch (ConfigurationException e) {
            log.error((Object)"caught ConfigurationException while registering the default Source Sax Handler Factories", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void register(SourceSaxHandlerFactory sourceSaxHandlerFactory) throws ConfigurationException {
        String type = sourceSaxHandlerFactory.getType();
        SourceSaxHandlerFactory oldFactory = this.factories.get(type);
        if (oldFactory != null) {
            throw new ConfigurationException("Attempted to register an SourceSaxHandlerFactory of type " + sourceSaxHandlerFactory.getType() + " and class " + sourceSaxHandlerFactory.getClass().getName() + " : A factory with this type already exists, " + " it has the class " + oldFactory.getClass().getName());
        }
        this.factories.put(type, sourceSaxHandlerFactory);
    }

    public SourceSaxHandlerFactory getSourceSaxHandlerFactory(String type) {
        return this.factories.get(type);
    }

    public Set<String> getSourceTypes() {
        return this.factories.keySet();
    }
}

