/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.outlet;

import java.util.Map;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.controller.Output;
import org.apache.torque.generator.configuration.mergepoint.MergepointMapping;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.control.outputtype.OutputType;
import org.apache.torque.generator.outlet.Outlet;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.QualifiedName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DebuggingOutletWrapper
implements Outlet {
    private Outlet delegate;

    public DebuggingOutletWrapper(Outlet delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate must not be null");
        }
        this.delegate = delegate;
    }

    @Override
    public QualifiedName getName() {
        return this.delegate.getName();
    }

    @Override
    public void addMergepointMapping(MergepointMapping mergepointMapping) throws ConfigurationException {
        this.delegate.addMergepointMapping(mergepointMapping);
    }

    @Override
    public MergepointMapping setMergepointMapping(MergepointMapping mergepointMapping) {
        return this.delegate.setMergepointMapping(mergepointMapping);
    }

    @Override
    public MergepointMapping getMergepointMapping(String name) {
        return this.delegate.getMergepointMapping(name);
    }

    @Override
    public Map<String, MergepointMapping> getMergepointMappings() {
        return this.delegate.getMergepointMappings();
    }

    @Override
    public void setInputElementName(String inputName) {
        this.delegate.setInputElementName(inputName);
    }

    @Override
    public String getInputElementName() {
        return this.delegate.getInputElementName();
    }

    @Override
    public void beforeExecute(ControllerState controllerState) throws GeneratorException {
        this.delegate.beforeExecute(controllerState);
    }

    @Override
    public void afterExecute(ControllerState controllerState) throws GeneratorException {
        this.delegate.afterExecute(controllerState);
    }

    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        OutletResult outletResult = this.delegate.execute(controllerState);
        if (outletResult.isByteArrayResult()) {
            return outletResult;
        }
        Output output = controllerState.getOutput();
        String lineBreak = output.getOrDetermineLineBreak(outletResult.getStringResult());
        String outputTypeString = output.getType();
        Map<String, OutputType> outputTypes = controllerState.getUnitConfiguration().getConfigurationHandlers().getOutputTypes();
        OutputType outputType = outputTypes.get(outputTypeString);
        if (outputType == null) {
            throw new GeneratorException("Unknown output type " + outputTypeString + " in output " + output.getName());
        }
        String commentStart = outputType.getCommentStart(lineBreak);
        String commentAtStart = this.getCommentAtStart(controllerState);
        String commentAtEnd = this.getCommentAtEnd(controllerState);
        String commentEnd = outputType.getCommentEnd(lineBreak);
        return new OutletResult(commentStart + commentAtStart + commentEnd + outletResult.getStringResult() + commentStart + commentAtEnd + commentEnd);
    }

    protected String getCommentAtStart(ControllerState controllerState) {
        return "start output of outlet " + controllerState.getOutlet().getName() + ", current source element is " + controllerState.getSourceElement().getName();
    }

    protected String getCommentAtEnd(ControllerState controllerState) {
        return "end output of outlet " + controllerState.getOutlet().getName() + ", current source element is " + controllerState.getSourceElement().getName();
    }
}

