/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.merge;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.torque.generator.GeneratorException;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.diff.SequenceComparator;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;

public class ThreeWayMerger {
    public String merge(String base, String generated, String edited, String charsetName) throws GeneratorException {
        MergeResult mergeResult;
        MergeAlgorithm mergeAlgorithm = new MergeAlgorithm();
        try {
            mergeResult = mergeAlgorithm.merge((SequenceComparator)RawTextComparator.DEFAULT, (Sequence)new RawText(base.getBytes(charsetName)), (Sequence)new RawText(generated.getBytes(charsetName)), (Sequence)new RawText(edited.getBytes(charsetName)));
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneratorException("unknown character set " + charsetName, e);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            new MergeFormatter().formatMerge((OutputStream)outputStream, mergeResult, "base", "generated", "edited", charsetName);
        }
        catch (IOException e) {
            throw new GeneratorException("could nor render merge result", e);
        }
        try {
            String result = new String(outputStream.toByteArray(), charsetName);
            return result;
        }
        catch (UnsupportedEncodingException e) {
            throw new GeneratorException("unknown character set " + charsetName, e);
        }
    }
}

