/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.ArrayList;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformer;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.model.Database;
import org.apache.torque.templates.transformer.IncludeSchemaTransformer;
import org.apache.torque.templates.transformer.LoadExternalSchemaTransformer;
import org.apache.torque.templates.transformer.om.DatabaseAttributeName;
import org.apache.torque.templates.transformer.om.DatabaseChildElementName;
import org.apache.torque.templates.transformer.om.OMForeignKeyColumnTransformer;
import org.apache.torque.templates.transformer.om.OMForeignKeyTransformer;
import org.apache.torque.templates.transformer.om.OMJoinGetterTransformer;
import org.apache.torque.templates.transformer.om.OMTableAndViewTransformer;
import org.apache.torque.templates.transformer.om.mapInit.DatabaseMapInitTransformer;

public class OMTransformer
implements SourceTransformer {
    private static final OMForeignKeyColumnTransformer foreignKeyColumnTransformer = new OMForeignKeyColumnTransformer();
    private static final OMForeignKeyTransformer foreignKeyTransformer = new OMForeignKeyTransformer();
    private static final OMTableAndViewTransformer tableOrViewTransformer;
    private static final SourceTransformer loadExternalSchemaTransformer;
    private static final SourceTransformer includeSchemaTransformer;
    private static OMJoinGetterTransformer joinGetterTransformer;

    public SourceElement transform(Object modelRoot, ControllerState controllerState) throws SourceTransformerException {
        SourceElement root = (SourceElement)modelRoot;
        TemplateOptionName.checkRequiredOptions(controllerState, TemplateOptionName.OM_PACKAGE);
        OMTransformer.setRootDatabaseNameAttribute(root);
        DatabaseMapInitTransformer.setDatabaseMapInitClassNameAttributes(root, (String)root.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME), controllerState);
        includeSchemaTransformer.transform((Object)root, controllerState);
        loadExternalSchemaTransformer.transform((Object)root, controllerState);
        ArrayList allTablesAndViews = new ArrayList();
        allTablesAndViews.addAll(root.getChild((SourceElementName)DatabaseChildElementName.ALL_TABLES).getChildren((SourceElementName)TorqueSchemaElementName.TABLE));
        allTablesAndViews.addAll(root.getChild((SourceElementName)DatabaseChildElementName.ALL_VIEWS).getChildren((SourceElementName)TorqueSchemaElementName.VIEW));
        for (SourceElement tableOrViewElement : allTablesAndViews) {
            tableOrViewTransformer.transform(tableOrViewElement, controllerState);
        }
        for (SourceElement tableOrViewElement : allTablesAndViews) {
            for (SourceElement columnElement : tableOrViewElement.getChildren((SourceElementName)TorqueSchemaElementName.COLUMN)) {
                foreignKeyColumnTransformer.transform(columnElement, controllerState);
            }
            for (SourceElement foreignKeyElement : tableOrViewElement.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY)) {
                foreignKeyTransformer.transform(foreignKeyElement, controllerState);
            }
        }
        for (SourceElement tableOrViewElement : allTablesAndViews) {
            for (SourceElement foreignKeyElement : tableOrViewElement.getChildren((SourceElementName)TorqueSchemaElementName.FOREIGN_KEY)) {
                foreignKeyTransformer.transformSecondPass(foreignKeyElement, controllerState);
            }
        }
        for (SourceElement tableOrViewElement : allTablesAndViews) {
            joinGetterTransformer.transform(tableOrViewElement, controllerState);
        }
        return root;
    }

    public static void setRootDatabaseNameAttribute(SourceElement databaseElement) {
        String databaseName = (String)databaseElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        databaseElement.setAttribute((SourceAttributeName)DatabaseAttributeName.ROOT_DATABASE_NAME, (Object)databaseName);
    }

    public static void setRootDatabaseName(Database database) {
        database.rootDatabaseName = database.name;
    }

    static {
        loadExternalSchemaTransformer = new LoadExternalSchemaTransformer();
        includeSchemaTransformer = new IncludeSchemaTransformer();
        joinGetterTransformer = new OMJoinGetterTransformer();
        try {
            tableOrViewTransformer = new OMTableAndViewTransformer();
        }
        catch (SourceTransformerException e) {
            throw new RuntimeException(e);
        }
    }
}

