/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.platform;

import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.torque.templates.platform.Platform;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;

public class PlatformDefaultImpl
implements Platform {
    private static final String TIMESTAMP_FORMAT = "''yyyy-MM-dd HH:mm:ss''";
    private Map<SchemaType, SqlType> schemaTypeToSqlTypeMap;

    public PlatformDefaultImpl() {
        this.initialize();
    }

    private void initialize() {
        this.schemaTypeToSqlTypeMap = Collections.synchronizedMap(new HashMap());
        for (SchemaType schemaType : SchemaType.values()) {
            this.setSchemaTypeToSqlTypeMapping(schemaType, new SqlType(schemaType.name()));
        }
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANCHAR, new SqlType("CHAR"));
        this.setSchemaTypeToSqlTypeMapping(SchemaType.BOOLEANINT, new SqlType("INTEGER"));
    }

    protected void setSchemaTypeToSqlTypeMapping(SchemaType schemaType, SqlType sqlType) {
        if (schemaType == null) {
            throw new NullPointerException("schemaType must not be null");
        }
        if (sqlType == null) {
            throw new NullPointerException("sqlType must not be null");
        }
        this.schemaTypeToSqlTypeMap.put(schemaType, sqlType);
    }

    protected String formatDateTimeString(Date date, String format) {
        return DateTimeFormatter.ofPattern(format).format(date.toInstant().atZone(ZoneId.of("GMT")));
    }

    @Override
    public SqlType getSqlTypeForSchemaType(SchemaType schemaType) {
        return this.schemaTypeToSqlTypeMap.get((Object)schemaType);
    }

    @Override
    public String getNullString(boolean notNull) {
        return notNull ? "NOT NULL" : "";
    }

    @Override
    public String getAutoIncrement() {
        return "IDENTITY";
    }

    @Override
    public boolean hasScale(String sqlType) {
        return true;
    }

    @Override
    public boolean hasSize(String sqlType) {
        return true;
    }

    @Override
    public String getSizeSuffix(String sqlType) {
        return "";
    }

    @Override
    public boolean createNotNullBeforeAutoincrement() {
        return true;
    }

    @Override
    public String quoteAndEscape(String text) {
        String result = text.replace("'", "''");
        if (this.escapeBackslashes()) {
            result = result.replace("\\", "\\\\");
        }
        return "'" + result + "'";
    }

    protected boolean escapeBackslashes() {
        return true;
    }

    @Override
    public String getDateString(Date date) {
        return this.getTimestampString(date);
    }

    @Override
    public String getTimeString(Date date) {
        return this.getTimestampString(date);
    }

    @Override
    public String getTimestampString(Date date) {
        return this.formatDateTimeString(date, TIMESTAMP_FORMAT);
    }

    @Override
    public boolean usesStandaloneSchema() {
        return false;
    }

    @Override
    public boolean hasUniqueConstraintSize() {
        return false;
    }
}

