/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.cdise.servlet;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.RequestScoped;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import org.apache.deltaspike.cdise.api.CdiContainer;
import org.apache.deltaspike.cdise.api.CdiContainerLoader;
import org.apache.deltaspike.cdise.api.ContextControl;

public class CdiServletRequestListener
implements ServletRequestListener {
    private static final Logger LOG = Logger.getLogger(CdiServletRequestListener.class.getName());
    private static final String CDI_REQ_CONTEXT = "cdiRequestContext";

    public void requestDestroyed(ServletRequestEvent servletRequestEvent) {
        LOG.log(Level.FINER, "Request done.");
        ContextControl contextControl = (ContextControl)servletRequestEvent.getServletRequest().getAttribute(CDI_REQ_CONTEXT);
        contextControl.stopContext(RequestScoped.class);
    }

    public void requestInitialized(ServletRequestEvent servletRequestEvent) {
        LOG.log(Level.FINER, "Incoming request.");
        ContextControl contextControl = this.getContextControl();
        servletRequestEvent.getServletRequest().setAttribute(CDI_REQ_CONTEXT, (Object)contextControl);
        contextControl.startContext(RequestScoped.class);
    }

    private ContextControl getContextControl() {
        CdiContainer container = CdiContainerLoader.getCdiContainer();
        return container.getContextControl();
    }
}

