/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.authn.ppolicy;

import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordPolicyException;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordValidator;

public class DefaultPasswordValidator
implements PasswordValidator {
    public static final DefaultPasswordValidator INSTANCE = new DefaultPasswordValidator();

    @Override
    public void validate(String password, Entry entry) throws PasswordPolicyException {
        this.checkUsernameSubstring(password, entry);
    }

    private void checkUsernameSubstring(String password, Entry entry) throws PasswordPolicyException {
        String[] tokens;
        String username = entry.getDn().getRdn().getValue();
        if (username == null || username.trim().length() == 0) {
            return;
        }
        for (String token : tokens = username.split("[^a-zA-Z]")) {
            if (token == null || token.length() < 4 || !password.matches("(?i).*" + token + ".*")) continue;
            throw new PasswordPolicyException("Password shouldn't contain parts of the username", 5);
        }
    }
}

