/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapservers.jobs;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.common.core.jobs.StudioRunnableWithProgress;
import org.apache.directory.studio.ldapservers.jobs.Messages;
import org.apache.directory.studio.ldapservers.model.LdapServer;
import org.eclipse.osgi.util.NLS;

public class OpenConfigurationLdapServerRunnable
implements StudioRunnableWithProgress {
    private LdapServer server;

    public OpenConfigurationLdapServerRunnable(LdapServer server) {
        this.server = server;
    }

    public String getErrorMessage() {
        return NLS.bind((String)Messages.getString("OpenConfigurationLdapServerRunnable.UnableToOpenConfigurationForServer"), (Object[])new String[]{this.server.getName()});
    }

    public Object[] getLockedObjects() {
        return new Object[]{this.server};
    }

    public String getName() {
        return NLS.bind((String)Messages.getString("OpenConfigurationLdapServerRunnable.OpenConfigurationForServer"), (Object[])new String[]{this.server.getName()});
    }

    public void run(StudioProgressMonitor monitor) {
        try {
            this.server.getLdapServerAdapterExtension().getInstance().openConfiguration(this.server, monitor);
        }
        catch (Exception e) {
            monitor.reportError(e);
        }
    }
}

