/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.core.jobs;

import org.apache.directory.studio.common.core.jobs.StudioProgressMonitor;
import org.apache.directory.studio.ldapbrowser.core.events.EntryModificationEvent;
import org.apache.directory.studio.ldapbrowser.core.events.EventRegistry;
import org.apache.directory.studio.ldapbrowser.core.jobs.ExecuteLdifRunnable;
import org.apache.directory.studio.ldapbrowser.core.jobs.InitializeAttributesRunnable;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;

public class UpdateEntryRunnable
extends ExecuteLdifRunnable {
    private IEntry entry;

    public UpdateEntryRunnable(IEntry entry, String ldif) {
        super(entry.getBrowserConnection(), ldif, false, false);
        this.entry = entry;
    }

    @Override
    public void run(StudioProgressMonitor monitor) {
        super.run(monitor);
        if (monitor.isCanceled()) {
            monitor.setCanceled(false);
        }
        InitializeAttributesRunnable.initializeAttributes(this.entry, monitor);
    }

    @Override
    public void runNotification(StudioProgressMonitor monitor) {
        EventRegistry.fireEntryUpdated(new EntryModificationEvent(this.entry.getBrowserConnection(), this.entry), this);
    }
}

