/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ntp.messages;

public enum LeapIndicatorType {
    NO_WARNING(0, "No leap second warning."),
    POSITIVE_LEAP_SECOND(1, "Last minute has 61 seconds."),
    NEGATIVE_LEAP_SECOND(2, "Last minute has 59 seconds."),
    ALARM_CONDITION(3, "Alarm condition (clock not synchronized).");

    private String name;
    private int ordinal;

    private LeapIndicatorType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static LeapIndicatorType getTypeByOrdinal(int type) {
        for (LeapIndicatorType lit : LeapIndicatorType.values()) {
            if (type != lit.getOrdinal()) continue;
            return lit;
        }
        return NO_WARNING;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public String toString() {
        return this.name;
    }
}

