/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.dbms.h2;

import org.apache.empire.data.DataType;
import org.apache.empire.db.DBDDLGenerator;
import org.apache.empire.db.DBSQLBuilder;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.dbms.h2.DBMSHandlerH2;

public class H2DDLGenerator
extends DBDDLGenerator<DBMSHandlerH2> {
    public H2DDLGenerator(DBMSHandlerH2 dbms) {
        super(dbms);
        this.initDataTypes();
    }

    private void initDataTypes() {
        this.DATATYPE_FLOAT = "DOUBLE";
        this.DATATYPE_CLOB = "LONGTEXT";
    }

    @Override
    protected boolean appendColumnDataType(DataType type, double size, DBTableColumn c, DBSQLBuilder sql) {
        switch (type) {
            case AUTOINC: {
                super.appendColumnDataType(type, size, c, sql);
                if (((DBMSHandlerH2)this.dbms).isUseSequenceTable()) break;
                sql.append(" AUTO_INCREMENT");
                break;
            }
            default: {
                return super.appendColumnDataType(type, size, c, sql);
            }
        }
        return true;
    }
}

