/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.connect.felix.framework.ServiceRegistry;
import org.apache.felix.connect.felix.framework.capabilityset.SimpleFilter;
import org.apache.felix.connect.felix.framework.util.EventDispatcher;
import org.apache.felix.connect.felix.framework.util.ShrinkableCollection;
import org.apache.felix.connect.felix.framework.util.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.FindHook;

class PojoSRBundleContext
implements BundleContext {
    private final Bundle m_bundle;
    private final ServiceRegistry m_reg;
    private final EventDispatcher m_dispatcher;
    private final Map<Long, Bundle> m_bundles;
    private final Map<String, Object> m_config;

    public PojoSRBundleContext(Bundle bundle, ServiceRegistry reg, EventDispatcher dispatcher, Map<Long, Bundle> bundles, Map<String, Object> config) {
        this.m_bundle = bundle;
        this.m_reg = reg;
        this.m_dispatcher = dispatcher;
        this.m_bundles = bundles;
        this.m_config = config;
    }

    public boolean ungetService(ServiceReference reference) {
        return this.m_reg.ungetService(this.m_bundle, reference);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        this.m_dispatcher.removeListener(this, ServiceListener.class, listener);
    }

    @Override
    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_dispatcher.removeListener(this, FrameworkListener.class, listener);
    }

    @Override
    public void removeBundleListener(BundleListener listener) {
        this.m_dispatcher.removeListener(this, BundleListener.class, listener);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        return this.m_reg.registerService(this.m_bundle, new String[]{clazz}, service, properties);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        return this.m_reg.registerService(this.m_bundle, clazzes, service, properties);
    }

    @Override
    public Bundle installBundle(String location) throws BundleException {
        throw new BundleException("pojosr can't do that");
    }

    @Override
    public Bundle installBundle(String location, InputStream input) throws BundleException {
        throw new BundleException("pojosr can't do that");
    }

    @Override
    public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(clazz, filter, true);
    }

    @Override
    public ServiceReference<?> getServiceReference(String clazz) {
        try {
            return this.getBestServiceReference(this.getServiceReferences(clazz, null));
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    private ServiceReference<?> getBestServiceReference(ServiceReference<?>[] refs) {
        if (refs == null) {
            return null;
        }
        if (refs.length == 1) {
            return refs[0];
        }
        ServiceReference<?> bestRef = refs[0];
        for (int i = 1; i < refs.length; ++i) {
            if (bestRef.compareTo(refs[i]) >= 0) continue;
            bestRef = refs[i];
        }
        return bestRef;
    }

    @Override
    public <S> S getService(ServiceReference<S> reference) {
        return this.m_reg.getService(this.m_bundle, reference);
    }

    @Override
    public String getProperty(String key) {
        Object result = this.m_config.get(key);
        return result == null ? System.getProperty(key) : result.toString();
    }

    @Override
    public File getDataFile(String filename) {
        File root = new File("bundle" + this.m_bundle.getBundleId());
        String storage = this.getProperty("org.osgi.framework.storage");
        if (storage != null) {
            root = new File(new File(storage), root.getName());
        }
        root.mkdirs();
        return filename.trim().length() > 0 ? new File(root, filename) : root;
    }

    @Override
    public Bundle[] getBundles() {
        Bundle[] result = this.m_bundles.values().toArray(new Bundle[this.m_bundles.size()]);
        Arrays.sort(result, new Comparator<Bundle>(){

            @Override
            public int compare(Bundle o1, Bundle o2) {
                return (int)(o1.getBundleId() - o2.getBundleId());
            }
        });
        return result;
    }

    @Override
    public Bundle getBundle(long id) {
        return this.m_bundles.get(id);
    }

    @Override
    public Bundle getBundle() {
        return this.m_bundle;
    }

    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        return this.getServiceReferences(clazz, filter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServiceReference[] getServiceReferences(String className, String expr, boolean checkAssignable) throws InvalidSyntaxException {
        SimpleFilter filter = null;
        if (expr != null) {
            try {
                filter = SimpleFilter.parse(expr);
            }
            catch (Exception ex) {
                throw new InvalidSyntaxException(ex.getMessage(), expr);
            }
        }
        Collection<ServiceReference<?>> refList = this.m_reg.getServiceReferences(className, filter);
        if (checkAssignable) {
            Iterator<ServiceReference<?>> it = refList.iterator();
            while (it.hasNext()) {
                ServiceReference<?> ref = it.next();
                if (Util.isServiceAssignable(this.m_bundle, ref)) continue;
                it.remove();
            }
        }
        Set<ServiceReference<FindHook>> findHooks = this.m_reg.getHooks(FindHook.class);
        for (ServiceReference<FindHook> sr : findHooks) {
            FindHook fh = this.m_reg.getService(this.getBundle(0L), sr);
            if (fh == null) continue;
            try {
                fh.find(this, className, expr, !checkAssignable, new ShrinkableCollection(refList));
            }
            catch (Throwable th) {
                System.err.println("Problem invoking service registry hook");
                th.printStackTrace();
            }
            finally {
                this.m_reg.ungetService(this.getBundle(0L), sr);
            }
        }
        if (refList.size() > 0) {
            return refList.toArray(new ServiceReference[refList.size()]);
        }
        return null;
    }

    @Override
    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return FrameworkUtil.createFilter(filter);
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        try {
            this.addServiceListener(listener, null);
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        this.m_dispatcher.addListener(this, ServiceListener.class, listener, filter == null ? null : FrameworkUtil.createFilter(filter));
    }

    @Override
    public void addFrameworkListener(FrameworkListener listener) {
        this.m_dispatcher.addListener(this, FrameworkListener.class, listener, null);
    }

    @Override
    public void addBundleListener(BundleListener listener) {
        this.m_dispatcher.addListener(this, BundleListener.class, listener, null);
    }

    @Override
    public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
        return this.registerService(clazz.getName(), (Object)service, (Dictionary)properties);
    }

    @Override
    public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
        return this.getServiceReference(clazz.getName());
    }

    @Override
    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
        ServiceReference<?>[] refs = this.getServiceReferences(clazz.getName(), filter);
        if (refs == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(refs);
    }

    @Override
    public Bundle getBundle(String location) {
        for (Bundle bundle : this.m_bundles.values()) {
            if (!location.equals(bundle.getLocation())) continue;
            return bundle;
        }
        return null;
    }
}

