/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Dictionary;
import org.apache.felix.ipojo.EventDispatcher;
import org.apache.felix.ipojo.ServiceContext;
import org.apache.felix.ipojo.dependency.interceptors.TransformedServiceReference;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPojoContext
implements BundleContext,
ServiceContext {
    private BundleContext m_bundleContext;
    private ServiceContext m_serviceContext;

    public IPojoContext(BundleContext context) {
        if (context instanceof IPojoContext) {
            this.m_bundleContext = ((IPojoContext)context).getGlobalContext();
            this.m_serviceContext = ((IPojoContext)context).getServiceContext();
        } else {
            this.m_bundleContext = context;
        }
    }

    public IPojoContext(BundleContext bundleContext, ServiceContext serviceContext) {
        this.m_bundleContext = bundleContext;
        this.m_serviceContext = serviceContext;
    }

    public void addBundleListener(BundleListener listener) {
        this.m_bundleContext.addBundleListener(listener);
    }

    public void addFrameworkListener(FrameworkListener listener) {
        this.m_bundleContext.addFrameworkListener(listener);
    }

    @Override
    public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
        if (this.m_serviceContext == null) {
            EventDispatcher dispatcher = EventDispatcher.getDispatcher();
            if (dispatcher != null) {
                String itf = this.match(filter);
                if (itf != null) {
                    dispatcher.addListener(itf, listener);
                } else {
                    this.m_bundleContext.addServiceListener(listener, filter);
                }
            } else {
                this.m_bundleContext.addServiceListener(listener, filter);
            }
        } else {
            this.m_serviceContext.addServiceListener(listener, filter);
        }
    }

    @Override
    public void addServiceListener(ServiceListener listener) {
        if (this.m_serviceContext == null) {
            this.m_bundleContext.addServiceListener(listener);
        } else {
            this.m_serviceContext.addServiceListener(listener);
        }
    }

    private String match(String filter) {
        if (filter != null && filter.startsWith("(objectClass=") && filter.lastIndexOf(41) == filter.indexOf(41)) {
            return filter.substring("(objectClass=".length(), filter.length() - 1);
        }
        return null;
    }

    public Filter createFilter(String filter) throws InvalidSyntaxException {
        return this.m_bundleContext.createFilter(filter);
    }

    public Bundle getBundle(String s) {
        return this.m_bundleContext.getBundle(s);
    }

    @Override
    public ServiceReference[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.getAllServiceReferences(clazz, filter);
        }
        return this.m_serviceContext.getAllServiceReferences(clazz, filter);
    }

    public Bundle getBundle() {
        return this.m_bundleContext.getBundle();
    }

    public Bundle getBundle(long bundleId) {
        return this.m_bundleContext.getBundle(bundleId);
    }

    public Bundle[] getBundles() {
        return this.m_bundleContext.getBundles();
    }

    public File getDataFile(String filename) {
        return this.m_bundleContext.getDataFile(filename);
    }

    public String getProperty(String key) {
        return this.m_bundleContext.getProperty(key);
    }

    @Override
    public <S> S getService(ServiceReference<S> ref) {
        if (ref instanceof TransformedServiceReference) {
            ref = ((TransformedServiceReference)ref).getWrappedReference();
        }
        if (this.m_serviceContext == null) {
            return (S)this.m_bundleContext.getService(ref);
        }
        return this.m_serviceContext.getService(ref);
    }

    @Override
    public ServiceReference getServiceReference(String clazz) {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.getServiceReference(clazz);
        }
        return this.m_serviceContext.getServiceReference(clazz);
    }

    public <S> ServiceReference<S> getServiceReference(Class<S> sClass) {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.getServiceReference(sClass);
        }
        return this.m_serviceContext.getServiceReference(sClass);
    }

    public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> sClass, String filter) throws InvalidSyntaxException {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.getServiceReferences(sClass, filter);
        }
        return this.m_serviceContext.getServiceReferences(sClass, filter);
    }

    @Override
    public ServiceReference[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.getServiceReferences(clazz, filter);
        }
        return this.m_serviceContext.getServiceReferences(clazz, filter);
    }

    public Bundle installBundle(String location) throws BundleException {
        return this.m_bundleContext.installBundle(location);
    }

    public Bundle installBundle(String location, InputStream input) throws BundleException {
        return this.m_bundleContext.installBundle(location, input);
    }

    public ServiceRegistration registerService(String[] clazzes, Object service, Dictionary properties) {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.registerService(clazzes, service, properties);
        }
        return this.m_serviceContext.registerService(clazzes, service, properties);
    }

    public ServiceRegistration registerService(String clazz, Object service, Dictionary properties) {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.registerService(clazz, service, properties);
        }
        return this.m_serviceContext.registerService(clazz, service, properties);
    }

    public void removeBundleListener(BundleListener listener) {
        this.m_bundleContext.removeBundleListener(listener);
    }

    public void removeFrameworkListener(FrameworkListener listener) {
        this.m_bundleContext.removeFrameworkListener(listener);
    }

    public <S> ServiceRegistration<S> registerService(Class<S> sClass, S s, Dictionary<String, ?> stringDictionary) {
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.registerService(sClass, s, stringDictionary);
        }
        return this.m_serviceContext.registerService(sClass, s, stringDictionary);
    }

    @Override
    public void removeServiceListener(ServiceListener listener) {
        if (this.m_serviceContext == null) {
            EventDispatcher dispatcher = EventDispatcher.getDispatcher();
            if (dispatcher == null || !dispatcher.removeListener(listener)) {
                this.m_bundleContext.removeServiceListener(listener);
            }
        } else {
            this.m_serviceContext.removeServiceListener(listener);
        }
    }

    public boolean ungetService(ServiceReference reference) {
        if (reference instanceof TransformedServiceReference) {
            reference = ((TransformedServiceReference)reference).getWrappedReference();
        }
        if (this.m_serviceContext == null) {
            return this.m_bundleContext.ungetService(reference);
        }
        return this.m_serviceContext.ungetService(reference);
    }

    public BundleContext getGlobalContext() {
        return this.m_bundleContext;
    }

    public ServiceContext getServiceContext() {
        return this.m_serviceContext;
    }
}

