/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.manipulation.ClassLoaderAwareClassWriter;
import org.apache.felix.ipojo.manipulation.ClassManipulator;
import org.apache.felix.ipojo.manipulation.InnerClassAdapter;
import org.apache.felix.ipojo.manipulation.InnerClassChecker;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.CheckClassAdapter;

public class Manipulator {
    private final ClassLoader m_classLoader;
    private Map<String, String> m_fields;
    private Set<String> m_finalFields;
    private List<String> m_interfaces;
    private List<MethodDescriptor> m_methods;
    private String m_superClass;
    private Map<String, List<MethodDescriptor>> m_inners;
    private int m_version;
    private boolean m_alreadyManipulated;
    private String m_className;

    public Manipulator(ClassLoader loader) {
        this.m_classLoader = loader;
    }

    public void prepare(byte[] origin) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(origin);
        ClassReader ckReader = new ClassReader(is);
        ClassChecker ck = new ClassChecker();
        ckReader.accept(ck, 4);
        ((InputStream)is).close();
        this.m_fields = ck.getFields();
        this.m_finalFields = ck.getFinalFields();
        this.m_className = ck.getClassName();
        this.m_interfaces = ck.getInterfaces();
        this.m_superClass = ck.getSuperClass();
        this.m_methods = ck.getMethods();
        this.m_inners = ck.getInnerClassesAndMethods();
        this.m_version = ck.getClassVersion();
        this.m_alreadyManipulated = ck.isAlreadyManipulated();
    }

    public byte[] manipulate(byte[] origin) throws IOException {
        if (!this.m_alreadyManipulated) {
            ByteArrayInputStream is2 = new ByteArrayInputStream(origin);
            ClassReader reader = new ClassReader(is2);
            ClassLoaderAwareClassWriter writer = new ClassLoaderAwareClassWriter(2, this.m_className, this.m_superClass, this.m_classLoader);
            ClassManipulator process = new ClassManipulator((ClassVisitor)new CheckClassAdapter((ClassVisitor)writer, false), this);
            if (this.m_version >= 50) {
                reader.accept(process, 8);
            } else {
                reader.accept(process, 0);
            }
            ((InputStream)is2).close();
            return writer.toByteArray();
        }
        return origin;
    }

    public boolean isAlreadyManipulated() {
        return this.m_alreadyManipulated;
    }

    public static String toQualifiedName(String clazz) {
        return clazz.replace("/", ".");
    }

    public Element getManipulationMetadata() {
        Element elem = new Element("Manipulation", "");
        elem.addAttribute(new Attribute("className", Manipulator.toQualifiedName(this.m_className)));
        if (this.m_superClass != null) {
            elem.addAttribute(new Attribute("super", this.m_superClass));
        }
        for (String string : this.m_interfaces) {
            Element itf = new Element("Interface", "");
            Attribute att = new Attribute("name", string);
            itf.addAttribute(att);
            elem.addElement(itf);
        }
        for (Map.Entry entry : this.m_fields.entrySet()) {
            Element field = new Element("Field", "");
            Attribute attName = new Attribute("name", (String)entry.getKey());
            Attribute attType = new Attribute("type", (String)entry.getValue());
            field.addAttribute(attName);
            field.addAttribute(attType);
            elem.addElement(field);
        }
        for (MethodDescriptor methodDescriptor : this.m_methods) {
            elem.addElement(methodDescriptor.getElement());
        }
        for (Map.Entry entry : this.m_inners.entrySet()) {
            Element element = new Element("Inner", "");
            Attribute name = new Attribute("name", Manipulator.extractInnerClassName(Manipulator.toQualifiedName((String)entry.getKey())));
            element.addAttribute(name);
            for (MethodDescriptor method : (List)entry.getValue()) {
                element.addElement(method.getElement());
            }
            elem.addElement(element);
        }
        return elem;
    }

    public static String extractInnerClassName(String clazz) {
        if (!clazz.contains("$")) {
            return clazz;
        }
        return clazz.substring(clazz.indexOf("$") + 1);
    }

    public Map<String, String> getFields() {
        return this.m_fields;
    }

    public Set<String> getFinalFields() {
        return this.m_finalFields;
    }

    public List<MethodDescriptor> getMethods() {
        return this.m_methods;
    }

    public Collection<String> getInnerClasses() {
        return new ArrayList<String>(this.m_inners.keySet());
    }

    public int getClassVersion() {
        return this.m_version;
    }

    public void addMethodToInnerClass(String name, MethodDescriptor md) {
        List<MethodDescriptor> list = this.m_inners.get(name);
        if (list == null) {
            list = new ArrayList<MethodDescriptor>();
            this.m_inners.put(name, list);
        }
        list.add(md);
    }

    public void prepareInnerClass(String inner, byte[] bytecode) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytecode);
        ClassReader ckReader = new ClassReader(is);
        InnerClassChecker ck = new InnerClassChecker(inner, this);
        ckReader.accept(ck, 4);
        ((InputStream)is).close();
    }

    public byte[] manipulateInnerClass(String inner, byte[] bytecode) throws IOException {
        if (!this.m_alreadyManipulated) {
            ByteArrayInputStream is1 = new ByteArrayInputStream(bytecode);
            ClassReader cr = new ClassReader(is1);
            ClassLoaderAwareClassWriter cw = new ClassLoaderAwareClassWriter(2, inner, null, this.m_classLoader);
            InnerClassAdapter adapter = new InnerClassAdapter(inner, cw, this.m_className, this);
            if (this.m_version >= 50) {
                cr.accept(adapter, 8);
            } else {
                cr.accept(adapter, 0);
            }
            ((InputStream)is1).close();
            return cw.toByteArray();
        }
        return bytecode;
    }

    public List<MethodDescriptor> getMethodsFromInnerClass(String innerClassInternalName) {
        return this.m_inners.get(innerClassInternalName);
    }

    public Map<String, List<MethodDescriptor>> getInnerClassesAndMethods() {
        HashMap<String, List<MethodDescriptor>> map = new HashMap<String, List<MethodDescriptor>>();
        for (Map.Entry<String, List<MethodDescriptor>> entry : this.m_inners.entrySet()) {
            String name = Manipulator.extractInnerClassName(Manipulator.toQualifiedName(entry.getKey()));
            map.put(name, entry.getValue());
        }
        return map;
    }
}

