/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scrplugin.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.felix.scrplugin.Options;
import org.apache.felix.scrplugin.Project;
import org.apache.felix.scrplugin.SCRDescriptorException;
import org.apache.felix.scrplugin.SCRDescriptorFailureException;
import org.apache.felix.scrplugin.SCRDescriptorGenerator;
import org.apache.felix.scrplugin.Source;
import org.apache.felix.scrplugin.SpecVersion;
import org.apache.felix.scrplugin.ant.AntLog;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;

public class SCRDescriptorTask
extends MatchingTask {
    private File destdir;
    private Path classpath;
    private boolean generateAccessors = true;
    protected boolean strictMode = false;
    private boolean scanClasses = false;
    private String specVersion;

    public void execute() throws BuildException {
        if (this.getImplicitFileSet().getDir() == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        AntLog scrLog = new AntLog((Task)this);
        scrLog.debug("SCRDescriptorTask Configuration");
        scrLog.debug("  implicitFileset: " + this.getImplicitFileSet());
        scrLog.debug("  outputDirectory: " + this.destdir);
        scrLog.debug("  classpath: " + this.classpath);
        scrLog.debug("  generateAccessors: " + this.generateAccessors);
        scrLog.debug("  strictMode: " + this.strictMode);
        scrLog.debug("  specVersion: " + this.specVersion);
        try {
            Path classPath = this.createClasspath();
            Project project = new Project();
            project.setClassLoader(this.getClassLoader(((Object)((Object)this)).getClass().getClassLoader()));
            project.setDependencies(this.getDependencies(classPath));
            project.setSources(this.getSourceFiles(this.getImplicitFileSet()));
            project.setClassesDirectory(this.destdir.getAbsolutePath());
            Options options = new Options();
            options.setOutputDirectory(this.destdir);
            options.setGenerateAccessors(this.generateAccessors);
            options.setStrictMode(this.strictMode);
            options.setProperties(new HashMap<String, String>());
            options.setSpecVersion(SpecVersion.fromName(this.specVersion));
            if (this.specVersion != null && options.getSpecVersion() == null) {
                throw new BuildException("Unknown spec version specified: " + this.specVersion);
            }
            SCRDescriptorGenerator generator = new SCRDescriptorGenerator(scrLog);
            generator.setOptions(options);
            generator.setProject(project);
            generator.execute();
        }
        catch (SCRDescriptorException sde) {
            if (sde.getSourceLocation() != null) {
                Location loc = new Location(sde.getSourceLocation(), -1, 0);
                throw new BuildException(sde.getMessage(), sde.getCause(), loc);
            }
            throw new BuildException(sde.getMessage(), sde.getCause());
        }
        catch (SCRDescriptorFailureException sdfe) {
            throw new BuildException(sdfe.getMessage(), sdfe.getCause());
        }
    }

    protected Collection<Source> getSourceFiles(FileSet sourceFiles) {
        String prefix = sourceFiles.getDir().getAbsolutePath();
        final int prefixLength = prefix.length() + 1;
        ArrayList<Source> result = new ArrayList<Source>();
        Iterator resources = sourceFiles.iterator();
        final String ext = this.scanClasses ? ".class" : ".java";
        while (resources.hasNext()) {
            File file;
            Resource r = (Resource)resources.next();
            if (!(r instanceof FileResource) || !(file = ((FileResource)r).getFile()).getName().endsWith(ext)) continue;
            result.add(new Source(){

                @Override
                public File getFile() {
                    return file;
                }

                @Override
                public String getClassName() {
                    String name = file.getAbsolutePath().substring(prefixLength).replace(File.separatorChar, '/').replace('/', '.');
                    return name.substring(0, name.length() - ext.length());
                }
            });
        }
        return result;
    }

    private List<File> getDependencies(Path classPath) {
        ArrayList<File> files = new ArrayList<File>();
        for (String entry : classPath.list()) {
            File file = new File(entry);
            if (!file.isFile()) continue;
            files.add(file);
        }
        return files;
    }

    private ClassLoader getClassLoader(ClassLoader parent) throws BuildException {
        Path classPath = this.createClasspath();
        this.log("Using classes from: " + classPath, 4);
        return this.getProject().createClassLoader(parent, this.classpath);
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath;
    }

    public void setClasspath(Path classPath) {
        this.createClasspath().add(classPath);
    }

    public void setClasspathRef(Reference classpathRef) {
        if (classpathRef != null && classpathRef.getReferencedObject() instanceof Path) {
            this.createClasspath().add((Path)classpathRef.getReferencedObject());
        }
    }

    public void setSrcdir(File srcdir) {
        this.getImplicitFileSet().setDir(srcdir);
    }

    public void setDestdir(File outputDirectory) {
        this.destdir = outputDirectory;
        if (this.destdir != null) {
            Path dst = new Path(this.getProject());
            dst.setLocation(this.destdir);
            this.createClasspath().add(dst);
        }
    }

    public void setGenerateAccessors(boolean generateAccessors) {
        this.generateAccessors = generateAccessors;
    }

    public void setStrictMode(boolean strictMode) {
        this.strictMode = strictMode;
    }

    public void setSpecVersion(String specVersion) {
        this.specVersion = specVersion;
    }

    public boolean isScanClasses() {
        return this.scanClasses;
    }

    public void setScanClasses(boolean scanClasses) {
        this.scanClasses = scanClasses;
    }
}

