/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableCellEditor;

class SliderEditor
extends AbstractCellEditor
implements TableCellEditor {
    JPanel editor = new JPanel(new BorderLayout());
    JTextField text;
    JSlider slider;

    public SliderEditor(int min, int max, int value) {
        this.text = new JTextField(Integer.toString(max).length());
        this.slider = new JSlider(0, min, max, value);
        this.editor.add((Component)this.text, "West");
        this.editor.add(this.slider);
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SliderEditor.this.text.setText(new Integer(SliderEditor.this.slider.getValue()).toString());
            }
        });
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.text.setText((String)value);
        try {
            this.slider.setValue(Integer.parseInt((String)value));
        }
        catch (NumberFormatException ignored) {
            // empty catch block
        }
        return this.editor;
    }

    public Object getCellEditorValue() {
        return this.text.getText();
    }
}

