/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.upnp.tester.gui;

import java.awt.event.ActionEvent;
import java.util.Dictionary;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.apache.felix.upnp.tester.Activator;
import org.apache.felix.upnp.tester.Mediator;
import org.apache.felix.upnp.tester.UPnPSubscriber;
import org.apache.felix.upnp.tester.discovery.DeviceNode;
import org.apache.felix.upnp.tester.gui.LogPanel;
import org.apache.felix.upnp.tester.gui.UPnPDeviceTreeNode;
import org.osgi.service.upnp.UPnPEventListener;
import org.osgi.service.upnp.UPnPService;

public class SubscriptionPanel
extends JPanel
implements UPnPEventListener {
    UPnPSubscriber subscriber;

    public SubscriptionPanel() {
        this.buildButtonPanel();
    }

    private void buildButtonPanel() {
        JButton subscribeBtn = new JButton("Subscribe");
        subscribeBtn.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SubscriptionPanel.this.doSubscribe();
            }
        });
        JButton unsubscribeBtn = new JButton("Unsubscribe");
        unsubscribeBtn.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                SubscriptionPanel.this.doUnsubscribe();
            }
        });
        this.add(subscribeBtn);
        this.add(unsubscribeBtn);
    }

    public void doSubscribe() {
        if (this.subscriber == null) {
            this.subscriber = new UPnPSubscriber(Activator.context, this);
        }
        UPnPDeviceTreeNode selectedNode = this.getSelectedNode();
        String serviceId = this.getServiceId(selectedNode);
        String parentId = this.getDeviceId(selectedNode);
        LogPanel.log("subscribing ... ServiceId [" + serviceId + "] of DeviceId [" + parentId + "]");
        this.subscriber.subscribe(parentId, serviceId);
        this.setSubscribedVariableOf(selectedNode);
    }

    public void doUnsubscribe() {
        UPnPDeviceTreeNode selectedNode = this.getSelectedNode();
        String serviceId = this.getServiceId(selectedNode);
        String parentId = this.getDeviceId(selectedNode);
        LogPanel.log("unsubscribing ... ServiceId [" + serviceId + "] of DeviceId [" + parentId + "]");
        this.subscriber.unsubscribe(parentId, serviceId);
        this.setUnubscribedVariableOf(selectedNode);
    }

    public void notifyUPnPEvent(final String deviceId, final String serviceId, final Dictionary events) {
        Runnable doShowMsg = new Runnable(){

            public void run() {
                LogPanel.log("notifyUPnPEvent::[DeviceID " + deviceId + "][ServiceId " + serviceId + "]");
                Enumeration elements = events.keys();
                while (elements.hasMoreElements()) {
                    Object key = elements.nextElement();
                    Object value = events.get(key);
                    LogPanel.log("[" + key + "][value " + value + "]");
                }
            }
        };
        SwingUtilities.invokeLater(doShowMsg);
    }

    private void setSubscribedVariableOf(UPnPDeviceTreeNode selectedNode) {
        Enumeration<TreeNode> list = selectedNode.children();
        while (list.hasMoreElements()) {
            UPnPDeviceTreeNode node = (UPnPDeviceTreeNode)list.nextElement();
            if (node.category != "EventedStateVariable") continue;
            node.category = "SubscribedStateVariable";
        }
        JTree tree = Mediator.getUPnPDeviceTree();
        tree.validate();
        tree.repaint();
    }

    private void setUnubscribedVariableOf(UPnPDeviceTreeNode selectedNode) {
        Enumeration<TreeNode> list = selectedNode.children();
        while (list.hasMoreElements()) {
            UPnPDeviceTreeNode node = (UPnPDeviceTreeNode)list.nextElement();
            if (node.category != "SubscribedStateVariable") continue;
            node.category = "EventedStateVariable";
        }
        JTree tree = Mediator.getUPnPDeviceTree();
        tree.validate();
        tree.repaint();
    }

    private UPnPDeviceTreeNode getSelectedNode() {
        JTree tree = Mediator.getUPnPDeviceTree();
        UPnPDeviceTreeNode selectedNode = (UPnPDeviceTreeNode)tree.getLastSelectedPathComponent();
        return selectedNode;
    }

    private String getServiceId(UPnPDeviceTreeNode selectedNode) {
        Object userObj = selectedNode.getUserObject();
        String serviceId = ((UPnPService)userObj).getId();
        return serviceId;
    }

    private String getDeviceId(UPnPDeviceTreeNode selectedNode) {
        UPnPDeviceTreeNode parent = (UPnPDeviceTreeNode)selectedNode.getParent();
        DeviceNode node = (DeviceNode)parent.getUserObject();
        String parentId = (String)node.getReference().getProperty("UPnP.device.UDN");
        return parentId;
    }
}

