/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.plugins.subsystem.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.felix.webconsole.DefaultVariableResolver;
import org.apache.felix.webconsole.SimpleWebConsolePlugin;
import org.apache.felix.webconsole.WebConsoleUtil;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.subsystem.Subsystem;

public class WebConsolePlugin
extends SimpleWebConsolePlugin {
    private static final long serialVersionUID = 4329827842860201817L;
    private static final String UNABLE_TO_FIND_TARGET_SUBSYSTEM = "Unable to find target subsystem";
    private static final String LABEL = "subsystems";
    private static final String TITLE = "Subsystems";
    private static final String CATEGORY = "OSGi";
    private static final String[] CSS = new String[]{"/res/ui/bundles.css"};
    private static final String RES = "/subsystems/res/";
    private final BundleContext bundleContext;
    private final String template;

    public WebConsolePlugin(BundleContext bc) {
        super(LABEL, TITLE, CSS);
        this.bundleContext = bc;
        this.template = this.readTemplateFile("/res/plugin.html");
    }

    public String getCategory() {
        return CATEGORY;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getPathInfo();
        if (!path.startsWith(RES)) {
            RequestInfo reqInfo = new RequestInfo(request);
            if (reqInfo.extension.equals("json")) {
                this.renderResult(response, reqInfo);
                return;
            }
        }
        super.doGet(request, response);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = WebConsoleUtil.getParameter((HttpServletRequest)req, (String)"action");
        if ("install".equals(action)) {
            this.installSubsystem(req);
            if (req.getRequestURI().endsWith("/install")) {
                resp.setContentLength(0);
            } else {
                resp.sendRedirect(req.getRequestURI());
            }
            return;
        }
        boolean success = false;
        RequestInfo reqInfo = new RequestInfo(req);
        if ("start".equals(action)) {
            this.startSubsystem(reqInfo.id);
            success = true;
        } else if ("stop".equals(action)) {
            this.stopSubsystem(reqInfo.id);
            success = true;
        } else if ("uninstall".equals(action)) {
            this.uninstallSubsystem(reqInfo.id);
            success = true;
        } else {
            super.doPost(req, resp);
        }
        if (success) {
            this.renderResult(resp, reqInfo);
        }
    }

    private void installSubsystem(HttpServletRequest req) throws IOException {
        FileItem[] subsystemItems;
        Map params = (Map)req.getAttribute("org.apache.felix.webconsole.fileupload");
        final boolean start = this.getParameter(params, "subsystemstart") != null;
        for (final FileItem subsystemItem : subsystemItems = this.getFileItems(params, "subsystemfile")) {
            File tmpFile;
            block3: {
                tmpFile = null;
                try {
                    tmpFile = File.createTempFile("installSubsystem", ".tmp");
                    subsystemItem.write(tmpFile);
                }
                catch (Exception e) {
                    this.log(1, "Problem accessing uploaded subsystem file: " + subsystemItem.getName(), e);
                    if (tmpFile == null) break block3;
                    tmpFile.delete();
                    tmpFile = null;
                }
            }
            if (tmpFile == null) continue;
            final File file = tmpFile;
            this.asyncSubsystemOperation(0L, new SubsystemOperation(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void exec(Subsystem ss) {
                    try {
                        FileInputStream is = new FileInputStream(file);
                        try {
                            Subsystem nss = ss.install("inputstream:" + subsystemItem.getName(), (InputStream)is);
                            if (start) {
                                nss.start();
                            }
                        }
                        finally {
                            ((InputStream)is).close();
                            file.delete();
                        }
                    }
                    catch (IOException e) {
                        WebConsolePlugin.this.log(1, "Problem installing subsystem", e);
                    }
                }
            });
        }
    }

    private void startSubsystem(long id) throws IOException {
        this.asyncSubsystemOperation(id, new SubsystemOperation(){

            @Override
            public void exec(Subsystem ss) {
                ss.start();
            }
        });
    }

    private void stopSubsystem(long id) throws IOException {
        this.asyncSubsystemOperation(id, new SubsystemOperation(){

            @Override
            public void exec(Subsystem ss) {
                ss.stop();
            }
        });
    }

    private void uninstallSubsystem(long id) throws IOException {
        this.asyncSubsystemOperation(id, new SubsystemOperation(){

            @Override
            public void exec(Subsystem ss) {
                ss.uninstall();
            }
        });
    }

    private void asyncSubsystemOperation(long id, final SubsystemOperation op) throws IOException {
        try {
            Collection refs = this.bundleContext.getServiceReferences(Subsystem.class, "(subsystem.id=" + id + ")");
            if (refs.size() < 1) {
                throw new IOException(UNABLE_TO_FIND_TARGET_SUBSYSTEM);
            }
            final ServiceReference ref = (ServiceReference)refs.iterator().next();
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Subsystem ss = (Subsystem)WebConsolePlugin.this.bundleContext.getService(ref);
                    try {
                        op.exec(ss);
                    }
                    finally {
                        WebConsolePlugin.this.bundleContext.ungetService(ref);
                    }
                }
            }).start();
        }
        catch (InvalidSyntaxException e) {
            throw new IOException(e);
        }
    }

    private FileItem getParameter(Map params, String name) {
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (!items[i].isFormField()) continue;
                return items[i];
            }
        }
        return null;
    }

    private FileItem[] getFileItems(Map params, String name) {
        ArrayList<FileItem> files = new ArrayList<FileItem>();
        FileItem[] items = (FileItem[])params.get(name);
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isFormField() || items[i].getSize() <= 0L) continue;
                files.add(items[i]);
            }
        }
        return files.toArray(new FileItem[files.size()]);
    }

    protected void renderContent(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        RequestInfo reqInfo = WebConsolePlugin.getRequestInfo(req);
        StringWriter w = new StringWriter();
        PrintWriter w2 = new PrintWriter(w);
        this.renderResult(w2, reqInfo);
        DefaultVariableResolver vars = (DefaultVariableResolver)WebConsoleUtil.getVariableResolver((ServletRequest)req);
        vars.put((Object)"__data__", (Object)w.toString());
        res.getWriter().print(this.template);
    }

    private void renderResult(HttpServletResponse response, RequestInfo reqInfo) throws IOException {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        this.renderResult(response.getWriter(), reqInfo);
    }

    private void renderResult(PrintWriter pw, RequestInfo reqInfo) throws IOException {
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            List<Subsystem> subsystems = this.getSubsystems();
            jw.key("status");
            jw.value((long)subsystems.size());
            jw.key("data");
            jw.array();
            for (Subsystem ss : subsystems) {
                this.subsystem(jw, ss);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je);
        }
    }

    private void subsystem(JSONWriter jw, Subsystem ss) throws JSONException {
        jw.object();
        jw.key("id");
        jw.value(ss.getSubsystemId());
        jw.key("name");
        jw.value((Object)ss.getSymbolicName());
        jw.key("version");
        jw.value((Object)ss.getVersion());
        jw.key("state");
        jw.value((Object)ss.getState());
        jw.endObject();
    }

    private List<Subsystem> getSubsystems() throws IOException {
        try {
            ArrayList<Subsystem> l = new ArrayList<Subsystem>();
            for (ServiceReference ref : this.bundleContext.getServiceReferences(Subsystem.class, null)) {
                l.add((Subsystem)this.bundleContext.getService(ref));
            }
            return l;
        }
        catch (InvalidSyntaxException e) {
            throw new IOException(e);
        }
    }

    public SimpleWebConsolePlugin register() {
        return this.register(this.bundleContext);
    }

    static RequestInfo getRequestInfo(HttpServletRequest request) {
        return (RequestInfo)request.getAttribute(WebConsolePlugin.class.getName());
    }

    static interface SubsystemOperation {
        public void exec(Subsystem var1);
    }

    class RequestInfo {
        public final long id;
        public final Object extension;

        protected RequestInfo(HttpServletRequest req) {
            String info = req.getPathInfo();
            info = info.substring(WebConsolePlugin.this.getLabel().length() + 1);
            if (info.endsWith(".json")) {
                this.extension = "json";
                info = info.substring(0, info.length() - 5);
            } else {
                this.extension = "html";
            }
            if (info.startsWith("/")) {
                info = info.substring(1);
            }
            this.id = "".equals(info) ? -1L : Long.parseLong(info);
            req.setAttribute(((Object)((Object)WebConsolePlugin.this)).getClass().getName(), (Object)this);
        }
    }
}

