////////////////////////////////////////////////////////////////////////////////
//
//  Licensed to the Apache Software Foundation (ASF) under one or more
//  contributor license agreements.  See the NOTICE file distributed with
//  this work for additional information regarding copyright ownership.
//  The ASF licenses this file to You under the Apache License, Version 2.0
//  (the "License"); you may not use this file except in compliance with
//  the License.  You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
//  Unless required by applicable law or agreed to in writing, software
//  distributed under the License is distributed on an "AS IS" BASIS,
//  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//  See the License for the specific language governing permissions and
//  limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

package
{

/**
 *  @private
 *  This class is used to link additional classes into framework.swc
 *  beyond those that are found by dependecy analysis starting
 *  from the classes specified in manifest.xml.
 *  For example, Button does not have a reference to ButtonSkin,
 *  but ButtonSkin needs to be in framework.swc along with Button.
 */
internal class SparkSkinsClasses
{
    import mx.skins.spark.AccordionHeaderSkin; AccordionHeaderSkin;
	import mx.skins.spark.BorderSkin; BorderSkin;
	import mx.skins.spark.ButtonSkin; ButtonSkin;
	import mx.skins.spark.DefaultButtonSkin; DefaultButtonSkin;
	import mx.skins.spark.ButtonBarFirstButtonSkin; ButtonBarFirstButtonSkin;
	import mx.skins.spark.ButtonBarLastButtonSkin; ButtonBarLastButtonSkin;
	import mx.skins.spark.ButtonBarMiddleButtonSkin; ButtonBarMiddleButtonSkin;
	import mx.skins.spark.CheckBoxSkin; CheckBoxSkin;
	import mx.skins.spark.ColorPickerSkin; ColorPickerSkin;
    import mx.skins.spark.ComboBoxSkin; ComboBoxSkin;
    import mx.skins.spark.ContainerBorderSkin; ContainerBorderSkin;
	import mx.skins.spark.DataGridHeaderBackgroundSkin; DataGridHeaderBackgroundSkin;
	import mx.skins.spark.DataGridHeaderSeparatorSkin; DataGridHeaderSeparatorSkin;
	import mx.skins.spark.DataGridSortArrow; DataGridSortArrow;
	import mx.skins.spark.DateChooserNextMonthSkin; DateChooserNextMonthSkin;
	import mx.skins.spark.DateChooserNextYearSkin; DateChooserNextYearSkin;
	import mx.skins.spark.DateChooserPrevMonthSkin; DateChooserPrevMonthSkin;
	import mx.skins.spark.DateChooserPrevYearSkin; DateChooserPrevYearSkin;
	import mx.skins.spark.DateChooserRollOverIndicatorSkin; DateChooserRollOverIndicatorSkin;
	import mx.skins.spark.DateChooserSelectionIndicatorSkin; DateChooserSelectionIndicatorSkin;
	import mx.skins.spark.DateChooserTodayIndicatorSkin; DateChooserTodayIndicatorSkin;
	import mx.skins.spark.EditableComboBoxSkin; EditableComboBoxSkin;
	import mx.skins.spark.LinkButtonSkin; LinkButtonSkin;
	import mx.skins.spark.MenuArrow; MenuArrow;
	import mx.skins.spark.MenuArrowDisabled; MenuArrowDisabled;
	import mx.skins.spark.MenuCheck; MenuCheck;
	import mx.skins.spark.MenuCheckDisabled; MenuCheckDisabled;
	import mx.skins.spark.MenuRadio; MenuRadio;
	import mx.skins.spark.MenuRadioDisabled; MenuRadioDisabled;
	import mx.skins.spark.MenuItemSkin; MenuItemSkin;
	import mx.skins.spark.MenuSeparatorSkin; MenuSeparatorSkin;
	import mx.skins.spark.PanelBorderSkin; PanelBorderSkin;
	import mx.skins.spark.PopUpButtonSkin; PopUpButtonSkin;
	import mx.skins.spark.ProgressBarSkin; ProgressBarSkin;
	import mx.skins.spark.ProgressBarTrackSkin; ProgressBarTrackSkin;
	import mx.skins.spark.ProgressIndeterminateSkin; ProgressIndeterminateSkin;
	import mx.skins.spark.ProgressMaskSkin; ProgressMaskSkin;
	import mx.skins.spark.RadioButtonSkin; RadioButtonSkin;
	import mx.skins.spark.ScrollBarDownButtonSkin; ScrollBarDownButtonSkin;
	import mx.skins.spark.ScrollBarThumbSkin; ScrollBarThumbSkin;
	import mx.skins.spark.ScrollBarTrackSkin; ScrollBarTrackSkin;
	import mx.skins.spark.ScrollBarUpButtonSkin; ScrollBarUpButtonSkin;
	import mx.skins.spark.SliderThumbSkin; SliderThumbSkin;
	import mx.skins.spark.SliderTrackSkin; SliderTrackSkin;
	import mx.skins.spark.SliderTrackHighlightSkin; SliderTrackHighlightSkin;
	import mx.skins.spark.StepperDecrButtonSkin; StepperDecrButtonSkin;
	import mx.skins.spark.StepperIncrButtonSkin; StepperIncrButtonSkin;
	import mx.skins.spark.TabSkin; TabSkin;
	import mx.skins.spark.TextInputBorderSkin; TextInputBorderSkin;
	// Maintain alphabetical order
}

}

